/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders;

import java.io.Closeable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.olapServer2.collections.LockFreeStack;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.OlapConfigItem;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IMappedResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.MappedFile;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.MappedMemory;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ResourceCacheItem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0012\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "Ljava/io/Closeable;", "tempFolder", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "cachedCount", "", "getCachedCount", "()I", "memoryPool", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$MemoryByteBufferResourcePool;", "tempFilePool", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$TempFileByteBufferResourcePool;", "close", "", "gc", "getOrCreate", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ResourceCacheItem;", "headSize", "", "Lkd/bos/olapServer2/common/long;", "getOrCreateTempFile", "release", "item", "AbstractByteBufferResourcePool", "Companion", "MemoryByteBufferResourcePool", "TempFileByteBufferResourcePool", "bos-olap-core2"})
public final class ByteBufferResourcePool
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MemoryByteBufferResourcePool memoryPool;
    @Nullable
    private final TempFileByteBufferResourcePool tempFilePool;
    @NotNull
    private static final OlapConfigItem.OlapConfigIntTypeItem minCachedResourcesCountConfigItem = new OlapConfigItem.OlapConfigIntTypeItem("BytePool_MinCachedResourcesCount", CommonTypesKt.getAvailableProcessors() * 11 * 2 * 2, 0, Integer.MAX_VALUE, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigIntTypeItem maxBytesCountConfigItem = new OlapConfigItem.OlapConfigIntTypeItem("BytePool_MaxBytesCount", 0x800000, 0, Integer.MAX_VALUE, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigLongTypeItem resourceTimeoutConfigItem = new OlapConfigItem.OlapConfigLongTypeItem("BytePool_ResourceTimeout", 20L, 0L, 7200L, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigIntTypeItem memorySwitchToFileByteSizeConfigItem = new OlapConfigItem.OlapConfigIntTypeItem("BytePool_MemorySwitchToFileByteSize", 0x4000000, 4096, Integer.MAX_VALUE, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigLongTypeItem maxRecycleFileBytesCountConfigItem = new OlapConfigItem.OlapConfigLongTypeItem("BytePool_MaxRecycleFileBytesCount", 0x10000000L, 4096L, Long.MAX_VALUE, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigIntTypeItem reservedCachedFilesCountConfigItem = new OlapConfigItem.OlapConfigIntTypeItem("BytePool_ReservedCachedFilesCount", 6, 0, Integer.MAX_VALUE, null, false, false, null, 240, null);
    private static int maxSkipCount = 60;

    public ByteBufferResourcePool(@NotNull String tempFolder) {
        Intrinsics.checkNotNullParameter((Object)tempFolder, (String)"tempFolder");
        this.memoryPool = new MemoryByteBufferResourcePool();
        this.tempFilePool = ((CharSequence)tempFolder).length() == 0 ? null : new TempFileByteBufferResourcePool(tempFolder);
    }

    @NotNull
    public final ResourceCacheItem getOrCreate(long headSize) {
        return this.memoryPool.getOrCreate(headSize);
    }

    @Nullable
    public final ResourceCacheItem getOrCreateTempFile() {
        TempFileByteBufferResourcePool tempFileByteBufferResourcePool = this.tempFilePool;
        return tempFileByteBufferResourcePool != null ? tempFileByteBufferResourcePool.getOrCreate(0L) : null;
    }

    public final void release(@Nullable ResourceCacheItem item) {
        if (item != null && item.isMemoryCache() || this.tempFilePool == null) {
            this.memoryPool.release(item);
        } else {
            this.tempFilePool.release(item);
        }
    }

    public final int getCachedCount() {
        TempFileByteBufferResourcePool tempFileByteBufferResourcePool = this.tempFilePool;
        return this.memoryPool.getCachedCount() + (tempFileByteBufferResourcePool != null ? tempFileByteBufferResourcePool.getCachedCount() : 0);
    }

    @Override
    public void close() {
        block0: {
            this.memoryPool.close();
            TempFileByteBufferResourcePool tempFileByteBufferResourcePool = this.tempFilePool;
            if (tempFileByteBufferResourcePool == null) break block0;
            tempFileByteBufferResourcePool.close();
        }
    }

    public final void gc() {
        block0: {
            this.memoryPool.gc();
            TempFileByteBufferResourcePool tempFileByteBufferResourcePool = this.tempFilePool;
            if (tempFileByteBufferResourcePool == null) break block0;
            tempFileByteBufferResourcePool.gc();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0002J\b\u0010\u0018\u001a\u00020\u0019H$J\u0006\u0010\u001a\u001a\u00020\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\u0012\u0010\u001c\u001a\u00020\b2\n\u0010\u001d\u001a\u00060\u0005j\u0002`\u0006J\u0010\u0010\u001e\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\bJ\u0016\u0010 \u001a\u0004\u0018\u00010\b2\n\u0010\u001d\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u0014\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010\u001f\u001a\u00020\bH\u0002R$\u0010\u0003\u001a\u0018\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00060\u0005j\u0002`\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00060\fj\u0002`\u0013X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\u0082\u0001\u0002$%\u00a8\u0006&"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$AbstractByteBufferResourcePool;", "Ljava/io/Closeable;", "()V", "_cachedResourcesMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkd/bos/olapServer2/common/long;", "Lkd/bos/olapServer2/collections/LockFreeStack;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ResourceCacheItem;", "_garbageCollecting", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cachedCount", "", "getCachedCount", "()I", "maxRecycleBytesCount", "getMaxRecycleBytesCount", "()J", "reservedResourcesCount", "Lkd/bos/olapServer2/common/int;", "getReservedResourcesCount", "close", "", "create", "createMappedResource", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IMappedResource;", "gc", "gcCore", "getOrCreate", "headSize", "release", "item", "tryGet", "tryRelease", "", "Lkd/bos/olapServer2/common/bool;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$MemoryByteBufferResourcePool;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$TempFileByteBufferResourcePool;", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nByteBufferResourcePool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBufferResourcePool.kt\nkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$AbstractByteBufferResourcePool\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n72#2,2:325\n1#3:327\n1#3:330\n1855#4,2:328\n1855#4,2:331\n*S KotlinDebug\n*F\n+ 1 ByteBufferResourcePool.kt\nkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$AbstractByteBufferResourcePool\n*L\n188#1:325,2\n188#1:327\n207#1:328,2\n250#1:331,2\n*E\n"})
    private static abstract class AbstractByteBufferResourcePool
    implements Closeable {
        @NotNull
        private final ConcurrentHashMap<Long, LockFreeStack<ResourceCacheItem>> _cachedResourcesMap = new ConcurrentHashMap();
        @NotNull
        private final AtomicBoolean _garbageCollecting = new AtomicBoolean();

        private AbstractByteBufferResourcePool() {
        }

        @NotNull
        protected abstract IMappedResource createMappedResource();

        protected abstract long getMaxRecycleBytesCount();

        protected abstract int getReservedResourcesCount();

        @NotNull
        public final ResourceCacheItem getOrCreate(long headSize) {
            ResourceCacheItem resourceCacheItem = this.tryGet(headSize);
            if (resourceCacheItem == null) {
                resourceCacheItem = this.create();
            }
            return resourceCacheItem;
        }

        private final ResourceCacheItem tryGet(long headSize) {
            LockFreeStack<ResourceCacheItem> lockFreeStack = this._cachedResourcesMap.get(headSize);
            if (lockFreeStack == null) {
                return null;
            }
            LockFreeStack<ResourceCacheItem> res = lockFreeStack;
            return res.tryPop();
        }

        private final ResourceCacheItem create() {
            return new ResourceCacheItem(this.createMappedResource());
        }

        public final void release(@Nullable ResourceCacheItem item) {
            if (!(item == null || item.getContentBufferSize() <= this.getMaxRecycleBytesCount() && this.tryRelease(item))) {
                item.closeAndDelete();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean tryRelease(ResourceCacheItem item) {
            boolean bl;
            long key2 = item.getHeadBufferSize();
            if (key2 >= 0L) {
                void $this$getOrPut$iv;
                ConcurrentMap concurrentMap = this._cachedResourcesMap;
                Long key$iv = key2;
                boolean $i$f$getOrPut = false;
                Object object2 = $this$getOrPut$iv.get(key$iv);
                if (object2 == null) {
                    boolean bl2 = false;
                    LockFreeStack default$iv = new LockFreeStack();
                    boolean bl3 = false;
                    object2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                    if (object2 == null) {
                        object2 = default$iv;
                    }
                }
                LockFreeStack res = (LockFreeStack)object2;
                item.setReleaseTime(System.nanoTime());
                item.resetBeforeReuse();
                res.push(item);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public void close() {
            Collection<LockFreeStack<ResourceCacheItem>> collection = this._cachedResourcesMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LockFreeStack stack = (LockFreeStack)element$iv;
                boolean bl = false;
                ResourceCacheItem item = (ResourceCacheItem)stack.tryPop();
                while (item != null) {
                    item.closeAndDelete();
                    item = (ResourceCacheItem)stack.tryPop();
                }
            }
            this._cachedResourcesMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void gc() {
            if (this._garbageCollecting.compareAndSet(false, true)) {
                try {
                    this.gcCore();
                }
                finally {
                    this._garbageCollecting.set(false);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final int getCachedCount() {
            Collection<LockFreeStack<ResourceCacheItem>> collection = this._cachedResourcesMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            int n = 0;
            for (Object t2 : iterable) {
                void it;
                LockFreeStack lockFreeStack = (LockFreeStack)t2;
                int n2 = n;
                boolean bl = false;
                int n3 = it.getSize();
                n = n2 + n3;
            }
            return n;
        }

        private final void gcCore() {
            Ref.IntRef currentCount = new Ref.IntRef();
            currentCount.element = this.getCachedCount();
            int reservedCount = this.getReservedResourcesCount();
            if (currentCount.element <= reservedCount) {
                return;
            }
            long min = System.nanoTime() - Companion.getResourceTimeout() * 1000000000L;
            long veryMin = System.nanoTime() - Companion.getResourceTimeout() * 1000000000L * (long)3;
            Collection<LockFreeStack<ResourceCacheItem>> collection = this._cachedResourcesMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LockFreeStack stack = (LockFreeStack)element$iv;
                boolean bl = false;
                stack.gc((Function1)new Function1<ResourceCacheItem, Boolean>(currentCount, reservedCount, min, veryMin){
                    final /* synthetic */ Ref.IntRef $currentCount;
                    final /* synthetic */ int $reservedCount;
                    final /* synthetic */ long $min;
                    final /* synthetic */ long $veryMin;
                    {
                        this.$currentCount = $currentCount;
                        this.$reservedCount = $reservedCount;
                        this.$min = $min;
                        this.$veryMin = $veryMin;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ResourceCacheItem it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$currentCount.element > this.$reservedCount && it.getReleaseTime() < this.$min || it.getReleaseTime() < this.$veryMin;
                    }
                }, (Function1)new Function1<ResourceCacheItem, Unit>(currentCount){
                    final /* synthetic */ Ref.IntRef $currentCount;
                    {
                        this.$currentCount = $currentCount;
                        super(1);
                    }

                    public final void invoke(@NotNull ResourceCacheItem it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        int n = this.$currentCount.element;
                        this.$currentCount.element = n + -1;
                        it.closeAndDelete();
                    }
                });
            }
        }

        public /* synthetic */ AbstractByteBufferResourcePool(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R,\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR,\u0010\u0011\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u0003\u001a\u00060\u000fj\u0002`\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\b\"\u0004\b\u001c\u0010\nR,\u0010\u001d\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u0003\u001a\u00060\u000fj\u0002`\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010\u0015R\u0014\u0010 \u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000eR,\u0010\"\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\b\"\u0004\b$\u0010\nR\u0014\u0010%\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000eR,\u0010'\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010\b\"\u0004\b)\u0010\nR\u0014\u0010*\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u000eR,\u0010,\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u0003\u001a\u00060\u000fj\u0002`\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010\u0013\"\u0004\b.\u0010\u0015R\u0014\u0010/\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0019\u00a8\u00061"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$Companion;", "", "()V", "value", "", "Lkd/bos/olapServer2/common/int;", "maxBytesCount", "getMaxBytesCount", "()I", "setMaxBytesCount", "(I)V", "maxBytesCountConfigItem", "Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigIntTypeItem;", "getMaxBytesCountConfigItem$bos_olap_core2", "()Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigIntTypeItem;", "", "Lkd/bos/olapServer2/common/long;", "maxRecycleFileBytesCount", "getMaxRecycleFileBytesCount", "()J", "setMaxRecycleFileBytesCount", "(J)V", "maxRecycleFileBytesCountConfigItem", "Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigLongTypeItem;", "getMaxRecycleFileBytesCountConfigItem$bos_olap_core2", "()Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigLongTypeItem;", "maxSkipCount", "getMaxSkipCount", "setMaxSkipCount", "memorySwitchToFileByteSize", "getMemorySwitchToFileByteSize", "setMemorySwitchToFileByteSize", "memorySwitchToFileByteSizeConfigItem", "getMemorySwitchToFileByteSizeConfigItem$bos_olap_core2", "minCachedResourcesCount", "getMinCachedResourcesCount", "setMinCachedResourcesCount", "minCachedResourcesCountConfigItem", "getMinCachedResourcesCountConfigItem$bos_olap_core2", "reservedCachedFilesCount", "getReservedCachedFilesCount", "setReservedCachedFilesCount", "reservedCachedFilesCountConfigItem", "getReservedCachedFilesCountConfigItem$bos_olap_core2", "resourceTimeout", "getResourceTimeout", "setResourceTimeout", "resourceTimeoutConfigItem", "getResourceTimeoutConfigItem$bos_olap_core2", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OlapConfigItem.OlapConfigIntTypeItem getMinCachedResourcesCountConfigItem$bos_olap_core2() {
            return minCachedResourcesCountConfigItem;
        }

        public final int getMinCachedResourcesCount() {
            return this.getMinCachedResourcesCountConfigItem$bos_olap_core2().getValue();
        }

        public final void setMinCachedResourcesCount(int value2) {
            this.getMinCachedResourcesCountConfigItem$bos_olap_core2().setValue(value2);
        }

        @NotNull
        public final OlapConfigItem.OlapConfigIntTypeItem getMaxBytesCountConfigItem$bos_olap_core2() {
            return maxBytesCountConfigItem;
        }

        public final int getMaxBytesCount() {
            return this.getMaxBytesCountConfigItem$bos_olap_core2().getValue();
        }

        public final void setMaxBytesCount(int value2) {
            this.getMaxBytesCountConfigItem$bos_olap_core2().setValue(value2);
        }

        @NotNull
        public final OlapConfigItem.OlapConfigLongTypeItem getResourceTimeoutConfigItem$bos_olap_core2() {
            return resourceTimeoutConfigItem;
        }

        public final long getResourceTimeout() {
            return this.getResourceTimeoutConfigItem$bos_olap_core2().getValue();
        }

        public final void setResourceTimeout(long value2) {
            this.getResourceTimeoutConfigItem$bos_olap_core2().setValue(value2);
        }

        @NotNull
        public final OlapConfigItem.OlapConfigIntTypeItem getMemorySwitchToFileByteSizeConfigItem$bos_olap_core2() {
            return memorySwitchToFileByteSizeConfigItem;
        }

        public final long getMemorySwitchToFileByteSize() {
            return this.getMemorySwitchToFileByteSizeConfigItem$bos_olap_core2().getValue();
        }

        public final void setMemorySwitchToFileByteSize(long value2) {
            this.getMemorySwitchToFileByteSizeConfigItem$bos_olap_core2().setValue((int)value2);
        }

        @NotNull
        public final OlapConfigItem.OlapConfigLongTypeItem getMaxRecycleFileBytesCountConfigItem$bos_olap_core2() {
            return maxRecycleFileBytesCountConfigItem;
        }

        public final long getMaxRecycleFileBytesCount() {
            return this.getMaxRecycleFileBytesCountConfigItem$bos_olap_core2().getValue();
        }

        public final void setMaxRecycleFileBytesCount(long value2) {
            this.getMaxRecycleFileBytesCountConfigItem$bos_olap_core2().setValue(value2);
        }

        @NotNull
        public final OlapConfigItem.OlapConfigIntTypeItem getReservedCachedFilesCountConfigItem$bos_olap_core2() {
            return reservedCachedFilesCountConfigItem;
        }

        public final int getReservedCachedFilesCount() {
            return this.getReservedCachedFilesCountConfigItem$bos_olap_core2().getValue();
        }

        public final void setReservedCachedFilesCount(int value2) {
            this.getReservedCachedFilesCountConfigItem$bos_olap_core2().setValue(value2);
        }

        public final int getMaxSkipCount() {
            return maxSkipCount;
        }

        public final void setMaxSkipCount(int n) {
            maxSkipCount = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$MemoryByteBufferResourcePool;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$AbstractByteBufferResourcePool;", "()V", "maxRecycleBytesCount", "", "Lkd/bos/olapServer2/common/long;", "getMaxRecycleBytesCount", "()J", "reservedResourcesCount", "", "Lkd/bos/olapServer2/common/int;", "getReservedResourcesCount", "()I", "createMappedResource", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IMappedResource;", "bos-olap-core2"})
    private static final class MemoryByteBufferResourcePool
    extends AbstractByteBufferResourcePool {
        public MemoryByteBufferResourcePool() {
            super(null);
        }

        @Override
        @NotNull
        protected IMappedResource createMappedResource() {
            return new MappedMemory();
        }

        @Override
        protected long getMaxRecycleBytesCount() {
            return Companion.getMaxBytesCount();
        }

        @Override
        protected int getReservedResourcesCount() {
            return Companion.getMinCachedResourcesCount();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$TempFileByteBufferResourcePool;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$AbstractByteBufferResourcePool;", "tempFolder", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "_fileNameSeq", "Ljava/util/concurrent/atomic/AtomicLong;", "maxRecycleBytesCount", "", "Lkd/bos/olapServer2/common/long;", "getMaxRecycleBytesCount", "()J", "reservedResourcesCount", "", "Lkd/bos/olapServer2/common/int;", "getReservedResourcesCount", "()I", "getTempFolder", "()Ljava/lang/String;", "close", "", "createMappedResource", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IMappedResource;", "bos-olap-core2"})
    private static final class TempFileByteBufferResourcePool
    extends AbstractByteBufferResourcePool {
        @NotNull
        private final String tempFolder;
        @NotNull
        private final AtomicLong _fileNameSeq;

        public TempFileByteBufferResourcePool(@NotNull String tempFolder) {
            Intrinsics.checkNotNullParameter((Object)tempFolder, (String)"tempFolder");
            super(null);
            this.tempFolder = tempFolder;
            if (!(((CharSequence)this.tempFolder).length() > 0)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            this._fileNameSeq = new AtomicLong();
        }

        @NotNull
        public final String getTempFolder() {
            return this.tempFolder;
        }

        @Override
        @NotNull
        protected IMappedResource createMappedResource() {
            long fileNameSeq = this._fileNameSeq.incrementAndGet();
            String[] stringArray = new String[]{"temp" + fileNameSeq + ".dat"};
            String fileName = ((Object)Paths.INSTANCE.get(this.tempFolder, stringArray)).toString();
            return new MappedFile(fileName);
        }

        @Override
        protected long getMaxRecycleBytesCount() {
            return Companion.getMaxRecycleFileBytesCount();
        }

        @Override
        protected int getReservedResourcesCount() {
            return Companion.getReservedCachedFilesCount();
        }

        @Override
        public void close() {
            super.close();
            PathsKt.fileSafeConstructor(this.tempFolder).delete();
        }
    }
}

