/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders;

import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.memoryMappedFiles.IHeadFieldCollection;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ByteBufferResourcePool;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.CachedByteBufferProvider;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ResourceCacheItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u00020\f2\n\u0010\u0010\u001a\u00060\bj\u0002`\u0011H\u0002J\u0014\u0010\u001c\u001a\u00020\u00062\n\u0010\u001d\u001a\u00060\bj\u0002`\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0014\u0010!\u001a\u00020\u00062\n\u0010\u001d\u001a\u00060\bj\u0002`\u0011H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fH\u0002J\b\u0010$\u001a\u00020%H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\bj\u0002`\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00060\nj\u0002`\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0018\u0010\u0017\u001a\u00060\bj\u0002`\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/CachedByteBufferResource;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBufferResource;", "provider", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/CachedByteBufferProvider;", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/CachedByteBufferProvider;)V", "_contentBuffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "_headSize", "", "_isClosed", "", "_source", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ResourceCacheItem;", "contentBuffer", "getContentBuffer", "()Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "headSize", "Lkd/bos/olapServer2/common/long;", "getHeadSize", "()J", "isReadOnly", "Lkd/bos/olapServer2/common/bool;", "()Z", "length", "getLength", "force", "", "getSource", "mapContentBuffer", "minSize", "open", "headFields", "Lkd/bos/olapServer2/memoryMappedFiles/IHeadFieldCollection;", "resize", "switchToFile", "currentSource", "toString", "", "bos-olap-core2"})
public final class CachedByteBufferResource
implements IByteBufferResource {
    @NotNull
    private final CachedByteBufferProvider provider;
    @Nullable
    private ResourceCacheItem _source;
    private boolean _isClosed;
    private long _headSize;
    @Nullable
    private IByteBuffer _contentBuffer;

    public CachedByteBufferResource(@NotNull CachedByteBufferProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
        this._headSize = -1L;
    }

    private final long getHeadSize() {
        if (this._headSize < 0L) {
            throw new NotSupportedException();
        }
        return this._headSize;
    }

    private final ResourceCacheItem getSource(long headSize) {
        if (!(!this._isClosed)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ResourceCacheItem source2 = this._source;
        if (source2 != null) {
            return source2;
        }
        source2 = this.provider.getOrCreate(headSize);
        this._headSize = headSize;
        this._source = source2;
        return source2;
    }

    @Override
    @NotNull
    public IByteBuffer open(@NotNull IHeadFieldCollection headFields) {
        Intrinsics.checkNotNullParameter((Object)headFields, (String)"headFields");
        long headSize = headFields.getNextOffset();
        ResourceCacheItem source2 = this.getSource(headSize);
        IByteBuffer buffer = source2.mapFileHeadBuffer(headSize);
        headFields.initFile(buffer);
        return buffer;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long getLength() {
        ResourceCacheItem source2;
        ResourceCacheItem resourceCacheItem = source2 = this._source;
        return resourceCacheItem != null ? resourceCacheItem.getValidFileLength() : 0L;
    }

    @Override
    @NotNull
    public IByteBuffer getContentBuffer() {
        return this.mapContentBuffer(0L);
    }

    private final IByteBuffer mapContentBuffer(long minSize) {
        IByteBuffer newBuffer;
        IByteBuffer oldBuffer = this._contentBuffer;
        if (oldBuffer != null && oldBuffer.getCapacity() >= minSize) {
            return oldBuffer;
        }
        long position = this.getHeadSize();
        ResourceCacheItem currentSource = this._source;
        currentSource = minSize > ByteBufferResourcePool.Companion.getMemorySwitchToFileByteSize() && currentSource != null && currentSource.isMemoryCache() ? this.switchToFile(currentSource) : this.getSource(this.getHeadSize());
        this._contentBuffer = newBuffer = currentSource.mapContentBuffer(position, minSize);
        return newBuffer;
    }

    private final ResourceCacheItem switchToFile(ResourceCacheItem currentSource) {
        ResourceCacheItem resourceCacheItem = this.provider.getOrCreateTempFile();
        if (resourceCacheItem == null) {
            return currentSource;
        }
        ResourceCacheItem tempFileSource = resourceCacheItem;
        IByteBuffer oldBuff = currentSource.mapContentBuffer(0L, currentSource.getContentBufferSize());
        IByteBuffer newBuff = tempFileSource.mapContentBuffer(0L, currentSource.getContentBufferSize());
        newBuff.copy(0L, oldBuff);
        if (this.getHeadSize() == 0L) {
            this.provider.release(currentSource);
        }
        this._source = tempFileSource;
        return tempFileSource;
    }

    @Override
    @NotNull
    public IByteBuffer resize(long minSize) {
        return this.mapContentBuffer(minSize);
    }

    @Override
    public void force() {
        block0: {
            ResourceCacheItem resourceCacheItem = this._source;
            if (resourceCacheItem == null) break block0;
            resourceCacheItem.force();
        }
    }

    @NotNull
    public String toString() {
        return "CachedByteBufferResource : " + this._source;
    }
}

