/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders;

import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.EmptyByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IDynamicByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IOffsetMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.IImmutableSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFixedSegmentSequenceContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IRecycle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\n\u0010\u0014\u001a\u00060\u000bj\u0002`\fH\u0002J\u0014\u0010\u0015\u001a\u00020\t2\n\u0010\u0014\u001a\u00060\u000bj\u0002`\fH\u0002J\u0006\u0010\u0016\u001a\u00020\u0011J\u0014\u0010\u0017\u001a\u00020\t2\n\u0010\u0014\u001a\u00060\u000bj\u0002`\fH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ContainerByteBufferResource;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IRecycle;", "containers", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFixedSegmentSequenceContainer;", "metadata", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IOffsetMetadata;", "(Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFixedSegmentSequenceContainer;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IOffsetMetadata;)V", "_contentBuffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "_offset", "", "Lkd/bos/olapServer2/common/long;", "contentBuffer", "getContentBuffer", "()Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "gc", "", "getOrResize", "oldBuffer", "minSize", "mapContentBuffer", "release", "resize", "bos-olap-core2"})
public final class ContainerByteBufferResource
implements IDynamicByteBufferResource,
IRecycle {
    @NotNull
    private final IMutableFixedSegmentSequenceContainer containers;
    @NotNull
    private final IOffsetMetadata metadata;
    private long _offset;
    @Nullable
    private IByteBuffer _contentBuffer;

    public ContainerByteBufferResource(@NotNull IMutableFixedSegmentSequenceContainer containers, @NotNull IOffsetMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)containers, (String)"containers");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.containers = containers;
        this.metadata = metadata;
        this._offset = this.metadata.getOffset();
    }

    @Override
    @NotNull
    public IByteBuffer getContentBuffer() {
        return this.mapContentBuffer(0L);
    }

    private final IByteBuffer mapContentBuffer(long minSize) {
        IByteBuffer iByteBuffer;
        IByteBuffer oldBuffer = this._contentBuffer;
        if (oldBuffer != null) {
            iByteBuffer = this.getOrResize(oldBuffer, minSize);
        } else {
            IByteBuffer currentBuffer;
            this._contentBuffer = currentBuffer = this._offset == -1L ? (IByteBuffer)EmptyByteBuffer.INSTANCE : ((IImmutableSegmentContainer)this.containers.getImmutableObject()).getBuffer(this._offset);
            iByteBuffer = this.getOrResize(currentBuffer, minSize);
        }
        return iByteBuffer;
    }

    private final IByteBuffer getOrResize(IByteBuffer oldBuffer, long minSize) {
        IByteBuffer newBuffer;
        long newOffset;
        if (oldBuffer.getCapacity() >= minSize) {
            return oldBuffer;
        }
        this._offset = newOffset = Intrinsics.areEqual((Object)oldBuffer, (Object)EmptyByteBuffer.INSTANCE) ? this.containers.allot(minSize) : this.containers.resize(this._offset, minSize);
        this.metadata.setOffset(newOffset);
        this._contentBuffer = newBuffer = ((IImmutableSegmentContainer)this.containers.getImmutableObject()).getBuffer(newOffset);
        return newBuffer;
    }

    public final void release() {
        this.containers.release(this._offset);
        this._offset = -1L;
        this.metadata.setOffset(-1L);
    }

    @Override
    @NotNull
    public IByteBuffer resize(long minSize) {
        return this.mapContentBuffer(minSize);
    }

    @Override
    public void gc() {
        this.containers.gc();
    }
}

