/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.FileInfo;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBufferProvider;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.MappedFile;
import kd.bos.olapServer2.tools.FileTools;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\f2\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0006\u0010\u0015\u001a\u00020\fJ\u0014\u0010\u0015\u001a\u00020\f2\n\u0010\u000f\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0018\u0010\u0016\u001a\u00060\u0011j\u0002`\u00122\n\u0010\u000f\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0014\u0010\u0017\u001a\u00020\u00032\n\u0010\u000f\u001a\u00060\u0003j\u0002`\u0004H\u0002J#\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u00192\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004H\u0016\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u00192\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004H\u0016\u00a2\u0006\u0002\u0010\u001aJ$\u0010\u001c\u001a\u00060\u0011j\u0002`\u00122\n\u0010\u001d\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u001e\u001a\u00060\u0003j\u0002`\u0004H\u0016R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/DefaultByteBufferProvider;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;", "path", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "_resources", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/DefaultByteBufferProvider$ResourcePair;", "getPath", "()Ljava/lang/String;", "close", "", "create", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBufferResource;", "name", "isReadonly", "", "Lkd/bos/olapServer2/common/bool;", "createFolder", "relativePath", "delete", "exist", "getResKey", "listFiles", "", "(Ljava/lang/String;)[Ljava/lang/String;", "listFolder", "rename", "oldName", "newName", "ResourcePair", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nDefaultByteBufferProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultByteBufferProvider.kt\nkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/DefaultByteBufferProvider\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n26#2:103\n26#2:110\n11065#3:104\n11400#3,3:105\n37#4,2:108\n72#5,2:111\n1#6:113\n*S KotlinDebug\n*F\n+ 1 DefaultByteBufferProvider.kt\nkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/DefaultByteBufferProvider\n*L\n24#1:103\n33#1:110\n31#1:104\n31#1:105,3\n31#1:108,2\n38#1:111,2\n38#1:113\n*E\n"})
public final class DefaultByteBufferProvider
implements IByteBufferProvider {
    @NotNull
    private final String path;
    @NotNull
    private final ConcurrentHashMap<String, ResourcePair> _resources;

    public DefaultByteBufferProvider(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this._resources = new ConcurrentHashMap();
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Override
    public void createFolder(@NotNull String relativePath) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        if (((CharSequence)relativePath).length() == 0) {
            string2 = this.path;
        } else {
            String[] stringArray = new String[]{relativePath};
            string2 = ((Object)Paths.INSTANCE.get(this.path, stringArray)).toString();
        }
        String p = string2;
        FileTools.INSTANCE.autoMakeDir(p);
    }

    @Override
    @NotNull
    public String[] listFiles(@NotNull String relativePath) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String[] stringArray2 = Paths.INSTANCE.toFile(this.path, relativePath).list();
        if (stringArray2 == null) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        } else {
            stringArray = stringArray2;
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String[] listFolder(@NotNull String relativePath) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        File[] files = Paths.INSTANCE.toFile(this.path, relativePath).listFiles(DefaultByteBufferProvider::listFolder$lambda$0);
        if (files != null) {
            void $this$mapTo$iv$iv;
            File[] $this$map$iv = files;
            boolean $i$f$map = false;
            File[] fileArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IByteBufferResource create(@NotNull String name2, boolean isReadonly) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ConcurrentMap concurrentMap = this._resources;
        String key$iv = this.getResKey(name2);
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv.get(key$iv);
        if (object2 == null) {
            boolean bl = false;
            String[] stringArray = new String[]{name2};
            String file = ((Object)Paths.INSTANCE.get(this.path, stringArray)).toString();
            FileInfo fileInfo = new FileInfo(PathsKt.fileSafeConstructor(file));
            MappedFile mappedFile = new MappedFile(file);
            ResourcePair default$iv = new ResourcePair(fileInfo, mappedFile);
            boolean bl2 = false;
            object2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        }
        ResourcePair pair = (ResourcePair)object2;
        return new ByteBufferResource(pair.getFile(), pair.getMappedFile(), isReadonly);
    }

    @Override
    public boolean exist(@NotNull String name2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ResourcePair pair = this._resources.get(this.getResKey(name2));
        if (pair == null) {
            String[] stringArray = new String[]{name2};
            Path fileName = Paths.INSTANCE.get(this.path, stringArray);
            bl = Files.exists(fileName, new LinkOption[0]);
        } else {
            bl = pair.getFile().exists();
        }
        return bl;
    }

    @Override
    public void delete(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ResourcePair pair = this._resources.remove(this.getResKey(name2));
        Object object2 = pair;
        if (object2 != null && (object2 = ((ResourcePair)object2).getMappedFile()) != null) {
            ((MappedFile)object2).close();
        }
        String[] stringArray = new String[]{name2};
        Files.deleteIfExists(Paths.INSTANCE.get(this.path, stringArray));
    }

    private final String getResKey(String name2) {
        String string2 = name2;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        return string3;
    }

    public final void delete() {
        this.close();
        boolean result2 = FilesKt.deleteRecursively((File)PathsKt.fileSafeConstructor(this.path));
        if (!result2) {
            throw new RuntimeException("Failed to delete folder \"" + this.path + "\" and its subdirectory. ");
        }
    }

    @Override
    public boolean rename(@NotNull String oldName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Object object2 = this._resources.get(this.getResKey(oldName));
        if (object2 != null && (object2 = ((ResourcePair)object2).getMappedFile()) != null) {
            ((MappedFile)object2).close();
        }
        String[] stringArray = new String[]{oldName};
        File sourceFile = PathsKt.fileSafeConstructor(((Object)Paths.INSTANCE.get(this.path, stringArray)).toString());
        String string2 = sourceFile.getParentFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String[] stringArray2 = new String[1];
        String string3 = sourceFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        String string4 = sourceFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        stringArray2[0] = StringsKt.replace$default((String)string3, (String)string4, (String)newName, (boolean)false, (int)4, null);
        File targetFile = PathsKt.fileSafeConstructor(((Object)Paths.INSTANCE.get(string2, stringArray2)).toString());
        boolean success = sourceFile.renameTo(targetFile);
        if (success) {
            this._resources.remove(this.getResKey(oldName));
        }
        return success;
    }

    @Override
    public void close() {
        Iterator iterator2 = ((Map)this._resources).entrySet().iterator();
        while (iterator2.hasNext()) {
            ResourcePair value2 = (ResourcePair)iterator2.next().getValue();
            value2.getMappedFile().close();
        }
        this._resources.clear();
    }

    private static final boolean listFolder$lambda$0(File file) {
        return file.isDirectory();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/DefaultByteBufferProvider$ResourcePair;", "", "file", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/FileInfo;", "mappedFile", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedFile;", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/FileInfo;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedFile;)V", "getFile", "()Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/FileInfo;", "getMappedFile", "()Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedFile;", "bos-olap-core2"})
    private static final class ResourcePair {
        @NotNull
        private final FileInfo file;
        @NotNull
        private final MappedFile mappedFile;

        public ResourcePair(@NotNull FileInfo file, @NotNull MappedFile mappedFile) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)mappedFile, (String)"mappedFile");
            this.file = file;
            this.mappedFile = mappedFile;
        }

        @NotNull
        public final FileInfo getFile() {
            return this.file;
        }

        @NotNull
        public final MappedFile getMappedFile() {
            return this.mappedFile;
        }
    }
}

