/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders;

import java.io.Closeable;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.EmptyByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IMappedResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.MappedDatabase;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.MappedFile;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.SafeHandle;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002'(B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0006\u0010\u001d\u001a\u00020\u001bJ4\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060\fj\u0002`\u00172\n\u0010!\u001a\u00060\fj\u0002`\u00172\n\u0010\"\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\n2\n\u0010!\u001a\u00060\fj\u0002`\u00172\n\u0010\"\u001a\u00060\u0013j\u0002`\u0014H\u0002J\b\u0010&\u001a\u00020\u0004H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00060\u0013j\u0002`\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0015R\u0015\u0010\u0016\u001a\u00060\fj\u0002`\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedFile;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IMappedResource;", "Ljava/io/Closeable;", "filePath", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "_accessFile", "Ljava/io/RandomAccessFile;", "_lastDb", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedFile$MappedFileDatabase;", "_maxMappedCapacity", "", "_safeHandles", "", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/SafeHandle;", "getFilePath", "()Ljava/lang/String;", "isFree", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "maxMappedCapacity", "Lkd/bos/olapServer2/common/long;", "getMaxMappedCapacity", "()J", "close", "", "delete", "force", "map", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "position", "size", "isReadOnly", "byteOrder", "Ljava/nio/ByteOrder;", "mapCore", "toString", "MapMode", "MappedFileDatabase", "bos-olap-core2"})
public final class MappedFile
implements IMappedResource,
Closeable {
    @NotNull
    private final String filePath;
    @Nullable
    private RandomAccessFile _accessFile;
    @NotNull
    private final List<SafeHandle> _safeHandles;
    @Nullable
    private volatile MappedFileDatabase _lastDb;
    private volatile long _maxMappedCapacity;

    public MappedFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this._safeHandles = new ArrayList();
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IByteBuffer map(long position, long size, boolean isReadOnly, @NotNull ByteOrder byteOrder) {
        MappedFileDatabase mappedFileDatabase;
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        if (!(position >= 0L)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(size >= 0L)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        if (size == 0L) {
            return EmptyByteBuffer.INSTANCE;
        }
        long capacity = Math.addExact(position, size);
        MappedFileDatabase lastDb = this._lastDb;
        if (lastDb != null && capacity <= lastDb.getCapacity()) {
            return lastDb.create(position, size, isReadOnly, byteOrder);
        }
        MappedFile mappedFile = this;
        synchronized (mappedFile) {
            boolean bl = false;
            MappedFileDatabase lastItem = this._lastDb;
            mappedFileDatabase = lastItem != null && capacity <= lastItem.getCapacity() ? lastItem : this.mapCore(position + size, isReadOnly);
        }
        return mappedFileDatabase.create(position, size, isReadOnly, byteOrder);
    }

    private final MappedFileDatabase mapCore(long size, boolean isReadOnly) {
        MappedFileDatabase db;
        long l;
        if (!(size >= 0L)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        RandomAccessFile randomAccessFile = this._accessFile;
        if (randomAccessFile == null) {
            RandomAccessFile randomAccessFile2;
            RandomAccessFile it = randomAccessFile2 = new RandomAccessFile(this.filePath, "rw");
            boolean bl = false;
            this._accessFile = it;
            randomAccessFile = randomAccessFile2;
        }
        RandomAccessFile backingFile = randomAccessFile;
        long fileLength = backingFile.length();
        long capacity = 0L;
        int mode = MapMode.READ_WRITE.getValue();
        if (isReadOnly && fileLength > 0L) {
            if (size > fileLength) {
                String string3 = Res.INSTANCE.getMappedFileException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-MappedFileException_1>(...)");
                Object[] objectArray = new Object[]{this.filePath, size, fileLength};
                throw Res.INSTANCE.getNotSupportedException(string3, objectArray);
            }
            capacity = fileLength;
        } else {
            capacity = Math.max(Bits.INSTANCE.roundTo4096(size), fileLength);
            if (capacity > fileLength) {
                backingFile.setLength(capacity);
            }
        }
        if (capacity != 0L) {
            Object[] objectArray = new Object[]{mode, 0, capacity};
            Object object2 = Bits.INSTANCE.getMapMethod().invoke((Object)backingFile.getChannel(), objectArray);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Long");
            l = (Long)object2;
        } else {
            l = -1L;
        }
        long address = l;
        this._safeHandles.removeIf(arg_0 -> MappedFile.mapCore$lambda$2(mapCore.1.INSTANCE, arg_0));
        SafeHandle handle = SafeHandle.Companion.createFileSafeHandle(address, capacity);
        this._safeHandles.add(handle);
        this._lastDb = db = new MappedFileDatabase(handle);
        this._maxMappedCapacity = Math.max(capacity, this._maxMappedCapacity);
        return db;
    }

    public final void force() {
        block0: {
            Closeable closeable = this._accessFile;
            if (closeable == null || (closeable = ((RandomAccessFile)closeable).getChannel()) == null) break block0;
            ((FileChannel)closeable).force(true);
        }
    }

    public final long getMaxMappedCapacity() {
        return this._maxMappedCapacity;
    }

    @Override
    public void delete() {
        this.close();
        PathsKt.fileSafeConstructor(this.filePath).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MappedFile mappedFile = this;
        synchronized (mappedFile) {
            Unit unit;
            boolean bl = false;
            List<SafeHandle> handles = this._safeHandles;
            for (SafeHandle handle : handles) {
                handle.close();
            }
            handles.clear();
            this._lastDb = null;
            RandomAccessFile randomAccessFile = this._accessFile;
            if (randomAccessFile != null) {
                randomAccessFile.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    @Override
    public boolean isFree() {
        return this._lastDb == null;
    }

    @NotNull
    public String toString() {
        return "filePath: " + this.filePath;
    }

    private static final boolean mapCore$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedFile$MapMode;", "", "value", "", "Lkd/bos/olapServer2/common/int;", "(Ljava/lang/String;II)V", "getValue", "()I", "READ_ONLY", "READ_WRITE", "PRIVATE", "bos-olap-core2"})
    private static final class MapMode
    extends Enum<MapMode> {
        private final int value;
        public static final /* enum */ MapMode READ_ONLY = new MapMode(0);
        public static final /* enum */ MapMode READ_WRITE = new MapMode(1);
        public static final /* enum */ MapMode PRIVATE = new MapMode(2);
        private static final /* synthetic */ MapMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MapMode(int value2) {
            this.value = value2;
        }

        public final int getValue() {
            return this.value;
        }

        public static MapMode[] values() {
            return (MapMode[])$VALUES.clone();
        }

        public static MapMode valueOf(String value2) {
            return Enum.valueOf(MapMode.class, value2);
        }

        @NotNull
        public static EnumEntries<MapMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mapModeArray = new MapMode[]{MapMode.READ_ONLY, MapMode.READ_WRITE, MapMode.PRIVATE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0004\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedFile$MappedFileDatabase;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedDatabase;", "safeHandle", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/SafeHandle;", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/SafeHandle;)V", "finalize", "", "bos-olap-core2"})
    private static final class MappedFileDatabase
    extends MappedDatabase {
        public MappedFileDatabase(@NotNull SafeHandle safeHandle) {
            Intrinsics.checkNotNullParameter((Object)safeHandle, (String)"safeHandle");
            super(safeHandle);
        }

        protected final void finalize() {
            this.getSafeHandle().close();
        }
    }
}

