/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders;

import java.io.Closeable;
import java.nio.ByteOrder;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.EmptyByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IMappedResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.MappedDatabase;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.SafeHandle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.VM;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J4\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0015\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0016\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0004\u001a\b\u0018\u00010\u0005R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00060\fj\u0002`\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedMemory;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IMappedResource;", "Ljava/io/Closeable;", "()V", "_lastDb", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedMemory$MappedMemoryDatabase;", "capacity", "", "Lkd/bos/olapServer2/common/long;", "getCapacity", "()J", "isFree", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "close", "", "delete", "map", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "position", "size", "isReadOnly", "byteOrder", "Ljava/nio/ByteOrder;", "toString", "", "MappedMemoryDatabase", "bos-olap-core2"})
public final class MappedMemory
implements IMappedResource,
Closeable {
    @Nullable
    private volatile MappedMemoryDatabase _lastDb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IByteBuffer map(long position, long size, boolean isReadOnly, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        if (!(position >= 0L)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(size >= 0L)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        if (size == 0L) {
            return EmptyByteBuffer.INSTANCE;
        }
        long capacity = Math.addExact(position, size);
        MappedMemoryDatabase lastDb = this._lastDb;
        if (lastDb != null && capacity <= lastDb.getCapacity()) {
            return lastDb.create(position, size, isReadOnly, byteOrder);
        }
        MappedMemory mappedMemory = this;
        synchronized (mappedMemory) {
            boolean bl = false;
            MappedMemoryDatabase database = this._lastDb;
            if (database == null || capacity > database.getCapacity()) {
                boolean pa = VM.isDirectMemoryPageAligned();
                int pageSize = Bits.INSTANCE.getPageSize();
                long allocSize = Math.max(1L, capacity + (long)(pa ? pageSize : 0));
                long address = 0L;
                if (database == null) {
                    address = Bits.INSTANCE.getUnsafe().allocateMemory(allocSize);
                    Bits.INSTANCE.getUnsafe().setMemory(address, allocSize, (byte)0);
                } else {
                    address = Bits.INSTANCE.getUnsafe().reallocateMemory(database.getAddress(), allocSize);
                    Bits.INSTANCE.getUnsafe().setMemory(address + database.getCapacity(), allocSize - database.getCapacity(), (byte)0);
                    database.close();
                }
                this._lastDb = database = new MappedMemoryDatabase(SafeHandle.Companion.createMemorySafeHandle(address, allocSize));
            }
            IByteBuffer iByteBuffer = database.create(position, size, isReadOnly, byteOrder);
            return iByteBuffer;
        }
    }

    @Override
    public void delete() {
        this.close();
    }

    @Override
    public void close() {
        block1: {
            MappedMemoryDatabase mappedMemoryDatabase;
            MappedMemoryDatabase mappedMemoryDatabase2 = this._lastDb;
            if (mappedMemoryDatabase2 == null) break block1;
            MappedMemoryDatabase $this$close_u24lambda_u241 = mappedMemoryDatabase = mappedMemoryDatabase2;
            boolean bl = false;
            if (!$this$close_u24lambda_u241.isClosed()) {
                $this$close_u24lambda_u241.close();
                Bits.INSTANCE.getUnsafe().freeMemory($this$close_u24lambda_u241.getAddress());
            }
            this._lastDb = null;
        }
    }

    @NotNull
    public String toString() {
        return "Memory(" + this.getCapacity() + ')';
    }

    @Override
    public boolean isFree() {
        return this._lastDb == null;
    }

    public final long getCapacity() {
        MappedMemoryDatabase mappedMemoryDatabase = this._lastDb;
        return mappedMemoryDatabase != null ? mappedMemoryDatabase.getCapacity() : 0L;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedMemory$MappedMemoryDatabase;", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedDatabase;", "safeHandle", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/SafeHandle;", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/MappedMemory;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/SafeHandle;)V", "close", "", "bos-olap-core2"})
    private final class MappedMemoryDatabase
    extends MappedDatabase {
        public MappedMemoryDatabase(SafeHandle safeHandle) {
            Intrinsics.checkNotNullParameter((Object)safeHandle, (String)"safeHandle");
            super(safeHandle);
        }

        public final void close() {
            this.getSafeHandle().close();
        }
    }
}

