/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders;

import kd.bos.olapServer2.common.ParallelTaskManager;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IMappedResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.MappedMemory;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ResourceCacheItem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u001d\u001a\u00060\u0006j\u0002`\t2\n\u0010\u001e\u001a\u00060\u0006j\u0002`\t2\n\u0010\u001f\u001a\u00060\u0006j\u0002`\t2\b\b\u0002\u0010 \u001a\u00020\u0006H\u0002J\u0006\u0010!\u001a\u00020\"J \u0010#\u001a\u00020\u000b2\n\u0010$\u001a\u00060\u0006j\u0002`\t2\n\u0010%\u001a\u00060\u0006j\u0002`\tH\u0002J\u0014\u0010&\u001a\u00020\u000b2\n\u0010'\u001a\u00060\u0006j\u0002`\tH\u0002J\u0006\u0010(\u001a\u00020\"J\u001e\u0010)\u001a\u00020\u000b2\n\u0010$\u001a\u00060\u0006j\u0002`\t2\n\u0010%\u001a\u00060\u0006j\u0002`\tJ\u0012\u0010*\u001a\u00020\u000b2\n\u0010'\u001a\u00060\u0006j\u0002`\tJ\u0006\u0010+\u001a\u00020\"J\b\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\u0006j\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00060\u0006j\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0010\u001a\u00060\u0006j\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR\u0015\u0010\u0012\u001a\u00060\u0013j\u0002`\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0015R\u0012\u0010\u0016\u001a\u00060\u0006j\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00060\u0006j\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u001aR\u0015\u0010\u001b\u001a\u00060\u0006j\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000e\u00a8\u0006/"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ResourceCacheItem;", "", "_mappedFile", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IMappedResource;", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IMappedResource;)V", "_fileHeaderLengthCache", "", "_fileLengthCache", "_validCapacity", "Lkd/bos/olapServer2/common/long;", "contentBuffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "contentBufferSize", "getContentBufferSize", "()J", "fileHeadBuffer", "headBufferSize", "getHeadBufferSize", "isMemoryCache", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "lastTranId", "releaseTime", "getReleaseTime", "setReleaseTime", "(J)V", "validFileLength", "getValidFileLength", "calcAlignmentSize", "requiredSize", "headerSize", "defaultMaxValue", "closeAndDelete", "", "createContentBuffer", "position", "minSize", "createFileHeadBuffer", "size", "force", "mapContentBuffer", "mapFileHeadBuffer", "resetBeforeReuse", "toString", "", "Companion", "bos-olap-core2"})
public final class ResourceCacheItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IMappedResource _mappedFile;
    private long _fileLengthCache;
    private long _fileHeaderLengthCache;
    private long _validCapacity;
    @Nullable
    private IByteBuffer fileHeadBuffer;
    @Nullable
    private IByteBuffer contentBuffer;
    private long lastTranId;
    private long releaseTime;
    public static final long IntMax = Integer.MAX_VALUE;
    public static final long InitMinCapacity = 16384L;
    private static final long Alignment_By_4K = 4096L;
    public static final long Alignment_By_4K_Mask = 4095L;
    public static final long Alignment_By_4K_Mask_INV = -4096L;

    public ResourceCacheItem(@NotNull IMappedResource _mappedFile) {
        Intrinsics.checkNotNullParameter((Object)_mappedFile, (String)"_mappedFile");
        this._mappedFile = _mappedFile;
        this._fileLengthCache = -1L;
        this._fileHeaderLengthCache = -1L;
    }

    public final long getValidFileLength() {
        return this.getHeadBufferSize() + this._validCapacity;
    }

    public final long getHeadBufferSize() {
        IByteBuffer iByteBuffer = this.fileHeadBuffer;
        return iByteBuffer != null ? iByteBuffer.getCapacity() : 0L;
    }

    public final long getContentBufferSize() {
        IByteBuffer iByteBuffer = this.contentBuffer;
        return iByteBuffer != null ? iByteBuffer.getCapacity() : 0L;
    }

    public final void resetBeforeReuse() {
        IByteBuffer iByteBuffer = this.fileHeadBuffer;
        if (iByteBuffer != null) {
            iByteBuffer.clearData();
        }
        IByteBuffer buffer = this.contentBuffer;
        if (buffer != null) {
            long contentSize = Math.min(buffer.getCapacity(), Math.max(16384L - this.getHeadBufferSize(), 0L));
            if (contentSize > 0L) {
                buffer.clearData(0L, contentSize);
            }
            this._validCapacity = contentSize;
        }
    }

    @NotNull
    public final IByteBuffer mapFileHeadBuffer(long size) {
        IByteBuffer iByteBuffer;
        IByteBuffer buffer = this.fileHeadBuffer;
        if (buffer != null) {
            if (!(buffer.getCapacity() == size)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            iByteBuffer = buffer;
        } else {
            iByteBuffer = this.createFileHeadBuffer(size);
        }
        return iByteBuffer;
    }

    private final IByteBuffer createFileHeadBuffer(long size) {
        IByteBuffer result2;
        this.fileHeadBuffer = result2 = IMappedResource.DefaultImpls.map$default(this._mappedFile, 0L, size, false, null, 8, null);
        this._fileHeaderLengthCache = size;
        return result2;
    }

    private final long calcAlignmentSize(long requiredSize, long headerSize, long defaultMaxValue) {
        return requiredSize <= 16384L ? 16384L : Math.min(requiredSize + 4095L & 0xFFFFFFFFFFFFF000L, defaultMaxValue + headerSize);
    }

    static /* synthetic */ long calcAlignmentSize$default(ResourceCacheItem resourceCacheItem, long l, long l2, long l3, int n, Object object2) {
        if ((n & 4) != 0) {
            l3 = Integer.MAX_VALUE;
        }
        return resourceCacheItem.calcAlignmentSize(l, l2, l3);
    }

    @NotNull
    public final IByteBuffer mapContentBuffer(long position, long minSize) {
        long requiredContentSize = ResourceCacheItem.calcAlignmentSize$default(this, position + minSize, position, 0L, 4, null) - position;
        IByteBuffer curBuffer = this.contentBuffer;
        if (curBuffer != null) {
            long endPos;
            boolean needToClean;
            boolean bl = needToClean = requiredContentSize > this._validCapacity;
            if (needToClean && this._validCapacity < (endPos = Math.min(requiredContentSize, this._fileLengthCache - position))) {
                curBuffer.clearData(this._validCapacity, endPos - this._validCapacity);
            }
            if (curBuffer.getCapacity() >= requiredContentSize) {
                IByteBuffer slice = curBuffer.slice(0L, requiredContentSize);
                this._validCapacity = requiredContentSize;
                return slice;
            }
        }
        return this.createContentBuffer(position, requiredContentSize);
    }

    private final IByteBuffer createContentBuffer(long position, long minSize) {
        IByteBuffer result2;
        this.contentBuffer = result2 = IMappedResource.DefaultImpls.map$default(this._mappedFile, position, minSize, false, null, 8, null);
        this._validCapacity = minSize;
        this._fileLengthCache = this.getHeadBufferSize() + result2.getCapacity();
        if (this.getHeadBufferSize() > 0L) {
            this.createFileHeadBuffer(this.getHeadBufferSize());
        }
        return result2.slice(0L, minSize);
    }

    public final void force() {
        this.lastTranId = ParallelTaskManager.Companion.put(this.lastTranId, (Function0<Unit>)((Function0)force.1.INSTANCE));
    }

    public final void closeAndDelete() {
        this._mappedFile.delete();
    }

    public final long getReleaseTime() {
        return this.releaseTime;
    }

    public final void setReleaseTime(long l) {
        this.releaseTime = l;
    }

    public final boolean isMemoryCache() {
        return this._mappedFile instanceof MappedMemory;
    }

    @NotNull
    public String toString() {
        return "CacheByteBufferResource : " + this._mappedFile;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0004j\u0002`\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\u0004j\u0002`\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ResourceCacheItem$Companion;", "", "()V", "Alignment_By_4K", "", "Lkd/bos/olapServer2/common/long;", "Alignment_By_4K_Mask", "Alignment_By_4K_Mask_INV", "InitMinCapacity", "IntMax", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

