/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData;

import java.math.BigInteger;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.Bits;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000bJ,\u0010\r\u001a\u00060\u0004j\u0002`\u000e2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000bH\u0002J&\u0010\u000f\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ(\u0010\u0011\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/BytesTransform;", "", "()V", "firstLongMark", "", "readZipBigInteger", "Ljava/math/BigInteger;", "buffer", "", "start", "", "Lkd/bos/olapServer2/common/int;", "len", "readZipLong", "Lkd/bos/olapServer2/common/long;", "writeZipBigInteger", "value", "writeZipLong", "bos-olap-core2"})
public final class BytesTransform {
    @NotNull
    public static final BytesTransform INSTANCE = new BytesTransform();
    private static final long firstLongMark = Long.MAX_VALUE;

    private BytesTransform() {
    }

    public final int writeZipBigInteger(@NotNull BigInteger value2, @NotNull byte[] buffer, int start) {
        int n;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long firstLong = value2.longValue() & Long.MAX_VALUE;
        BigInteger bigInteger = value2.shiftRight(63);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.shiftRight(n)");
        long secondLong = bigInteger.longValue();
        if (secondLong == 0L) {
            Bits.INSTANCE.putLongL(firstLong, buffer, start);
            n = 8;
        } else {
            Bits.INSTANCE.putLongL(firstLong, buffer, start);
            n = 8 + this.writeZipLong(secondLong, buffer, start + 8);
        }
        return n;
    }

    @NotNull
    public final BigInteger readZipBigInteger(@NotNull byte[] buffer, int start, int len) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BigInteger firstLong = BigInteger.valueOf(Bits.INSTANCE.getLongL(buffer, start));
        BigInteger secondLong = BigInteger.valueOf(this.readZipLong(buffer, start + 8, len - 8));
        Intrinsics.checkNotNull((Object)firstLong);
        Intrinsics.checkNotNull((Object)secondLong);
        BigInteger bigInteger = secondLong.shiftLeft(63);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.shiftLeft(n)");
        BigInteger bigInteger2 = firstLong.or(bigInteger);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.or(other)");
        return bigInteger2;
    }

    private final int writeZipLong(long value2, byte[] buffer, int start) {
        int index2 = start;
        for (long v = value2; v > 0L; v >>= 8) {
            buffer[index2++] = (byte)v;
        }
        return index2 - start;
    }

    private final long readZipLong(byte[] buffer, int start, int len) {
        long result2 = 0L;
        for (int i = 0; i < len; ++i) {
            result2 |= CommonTypesKt.toLongNoNegative(buffer[start + i]) << 8 * i;
        }
        return result2;
    }
}

