/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData;

import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fR\u001e\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/ConcurrentInstance;", "T", "", "creator", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "_items", "", "Ljava/util/concurrent/atomic/AtomicReference;", "[Ljava/util/concurrent/atomic/AtomicReference;", "borrow", "()Ljava/lang/Object;", "release", "", "item", "(Ljava/lang/Object;)V", "bos-olap-core2"})
public final class ConcurrentInstance<T> {
    @NotNull
    private final Function0<T> creator;
    @NotNull
    private final AtomicReference<T>[] _items;

    public ConcurrentInstance(@NotNull Function0<? extends T> creator) {
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        this.creator = creator;
        int n = 0;
        AtomicReference[] atomicReferenceArray = new AtomicReference[256];
        ConcurrentInstance concurrentInstance = this;
        while (n < 256) {
            int n2 = n++;
            atomicReferenceArray[n2] = new AtomicReference<Object>(null);
        }
        concurrentInstance._items = atomicReferenceArray;
    }

    public final T borrow() {
        long tid = Thread.currentThread().getId();
        AtomicReference<T> itemRef = this._items[(int)tid & 0xFF];
        T item = itemRef.get();
        if (item != null && itemRef.compareAndSet(item, null)) {
            return item;
        }
        return (T)this.creator.invoke();
    }

    public final void release(T item) {
        long tid = Thread.currentThread().getId();
        AtomicReference<T> itemRef = this._items[(int)tid & 0xFF];
        itemRef.set(item);
    }
}

