/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData;

import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.UUID;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.BytesTransform;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.EncodeContext;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.EncodingVersion;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IBoxedOutputStream;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IEncoding;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IntArrayByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.RealScale;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.decimal4j.immutable.Decimal6f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0016J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016J*\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016J\u001e\u0010\u000f\u001a\u00060\bj\u0002`\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/Encoding;", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/IEncoding;", "version", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/EncodingVersion;", "(Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/EncodingVersion;)V", "decode", "", "zipLong", "", "Lkd/bos/olapServer2/common/long;", "len", "", "Lkd/bos/olapServer2/common/int;", "byteArray", "", "encode", "value", "ctx", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/EncodeContext;", "Companion", "bos-olap-core2"})
public final class Encoding
implements IEncoding {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EncodingVersion version;
    @NotNull
    private static final Unsafe unsafe;
    private static final long intValOffset;
    private static final long intCompactOffset;
    @NotNull
    private static final long[] powerDecimals;
    @NotNull
    private static final long[] decimalDotMarks;
    @NotNull
    private static final long[] negativeDecimalDotMarks;
    @NotNull
    private static final BigDecimal LongMaxValue;
    @NotNull
    private static final BigDecimal LongMinValue;
    private static final int MaxDecimalScale = 15;
    private static final long INFLATED = Long.MIN_VALUE;

    public Encoding(@NotNull EncodingVersion version) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.version = version;
    }

    @Override
    @Nullable
    public Object decode(long zipLong) {
        if (zipLong == 0L) {
            Object object2;
            switch (WhenMappings.$EnumSwitchMapping$0[this.version.ordinal()]) {
                case 1: {
                    object2 = null;
                    break;
                }
                case 2: {
                    object2 = CommonTypesKt.getUndefined();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return object2;
        }
        boolean sign = !CommonTypesKt.getBit(zipLong, 62);
        int scale = (int)(zipLong >>> 60 & 3L);
        long pValue = zipLong & 0xFFFFFFFFFFFFFFFL;
        long uValue = sign ? pValue : (pValue == 0L ? Long.MIN_VALUE : -pValue);
        return scale == 0 ? Encoding.Companion.tryToInt(uValue) : BigDecimal.valueOf(uValue, scale);
    }

    @Override
    @Nullable
    public Object decode(long zipLong, int len) {
        Object object2;
        switch (Encoding.Companion.getDataType(zipLong)) {
            case 0: {
                object2 = Encoding.Companion.decodeNumber(zipLong & 0xFFFFFFFFFFFFL, Encoding.Companion.getSecondDataType(zipLong), true);
                break;
            }
            case 1: {
                object2 = Encoding.Companion.decodeNumber(zipLong & 0xFFFFFFFFFFFFL, Encoding.Companion.getSecondDataType(zipLong), false);
                break;
            }
            case 2: {
                object2 = zipLong == 0x2000000000000000L;
                break;
            }
            case 3: {
                byte[] bytes2 = new byte[len];
                for (int i = 0; i < len; ++i) {
                    bytes2[i] = (byte)(zipLong >> 8 * i & 0xFFL);
                }
                object2 = new String(bytes2, 0, len, Charsets.UTF_8);
                break;
            }
            case 5: {
                object2 = null;
                break;
            }
            case 7: {
                byte[] bytes3 = new byte[len];
                if (len != 0) {
                    Bits.INSTANCE.putLongLL(zipLong, bytes3, 0, len);
                }
                object2 = Encoding.Companion.decodeByteArray(bytes3, len, Encoding.Companion.getSecondDataType(zipLong), false);
                break;
            }
            default: {
                throw new NotSupportedException("Could not decode the zipLong: " + zipLong);
            }
        }
        return object2;
    }

    @Override
    @Nullable
    public Object decode(long zipLong, @NotNull byte[] byteArray, int len) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        switch (Encoding.Companion.getDataType(zipLong)) {
            case 0: {
                if (len == 8) {
                    object2 = Encoding.Companion.decodeNumber(Bits.INSTANCE.getLongL(byteArray, 0), Encoding.Companion.getSecondDataType(zipLong), true);
                    break;
                }
                object2 = Encoding.Companion.decodeNumber(BytesTransform.INSTANCE.readZipBigInteger(byteArray, 0, len), Encoding.Companion.getSecondDataType(zipLong), true);
                break;
            }
            case 1: {
                if (len == 8) {
                    object2 = Encoding.Companion.decodeNumber(Bits.INSTANCE.getLongL(byteArray, 0), Encoding.Companion.getSecondDataType(zipLong), false);
                    break;
                }
                object2 = Encoding.Companion.decodeNumber(BytesTransform.INSTANCE.readZipBigInteger(byteArray, 0, len), Encoding.Companion.getSecondDataType(zipLong), false);
                break;
            }
            case 3: {
                object2 = new String(byteArray, 0, len, Charsets.UTF_8);
                break;
            }
            case 4: {
                object2 = Encoding.Companion.decodeUUID(byteArray);
                break;
            }
            case 5: {
                object2 = null;
                break;
            }
            case 7: {
                object2 = Encoding.Companion.decodeByteArray(byteArray, len, Encoding.Companion.getSecondDataType(zipLong), true);
                break;
            }
            default: {
                throw new NotSupportedException("decode in heap error, zipLong = " + zipLong);
            }
        }
        return object2;
    }

    @Override
    public long encode(@Nullable Object value2, @NotNull EncodeContext ctx) {
        long l;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object object2 = value2;
        if (Intrinsics.areEqual((Object)object2, (Object)CommonTypesKt.getUndefined())) {
            l = Encoding.Companion.encodeUndefined(ctx);
        } else if (object2 == null) {
            l = Encoding.Companion.encodeNull(ctx, this.version);
        } else if (object2 instanceof BigDecimal) {
            l = Encoding.Companion.encodeBigDecimal((BigDecimal)value2, ctx);
        } else if (object2 instanceof Integer) {
            l = Encoding.Companion.encodeInt(((Number)value2).intValue());
        } else if (object2 instanceof Long) {
            l = Encoding.Companion.encodeLong(((Number)value2).longValue(), ctx);
        } else if (object2 instanceof Decimal6f) {
            l = Encoding.Companion.encodeDecimal((Decimal6f)value2, ctx);
        } else if (object2 instanceof Boolean) {
            l = Encoding.Companion.encodeBool((Boolean)value2, ctx);
        } else if (object2 instanceof String) {
            l = Encoding.Companion.encodeString((String)value2, ctx);
        } else if (object2 instanceof UUID) {
            l = Encoding.Companion.encodeUUID((UUID)value2, ctx);
        } else if (object2 instanceof IBoxedOutputStream) {
            l = Encoding.Companion.encodeStream((IBoxedOutputStream)value2, ctx);
        } else if (object2 instanceof byte[]) {
            l = Encoding.Companion.encodeByteArray((byte[])value2, ctx);
        } else {
            throw new NotSupportedException("encode in heap error,notSupported");
        }
        return l;
    }

    static {
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        Field[] fieldArray = new Field[]{unsafeField};
        AccessibleObject.setAccessible(fieldArray, true);
        Object object2 = unsafeField.get(null);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type sun.misc.Unsafe");
        unsafe = (Unsafe)object2;
        intValOffset = unsafe.objectFieldOffset(BigDecimal.class.getDeclaredField("intVal"));
        intCompactOffset = unsafe.objectFieldOffset(BigDecimal.class.getDeclaredField("intCompact"));
        long[] lArray = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L};
        powerDecimals = lArray;
        lArray = new long[]{CommonTypesKt.setTrue(0L, 63), CommonTypesKt.setTrue(0x1000000000000000L, 63), CommonTypesKt.setTrue(0x2000000000000000L, 63), CommonTypesKt.setTrue(0x3000000000000000L, 63)};
        decimalDotMarks = lArray;
        lArray = new long[]{CommonTypesKt.setTrue(0x4000000000000000L, 63), CommonTypesKt.setTrue(0x5000000000000000L, 63), CommonTypesKt.setTrue(0x6000000000000000L, 63), CommonTypesKt.setTrue(0x7000000000000000L, 63)};
        negativeDecimalDotMarks = lArray;
        LongMaxValue = new BigDecimal(Long.MAX_VALUE);
        LongMinValue = new BigDecimal(Long.MIN_VALUE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017J4\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\tj\u0002`\u001c2\n\u0010\u001d\u001a\u00060\tj\u0002`\u001c2\n\u0010\u001e\u001a\u00060\u0016j\u0002`\u0017H\u0002J(\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\n\u0010\"\u001a\u00060\tj\u0002`\u001c2\n\u0010#\u001a\u00060\u0016j\u0002`\u0017H\u0002J,\u0010\u001f\u001a\u00020\u00012\n\u0010 \u001a\u00060\u0004j\u0002`\r2\n\u0010\"\u001a\u00060\tj\u0002`\u001c2\n\u0010#\u001a\u00060\u0016j\u0002`\u0017H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001aH\u0002J\u001c\u0010'\u001a\u00060\u0004j\u0002`\r2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\u00060\u0004j\u0002`\r2\n\u0010(\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u0010,\u001a\u00060\u0004j\u0002`\r2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0002J \u0010-\u001a\u00060\u0004j\u0002`\r2\n\u0010(\u001a\u00060.j\u0002`/2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u00100\u001a\u00060\u0004j\u0002`\r2\n\u0010(\u001a\u00060\tj\u0002`\u001cH\u0002J \u00101\u001a\u00060\u0004j\u0002`\r2\n\u0010(\u001a\u00060\u0004j\u0002`\r2\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u00102\u001a\u00060\u0004j\u0002`\r2\u0006\u0010)\u001a\u00020*2\u0006\u00103\u001a\u000204H\u0002J,\u00105\u001a\u00060\u0004j\u0002`\r2\n\u00106\u001a\u00060\u0004j\u0002`\r2\n\u0010\"\u001a\u00060\tj\u0002`\u001c2\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u00107\u001a\u00060\u0004j\u0002`\r2\u0006\u0010(\u001a\u0002082\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u00109\u001a\u00060\u0004j\u0002`\r2\u0006\u0010(\u001a\u00020:2\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u0010;\u001a\u00060\u0004j\u0002`\r2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0002J\u0014\u0010<\u001a\u00060\u0004j\u0002`\r2\u0006\u0010)\u001a\u00020*H\u0002J\u0014\u0010=\u001a\u00020\t2\n\u0010>\u001a\u00060\u0004j\u0002`\rH\u0002J$\u0010?\u001a\u00060\u0004j\u0002`\r2\n\u0010@\u001a\u00060\u0004j\u0002`\r2\n\u0010\"\u001a\u00060\tj\u0002`\u001cH\u0002J\u0014\u0010A\u001a\u00020\t2\n\u0010>\u001a\u00060\u0004j\u0002`\rH\u0002J\u0014\u0010B\u001a\u00020\u00012\n\u0010(\u001a\u00060\u0004j\u0002`\rH\u0002J\u0010\u0010C\u001a\u00060\u0004j\u0002`\r*\u00020\u0006H\u0002J\u000e\u0010D\u001a\u0004\u0018\u00010!*\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\u0004j\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u0004j\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/Encoding$Companion;", "", "()V", "INFLATED", "", "LongMaxValue", "Ljava/math/BigDecimal;", "LongMinValue", "MaxDecimalScale", "", "decimalDotMarks", "", "intCompactOffset", "Lkd/bos/olapServer2/common/long;", "intValOffset", "negativeDecimalDotMarks", "powerDecimals", "unsafe", "Lsun/misc/Unsafe;", "create", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/Encoding;", "isSupportUndefined", "", "Lkd/bos/olapServer2/common/bool;", "decodeByteArray", "byteArray", "", "len", "Lkd/bos/olapServer2/common/int;", "secondDataType", "requireCopyByteArray", "decodeNumber", "pValue", "Ljava/math/BigInteger;", "scale", "sign", "decodeUUID", "Ljava/util/UUID;", "bytes", "encodeBigDecimal", "value", "ctx", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/EncodeContext;", "encodeBool", "encodeByteArray", "encodeDecimal", "Lorg/decimal4j/immutable/Decimal6f;", "Lkd/bos/olapServer2/common/decimal;", "encodeInt", "encodeLong", "encodeNull", "version", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/EncodingVersion;", "encodeSimpleNumber", "intCompact", "encodeStream", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/IBoxedOutputStream;", "encodeString", "", "encodeUUID", "encodeUndefined", "getDataType", "indexValue", "getNumberIndexValue", "uValue", "getSecondDataType", "tryToInt", "getIntCompact", "getIntVal", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Encoding create(boolean isSupportUndefined) {
            return isSupportUndefined ? new Encoding(EncodingVersion.V3) : new Encoding(EncodingVersion.V2);
        }

        private final BigInteger getIntVal(BigDecimal $this$getIntVal) {
            Object object2 = unsafe.getObjectVolatile($this$getIntVal, intValOffset);
            return object2 instanceof BigInteger ? (BigInteger)object2 : null;
        }

        private final long getIntCompact(BigDecimal $this$getIntCompact) {
            return unsafe.getLongVolatile($this$getIntCompact, intCompactOffset);
        }

        private final long encodeBigDecimal(BigDecimal value2, EncodeContext ctx) {
            int scale = value2.scale();
            long intCompact = this.getIntCompact(value2);
            boolean bl = 0 <= scale ? scale < 16 : false;
            if (bl && intCompact != Long.MIN_VALUE) {
                return this.encodeSimpleNumber(intCompact, scale, ctx);
            }
            Object[] objectArray = LongMinValue;
            if (!(value2.compareTo((Object)LongMaxValue) <= 0 ? 0 <= value2.compareTo(objectArray) : false)) {
                String string2 = Res.INSTANCE.getArrayJsonReaderException_8();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ArrayJsonReaderException_8>(...)");
                objectArray = new Object[]{LongMinValue, LongMaxValue, value2};
                throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
            }
            BigDecimal newValue = scale > 15 ? value2.setScale(15, 4) : value2;
            scale = (newValue = newValue.stripTrailingZeros()).scale();
            if (scale < 0) {
                newValue = new BigDecimal(newValue.toPlainString());
                scale = newValue.scale();
            }
            BigDecimal bigDecimal = newValue;
            Intrinsics.checkNotNull((Object)bigDecimal);
            intCompact = this.getIntCompact(bigDecimal);
            if (intCompact != Long.MIN_VALUE) {
                if (!(0 <= scale ? scale < 16 : false)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                return this.encodeSimpleNumber(intCompact, scale, ctx);
            }
            byte[] byteArray = ctx.getByteArray();
            long firstMask = 0L;
            Object object2 = newValue;
            Intrinsics.checkNotNull((Object)object2);
            BigInteger bigInteger = this.getIntVal((BigDecimal)object2);
            Intrinsics.checkNotNull((Object)bigInteger, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger intVal = bigInteger;
            if (intVal.compareTo(BigInteger.ZERO) >= 0) {
                firstMask = 0L | (long)scale;
            } else {
                firstMask = 0x10L | (long)scale;
                BigInteger bigInteger2 = intVal.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.negate()");
                intVal = bigInteger2;
            }
            if (!(scale >= 0)) {
                object2 = "Failed requirement.";
                throw new IllegalArgumentException(object2.toString());
            }
            ctx.setLen(BytesTransform.INSTANCE.writeZipBigInteger(intVal, byteArray, 0));
            return firstMask << 56 | (long)ctx.getLen() << 48;
        }

        private final long encodeSimpleNumber(long intCompact, int scale, EncodeContext ctx) {
            int realScale;
            long uValue = intCompact;
            if (scale <= 3) {
                boolean bl = -1152921504606846975L <= uValue ? uValue < 0x1000000000000000L : false;
                if (bl) {
                    return this.getNumberIndexValue(uValue, scale);
                }
            }
            if ((realScale = RealScale.INSTANCE.getLen(uValue, scale)) != scale) {
                uValue /= powerDecimals[scale - realScale - 1];
                if (realScale <= 3) {
                    boolean bl = -1152921504606846975L <= uValue ? uValue < 0x1000000000000000L : false;
                    if (bl) {
                        return this.getNumberIndexValue(uValue, realScale);
                    }
                }
            }
            long mask = 0L;
            if (uValue >= 0L) {
                mask = 0L | (long)realScale;
            } else {
                mask = 0x10L | (long)realScale;
                long l = uValue = uValue == Long.MIN_VALUE ? 0L : -uValue;
            }
            boolean bl = 0L <= uValue ? uValue < 0x1000000000000L : false;
            if (bl) {
                ctx.setLen(6);
                return mask << 56 | 0x6000000000000L | uValue;
            }
            ctx.setLen(8);
            Bits.INSTANCE.putLongL(uValue, ctx.getByteArray(), 0);
            return mask << 56 | 0x8000000000000L;
        }

        private final long getNumberIndexValue(long uValue, int scale) {
            return uValue >= 0L ? uValue | decimalDotMarks[scale] : -uValue | negativeDecimalDotMarks[scale];
        }

        private final long encodeString(String value2, EncodeContext ctx) {
            byte[] byArray = value2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] bytes2 = byArray;
            int len = bytes2.length;
            ctx.setLen(len);
            long result2 = 0x3000000000000000L;
            if (len <= 6) {
                for (int i = 0; i < len; ++i) {
                    result2 |= CommonTypesKt.toLongNoNegative(bytes2[i]) << 8 * i;
                }
            } else {
                byte[] byteArray = ctx.getByteArray(len);
                System.arraycopy(bytes2, 0, byteArray, 0, len);
            }
            int flagLen = len <= 252 ? len : 255;
            return result2 | (long)flagLen << 48;
        }

        private final long encodeBool(boolean value2, EncodeContext ctx) {
            ctx.setLen(0);
            return value2 ? 0x2000000000000000L : 0x2100000000000000L;
        }

        private final long encodeNull(EncodeContext ctx, EncodingVersion version) {
            long l;
            ctx.setLen(0);
            switch (WhenMappings.$EnumSwitchMapping$0[version.ordinal()]) {
                case 1: {
                    l = 0L;
                    break;
                }
                case 2: {
                    l = 0x5000000000000000L;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return l;
        }

        private final long encodeUndefined(EncodeContext ctx) {
            ctx.setLen(0);
            return 0L;
        }

        private final long encodeDecimal(Decimal6f value2, EncodeContext ctx) {
            long uValue = value2.unscaledValue();
            int realScale = RealScale.INSTANCE.getLenAs6Scale(uValue);
            long result2 = realScale == 6 ? uValue : uValue / powerDecimals[5 - realScale];
            return this.encodeSimpleNumber(result2, realScale, ctx);
        }

        private final long encodeUUID(UUID value2, EncodeContext ctx) {
            byte[] byteArray = ctx.getByteArray();
            Bits.INSTANCE.putLongL(value2.getMostSignificantBits(), byteArray, 0);
            Bits.INSTANCE.putLongL(value2.getLeastSignificantBits(), byteArray, 8);
            ctx.setLen(16);
            return 0x4010000000000000L;
        }

        private final long encodeByteArray(byte[] value2, EncodeContext ctx) {
            long l;
            if (value2.length == 0) {
                return 0x7100000000000000L;
            }
            OutputStream stream = ctx.createStream(value2.length);
            stream.write(value2);
            stream.flush();
            int ctxLen = ctx.getLen();
            if (ctxLen == 0) {
                l = 0x7100000000000000L | (long)ctxLen << 48;
            } else if (ctxLen <= 6) {
                l = 0x7100000000000000L | (long)ctxLen << 48 | Bits.INSTANCE.getLongLL(value2, 0, ctxLen);
            } else {
                int flagLen = ctxLen <= 252 ? ctxLen : 255;
                l = 0x7100000000000000L | (long)flagLen << 48;
            }
            return l;
        }

        private final long encodeStream(IBoxedOutputStream value2, EncodeContext ctx) {
            long l;
            long secondDataType = value2.getDataTypeFlag();
            if (!(0L <= secondDataType ? secondDataType < 15L : false)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            OutputStream stream = ctx.createStream(value2.getMinCapacity());
            value2.write(stream);
            stream.flush();
            int ctxLen = ctx.getLen();
            if (ctxLen == 0) {
                l = 0x7000000000000000L | secondDataType << 56 | (long)ctxLen << 48;
            } else if (ctxLen <= 6) {
                l = 0x7000000000000000L | secondDataType << 56 | (long)ctxLen << 48 | Bits.INSTANCE.getLongLL(ctx.getCurrent(), 0, ctxLen);
            } else {
                int flagLen = ctxLen <= 252 ? ctxLen : 255;
                l = 0x7000000000000000L | secondDataType << 56 | (long)flagLen << 48;
            }
            return l;
        }

        private final long encodeLong(long value2, EncodeContext ctx) {
            boolean bl = -1152921504606846975L <= value2 ? value2 < 0x1000000000000000L : false;
            if (bl) {
                return this.getNumberIndexValue(value2, 0);
            }
            long mask = 0L;
            long pValue = 0L;
            if (value2 >= 0L) {
                mask = 0L;
                pValue = value2;
            } else {
                mask = 16L;
                pValue = value2 == Long.MIN_VALUE ? 0L : -value2;
            }
            ctx.setLen(8);
            Bits.INSTANCE.putLongL(pValue, ctx.getByteArray(), 0);
            return mask << 56 | 0x8000000000000L;
        }

        private final long encodeInt(int value2) {
            return this.getNumberIndexValue(value2, 0);
        }

        private final Object decodeNumber(long pValue, int scale, boolean sign) {
            Object object2;
            long uValue = sign ? pValue : (pValue == 0L ? Long.MIN_VALUE : -pValue);
            switch (scale) {
                case 6: {
                    Decimal6f decimal6f = Decimal6f.valueOfUnscaled((long)uValue, (int)6);
                    object2 = decimal6f;
                    Intrinsics.checkNotNullExpressionValue((Object)decimal6f, (String)"valueOfUnscaled(...)");
                    break;
                }
                case 5: {
                    Object object3 = (-922337203685477580L <= uValue ? uValue < 0xCCCCCCCCCCCCCCDL : false) ? Decimal6f.valueOfUnscaled((long)uValue, (int)5) : BigDecimal.valueOf(uValue, 5);
                    Intrinsics.checkNotNull((Object)object3);
                    object2 = object3;
                    break;
                }
                case 4: {
                    Object object4 = (-92233720368547758L <= uValue ? uValue < 92233720368547759L : false) ? Decimal6f.valueOfUnscaled((long)uValue, (int)4) : BigDecimal.valueOf(uValue, 4);
                    Intrinsics.checkNotNull((Object)object4);
                    object2 = object4;
                    break;
                }
                case 3: {
                    Object object5 = (-9223372036854775L <= uValue ? uValue < 9223372036854776L : false) ? Decimal6f.valueOfUnscaled((long)uValue, (int)3) : BigDecimal.valueOf(uValue, 3);
                    Intrinsics.checkNotNull((Object)object5);
                    object2 = object5;
                    break;
                }
                case 2: {
                    Object object6 = (-922337203685477L <= uValue ? uValue < 922337203685478L : false) ? Decimal6f.valueOfUnscaled((long)uValue, (int)2) : BigDecimal.valueOf(uValue, 2);
                    Intrinsics.checkNotNull((Object)object6);
                    object2 = object6;
                    break;
                }
                case 1: {
                    Object object7 = (-92233720368547L <= uValue ? uValue < 92233720368548L : false) ? Decimal6f.valueOfUnscaled((long)uValue, (int)1) : BigDecimal.valueOf(uValue, 1);
                    Intrinsics.checkNotNull((Object)object7);
                    object2 = object7;
                    break;
                }
                case 0: {
                    object2 = this.tryToInt(uValue);
                    break;
                }
                default: {
                    BigDecimal bigDecimal = BigDecimal.valueOf(uValue, scale);
                    Intrinsics.checkNotNull((Object)bigDecimal);
                    object2 = bigDecimal;
                }
            }
            return object2;
        }

        private final Object tryToInt(long value2) {
            return (Integer.MIN_VALUE <= value2 ? value2 <= Integer.MAX_VALUE : false) ? (Number)((int)value2) : (Number)value2;
        }

        private final Object decodeNumber(BigInteger pValue, int scale, boolean sign) {
            BigDecimal bigDecimal;
            if (sign) {
                bigDecimal = new BigDecimal(pValue, scale);
            } else {
                BigInteger bigInteger = pValue.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.negate()");
                bigDecimal = new BigDecimal(bigInteger, scale);
            }
            return bigDecimal;
        }

        private final UUID decodeUUID(byte[] bytes2) {
            long mostSigBits = Bits.INSTANCE.getLongL(bytes2, 0);
            long leastSigBits = Bits.INSTANCE.getLongL(bytes2, 8);
            return new UUID(mostSigBits, leastSigBits);
        }

        private final Object decodeByteArray(byte[] byteArray, int len, int secondDataType, boolean requireCopyByteArray) {
            Object[] objectArray;
            switch (secondDataType) {
                case 1: {
                    if (requireCopyByteArray) {
                        byte[] byArray = Arrays.copyOf(byteArray, len);
                        objectArray = byArray;
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
                        break;
                    }
                    objectArray = byteArray;
                    break;
                }
                case 2: {
                    objectArray = new IntArrayByteBuffer(byteArray, 0, len).toIntArray();
                    break;
                }
                default: {
                    throw new NotSupportedException("decode in heap error,not supported flag: " + secondDataType);
                }
            }
            return objectArray;
        }

        private final int getDataType(long indexValue) {
            return (int)(indexValue >> 60);
        }

        private final int getSecondDataType(long indexValue) {
            return (int)((indexValue & 0xF00000000000000L) >> 56);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EncodingVersion.values().length];
                try {
                    nArray[EncodingVersion.V2.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EncodingVersion.V3.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncodingVersion.values().length];
            try {
                nArray[EncodingVersion.V2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncodingVersion.V3.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

