/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData;

import java.io.Closeable;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.EncodeContext;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IImmutableHeapByteContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\u00072\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/ImmutableHeapByteContainer;", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/IImmutableHeapByteContainer;", "Ljava/io/Closeable;", "buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;)V", "close", "", "get", "offset", "", "Lkd/bos/olapServer2/common/long;", "len", "", "Lkd/bos/olapServer2/common/int;", "ctx", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/EncodeContext;", "bos-olap-core2"})
public final class ImmutableHeapByteContainer
implements IImmutableHeapByteContainer,
Closeable {
    @NotNull
    private final IByteBuffer buffer;

    public ImmutableHeapByteContainer(@NotNull IByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
    }

    @Override
    public void get(long offset, int len, @NotNull EncodeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (len <= 252) {
            byte[] byteArray = ctx.getByteArray();
            this.buffer.getByteArray(offset, byteArray, 0, len);
            ctx.setLen(len);
        } else if (len == 255) {
            int realLength = this.buffer.getInt(offset);
            byte[] byteArray = ctx.getByteArray(realLength);
            ctx.setLen(realLength);
            int blockCount = (realLength + 4 - 1) / 252 + 1;
            int valueOffset = 0;
            this.buffer.getByteArray(offset + (long)4, byteArray, valueOffset, 248);
            valueOffset += 248;
            long nextBlockOffset = CommonTypesKt.toLongNoNegative(this.buffer.getInt(offset - (long)4));
            int n = blockCount - 1;
            for (int i = 1; i < n; ++i) {
                this.buffer.getByteArray(nextBlockOffset, byteArray, valueOffset, 252);
                valueOffset += 252;
                nextBlockOffset = CommonTypesKt.toLongNoNegative(this.buffer.getInt(nextBlockOffset - (long)4));
            }
            this.buffer.getByteArray(nextBlockOffset, byteArray, valueOffset, realLength - valueOffset);
        } else {
            throw new NotSupportedException("Not Support Measure Block Length = " + len);
        }
    }

    @Override
    public void close() {
    }
}

