/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData;

import java.io.Flushable;
import kd.bos.olapServer2.collections.IMutableCanSetList;
import kd.bos.olapServer2.collections.IMutableCanSetListLong;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.EncodeContext;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IEncoding;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IImmutableHeapByteContainer;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IMutableHeapByteContainer;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.ImmutableListAny;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0012\u001a\u00060\fj\u0002`\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00022\n\u0010\u0017\u001a\u00060\fj\u0002`\rH\u0096\u0002J\u001f\u0010\u0018\u001a\u00020\u00152\n\u0010\u0017\u001a\u00060\fj\u0002`\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002R\u0018\u0010\u000b\u001a\u00060\fj\u0002`\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/MutableCanSetListAny;", "Lkd/bos/olapServer2/collections/IMutableCanSetList;", "", "Ljava/io/Flushable;", "listLong", "Lkd/bos/olapServer2/collections/IMutableCanSetListLong;", "heap", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/IMutableHeapByteContainer;", "encoding", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/IEncoding;", "(Lkd/bos/olapServer2/collections/IMutableCanSetListLong;Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/IMutableHeapByteContainer;Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/IEncoding;)V", "count", "", "Lkd/bos/olapServer2/common/rowIdx;", "getCount", "()J", "ctx", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/EncodeContext;", "add", "value", "flush", "", "get", "index", "set", "throwExceed4GBException", "bos-olap-core2"})
public final class MutableCanSetListAny
implements IMutableCanSetList<Object>,
Flushable {
    @NotNull
    private final IMutableCanSetListLong listLong;
    @NotNull
    private final IMutableHeapByteContainer heap;
    @NotNull
    private final IEncoding encoding;
    @NotNull
    private final EncodeContext ctx;

    public MutableCanSetListAny(@NotNull IMutableCanSetListLong listLong, @NotNull IMutableHeapByteContainer heap, @NotNull IEncoding encoding) {
        Intrinsics.checkNotNullParameter((Object)listLong, (String)"listLong");
        Intrinsics.checkNotNullParameter((Object)heap, (String)"heap");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        this.listLong = listLong;
        this.heap = heap;
        this.encoding = encoding;
        this.ctx = new EncodeContext();
    }

    @Override
    public long add(@Nullable Object value2) {
        long l;
        long newIndexValue = this.encoding.encode(value2, this.ctx);
        if (newIndexValue <= 0L || this.ctx.getLen() <= 6) {
            l = this.listLong.add(newIndexValue);
        } else {
            long offset = this.heap.add(this.ctx.getCurrent(), this.ctx.getLen());
            if (offset < 0L) {
                this.throwExceed4GBException();
            }
            l = this.listLong.add(newIndexValue | offset);
        }
        return l;
    }

    @Override
    public void set(long index2, @Nullable Object value2) {
        long newIndexValue;
        long oldIndexValue = this.listLong.get(index2);
        int oldLength = ImmutableListAny.Companion.getLength(oldIndexValue);
        if (oldIndexValue >= 0L && oldLength > 6) {
            this.heap.remove(ImmutableListAny.Companion.getByteOffset(oldIndexValue), oldLength);
        }
        if ((newIndexValue = this.encoding.encode(value2, this.ctx)) <= 0L || this.ctx.getLen() <= 6) {
            this.listLong.set(index2, newIndexValue);
        } else {
            long offset = this.heap.add(this.ctx.getCurrent(), this.ctx.getLen());
            if (offset < 0L) {
                this.throwExceed4GBException();
            }
            this.listLong.set(index2, newIndexValue | offset);
        }
    }

    private final void throwExceed4GBException() {
        throw new RuntimeException("File size exceeds 4 GB");
    }

    @Override
    public void flush() {
        block1: {
            Object object2 = this.listLong;
            Flushable flushable = object2 instanceof Flushable ? (Flushable)object2 : null;
            if (flushable != null) {
                flushable.flush();
            }
            object2 = this.heap;
            Flushable flushable2 = object2 instanceof Flushable ? (Flushable)object2 : null;
            if (flushable2 == null) break block1;
            flushable2.flush();
        }
    }

    @Override
    @Nullable
    public Object get(long index2) {
        Object object2;
        long indexValue = this.listLong.get(index2);
        if (indexValue <= 0L) {
            object2 = this.encoding.decode(indexValue);
        } else {
            int len = ImmutableListAny.Companion.getLength(indexValue);
            if (len <= 6) {
                object2 = this.encoding.decode(indexValue, len);
            } else {
                ((IImmutableHeapByteContainer)this.heap.getImmutableObject()).get(ImmutableListAny.Companion.getByteOffset(indexValue), len, this.ctx);
                object2 = this.encoding.decode(indexValue, this.ctx.getCurrent(), this.ctx.getLen());
            }
        }
        return object2;
    }

    @Override
    public long getCount() {
        return this.listLong.getCount();
    }
}

