/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData;

import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.EventArgs;
import kd.bos.olapServer2.common.EventHandlerList;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IDynamicByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.HeapByteMetadata;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IMutableHeapByteContainer;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.ImmutableHeapByteContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.DefaultResizeStrategy;
import kd.bos.olapServer2.memoryMappedFiles.containers.SnapshotCreator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0016J \u0010\u001a\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u001b\u001a\u00020\u00162\n\u0010\u001c\u001a\u00060\u0018j\u0002`\u0019H\u0002J \u0010\u001d\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u001b\u001a\u00020\u00162\n\u0010\u001c\u001a\u00060\u0018j\u0002`\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u000bH\u0016J \u0010\"\u001a\u00020 2\n\u0010#\u001a\u00060\u0013j\u0002`\u00142\n\u0010\u001c\u001a\u00060\u0018j\u0002`\u0019H\u0016J\u0018\u0010$\u001a\u00060\u0013j\u0002`\u00142\n\u0010%\u001a\u00060\u0018j\u0002`\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006'"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/MutableHeapByteContainer;", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/IMutableHeapByteContainer;", "metadata", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/HeapByteMetadata;", "res", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;", "(Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/HeapByteMetadata;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;)V", "_buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "_snapshotCreator", "Lkd/bos/olapServer2/memoryMappedFiles/containers/SnapshotCreator;", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/ImmutableHeapByteContainer;", "updated", "Lkd/bos/olapServer2/common/EventHandlerList;", "", "Lkd/bos/olapServer2/common/EventArgs;", "getUpdated", "()Lkd/bos/olapServer2/common/EventHandlerList;", "add", "", "Lkd/bos/olapServer2/common/long;", "newValue", "", "newLength", "", "Lkd/bos/olapServer2/common/int;", "allotAndPutFew", "value", "length", "allotAndPutMany", "createImmutableContainer", "gc", "", "getImmutableObject", "remove", "byteOffset", "resize", "addLength", "Companion", "bos-olap-core2"})
public final class MutableHeapByteContainer
implements IMutableHeapByteContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HeapByteMetadata metadata;
    @NotNull
    private final IDynamicByteBufferResource res;
    @NotNull
    private IByteBuffer _buffer;
    @NotNull
    private final SnapshotCreator<ImmutableHeapByteContainer> _snapshotCreator;
    public static final int BLOCK_CONTENT_MAX_SIZE = 252;

    public MutableHeapByteContainer(@NotNull HeapByteMetadata metadata, @NotNull IDynamicByteBufferResource res) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        this.metadata = metadata;
        this.res = res;
        this._buffer = this.res.getContentBuffer();
        this._snapshotCreator = new SnapshotCreator((Function0)new Function0<ImmutableHeapByteContainer>((Object)this){

            @NotNull
            public final ImmutableHeapByteContainer invoke() {
                return MutableHeapByteContainer.access$createImmutableContainer((MutableHeapByteContainer)this.receiver);
            }
        });
    }

    @Override
    @NotNull
    public EventHandlerList<Object, EventArgs> getUpdated() {
        return this._snapshotCreator.getUpdated();
    }

    private final ImmutableHeapByteContainer createImmutableContainer() {
        IByteBuffer immutableBuffer = this._buffer.sliceAll();
        return new ImmutableHeapByteContainer(immutableBuffer);
    }

    @Override
    @NotNull
    public ImmutableHeapByteContainer getImmutableObject() {
        return this._snapshotCreator.getImmutableObject();
    }

    @Override
    public long add(@NotNull byte[] newValue, int newLength) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        if (!(newLength > 6)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return newLength <= 252 ? this.allotAndPutFew(newValue, newLength) : this.allotAndPutMany(newValue, newLength);
    }

    private final long allotAndPutMany(byte[] value2, int length) {
        long nextBlockOffset;
        int blockCount = (length + 4 - 1) / 252 + 1;
        long releasedHeadOffset = this.metadata.getGCedHeadNode(252);
        if (releasedHeadOffset == 0L) {
            long offset = this.resize(blockCount * 256);
            if (offset < 0L) {
                return offset;
            }
            int valueOffset = 0;
            long firstBlockOffset = offset + (long)4;
            this._buffer.putInt(firstBlockOffset - (long)4, (int)(firstBlockOffset + 256L));
            this._buffer.putInt(firstBlockOffset, length);
            this._buffer.putByteArray(firstBlockOffset + (long)4, value2, valueOffset, 248);
            valueOffset += 248;
            int n = blockCount - 1;
            for (int i = 1; i < n; ++i) {
                long blockOffset = firstBlockOffset + (long)i * 256L;
                this._buffer.putInt(blockOffset - (long)4, (int)(blockOffset + 256L));
                this._buffer.putByteArray(blockOffset, value2, valueOffset, 252);
                valueOffset += 252;
            }
            long lastBlockOffset = firstBlockOffset + (long)(blockCount - 1) * 256L;
            this._buffer.putByteArray(lastBlockOffset, value2, valueOffset, length - valueOffset);
            return firstBlockOffset;
        }
        int valueOffset = 0;
        long currentBlockOffset = releasedHeadOffset;
        this._buffer.putInt(currentBlockOffset, length);
        this._buffer.putByteArray(currentBlockOffset + (long)4, value2, valueOffset, 248);
        valueOffset += 248;
        int releasedCount = 1;
        while (releasedCount < blockCount && (nextBlockOffset = CommonTypesKt.toLongNoNegative(this._buffer.getInt(currentBlockOffset - (long)4))) != 0L) {
            currentBlockOffset = nextBlockOffset;
            if (++releasedCount == blockCount) {
                this._buffer.putByteArray(currentBlockOffset, value2, valueOffset, length - valueOffset);
                continue;
            }
            this._buffer.putByteArray(currentBlockOffset, value2, valueOffset, 252);
            valueOffset += 252;
        }
        if (releasedCount < blockCount) {
            long offset = this.resize((blockCount - releasedCount) * 256);
            if (offset < 0L) {
                return offset;
            }
            long firstResizeBlockOffset = offset + (long)4;
            this.metadata.setGCedHeadNode(this._buffer, 252, 0L);
            this._buffer.putInt(currentBlockOffset - (long)4, (int)firstResizeBlockOffset);
            int n = blockCount - releasedCount - 1;
            for (int i = 0; i < n; ++i) {
                long blockOffset = firstResizeBlockOffset + (long)i * 256L;
                this._buffer.putInt(blockOffset - (long)4, (int)(blockOffset + 256L));
                this._buffer.putByteArray(blockOffset, value2, valueOffset, 252);
                valueOffset += 252;
            }
            long lastBlockOffset = firstResizeBlockOffset + (long)(blockCount - releasedCount - 1) * 256L;
            this._buffer.putByteArray(lastBlockOffset, value2, valueOffset, length - valueOffset);
        } else {
            nextBlockOffset = CommonTypesKt.toLongNoNegative(this._buffer.getInt(currentBlockOffset - (long)4));
            this.metadata.setGCedHeadNode(this._buffer, 252, nextBlockOffset);
            this._buffer.putInt(currentBlockOffset - (long)4, 0);
        }
        return releasedHeadOffset;
    }

    private final long allotAndPutFew(byte[] value2, int length) {
        long l;
        long releasedOffset = this.metadata.getGCedHeadNode(length);
        if (releasedOffset != 0L) {
            this.metadata.setGCedHeadNode(this._buffer, length, CommonTypesKt.toLongNoNegative(this._buffer.getInt(releasedOffset - (long)4)));
            l = releasedOffset;
        } else {
            long blockOffset = this.resize(length + 4);
            if (blockOffset < 0L) {
                return blockOffset;
            }
            l = blockOffset + (long)4;
        }
        long contentOffset = l;
        this._buffer.putByteArray(contentOffset, value2, 0, length);
        return contentOffset;
    }

    private final long resize(int addLength) {
        long oldSize = this.metadata.getByteSize();
        long newSize = oldSize + (long)addLength;
        if (newSize > this._buffer.getCapacity()) {
            long nextCapacity = DefaultResizeStrategy.INSTANCE.getNextCapacity(this.metadata.getHeadSize(), newSize);
            if (nextCapacity < 0L) {
                return -1L;
            }
            this._buffer = this.res.resize(nextCapacity);
            this._snapshotCreator.update();
        }
        this.metadata.setByteSize(newSize);
        return oldSize;
    }

    @Override
    public void remove(long byteOffset, int length) {
        if (length > 252) {
            int realLength = this._buffer.getInt(byteOffset);
            int blockCount = (realLength + 4 - 1) / 252 + 1;
            long currentBlockOffset = byteOffset;
            int n = blockCount - 1;
            for (int i = 0; i < n; ++i) {
                currentBlockOffset = CommonTypesKt.toLongNoNegative(this._buffer.getInt(currentBlockOffset - (long)4));
            }
            this.metadata.addToBeGC(this._buffer, 252, byteOffset, currentBlockOffset);
        } else {
            this.metadata.addToBeGC(this._buffer, length, byteOffset);
        }
    }

    @Override
    public void gc() {
        this.metadata.gc(this._buffer);
    }

    public static final /* synthetic */ ImmutableHeapByteContainer access$createImmutableContainer(MutableHeapByteContainer $this) {
        return $this.createImmutableContainer();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/MutableHeapByteContainer$Companion;", "", "()V", "BLOCK_CONTENT_MAX_SIZE", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

