/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.containers;

import kd.bos.olapServer2.common.DebugContext;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\nj\u0002`\r2\n\u0010\u0019\u001a\u00060\nj\u0002`\rJ\u0018\u0010\u001a\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001b\u001a\u00060\nj\u0002`\rH\u0002J\u0016\u0010\u001c\u001a\u00060\nj\u0002`\r2\n\u0010\u0018\u001a\u00060\nj\u0002`\rJ\u0016\u0010\u001d\u001a\u00060\nj\u0002`\r2\n\u0010\u0018\u001a\u00060\nj\u0002`\rJ\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0000J\u0012\u0010 \u001a\u00020\u00172\n\u0010!\u001a\u00060\nj\u0002`\rJ\u001e\u0010 \u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\nj\u0002`\r2\n\u0010\u0019\u001a\u00060\nj\u0002`\rJ \u0010\"\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\nj\u0002`\r2\n\u0010#\u001a\u00060\u0005j\u0002`\u0006H\u0002J\b\u0010$\u001a\u00020%H\u0016J\u0016\u0010&\u001a\u00060\nj\u0002`\r2\n\u0010'\u001a\u00060\nj\u0002`\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00060\nj\u0002`\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006)"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/containers/ByteBufferBitSet;", "", "buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "byteOffset", "", "Lkd/bos/olapServer2/common/long;", "countOffset", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;JJ)V", "_endNonzeroWordIndex", "", "_startNonzeroWordIndex", "count", "Lkd/bos/olapServer2/common/int;", "getCount", "()I", "endNonzeroWordIndex", "getEndNonzeroWordIndex", "startNonzeroWordIndex", "getStartNonzeroWordIndex", "wordCount", "getWordCount", "clear", "", "fromIndex", "bitCount", "getWord", "index", "nextClearBit", "nextSetBit", "or", "other", "set", "bitIndex", "setWord", "value", "toString", "", "tryGetContinuousSetBit", "freePageCount", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nByteBufferBitSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBufferBitSet.kt\nkd/bos/olapServer2/memoryMappedFiles/containers/ByteBufferBitSet\n+ 2 DebugContext.kt\nkd/bos/olapServer2/common/DebugContextKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n26#2,2:271\n29#2:274\n26#2,4:275\n1#3:273\n*S KotlinDebug\n*F\n+ 1 ByteBufferBitSet.kt\nkd/bos/olapServer2/memoryMappedFiles/containers/ByteBufferBitSet\n*L\n52#1:271,2\n52#1:274\n57#1:275,4\n*E\n"})
public final class ByteBufferBitSet {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final IByteBuffer buffer;
    private final long byteOffset;
    private final long countOffset;
    private int _startNonzeroWordIndex;
    private int _endNonzeroWordIndex;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;

    public ByteBufferBitSet(@NotNull IByteBuffer buffer, long byteOffset, long countOffset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.byteOffset = byteOffset;
        this.countOffset = countOffset;
        this._endNonzeroWordIndex = this.getWordCount() - 1;
    }

    private final long getWord(int index2) {
        boolean $i$f$onTrace = false;
        if (DebugContext.traceEnabled) {
            boolean bl = false;
            if (!(0 <= index2 ? index2 < this.getWordCount() : false)) {
                boolean bl2 = false;
                String string2 = "index = " + index2 + ", wordCount = " + this.getWordCount();
                throw new IllegalArgumentException(string2.toString());
            }
        }
        return this.buffer.getLong(this.byteOffset + (long)(index2 << 3));
    }

    private final void setWord(int index2, long value2) {
        boolean $i$f$onTrace = false;
        if (DebugContext.traceEnabled) {
            boolean bl = false;
            if (!(0 <= index2 ? index2 < this.getWordCount() : false)) {
                boolean bl2 = false;
                String string2 = "index = " + index2 + ", wordCount = " + this.getWordCount();
                throw new IllegalArgumentException(string2.toString());
            }
        }
        this.buffer.putLong(this.byteOffset + (long)(index2 << 3), value2);
    }

    public final int getCount() {
        return this.buffer.getInt(this.countOffset);
    }

    private final int getWordCount() {
        int currentCount = this.getCount();
        return (currentCount & 0x3F) == 0 ? currentCount >>> 6 : (currentCount >>> 6) + 1;
    }

    public final int getStartNonzeroWordIndex() {
        return this._startNonzeroWordIndex;
    }

    public final int getEndNonzeroWordIndex() {
        return this._endNonzeroWordIndex;
    }

    public final void set(int bitIndex) {
        if (!(0 <= bitIndex ? bitIndex < this.getCount() : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int wordIndex = ByteBufferBitSet.Companion.wordIndex(bitIndex);
        this.setWord(wordIndex, this.getWord(wordIndex) | 1L << bitIndex);
        this._startNonzeroWordIndex = Math.min(this._startNonzeroWordIndex, wordIndex);
        this._endNonzeroWordIndex = Math.max(this._endNonzeroWordIndex, wordIndex);
    }

    public final void set(int fromIndex, int bitCount) {
        int currentCount = this.getCount();
        if (!(bitCount > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(fromIndex + bitCount <= currentCount)) {
            boolean $i$a$-require-ByteBufferBitSet$set$22 = false;
            String $i$a$-require-ByteBufferBitSet$set$22 = fromIndex + " + " + bitCount + " > " + currentCount;
            throw new IllegalArgumentException($i$a$-require-ByteBufferBitSet$set$22.toString());
        }
        int toIndex = fromIndex + bitCount;
        int startWordIndex = ByteBufferBitSet.Companion.wordIndex(fromIndex);
        int endWordIndex = ByteBufferBitSet.Companion.wordIndex(toIndex - 1);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.setWord(startWordIndex, this.getWord(startWordIndex) | firstWordMask & lastWordMask);
        } else {
            this.setWord(startWordIndex, this.getWord(startWordIndex) | firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.setWord(i, -1L);
            }
            this.setWord(endWordIndex, this.getWord(endWordIndex) | lastWordMask);
        }
        this._startNonzeroWordIndex = Math.min(this._startNonzeroWordIndex, startWordIndex);
        this._endNonzeroWordIndex = Math.max(this._endNonzeroWordIndex, endWordIndex);
    }

    public final void clear(int fromIndex, int bitCount) {
        int currentCount = this.getCount();
        if (!(bitCount > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(fromIndex + bitCount <= currentCount)) {
            boolean $i$a$-require-ByteBufferBitSet$clear$22 = false;
            String $i$a$-require-ByteBufferBitSet$clear$22 = fromIndex + " + " + bitCount + " > " + currentCount;
            throw new IllegalArgumentException($i$a$-require-ByteBufferBitSet$clear$22.toString());
        }
        int toIndex = fromIndex + bitCount;
        int startWordIndex = ByteBufferBitSet.Companion.wordIndex(fromIndex);
        int endWordIndex = ByteBufferBitSet.Companion.wordIndex(toIndex - 1);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.setWord(startWordIndex, this.getWord(startWordIndex) & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.setWord(startWordIndex, this.getWord(startWordIndex) & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL));
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.setWord(i, 0L);
            }
            this.setWord(endWordIndex, this.getWord(endWordIndex) & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public final void clear() {
        int i = this._endNonzeroWordIndex;
        while (i >= this._startNonzeroWordIndex) {
            this.setWord(i--, 0L);
        }
        this._startNonzeroWordIndex = this.getWordCount();
        this._endNonzeroWordIndex = -1;
    }

    public final int nextSetBit(int fromIndex) {
        int endIndex;
        if (!(fromIndex >= 0)) {
            boolean $i$a$-require-ByteBufferBitSet$nextSetBit$22 = false;
            String $i$a$-require-ByteBufferBitSet$nextSetBit$22 = "nextFreePage(" + fromIndex + ')';
            throw new IllegalArgumentException($i$a$-require-ByteBufferBitSet$nextSetBit$22.toString());
        }
        int fi = fromIndex;
        int u = ByteBufferBitSet.Companion.wordIndex(fromIndex);
        if (u < this._startNonzeroWordIndex) {
            u = this._startNonzeroWordIndex;
            fi = 0;
        }
        if (u > (endIndex = this._endNonzeroWordIndex)) {
            return -1;
        }
        long word = this.getWord(u) & -1L << fi;
        while (word == 0L) {
            if (++u > endIndex) {
                this._endNonzeroWordIndex = Math.min(this._endNonzeroWordIndex, ByteBufferBitSet.Companion.wordIndex(fromIndex) + 1);
                return -1;
            }
            word = this.getWord(u);
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public final int nextClearBit(int fromIndex) {
        int wordsInUse;
        if (!(fromIndex >= 0)) {
            boolean $i$a$-require-ByteBufferBitSet$nextClearBit$22 = false;
            String $i$a$-require-ByteBufferBitSet$nextClearBit$22 = "nextFreePage(" + fromIndex + ')';
            throw new IllegalArgumentException($i$a$-require-ByteBufferBitSet$nextClearBit$22.toString());
        }
        int u = ByteBufferBitSet.Companion.wordIndex(fromIndex);
        if (u >= (wordsInUse = this._endNonzeroWordIndex + 1)) {
            return fromIndex;
        }
        long word = (this.getWord(u) ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == wordsInUse) {
                return wordsInUse * 64;
            }
            word = this.getWord(u) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public final int tryGetContinuousSetBit(int freePageCount) {
        int start = this.nextSetBit(0);
        if (start < 0) {
            if (this._endNonzeroWordIndex != -1) {
                this._startNonzeroWordIndex = this.getWordCount();
                this._endNonzeroWordIndex = -1;
            }
            return -1;
        }
        if (ByteBufferBitSet.Companion.wordIndex(start) > this._startNonzeroWordIndex) {
            this._startNonzeroWordIndex = ByteBufferBitSet.Companion.wordIndex(start);
        }
        while (start >= 0) {
            int end = this.nextClearBit(start);
            if (end - start >= freePageCount) {
                return start;
            }
            start = this.nextSetBit(end);
        }
        return -1;
    }

    public final void or(@NotNull ByteBufferBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this, (Object)other)) {
            return;
        }
        int wordsInUse = Math.min(other.getWordCount(), other._endNonzeroWordIndex + 1);
        for (int i = other._startNonzeroWordIndex; i < wordsInUse; ++i) {
            long otherWord = other.getWord(i);
            if (otherWord == 0L) continue;
            this.setWord(i, this.getWord(i) | otherWord);
        }
        this._startNonzeroWordIndex = Math.min(this._startNonzeroWordIndex, other._startNonzeroWordIndex);
        this._endNonzeroWordIndex = Math.max(this._endNonzeroWordIndex, other._endNonzeroWordIndex);
    }

    @NotNull
    public String toString() {
        return "Count=" + this.getCount() + '(' + this._startNonzeroWordIndex + ',' + this._endNonzeroWordIndex + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/containers/ByteBufferBitSet$Companion;", "", "()V", "ADDRESS_BITS_PER_WORD", "", "BITS_PER_WORD", "WORD_MASK", "", "wordIndex", "bitIndex", "bos-olap-core2"})
    private static final class Companion {
        private Companion() {
        }

        private final int wordIndex(int bitIndex) {
            return bitIndex >> 6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

