/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.containers;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.olapServer2.memoryMappedFiles.AbstractHeadFieldCollection;
import kd.bos.olapServer2.memoryMappedFiles.AbstractMetadata;
import kd.bos.olapServer2.memoryMappedFiles.FileHeadField;
import kd.bos.olapServer2.memoryMappedFiles.HeadFieldCollectionBuilder;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.containers.ByteBufferBitSet;
import kd.bos.olapServer2.memoryMappedFiles.containers.ByteBufferList;
import kd.bos.olapServer2.memoryMappedFiles.containers.DefaultResizeStrategy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0010\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002-.B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u001e\u001a\u00060\u001fj\u0002` 2\n\u0010!\u001a\u00060\u000fj\u0002`\u00102\n\u0010\"\u001a\u00060\u000fj\u0002`\u0010J\u0006\u0010#\u001a\u00020$J\u0014\u0010%\u001a\u00020$2\n\u0010&\u001a\u00060\u000fj\u0002`\u0010H\u0002J \u0010'\u001a\u00020$2\n\u0010!\u001a\u00060\u000fj\u0002`\u00102\n\u0010\"\u001a\u00060\u000fj\u0002`\u0010H\u0002J\u001e\u0010(\u001a\u00020$2\n\u0010!\u001a\u00060\u000fj\u0002`\u00102\n\u0010\"\u001a\u00060\u000fj\u0002`\u0010J\u001e\u0010)\u001a\u00020$2\n\u0010!\u001a\u00060\u000fj\u0002`\u00102\n\u0010\"\u001a\u00060\u000fj\u0002`\u0010J\n\u0010*\u001a\u00060\u000fj\u0002`\u0010J\u0016\u0010+\u001a\u00060\u000fj\u0002`\u00102\n\u0010,\u001a\u00060\u000fj\u0002`\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0011\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\u00060\u0017j\u0002`\u0018\u00a2\u0006\n\n\u0002\b\u001d\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006/"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata;", "Lkd/bos/olapServer2/memoryMappedFiles/AbstractMetadata;", "Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata$FixedHeadFieldCollection;", "headBuffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "headItems", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata$FixedHeadFieldCollection;)V", "_lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "_releasedBitSet", "Lkd/bos/olapServer2/memoryMappedFiles/containers/ByteBufferBitSet;", "_toBeReleasedBitSet", "_toBeReleasedList", "Lkd/bos/olapServer2/memoryMappedFiles/containers/ByteBufferList;", "value", "", "Lkd/bos/olapServer2/common/int;", "count", "getCount", "()I", "setCount", "(I)V", "headSize", "", "Lkd/bos/olapServer2/common/long;", "getHeadSize", "()J", "pageByteSize", "getPageByteSize", "pageByteSize$1", "isFreePage", "", "Lkd/bos/olapServer2/common/bool;", "fromIndex", "pageCount", "release", "", "setFreePage", "pageIndex", "setToBeReleasedPage", "setUsingPage", "toBeReleased", "tryGetAFreePage", "tryGetContinuousFreePage", "freePageCount", "Companion", "FixedHeadFieldCollection", "bos-olap-core2"})
public class FixedMetadata
extends AbstractMetadata<FixedHeadFieldCollection> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long headSize;
    private final long pageByteSize$1;
    @NotNull
    private final ReentrantReadWriteLock _lock;
    @NotNull
    private final ByteBufferList _toBeReleasedList;
    @NotNull
    private final ByteBufferBitSet _toBeReleasedBitSet;
    @NotNull
    private final ByteBufferBitSet _releasedBitSet;
    private static final int pageByteSize = 16384;
    private static final int pageByteSize1KB = 1024;
    @NotNull
    private static final FixedHeadFieldCollection defaultFixedSequenceHeadItems;
    @NotNull
    private static final FixedHeadFieldCollection minSegmentInfoHeadItems;

    public FixedMetadata(@NotNull IByteBuffer headBuffer, @NotNull FixedHeadFieldCollection headItems) {
        Intrinsics.checkNotNullParameter((Object)headBuffer, (String)"headBuffer");
        Intrinsics.checkNotNullParameter((Object)headItems, (String)"headItems");
        super(headBuffer, (AbstractHeadFieldCollection)headItems);
        this.headSize = headBuffer.getCapacity();
        this.pageByteSize$1 = headItems.getPageByteSize();
        this._lock = new ReentrantReadWriteLock();
        this._toBeReleasedList = new ByteBufferList(headBuffer, headItems.getToBeReleasedListField().getOffset());
        this._toBeReleasedBitSet = new ByteBufferBitSet(headBuffer, headItems.getToBeReleasedBitSetField().getOffset(), headItems.getCountField().getOffset());
        this._releasedBitSet = new ByteBufferBitSet(headBuffer, headItems.getReleasedBitSetField().getOffset(), headItems.getCountField().getOffset());
    }

    public final long getHeadSize() {
        return this.headSize;
    }

    public final long getPageByteSize() {
        return this.pageByteSize$1;
    }

    public final int getCount() {
        return this.getHeadBuffer().getInt(((FixedHeadFieldCollection)this.getHeadItems()).getCountField().getOffset());
    }

    public final void setCount(int value2) {
        this.getHeadBuffer().putInt(((FixedHeadFieldCollection)this.getHeadItems()).getCountField().getOffset(), value2);
    }

    private final void setFreePage(int pageIndex) {
        this._releasedBitSet.set(pageIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUsingPage(int fromIndex, int pageCount) {
        ReentrantReadWriteLock reentrantReadWriteLock = this._lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this._releasedBitSet.clear(fromIndex, pageCount);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final void setToBeReleasedPage(int fromIndex, int pageCount) {
        this._toBeReleasedBitSet.set(fromIndex, pageCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFreePage(int fromIndex, int pageCount) {
        ReentrantReadWriteLock.ReadLock readLock = this._lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            int nextUsingIndex = this._releasedBitSet.nextClearBit(fromIndex);
            boolean bl2 = nextUsingIndex - fromIndex >= pageCount;
            return bl2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int tryGetContinuousFreePage(int freePageCount) {
        ReentrantReadWriteLock.ReadLock readLock = this._lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            int n = this._releasedBitSet.tryGetContinuousSetBit(freePageCount);
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int tryGetAFreePage() {
        ReentrantReadWriteLock.ReadLock readLock = this._lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            int n = this._releasedBitSet.nextSetBit(0);
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void toBeReleased(int fromIndex, int pageCount) {
        ReentrantReadWriteLock reentrantReadWriteLock = this._lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            int listCount = this._toBeReleasedList.getCount();
            if (listCount < 255) {
                if (listCount + pageCount <= 255) {
                    for (int i = 0; i < pageCount; ++i) {
                        this._toBeReleasedList.add(fromIndex + i);
                    }
                } else {
                    int addToArrayCount = 255 - listCount;
                    for (int i = 0; i < addToArrayCount; ++i) {
                        this._toBeReleasedList.add(fromIndex + i);
                    }
                    this.setToBeReleasedPage(fromIndex + addToArrayCount, pageCount - addToArrayCount);
                }
            } else {
                this.setToBeReleasedPage(fromIndex, pageCount);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        int listCount = this._toBeReleasedList.getCount();
        if (listCount == 0) {
            return;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this._lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            for (int i = 0; i < listCount; ++i) {
                this.setFreePage(this._toBeReleasedList.get(i));
            }
            this._toBeReleasedList.clear();
            if (listCount == 255) {
                this._releasedBitSet.or(this._toBeReleasedBitSet);
                this._toBeReleasedBitSet.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    static {
        HeadFieldCollectionBuilder builder = HeadFieldCollectionBuilder.Companion.build$default(HeadFieldCollectionBuilder.Companion, "Kingdee Shrek OLAP Fixed Segment Sequence", 0L, 2, null);
        defaultFixedSequenceHeadItems = new FixedHeadFieldCollection(builder, 16384);
        minSegmentInfoHeadItems = new FixedHeadFieldCollection(HeadFieldCollectionBuilder.Companion.build$default(HeadFieldCollectionBuilder.Companion, "Kingdee Shrek MinBitmap Segment Info", 0L, 2, null), 1024);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata$Companion;", "", "()V", "defaultFixedSequenceHeadItems", "Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata$FixedHeadFieldCollection;", "getDefaultFixedSequenceHeadItems", "()Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata$FixedHeadFieldCollection;", "minSegmentInfoHeadItems", "getMinSegmentInfoHeadItems", "pageByteSize", "", "pageByteSize1KB", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FixedHeadFieldCollection getDefaultFixedSequenceHeadItems() {
            return defaultFixedSequenceHeadItems;
        }

        @NotNull
        public final FixedHeadFieldCollection getMinSegmentInfoHeadItems() {
            return minSegmentInfoHeadItems;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata$FixedHeadFieldCollection;", "Lkd/bos/olapServer2/memoryMappedFiles/AbstractHeadFieldCollection;", "builder", "Lkd/bos/olapServer2/memoryMappedFiles/HeadFieldCollectionBuilder;", "pageByteSize", "", "Lkd/bos/olapServer2/common/int;", "(Lkd/bos/olapServer2/memoryMappedFiles/HeadFieldCollectionBuilder;I)V", "countField", "Lkd/bos/olapServer2/memoryMappedFiles/FileHeadField;", "getCountField", "()Lkd/bos/olapServer2/memoryMappedFiles/FileHeadField;", "lastField", "getLastField", "maxBitSetByteSize", "", "getPageByteSize", "()I", "releasedBitSetField", "getReleasedBitSetField", "toBeReleasedBitSetField", "getToBeReleasedBitSetField", "toBeReleasedListField", "getToBeReleasedListField", "bos-olap-core2"})
    public static class FixedHeadFieldCollection
    extends AbstractHeadFieldCollection {
        private final int pageByteSize;
        @NotNull
        private final FileHeadField countField;
        @NotNull
        private final FileHeadField toBeReleasedListField;
        private final long maxBitSetByteSize;
        @NotNull
        private final FileHeadField toBeReleasedBitSetField;
        @NotNull
        private final FileHeadField releasedBitSetField;

        public FixedHeadFieldCollection(@NotNull HeadFieldCollectionBuilder builder, int pageByteSize) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            super(builder);
            this.pageByteSize = pageByteSize;
            this.countField = builder.addInt();
            this.toBeReleasedListField = builder.add(1021L);
            this.maxBitSetByteSize = DefaultResizeStrategy.INSTANCE.getFileMaxSize() / (long)this.pageByteSize / (long)8 + 1L + 7L & 0xFFFFFFFFFFFFFFF8L;
            this.toBeReleasedBitSetField = builder.add(this.maxBitSetByteSize);
            this.releasedBitSetField = builder.add(this.maxBitSetByteSize);
        }

        public final int getPageByteSize() {
            return this.pageByteSize;
        }

        @NotNull
        public final FileHeadField getCountField() {
            return this.countField;
        }

        @NotNull
        public final FileHeadField getToBeReleasedListField() {
            return this.toBeReleasedListField;
        }

        @NotNull
        public final FileHeadField getToBeReleasedBitSetField() {
            return this.toBeReleasedBitSetField;
        }

        @NotNull
        public final FileHeadField getReleasedBitSetField() {
            return this.releasedBitSetField;
        }

        @Override
        @NotNull
        public FileHeadField getLastField() {
            return this.releasedBitSetField;
        }
    }
}

