/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.containers;

import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0013\b\u0002\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\b\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0003j\u0002`\u0004J&\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u000e\u001a\u00060\u0003j\u0002`\u0004J\f\u0010\u000f\u001a\u00060\u0003j\u0002`\u0004H\u0002R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/containers/LengthOperator;", "", "byteSize", "", "Lkd/bos/olapServer2/common/long;", "(J)V", "getByteSize", "()J", "get", "buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "byteOffset", "put", "", "length", "throwNotSupport", "Companion", "bos-olap-core2"})
public final class LengthOperator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long byteSize;
    @NotNull
    private static final LengthOperator OneByteLengthOperator = new LengthOperator(1L);
    @NotNull
    private static final LengthOperator TwoByteLengthOperator = new LengthOperator(2L);
    @NotNull
    private static final LengthOperator FourByteLengthOperator = new LengthOperator(4L);

    private LengthOperator(long byteSize) {
        this.byteSize = byteSize;
    }

    public final long getByteSize() {
        return this.byteSize;
    }

    public final long get(@NotNull IByteBuffer buffer, long byteOffset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long l = this.byteSize;
        return l == 1L ? CommonTypesKt.toLongNoNegative(buffer.getByte(byteOffset)) : (l == 2L ? CommonTypesKt.toLongNoNegative(buffer.getShort(byteOffset)) : (l == 4L ? (long)buffer.getInt(byteOffset) : this.throwNotSupport()));
    }

    private final long throwNotSupport() {
        throw new RuntimeException("segmentMaxByteSize = " + this.byteSize + " cannot be zero or negative!");
    }

    public final void put(@NotNull IByteBuffer buffer, long byteOffset, long length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long l = this.byteSize;
        if (l == 1L) {
            buffer.putByte(byteOffset, (byte)length);
        } else if (l == 2L) {
            buffer.putShort(byteOffset, (short)length);
        } else if (l == 4L) {
            buffer.putInt(byteOffset, (int)length);
        } else {
            this.throwNotSupport();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\u00042\n\u0010\n\u001a\u00060\u000bj\u0002`\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/containers/LengthOperator$Companion;", "", "()V", "FourByteLengthOperator", "Lkd/bos/olapServer2/memoryMappedFiles/containers/LengthOperator;", "getFourByteLengthOperator", "()Lkd/bos/olapServer2/memoryMappedFiles/containers/LengthOperator;", "OneByteLengthOperator", "TwoByteLengthOperator", "create", "segmentMaxByteSize", "", "Lkd/bos/olapServer2/common/int;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LengthOperator create(int segmentMaxByteSize) {
            LengthOperator lengthOperator;
            int n = segmentMaxByteSize - 1;
            boolean bl = 0 <= n ? n < 256 : false;
            if (bl) {
                lengthOperator = OneByteLengthOperator;
            } else {
                boolean bl2 = 256 <= n ? n < 65536 : false;
                if (bl2) {
                    lengthOperator = TwoByteLengthOperator;
                } else {
                    boolean bl3 = 65536 <= n ? n < 0x1000000 : false;
                    if (bl3) {
                        lengthOperator = this.getFourByteLengthOperator();
                    } else {
                        boolean bl4 = 0x1000000 <= n ? n <= Integer.MAX_VALUE : false;
                        if (bl4) {
                            lengthOperator = this.getFourByteLengthOperator();
                        } else {
                            throw new RuntimeException("segmentMaxByteSize = " + segmentMaxByteSize + " cannot be zero or negative!");
                        }
                    }
                }
            }
            return lengthOperator;
        }

        @NotNull
        public final LengthOperator getFourByteLengthOperator() {
            return FourByteLengthOperator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

