/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.containers;

import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.EventArgs;
import kd.bos.olapServer2.common.EventHandlerList;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IDynamicByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.containers.DefaultResizeStrategy;
import kd.bos.olapServer2.memoryMappedFiles.containers.FixedMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFixedSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.ImmutableFixedSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.SnapshotCreator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\u0014\u0010\u0019\u001a\u00020\u00172\n\u0010\u001a\u001a\u00060\u0013j\u0002`\u0014H\u0016J\f\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/containers/MutableFixedSegmentContainer;", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFixedSegmentContainer;", "metadata", "Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata;", "res", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;", "(Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;)V", "_buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "_snapshotCreator", "Lkd/bos/olapServer2/memoryMappedFiles/containers/SnapshotCreator;", "Lkd/bos/olapServer2/memoryMappedFiles/containers/ImmutableFixedSegmentContainer;", "updated", "Lkd/bos/olapServer2/common/EventHandlerList;", "", "Lkd/bos/olapServer2/common/EventArgs;", "getUpdated", "()Lkd/bos/olapServer2/common/EventHandlerList;", "allot", "", "Lkd/bos/olapServer2/common/long;", "createImmutableContainer", "gc", "", "getImmutableObject", "release", "byteOffset", "tryAddPage", "", "Lkd/bos/olapServer2/common/int;", "bos-olap-core2"})
public final class MutableFixedSegmentContainer
implements IMutableFixedSegmentContainer {
    @NotNull
    private final FixedMetadata metadata;
    @NotNull
    private final IDynamicByteBufferResource res;
    @NotNull
    private IByteBuffer _buffer;
    @NotNull
    private final SnapshotCreator<ImmutableFixedSegmentContainer> _snapshotCreator;

    public MutableFixedSegmentContainer(@NotNull FixedMetadata metadata, @NotNull IDynamicByteBufferResource res) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        this.metadata = metadata;
        this.res = res;
        this._buffer = this.res.getContentBuffer();
        this._snapshotCreator = new SnapshotCreator((Function0)new Function0<ImmutableFixedSegmentContainer>((Object)this){

            @NotNull
            public final ImmutableFixedSegmentContainer invoke() {
                return MutableFixedSegmentContainer.access$createImmutableContainer((MutableFixedSegmentContainer)this.receiver);
            }
        });
    }

    @Override
    @NotNull
    public EventHandlerList<Object, EventArgs> getUpdated() {
        return this._snapshotCreator.getUpdated();
    }

    private final ImmutableFixedSegmentContainer createImmutableContainer() {
        IByteBuffer immutableBuffer = this._buffer.sliceAll();
        return new ImmutableFixedSegmentContainer(immutableBuffer, this.metadata.getPageByteSize());
    }

    @Override
    @NotNull
    public ImmutableFixedSegmentContainer getImmutableObject() {
        return this._snapshotCreator.getImmutableObject();
    }

    @Override
    public long allot() {
        int pageIndex = this.metadata.tryGetAFreePage();
        if ((long)pageIndex >= 0L) {
            this.metadata.setUsingPage(pageIndex, 1);
        } else {
            pageIndex = this.tryAddPage();
            if ((long)pageIndex < 0L) {
                return -1L;
            }
        }
        return (long)pageIndex * this.metadata.getPageByteSize();
    }

    private final int tryAddPage() {
        long newSize = (long)(this.metadata.getCount() + 1) * this.metadata.getPageByteSize();
        if (newSize > this._buffer.getCapacity()) {
            long nextCapacity = DefaultResizeStrategy.INSTANCE.getNextCapacity(this.metadata.getHeadSize(), newSize);
            if (nextCapacity < 0L) {
                return -1;
            }
            this._buffer = this.res.resize(nextCapacity);
            this._snapshotCreator.update();
        }
        int newPageIndex = this.metadata.getCount();
        FixedMetadata fixedMetadata = this.metadata;
        int n = fixedMetadata.getCount();
        fixedMetadata.setCount(n + 1);
        return newPageIndex;
    }

    @Override
    public void release(long byteOffset) {
        long pageIndex = byteOffset / this.metadata.getPageByteSize();
        this.metadata.toBeReleased(CommonTypesKt.toIntNoNegative(pageIndex), 1);
    }

    @Override
    public void gc() {
        this.metadata.release();
    }

    public static final /* synthetic */ ImmutableFixedSegmentContainer access$createImmutableContainer(MutableFixedSegmentContainer $this) {
        return $this.createImmutableContainer();
    }
}

