/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.containers;

import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.EventArgs;
import kd.bos.olapServer2.common.EventHandlerList;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IDynamicByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.containers.DefaultResizeStrategy;
import kd.bos.olapServer2.memoryMappedFiles.containers.FixedMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFixedSegmentSequenceContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.ImmutableFixedSegmentSequenceContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.LengthOperator;
import kd.bos.olapServer2.memoryMappedFiles.containers.SnapshotCreator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u0016H\u0016J\b\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016J\u0014\u0010\u001c\u001a\u00020\u001a2\n\u0010\u001d\u001a\u00060\u0015j\u0002`\u0016H\u0016J$\u0010\u001e\u001a\u00060\u0015j\u0002`\u00162\n\u0010\u001f\u001a\u00060\u0015j\u0002`\u00162\n\u0010 \u001a\u00060\u0015j\u0002`\u0016H\u0016J\u0018\u0010!\u001a\u00060\"j\u0002`#2\n\u0010$\u001a\u00060\"j\u0002`#H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/containers/MutableFixedSegmentSequenceContainer;", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFixedSegmentSequenceContainer;", "metadata", "Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata;", "res", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;", "(Lkd/bos/olapServer2/memoryMappedFiles/containers/FixedMetadata;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IDynamicByteBufferResource;)V", "_buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "_lengthOperator", "Lkd/bos/olapServer2/memoryMappedFiles/containers/LengthOperator;", "_snapshotCreator", "Lkd/bos/olapServer2/memoryMappedFiles/containers/SnapshotCreator;", "Lkd/bos/olapServer2/memoryMappedFiles/containers/ImmutableFixedSegmentSequenceContainer;", "updated", "Lkd/bos/olapServer2/common/EventHandlerList;", "", "Lkd/bos/olapServer2/common/EventArgs;", "getUpdated", "()Lkd/bos/olapServer2/common/EventHandlerList;", "allot", "", "Lkd/bos/olapServer2/common/long;", "byteSize", "createImmutableContainer", "gc", "", "getImmutableObject", "release", "byteOffset", "resize", "oldByteOffset", "newByteSize", "tryAddPage", "", "Lkd/bos/olapServer2/common/int;", "pageCount", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nMutableFixedSegmentSequenceContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableFixedSegmentSequenceContainer.kt\nkd/bos/olapServer2/memoryMappedFiles/containers/MutableFixedSegmentSequenceContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class MutableFixedSegmentSequenceContainer
implements IMutableFixedSegmentSequenceContainer {
    @NotNull
    private final FixedMetadata metadata;
    @NotNull
    private final IDynamicByteBufferResource res;
    @NotNull
    private final LengthOperator _lengthOperator;
    @NotNull
    private IByteBuffer _buffer;
    @NotNull
    private final SnapshotCreator<ImmutableFixedSegmentSequenceContainer> _snapshotCreator;

    public MutableFixedSegmentSequenceContainer(@NotNull FixedMetadata metadata, @NotNull IDynamicByteBufferResource res) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        this.metadata = metadata;
        this.res = res;
        this._lengthOperator = LengthOperator.Companion.getFourByteLengthOperator();
        this._buffer = this.res.getContentBuffer();
        this._snapshotCreator = new SnapshotCreator((Function0)new Function0<ImmutableFixedSegmentSequenceContainer>((Object)this){

            @NotNull
            public final ImmutableFixedSegmentSequenceContainer invoke() {
                return MutableFixedSegmentSequenceContainer.access$createImmutableContainer((MutableFixedSegmentSequenceContainer)this.receiver);
            }
        });
    }

    @Override
    @NotNull
    public EventHandlerList<Object, EventArgs> getUpdated() {
        return this._snapshotCreator.getUpdated();
    }

    private final ImmutableFixedSegmentSequenceContainer createImmutableContainer() {
        IByteBuffer immutableBuffer = this._buffer.sliceAll();
        return new ImmutableFixedSegmentSequenceContainer(immutableBuffer, this._lengthOperator, this.metadata.getPageByteSize());
    }

    @Override
    @NotNull
    public ImmutableFixedSegmentSequenceContainer getImmutableObject() {
        return this._snapshotCreator.getImmutableObject();
    }

    @Override
    public long allot(long byteSize) {
        if (!(byteSize > 0L)) {
            boolean $i$a$-require-MutableFixedSegmentSequenceContainer$allot$22 = false;
            String $i$a$-require-MutableFixedSegmentSequenceContainer$allot$22 = "allot byte size (" + byteSize + ") should be greater than zero.";
            throw new IllegalArgumentException($i$a$-require-MutableFixedSegmentSequenceContainer$allot$22.toString());
        }
        int pageCount = CommonTypesKt.toIntNoNegative(DefaultResizeStrategy.INSTANCE.minPageCount$bos_olap_core2(byteSize + this._lengthOperator.getByteSize(), this.metadata.getPageByteSize()));
        int pageIndex = this.metadata.tryGetContinuousFreePage(pageCount);
        if ((long)pageIndex >= 0L) {
            this.metadata.setUsingPage(pageIndex, pageCount);
        } else {
            pageIndex = this.tryAddPage(pageCount);
            if ((long)pageIndex < 0L) {
                return -1L;
            }
        }
        long pageOffset = (long)pageIndex * this.metadata.getPageByteSize();
        this._lengthOperator.put(this._buffer, pageOffset, pageCount);
        return pageOffset + this._lengthOperator.getByteSize();
    }

    private final int tryAddPage(int pageCount) {
        long newSize = (long)(this.metadata.getCount() + pageCount) * this.metadata.getPageByteSize();
        if (newSize > this._buffer.getCapacity()) {
            long nextCapacity = DefaultResizeStrategy.INSTANCE.getNextCapacity(this.metadata.getHeadSize(), newSize);
            if (nextCapacity < 0L) {
                return -1;
            }
            this._buffer = this.res.resize(nextCapacity);
            this._snapshotCreator.update();
        }
        int newPageIndex = this.metadata.getCount();
        FixedMetadata fixedMetadata = this.metadata;
        fixedMetadata.setCount(fixedMetadata.getCount() + pageCount);
        return newPageIndex;
    }

    @Override
    public long resize(long oldByteOffset, long newByteSize) {
        long l;
        int newPageCount;
        if (!(newByteSize > 0L)) {
            boolean bl = false;
            String string2 = "resize new byte size (" + newByteSize + ") should be greater than zero.";
            throw new IllegalArgumentException(string2.toString());
        }
        long oldPageOffset = oldByteOffset - this._lengthOperator.getByteSize();
        int oldPageCount = CommonTypesKt.toIntNoNegative(this._lengthOperator.get(this._buffer, oldPageOffset));
        if (oldPageCount >= (newPageCount = CommonTypesKt.toIntNoNegative(DefaultResizeStrategy.INSTANCE.minPageCount$bos_olap_core2(newByteSize + this._lengthOperator.getByteSize(), this.metadata.getPageByteSize())))) {
            return oldByteOffset;
        }
        int addPageCount = newPageCount - oldPageCount;
        int oldPageIndex = CommonTypesKt.toIntNoNegative(oldPageOffset / this.metadata.getPageByteSize());
        int reUsingPageIndex = oldPageIndex + oldPageCount;
        if (reUsingPageIndex >= this.metadata.getCount() && (long)this.tryAddPage(addPageCount) >= 0L) {
            this._lengthOperator.put(this._buffer, oldPageOffset, newPageCount);
            return oldByteOffset;
        }
        if (this.metadata.isFreePage(reUsingPageIndex, addPageCount)) {
            this.metadata.setUsingPage(reUsingPageIndex, addPageCount);
            this._lengthOperator.put(this._buffer, oldPageOffset, newPageCount);
            return oldByteOffset;
        }
        long newByteOffset = this.allot(newByteSize);
        if (newByteOffset < 0L) {
            l = -1L;
        } else {
            this._buffer.copy(newByteOffset, this._buffer, oldByteOffset, (long)oldPageCount * this.metadata.getPageByteSize() - this._lengthOperator.getByteSize());
            this.metadata.toBeReleased(oldPageIndex, oldPageCount);
            l = newByteOffset;
        }
        return l;
    }

    @Override
    public void gc() {
        this.metadata.release();
    }

    @Override
    public void release(long byteOffset) {
        long pageOffset = byteOffset - this._lengthOperator.getByteSize();
        int pageCount = CommonTypesKt.toIntNoNegative(this._lengthOperator.get(this._buffer, pageOffset));
        int pageIndex = CommonTypesKt.toIntNoNegative(pageOffset / this.metadata.getPageByteSize());
        this.metadata.toBeReleased(pageIndex, pageCount);
    }

    public static final /* synthetic */ ImmutableFixedSegmentSequenceContainer access$createImmutableContainer(MutableFixedSegmentSequenceContainer $this) {
        return $this.createImmutableContainer();
    }
}

