/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.dynamicData;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer2.memoryMappedFiles.dynamicData.BytesTransform;
import kd.bos.olapServer2.memoryMappedFiles.dynamicData.EncodeContext;
import kd.bos.olapServer2.memoryMappedFiles.dynamicData.IBoxedOutputStream;
import kd.bos.olapServer2.memoryMappedFiles.dynamicData.IEncoding;
import kd.bos.olapServer2.memoryMappedFiles.dynamicData.IntArrayInputStream;
import kd.bos.olapServer2.memoryMappedFiles.dynamicData.RealScale;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.decimal4j.immutable.Decimal6f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0016J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u0006j\u0002`\u0007H\u0016J\u001e\u0010\u000b\u001a\u00060\u0006j\u0002`\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/dynamicData/Encoding;", "Lkd/bos/olapServer2/memoryMappedFiles/dynamicData/IEncoding;", "()V", "decode", "", "zipInt", "", "Lkd/bos/olapServer2/common/int;", "byteArray", "", "len", "encode", "value", "ctx", "Lkd/bos/olapServer2/memoryMappedFiles/dynamicData/EncodeContext;", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Encoding.kt\nkd/bos/olapServer2/memoryMappedFiles/dynamicData/Encoding\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,526:1\n1#2:527\n*E\n"})
public final class Encoding
implements IEncoding {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Unsafe unsafe;
    private static final long intValOffset;
    private static final long intCompactOffset;
    @NotNull
    private static final Long[] powerDecimals;
    @NotNull
    private static final Integer[] decimalDotMarks;
    @NotNull
    private static final BigDecimal LongMaxValue;
    @NotNull
    private static final BigDecimal LongMinValue;
    private static final int MaxDecimalScale = 15;
    private static final long INFLATED = Long.MIN_VALUE;

    @Override
    @NotNull
    public Object decode(int zipInt) {
        Integer n;
        int dotLen = zipInt >> 29;
        int realValue = zipInt & 0x1FFFFFFF;
        int n2 = dotLen;
        if (n2 == 0) {
            n = realValue;
        } else {
            boolean bl = 1 <= n2 ? n2 < 4 : false;
            if (bl) {
                n = Decimal6f.valueOfUnscaled((long)realValue, (int)dotLen);
            } else {
                boolean bl2 = false;
                String string2 = "zipInt = " + zipInt;
                throw new IllegalArgumentException(string2.toString());
            }
        }
        Integer n3 = n;
        Intrinsics.checkNotNull((Object)n3);
        return n3;
    }

    @Override
    public int encode(@Nullable Object value2, @NotNull EncodeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object object2 = value2;
        if (object2 instanceof BigDecimal) {
            return Encoding.Companion.encodeBigDecimal((BigDecimal)value2, ctx);
        }
        if (object2 instanceof Integer) {
            return Encoding.Companion.encodeInt(((Number)value2).intValue(), ctx);
        }
        if (object2 instanceof Long) {
            return Encoding.Companion.encodeLong(((Number)value2).longValue(), ctx);
        }
        if (object2 instanceof Decimal6f) {
            return Encoding.Companion.encodeDecimal((Decimal6f)value2, ctx);
        }
        if (object2 instanceof Boolean) {
            return Encoding.Companion.encodeBool((Boolean)value2, ctx);
        }
        if (object2 instanceof String) {
            return Encoding.Companion.encodeString((String)value2, ctx);
        }
        if (object2 instanceof UUID) {
            return Encoding.Companion.encodeUUID((UUID)value2, ctx);
        }
        if (object2 instanceof IBoxedOutputStream) {
            return Encoding.Companion.encodeStream((IBoxedOutputStream)value2, ctx);
        }
        if (object2 instanceof byte[]) {
            return Encoding.Companion.encodeByteArray((byte[])value2, ctx);
        }
        throw new NotSupportedException("encode in heap error,notSupported");
    }

    @Override
    @NotNull
    public Object decode(@NotNull byte[] byteArray, int len) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        byte value2 = byteArray[0];
        switch (value2 >> 4) {
            case 0: {
                return Encoding.Companion.decodeDecimal(byteArray, value2, false);
            }
            case 1: {
                return Encoding.Companion.decodeDecimal(byteArray, value2, true);
            }
            case 2: {
                return byteArray[1] == 1;
            }
            case 3: {
                String string2;
                if (!(48 <= value2 ? value2 < 51 : false)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                switch (value2) {
                    case 50: {
                        string2 = new String(byteArray, 1, len - 1, Charsets.UTF_8);
                        break;
                    }
                    case 48: {
                        string2 = "";
                        break;
                    }
                    default: {
                        string2 = String.valueOf((char)byteArray[1]);
                    }
                }
                return string2;
            }
            case 4: {
                return Encoding.Companion.decodeUUID(byteArray);
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                return Encoding.Companion.decodeByteArray(byteArray, len);
            }
        }
        throw new NotSupportedException("decode in heap error,notSupported");
    }

    static {
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        Field[] fieldArray = new Field[]{unsafeField};
        AccessibleObject.setAccessible(fieldArray, true);
        Object object2 = unsafeField.get(null);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type sun.misc.Unsafe");
        unsafe = (Unsafe)object2;
        intValOffset = unsafe.objectFieldOffset(BigDecimal.class.getDeclaredField("intVal"));
        intCompactOffset = unsafe.objectFieldOffset(BigDecimal.class.getDeclaredField("intCompact"));
        Number[] numberArray = new Long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L};
        powerDecimals = numberArray;
        numberArray = new Integer[]{0, 0x20000000, 0x40000000, 0x60000000};
        decimalDotMarks = numberArray;
        LongMaxValue = new BigDecimal(Long.MAX_VALUE);
        LongMinValue = new BigDecimal(Long.MIN_VALUE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\tj\u0002`\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0019\u001a\u00060\tj\u0002`\u00172\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u001c\u0010 \u001a\u00060\tj\u0002`\u00172\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00060\tj\u0002`\u00172\n\u0010!\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010%\u001a\u00060\tj\u0002`\u00172\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0002J \u0010&\u001a\u00060\tj\u0002`\u00172\n\u0010!\u001a\u00060'j\u0002`(2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010)\u001a\u00020\t2\n\u0010!\u001a\u00060\tj\u0002`\u00172\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010*\u001a\u00020\t2\n\u0010!\u001a\u00060\u0004j\u0002`+2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010,\u001a\u00060\tj\u0002`\u00172\u0006\u0010!\u001a\u00020-2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010.\u001a\u00060\tj\u0002`\u00172\u0006\u0010!\u001a\u00020/2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u00100\u001a\u00060\tj\u0002`\u00172\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J,\u00101\u001a\u00060\tj\u0002`\u00172\n\u00102\u001a\u00060\u0004j\u0002`+2\n\u00103\u001a\u00060\tj\u0002`\u00172\u0006\u0010\"\u001a\u00020#H\u0002J(\u00104\u001a\n\u0018\u00010'j\u0004\u0018\u0001`(2\n\u00105\u001a\u00060\u0004j\u0002`+2\n\u00106\u001a\u00060\tj\u0002`\u0017H\u0002J\f\u00107\u001a\u00020\u0004*\u00020\u0006H\u0002J\u000e\u00108\u001a\u0004\u0018\u000109*\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/dynamicData/Encoding$Companion;", "", "()V", "INFLATED", "", "LongMaxValue", "Ljava/math/BigDecimal;", "LongMinValue", "MaxDecimalScale", "", "decimalDotMarks", "", "[Ljava/lang/Integer;", "intCompactOffset", "intValOffset", "powerDecimals", "[Ljava/lang/Long;", "unsafe", "Lsun/misc/Unsafe;", "decodeByteArray", "byteArray", "", "bytesSize", "Lkd/bos/olapServer2/common/int;", "decodeDecimal", "firstMark", "sign", "", "Lkd/bos/olapServer2/common/bool;", "decodeUUID", "Ljava/util/UUID;", "bytes", "encodeBigDecimal", "value", "ctx", "Lkd/bos/olapServer2/memoryMappedFiles/dynamicData/EncodeContext;", "encodeBool", "encodeByteArray", "encodeDecimal", "Lorg/decimal4j/immutable/Decimal6f;", "Lkd/bos/olapServer2/common/decimal;", "encodeInt", "encodeLong", "Lkd/bos/olapServer2/common/long;", "encodeStream", "Lkd/bos/olapServer2/memoryMappedFiles/dynamicData/IBoxedOutputStream;", "encodeString", "", "encodeUUID", "simpleEncodeBigDecimal", "intCompact", "scale", "tryConvertToDecimal", "uValue", "dotLen", "getIntCompact", "getIntVal", "Ljava/math/BigInteger;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        private final BigInteger getIntVal(BigDecimal $this$getIntVal) {
            Object object2 = unsafe.getObjectVolatile($this$getIntVal, intValOffset);
            return object2 instanceof BigInteger ? (BigInteger)object2 : null;
        }

        private final long getIntCompact(BigDecimal $this$getIntCompact) {
            return unsafe.getLongVolatile($this$getIntCompact, intCompactOffset);
        }

        private final int encodeBigDecimal(BigDecimal value2, EncodeContext ctx) {
            int scale = value2.scale();
            long intCompact = this.getIntCompact(value2);
            boolean bl = 0 <= scale ? scale < 16 : false;
            if (bl && intCompact != Long.MIN_VALUE) {
                return this.simpleEncodeBigDecimal(intCompact, scale, ctx);
            }
            Object[] objectArray = LongMinValue;
            if (!(value2.compareTo((Object)LongMaxValue) <= 0 ? 0 <= value2.compareTo(objectArray) : false)) {
                String string2 = Res.INSTANCE.getArrayJsonReaderException_8();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ArrayJsonReaderException_8>(...)");
                objectArray = new Object[]{LongMinValue, LongMaxValue, value2};
                throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
            }
            BigDecimal newValue = scale > 15 ? value2.setScale(15, 4) : value2;
            scale = (newValue = newValue.stripTrailingZeros()).scale();
            if (scale < 0) {
                newValue = new BigDecimal(newValue.toPlainString());
                scale = newValue.scale();
            }
            BigDecimal bigDecimal = newValue;
            Intrinsics.checkNotNull((Object)bigDecimal);
            intCompact = this.getIntCompact(bigDecimal);
            if (intCompact != Long.MIN_VALUE) {
                if (!(0 <= scale ? scale < 16 : false)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                return this.simpleEncodeBigDecimal(intCompact, scale, ctx);
            }
            byte[] byteArray = ctx.getByteArray();
            int firstMask = 0;
            Object object2 = newValue;
            Intrinsics.checkNotNull((Object)object2);
            BigInteger bigInteger = this.getIntVal((BigDecimal)object2);
            Intrinsics.checkNotNull((Object)bigInteger, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger intVal = bigInteger;
            if (intVal.compareTo(BigInteger.ZERO) >= 0) {
                firstMask = 0;
            } else {
                firstMask = 16;
                BigInteger bigInteger2 = intVal.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.negate()");
                intVal = bigInteger2;
            }
            if (!(scale >= 0)) {
                object2 = "Failed requirement.";
                throw new IllegalArgumentException(object2.toString());
            }
            byteArray[0] = (byte)(firstMask | scale);
            int len = BytesTransform.INSTANCE.write7BitEncodedBigInteger(intVal, byteArray, 1) + 1;
            ctx.setLen(len < 3 ? 3 : len);
            return -1;
        }

        private final int simpleEncodeBigDecimal(long intCompact, int scale, EncodeContext ctx) {
            int realScale;
            long intCompact2 = intCompact;
            if (scale <= 3) {
                boolean bl = 0L <= intCompact2 ? intCompact2 < 0x20000000L : false;
                if (bl) {
                    return (int)intCompact2 | decimalDotMarks[scale];
                }
            }
            if ((realScale = RealScale.INSTANCE.getLen(intCompact2, scale)) != scale) {
                intCompact2 /= powerDecimals[scale - realScale - 1].longValue();
                if (realScale <= 3) {
                    boolean bl = 0L <= intCompact2 ? intCompact2 < 0x20000000L : false;
                    if (bl) {
                        return (int)intCompact2 | decimalDotMarks[realScale];
                    }
                }
            }
            byte[] byteArray = ctx.getByteArray();
            int firstMask = 0;
            if (intCompact2 >= 0L) {
                firstMask = 0;
            } else {
                firstMask = 16;
                intCompact2 = -intCompact2;
            }
            byteArray[0] = (byte)(firstMask | realScale);
            int len = BytesTransform.INSTANCE.write7BitEncodedLong(intCompact2, byteArray, 1) + 1;
            ctx.setLen(len < 3 ? 3 : len);
            return -1;
        }

        private final int encodeString(String value2, EncodeContext ctx) {
            byte[] byArray = value2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] bytes2 = byArray;
            int len = bytes2.length + 1;
            byte[] byteArray = ctx.getByteArray(len);
            System.arraycopy(bytes2, 0, byteArray, 1, bytes2.length);
            switch (bytes2.length) {
                case 0: {
                    byteArray[0] = 48;
                    break;
                }
                case 1: {
                    byteArray[0] = 49;
                    break;
                }
                default: {
                    byteArray[0] = 50;
                }
            }
            ctx.setLen(len < 3 ? 3 : len);
            return -1;
        }

        private final int encodeBool(boolean value2, EncodeContext ctx) {
            byte[] byteArray = ctx.getByteArray();
            byteArray[0] = 32;
            byteArray[1] = value2 ? 1 : 10;
            ctx.setLen(3);
            return -1;
        }

        private final int encodeDecimal(Decimal6f value2, EncodeContext ctx) {
            long uValue = value2.unscaledValue();
            int dotLen = RealScale.INSTANCE.getLenAs6Scale(uValue);
            if (uValue >= 0L && dotLen <= 3) {
                long result2 = uValue / powerDecimals[5 - dotLen];
                boolean bl = 0L <= result2 ? result2 < 0x20000000L : false;
                if (bl) {
                    return (int)result2 | decimalDotMarks[dotLen];
                }
            }
            byte[] byteArray = ctx.getByteArray();
            int firstMark = 0;
            if (!(0 <= dotLen ? dotLen < 7 : false)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (uValue >= 0L) {
                firstMark = 0;
            } else {
                firstMark = 16;
                uValue = uValue == Long.MIN_VALUE ? 0L : -uValue;
            }
            byteArray[0] = (byte)(firstMark | dotLen);
            long result3 = dotLen == 6 ? uValue : uValue / powerDecimals[5 - dotLen];
            int len = BytesTransform.INSTANCE.write7BitEncodedLong(result3, byteArray, 1) + 1;
            ctx.setLen(len < 3 ? 3 : len);
            return -1;
        }

        private final int encodeUUID(UUID value2, EncodeContext ctx) {
            byte[] byteArray = ctx.getByteArray();
            byteArray[0] = 64;
            Bits.INSTANCE.putLongB(value2.getMostSignificantBits(), byteArray, 1);
            Bits.INSTANCE.putLongB(value2.getLeastSignificantBits(), byteArray, 9);
            ctx.setLen(17);
            return -1;
        }

        private final int encodeByteArray(byte[] value2, EncodeContext ctx) {
            OutputStream stream = ctx.createStream(value2.length + 3);
            byte[] byArray = new byte[]{112, 0, 1};
            stream.write(byArray);
            stream.write(value2);
            stream.flush();
            return -1;
        }

        private final int encodeStream(IBoxedOutputStream value2, EncodeContext ctx) {
            OutputStream stream = ctx.createStream(value2.getMinCapacity() + 3);
            short v = value2.getDataTypeFlag();
            byte[] byArray = new byte[]{112, (byte)(v >>> 8 & 0xFF), (byte)(v & 0xFF)};
            stream.write(byArray);
            value2.write(stream);
            stream.flush();
            return -1;
        }

        private final int encodeLong(long value2, EncodeContext ctx) {
            int len;
            boolean bl = 0L <= value2 ? value2 < 0x20000000L : false;
            if (bl) {
                return (int)value2;
            }
            byte[] byteArray = ctx.getByteArray();
            byteArray[0] = value2 >= 0L ? 0 : 16;
            long realValue = value2;
            if (realValue < 0L) {
                realValue = realValue == Long.MIN_VALUE ? 0L : -value2;
            }
            ctx.setLen((len = BytesTransform.INSTANCE.write7BitEncodedLong(realValue, byteArray, 1) + 1) < 3 ? 3 : len);
            return -1;
        }

        private final int encodeInt(int value2, EncodeContext ctx) {
            int len;
            boolean bl = 0 <= value2 ? value2 < 0x20000000 : false;
            if (bl) {
                return value2;
            }
            byte[] byteArray = ctx.getByteArray();
            byteArray[0] = value2 >= 0 ? 0 : 16;
            long realValue = value2;
            if (realValue < 0L) {
                realValue = -realValue;
            }
            ctx.setLen((len = BytesTransform.INSTANCE.write7BitEncodedLong(realValue, byteArray, 1) + 1) < 3 ? 3 : len);
            return -1;
        }

        private final Object decodeDecimal(byte[] byteArray, int firstMark, boolean sign) {
            long uValue = BytesTransform.INSTANCE.Read7BitEncodedLong(byteArray, 1);
            if (uValue >= 0L) {
                Number number;
                int dotLen;
                if (sign) {
                    long l = uValue = uValue == 0L ? Long.MIN_VALUE : -uValue;
                }
                if ((dotLen = firstMark & 0xF) == 0) {
                    number = (Integer.MIN_VALUE <= uValue ? uValue <= Integer.MAX_VALUE : false) ? (Number)((int)uValue) : (Number)uValue;
                } else if (dotLen <= 6) {
                    number = this.tryConvertToDecimal(uValue, dotLen);
                    if (number == null) {
                        number = BigDecimal.valueOf(uValue, dotLen);
                    }
                } else {
                    number = BigDecimal.valueOf(uValue, dotLen);
                }
                BigDecimal bigDecimal = number;
                Intrinsics.checkNotNull((Object)bigDecimal);
                return bigDecimal;
            }
            BigInteger firstUnScaleVal = BigInteger.valueOf(uValue & Long.MAX_VALUE);
            BigInteger bigInteger = BigInteger.valueOf(BytesTransform.INSTANCE.Read7BitEncodedLong(byteArray, 10));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            BigInteger bigInteger2 = bigInteger;
            int n = 63;
            BigInteger bigInteger3 = bigInteger2.shiftLeft(n);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.shiftLeft(n)");
            BigInteger nextUnScaleVal = bigInteger3;
            Intrinsics.checkNotNull((Object)firstUnScaleVal);
            BigInteger bigInteger4 = firstUnScaleVal.or(nextUnScaleVal);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"this.or(other)");
            BigInteger resultUnScaleVal = bigInteger4;
            if (sign) {
                BigInteger bigInteger5 = resultUnScaleVal.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"this.negate()");
                resultUnScaleVal = bigInteger5;
            }
            int dotLen = firstMark & 0xF;
            return new BigDecimal(resultUnScaleVal, dotLen);
        }

        private final Decimal6f tryConvertToDecimal(long uValue, int dotLen) {
            switch (dotLen) {
                case 6: {
                    if (Long.MIN_VALUE <= uValue ? uValue <= Long.MAX_VALUE : false) break;
                    return null;
                }
                case 5: {
                    if (-922337203685477580L <= uValue ? uValue < 0xCCCCCCCCCCCCCCDL : false) break;
                    return null;
                }
                case 4: {
                    if (-92233720368547758L <= uValue ? uValue < 92233720368547759L : false) break;
                    return null;
                }
                case 3: {
                    if (-9223372036854775L <= uValue ? uValue < 9223372036854776L : false) break;
                    return null;
                }
                case 2: {
                    if (-922337203685477L <= uValue ? uValue < 922337203685478L : false) break;
                    return null;
                }
                case 1: {
                    if (-92233720368547L <= uValue ? uValue < 92233720368548L : false) break;
                    return null;
                }
            }
            return Decimal6f.valueOfUnscaled((long)uValue, (int)dotLen);
        }

        private final UUID decodeUUID(byte[] bytes2) {
            long mostSigBits = Bits.INSTANCE.getLongB(bytes2, 1);
            long leastSigBits = Bits.INSTANCE.getLongB(bytes2, 9);
            return new UUID(mostSigBits, leastSigBits);
        }

        private final Object decodeByteArray(byte[] byteArray, int bytesSize) {
            Object[] objectArray;
            int dataTypeFlags = (byteArray[1] << 8) + byteArray[2];
            switch (dataTypeFlags) {
                case 1: {
                    byte[] byArray = byteArray;
                    int n = 3;
                    objectArray = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)bytesSize);
                    break;
                }
                case 2: {
                    objectArray = new IntArrayInputStream(new ByteArrayInputStream(byteArray, 3, bytesSize)).toIntArray();
                    break;
                }
                default: {
                    throw new NotSupportedException("decode in heap error,not supported flag:" + dataTypeFlags);
                }
            }
            return objectArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

