/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.minBitmapV4;

import java.util.BitSet;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.AbstractSortedArray;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.IMinBitmapSegment;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinSegmentType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\tB1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0019\u0010\u0017\u001a\u00060\u000bj\u0002`\f2\n\u0010\u0018\u001a\u00060\u000bj\u0002`\u0019H\u0096\u0002J\u0018\u0010\u001a\u001a\u00060\u000bj\u0002`\u00192\n\u0010\u001b\u001a\u00060\u000bj\u0002`\u0019H\u0014J\u0018\u0010\u001c\u001a\u00060\u000bj\u0002`\f2\n\u0010\u001b\u001a\u00060\u000bj\u0002`\u0019H\u0002R\u0018\u0010\u000e\u001a\u00060\u000bj\u0002`\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinArraySegment;", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/AbstractSortedArray;", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/IMinBitmapSegment;", "buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "frontEmptyCount", "", "Lkd/bos/olapServer2/common/int;", "validCount", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;II)V", "arrayCount", "", "Lkd/bos/olapServer2/common/long;", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;IIJ)V", "binarySearchThreshold", "getBinarySearchThreshold", "()J", "fill", "", "values", "", "dirtyFlags", "Ljava/util/BitSet;", "get", "index", "Lkd/bos/olapServer2/common/rowIdx;", "getIndex", "i", "getValue", "bos-olap-core2"})
public final class MinArraySegment
extends AbstractSortedArray
implements IMinBitmapSegment {
    @NotNull
    private final IByteBuffer buffer;
    private final int frontEmptyCount;
    private final int validCount;

    public MinArraySegment(@NotNull IByteBuffer buffer, int frontEmptyCount, int validCount, long arrayCount) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super(arrayCount);
        this.buffer = buffer;
        this.frontEmptyCount = frontEmptyCount;
        this.validCount = validCount;
        if (!(arrayCount * (long)9 + 1L == this.buffer.getCapacity())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public MinArraySegment(@NotNull IByteBuffer buffer, int frontEmptyCount, int validCount) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this(buffer, frontEmptyCount, validCount, (buffer.getCapacity() - 1L) / (long)9);
    }

    @Override
    public void fill(@NotNull long[] values, @NotNull BitSet dirtyFlags) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)dirtyFlags, (String)"dirtyFlags");
        if (!(values.length == 256)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.buffer.putByte(0L, MinSegmentType.MinArray.getValue());
        long offset = 1L;
        int index2 = dirtyFlags.nextSetBit(0);
        while (index2 >= 0) {
            this.buffer.putByte(offset, (byte)index2);
            this.buffer.putLong(offset + 1L, values[index2]);
            offset += (long)9;
            index2 = dirtyFlags.nextSetBit(index2 + 1);
        }
        if (!(offset == this.buffer.getCapacity())) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    @Override
    protected long getIndex(long i) {
        return CommonTypesKt.toLongNoNegative(this.buffer.getByte(1L + i * (long)9));
    }

    @Override
    protected long getBinarySearchThreshold() {
        return 7L;
    }

    private final long getValue(long i) {
        return this.buffer.getLong(2L + i * (long)9);
    }

    @Override
    public long get(long index2) {
        if (index2 < (long)this.frontEmptyCount || (long)(this.frontEmptyCount + this.validCount) <= index2) {
            return 0L;
        }
        long realIndex = this.getRealIndex(index2);
        return realIndex < 0L ? 0L : this.getValue(realIndex);
    }
}

