/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.minBitmapV4;

import java.io.Closeable;
import java.util.UUID;
import kd.bos.olapServer2.collections.IImmutableBitmap;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.memoryMappedFiles.IListMetadata;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ContainerByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IOffsetMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.IImmutableSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.ISnapshotSource;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.IMinBitmapSegment;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.ImmutableListSegmentInfo;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.ImmutableListSegmentInfoFacade;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinArraySegment;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinBitmapSegment;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinInvArraySegment;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinSegmentInfoEntry;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinSegmentType;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.RoaringArraySegment;
import kd.bos.olapServer2.query.EmptyQueryBitmap;
import kd.bos.olapServer2.storages.CubeBigContainerResource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0019\u0010\u0016\u001a\u00060\u000ej\u0002`\u00172\n\u0010\u0018\u001a\u00060\u000ej\u0002`\u0019H\u0096\u0002J\u0014\u0010\u001a\u001a\u00020\n2\n\u0010\u001b\u001a\u00060\u000ej\u0002`\u0019H\u0002J\u0014\u0010\u001c\u001a\u00020\f2\n\u0010\u001b\u001a\u00060\u000ej\u0002`\u0019H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinImmutableBitmap;", "Lkd/bos/olapServer2/collections/IImmutableBitmap;", "Ljava/io/Closeable;", "segmentInfoList", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/ImmutableListSegmentInfoFacade;", "container", "Lkd/bos/olapServer2/memoryMappedFiles/containers/ISnapshotSource;", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IImmutableSegmentContainer;", "(Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/ImmutableListSegmentInfoFacade;Lkd/bos/olapServer2/memoryMappedFiles/containers/ISnapshotSource;)V", "_lastGetSegment", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/IMinBitmapSegment;", "_lastGetSegmentEntry", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinSegmentInfoEntry;", "_lastGetSegmentEntryIndex", "", "_lastGetSegmentIndex", "getSegmentInfoList", "()Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/ImmutableListSegmentInfoFacade;", "buildSegment", "segmentEntry", "close", "", "get", "Lkd/bos/olapServer2/common/long;", "index", "Lkd/bos/olapServer2/common/rowIdx;", "getSegment", "segmentIndex", "getSegmentEntry", "Companion", "bos-olap-core2"})
public class MinImmutableBitmap
implements IImmutableBitmap,
Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableListSegmentInfoFacade segmentInfoList;
    @NotNull
    private final ISnapshotSource<IImmutableSegmentContainer> container;
    @Nullable
    private IMinBitmapSegment _lastGetSegment;
    private long _lastGetSegmentIndex;
    private long _lastGetSegmentEntryIndex;
    @NotNull
    private final MinSegmentInfoEntry _lastGetSegmentEntry;
    public static final int segmentLength = 256;

    public MinImmutableBitmap(@NotNull ImmutableListSegmentInfoFacade segmentInfoList, @NotNull ISnapshotSource<? extends IImmutableSegmentContainer> container) {
        Intrinsics.checkNotNullParameter((Object)segmentInfoList, (String)"segmentInfoList");
        Intrinsics.checkNotNullParameter(container, (String)"container");
        this.segmentInfoList = segmentInfoList;
        this.container = container;
        this._lastGetSegmentIndex = -1L;
        this._lastGetSegmentEntryIndex = -1L;
        this._lastGetSegmentEntry = new MinSegmentInfoEntry(-1L, 0, 0, -1L);
    }

    @NotNull
    protected final ImmutableListSegmentInfoFacade getSegmentInfoList() {
        return this.segmentInfoList;
    }

    @Override
    public long get(long index2) {
        long remainder = index2 % (long)256;
        long segmentIndex = index2 / (long)256;
        MinSegmentInfoEntry entry = this.getSegmentEntry(segmentIndex);
        if (remainder < (long)entry.getFrontEmptyCount() || remainder >= (long)(entry.getFrontEmptyCount() + entry.getValidCount())) {
            return 0L;
        }
        return this.getSegment(segmentIndex).get(remainder);
    }

    private final IMinBitmapSegment getSegment(long segmentIndex) {
        IMinBitmapSegment segment = this._lastGetSegment;
        if (this._lastGetSegmentIndex != segmentIndex || segment == null) {
            segment = this.buildSegment(this.getSegmentEntry(segmentIndex));
            this._lastGetSegmentIndex = segmentIndex;
            this._lastGetSegment = segment;
        }
        return segment;
    }

    private final IMinBitmapSegment buildSegment(MinSegmentInfoEntry segmentEntry) {
        IMinBitmapSegment iMinBitmapSegment;
        IByteBuffer buffer = this.container.getImmutableObject().getBuffer(segmentEntry.getOffset());
        int frontEmptyCount = segmentEntry.getFrontEmptyCount();
        int validCount = segmentEntry.getValidCount();
        byte by = buffer.getByte(0L);
        if (by == MinSegmentType.MinBitmap.getValue()) {
            iMinBitmapSegment = new MinBitmapSegment(buffer, frontEmptyCount, validCount);
        } else if (by == MinSegmentType.MinArray.getValue()) {
            iMinBitmapSegment = new MinArraySegment(buffer, frontEmptyCount, validCount);
        } else if (by == MinSegmentType.MinInvArray.getValue()) {
            iMinBitmapSegment = new MinInvArraySegment(buffer, frontEmptyCount, validCount);
        } else if (by == MinSegmentType.RoaringArray.getValue()) {
            iMinBitmapSegment = new RoaringArraySegment(buffer, frontEmptyCount, validCount);
        } else {
            throw new NotSupportedException();
        }
        return iMinBitmapSegment;
    }

    private final MinSegmentInfoEntry getSegmentEntry(long segmentIndex) {
        MinSegmentInfoEntry entry = this._lastGetSegmentEntry;
        if (this._lastGetSegmentEntryIndex != segmentIndex) {
            this.segmentInfoList.fillSegmentEntry(segmentIndex, entry);
            this._lastGetSegmentEntryIndex = segmentIndex;
        }
        return entry;
    }

    @Override
    public void close() {
        this.segmentInfoList.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinImmutableBitmap$Companion;", "", "()V", "segmentLength", "", "create", "Lkd/bos/olapServer2/collections/IImmutableBitmap;", "resource", "Lkd/bos/olapServer2/storages/CubeBigContainerResource;", "uuid", "Ljava/util/UUID;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IImmutableBitmap create(@NotNull CubeBigContainerResource resource, @NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Pair<IListMetadata, IOffsetMetadata> pair = resource.getUuidMap().tryGetMetadata(uuid);
            if (pair == null) {
                return EmptyQueryBitmap.INSTANCE;
            }
            Pair<IListMetadata, IOffsetMetadata> pair2 = pair;
            IListMetadata listMetadata = (IListMetadata)pair2.component1();
            IOffsetMetadata offsetMetadata = (IOffsetMetadata)pair2.component2();
            ContainerByteBufferResource res = new ContainerByteBufferResource(resource.getIndexKeyContainer(), offsetMetadata);
            ImmutableListSegmentInfo list2 = new ImmutableListSegmentInfo(listMetadata, res);
            ImmutableListSegmentInfoFacade segmentInfoList = new ImmutableListSegmentInfoFacade(list2);
            return new MinImmutableBitmap(segmentInfoList, resource.getIndexDataContainer());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

