/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.minBitmapV4;

import kd.bos.olapServer2.collections.IIndexScanner;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.ImmutableListSegmentInfoFacade;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinSegmentInfoEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\t2\n\u0010\u000b\u001a\u00060\bj\u0002`\tH\u0016J$\u0010\f\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\t2\n\u0010\r\u001a\u00060\bj\u0002`\tH\u0016J$\u0010\u000e\u001a\u00060\bj\u0002`\t2\n\u0010\u000f\u001a\u00060\bj\u0002`\t2\n\u0010\u0010\u001a\u00060\bj\u0002`\tH\u0002J\u0018\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\n\u0010\n\u001a\u00060\bj\u0002`\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinIndexScanner;", "Lkd/bos/olapServer2/collections/IIndexScanner;", "_indexes", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/ImmutableListSegmentInfoFacade;", "(Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/ImmutableListSegmentInfoFacade;)V", "_tempSegmentEntry", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinSegmentInfoEntry;", "getNextEmptyCount", "", "Lkd/bos/olapServer2/common/rowIdx;", "index", "maxEmptyCount", "getNextValidCount", "minValidCount", "getToLastEmptyCount", "startSegmentIndex", "count", "isEmptyValue", "", "Lkd/bos/olapServer2/common/bool;", "Companion", "bos-olap-core2"})
public final class MinIndexScanner
implements IIndexScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableListSegmentInfoFacade _indexes;
    @NotNull
    private final MinSegmentInfoEntry _tempSegmentEntry;
    public static final int segmentLength = 256;

    public MinIndexScanner(@NotNull ImmutableListSegmentInfoFacade _indexes) {
        Intrinsics.checkNotNullParameter((Object)_indexes, (String)"_indexes");
        this._indexes = _indexes;
        this._tempSegmentEntry = new MinSegmentInfoEntry();
    }

    @Override
    public boolean isEmptyValue(long index2) {
        long segmentIndex = index2 / (long)256;
        MinSegmentInfoEntry entry = this._tempSegmentEntry;
        this._indexes.fillSegmentEntry(segmentIndex, entry);
        long real = index2 % (long)256 - (long)entry.getFrontEmptyCount();
        return real < 0L || real >= (long)entry.getValidCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getNextEmptyCount(long index2, long maxEmptyCount) {
        long l;
        long segmentIndex = index2 / (long)256;
        long remainder = index2 % (long)256;
        ImmutableListSegmentInfoFacade.MinBitmapSegmentEntryIterator validEntries = this._indexes.getValidSegmentEntries(segmentIndex);
        long emptyCount = 0L;
        if (!validEntries.next()) {
            emptyCount = (long)256 - remainder;
            return emptyCount + this.getToLastEmptyCount(segmentIndex + 1L, index2 + maxEmptyCount);
        }
        MinSegmentInfoEntry entry = validEntries.getEntry();
        if (entry.getSegmentIndex() != segmentIndex) {
            emptyCount = (long)256 - remainder;
            long endSegmentIndex = entry.getSegmentIndex();
            return (emptyCount += (endSegmentIndex - segmentIndex - 1L) * (long)256) + (long)entry.getFrontEmptyCount();
        }
        long len = (long)entry.getFrontEmptyCount() - remainder;
        if (len > 0L) {
            return len;
        }
        if (len + (long)entry.getValidCount() > 0L) {
            return 0L;
        }
        emptyCount = (long)256 - remainder;
        if (!validEntries.next()) {
            l = emptyCount + this.getToLastEmptyCount(segmentIndex + 1L, index2 + maxEmptyCount);
            return l;
        }
        entry = validEntries.getEntry();
        long endSegmentIndex = entry.getSegmentIndex();
        if (!(endSegmentIndex > segmentIndex)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        l = (emptyCount += (endSegmentIndex - segmentIndex - 1L) * (long)256) + (long)entry.getFrontEmptyCount();
        return l;
    }

    private final long getToLastEmptyCount(long startSegmentIndex, long count) {
        return (count / (long)256 - startSegmentIndex) * (long)256 + count % (long)256;
    }

    @Override
    public long getNextValidCount(long index2, long minValidCount) {
        long segmentIndex = index2 / (long)256;
        long remainder = index2 % (long)256;
        ImmutableListSegmentInfoFacade.MinBitmapSegmentEntryIterator validEntries = this._indexes.getValidSegmentEntries(segmentIndex);
        long pre = segmentIndex - 1L;
        long validCount = 0L;
        while (validEntries.next() && validEntries.getEntry().getSegmentIndex() == pre + 1L) {
            MinSegmentInfoEntry entry = validEntries.getEntry();
            int vf = entry.getValidCount() + entry.getFrontEmptyCount();
            if (remainder >= (long)entry.getFrontEmptyCount() && remainder < (long)vf) {
                validCount += (long)vf - remainder;
            } else {
                return validCount;
            }
            if (vf < 256) {
                return validCount;
            }
            if (validCount >= minValidCount) {
                return minValidCount;
            }
            pre = entry.getSegmentIndex();
            remainder = 0L;
        }
        return validCount;
    }

    @Override
    public long getNextValidCount(long index2) {
        return IIndexScanner.DefaultImpls.getNextValidCount(this, index2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinIndexScanner$Companion;", "", "()V", "segmentLength", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

