/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.minBitmapV4;

import java.io.Flushable;
import java.util.BitSet;
import java.util.UUID;
import kd.bos.olapServer2.collections.IMutableList;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.memoryMappedFiles.IListMetadata;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ContainerByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IOffsetMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.IImmutableSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableUnFixedSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.IMinBitmapSegment;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.IMinMutableBitmap;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinArraySegment;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinBitmapSegment;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinInvArraySegment;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinSegmentInfoEntry;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MinSegmentType;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.MutableListSegmentInfo;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.RoaringArraySegment;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.storages.CubeBigContainerResource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007JP\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u0016\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u0017\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u001c\u0010\u0018\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0019\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u001a\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u001c\u001a\u00020\t2\n\u0010\u001d\u001a\u00060\u000bj\u0002`\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinMutableBitmap;", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/IMinMutableBitmap;", "segmentInfoList", "Lkd/bos/olapServer2/collections/IMutableList;", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinSegmentInfoEntry;", "container", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableUnFixedSegmentContainer;", "(Lkd/bos/olapServer2/collections/IMutableList;Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableUnFixedSegmentContainer;)V", "createAndFillSegment", "", "segmentIndex", "", "Lkd/bos/olapServer2/common/long;", "values", "", "dirtyFlags", "Ljava/util/BitSet;", "type", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinSegmentType;", "bufferSize", "", "Lkd/bos/olapServer2/common/int;", "frontEmptyCount", "validCount", "getBitCount", "getNegativeOneCount", "statisticsAndFill", "Lkd/bos/olapServer2/common/rowIdx;", "update", "index", "Companion", "bos-olap-core2"})
public final class MinMutableBitmap
implements IMinMutableBitmap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IMutableList<MinSegmentInfoEntry> segmentInfoList;
    @NotNull
    private final IMutableUnFixedSegmentContainer container;

    public MinMutableBitmap(@NotNull IMutableList<MinSegmentInfoEntry> segmentInfoList, @NotNull IMutableUnFixedSegmentContainer container) {
        Intrinsics.checkNotNullParameter(segmentInfoList, (String)"segmentInfoList");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.segmentInfoList = segmentInfoList;
        this.container = container;
    }

    @Override
    public void update(long index2, @NotNull long[] values, @NotNull BitSet dirtyFlags) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)dirtyFlags, (String)"dirtyFlags");
        if (!(index2 >= 0L && index2 % (long)256 == 0L && values.length == 256)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.statisticsAndFill(index2 / (long)256, values, dirtyFlags);
    }

    private final void statisticsAndFill(long segmentIndex, long[] values, BitSet dirtyFlags) {
        int roaringArraySize;
        if (!(values.length == 256)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int cardinality = dirtyFlags.cardinality();
        int frontEmptyCount = dirtyFlags.nextSetBit(0);
        int behindEmptyCount = dirtyFlags.previousSetBit(255);
        int validCount = behindEmptyCount - frontEmptyCount + 1;
        int arraySize = cardinality * 9;
        int bitmapSize = validCount * 8;
        int bitCount = this.getBitCount(values, dirtyFlags);
        if (bitCount >= 0 && (roaringArraySize = bitCount * 2) < arraySize && roaringArraySize < bitmapSize) {
            this.createAndFillSegment(segmentIndex, values, dirtyFlags, MinSegmentType.RoaringArray, roaringArraySize, frontEmptyCount, validCount);
            return;
        }
        if (arraySize >= bitmapSize) {
            int negativeOneCount = this.getNegativeOneCount(dirtyFlags, values);
            int invArraySize = (validCount - negativeOneCount) * 9;
            if (invArraySize < bitmapSize) {
                this.createAndFillSegment(segmentIndex, values, dirtyFlags, MinSegmentType.MinInvArray, invArraySize, frontEmptyCount, validCount);
                return;
            }
            this.createAndFillSegment(segmentIndex, values, dirtyFlags, MinSegmentType.MinBitmap, bitmapSize, frontEmptyCount, validCount);
            return;
        }
        this.createAndFillSegment(segmentIndex, values, dirtyFlags, MinSegmentType.MinArray, arraySize, frontEmptyCount, validCount);
    }

    private final int getBitCount(long[] values, BitSet dirtyFlags) {
        int bitCount = 0;
        int index2 = dirtyFlags.nextSetBit(0);
        while (index2 >= 0) {
            if ((bitCount += Long.bitCount(values[index2 = dirtyFlags.nextSetBit(index2 + 1)])) <= 256) continue;
            return -1;
        }
        return bitCount;
    }

    private final int getNegativeOneCount(BitSet dirtyFlags, long[] values) {
        int negativeOneCount = 0;
        int index2 = dirtyFlags.nextSetBit(0);
        while (index2 >= 0) {
            if (values[index2] == -1L) {
                ++negativeOneCount;
            }
            index2 = dirtyFlags.nextSetBit(index2 + 1);
        }
        return negativeOneCount;
    }

    private final void createAndFillSegment(long segmentIndex, long[] values, BitSet dirtyFlags, MinSegmentType type, int bufferSize, int frontEmptyCount, int validCount) {
        block6: {
            IMinBitmapSegment iMinBitmapSegment;
            long offset = this.container.allot((long)bufferSize + 1L);
            IByteBuffer buffer = ((IImmutableSegmentContainer)this.container.getImmutableObject()).getBuffer(offset);
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    iMinBitmapSegment = new MinBitmapSegment(buffer, frontEmptyCount, validCount);
                    break;
                }
                case 2: {
                    iMinBitmapSegment = new MinArraySegment(buffer, frontEmptyCount, validCount);
                    break;
                }
                case 3: {
                    iMinBitmapSegment = new MinInvArraySegment(buffer, frontEmptyCount, validCount);
                    break;
                }
                case 4: {
                    iMinBitmapSegment = new RoaringArraySegment(buffer, frontEmptyCount, validCount);
                    break;
                }
                default: {
                    throw new NotSupportedException();
                }
            }
            IMinBitmapSegment segment = iMinBitmapSegment;
            segment.fill(values, dirtyFlags);
            this.segmentInfoList.add(new MinSegmentInfoEntry(segmentIndex, frontEmptyCount, validCount, offset));
            IMutableList<MinSegmentInfoEntry> iMutableList = this.segmentInfoList;
            Flushable flushable = iMutableList instanceof Flushable ? (Flushable)((Object)iMutableList) : null;
            if (flushable == null) break block6;
            flushable.flush();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/MinMutableBitmap$Companion;", "", "()V", "create", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/IMinMutableBitmap;", "resource", "Lkd/bos/olapServer2/storages/CubeBigContainerResource;", "uuid", "Ljava/util/UUID;", "member", "Lkd/bos/olapServer2/metadata/Member;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IMinMutableBitmap create(@NotNull CubeBigContainerResource resource, @NotNull Member member) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            return this.create(resource, member.getGlobalID());
        }

        @NotNull
        public final IMinMutableBitmap create(@NotNull CubeBigContainerResource resource, @NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Pair<IListMetadata, IOffsetMetadata> pair = resource.getUuidMap().getOrAddMetadata(uuid);
            IListMetadata listMetadata = (IListMetadata)pair.component1();
            IOffsetMetadata offsetMetadata = (IOffsetMetadata)pair.component2();
            ContainerByteBufferResource res = new ContainerByteBufferResource(resource.getIndexKeyContainer(), offsetMetadata);
            MutableListSegmentInfo segmentInfoList = new MutableListSegmentInfo(listMetadata, res);
            return new MinMutableBitmap(segmentInfoList, resource.getIndexDataContainer());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MinSegmentType.values().length];
            try {
                nArray[MinSegmentType.MinBitmap.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MinSegmentType.MinArray.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MinSegmentType.MinInvArray.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MinSegmentType.RoaringArray.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

