/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.canUpdateBitmap;

import java.util.Iterator;
import kd.bos.olapServer2.memoryMappedFiles.IListMetadata;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.ContainerByteBufferResource;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IOffsetMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.IImmutableSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFixedSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFixedSegmentSequenceContainer;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.canUpdateBitmap.BitmapXSegment;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.canUpdateBitmap.IMutableBitmap;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.canUpdateBitmap.MutableSegmentEntryArray;
import kd.bos.olapServer2.memoryMappedFiles.minBitmapV4.canUpdateBitmap.SegmentInfoEntry;
import kotlin.Metadata;
import kotlin.collections.LongIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\b\u0002\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0018\u001a\u00020\u00142\n\u0010\u0019\u001a\u00060\u000fj\u0002`\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0019\u0010\u001e\u001a\u00060\u000fj\u0002`\u001a2\n\u0010\u001f\u001a\u00060\u000fj\u0002`\u0010H\u0096\u0002J\u0014\u0010 \u001a\u00020\u00142\n\u0010\u0019\u001a\u00060\u000fj\u0002`\u0010H\u0002J\u0014\u0010!\u001a\u00020\u001c2\n\u0010\"\u001a\u00060\u000fj\u0002`\u0010H\u0002J!\u0010#\u001a\u00020\u001c2\n\u0010\u001f\u001a\u00060\u000fj\u0002`\u00102\n\u0010$\u001a\u00060\u000fj\u0002`\u001aH\u0096\u0002J$\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000f2\n\u0010'\u001a\u00060(j\u0002`)H\u0002R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/canUpdateBitmap/MutableBitmap;", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/canUpdateBitmap/IMutableBitmap;", "indexContainer", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFixedSegmentSequenceContainer;", "dataContainer", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFixedSegmentContainer;", "offsetMetadata", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IOffsetMetadata;", "countMetadata", "Lkd/bos/olapServer2/memoryMappedFiles/IListMetadata;", "defaultValue", "", "Lkd/bos/olapServer2/common/bool;", "(Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFixedSegmentSequenceContainer;Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFixedSegmentContainer;Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IOffsetMetadata;Lkd/bos/olapServer2/memoryMappedFiles/IListMetadata;Z)V", "count", "", "Lkd/bos/olapServer2/common/rowIdx;", "indexContainerByteBufferResource", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/ContainerByteBufferResource;", "lastGetSegment", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/canUpdateBitmap/BitmapXSegment;", "lastGetSegmentEntryIndex", "segmentEntryArray", "Lkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/canUpdateBitmap/MutableSegmentEntryArray;", "createAndFillSegment", "segmentIndex", "Lkd/bos/olapServer2/common/long;", "delete", "", "flush", "get", "index", "getSegment", "reCalcCount", "rowCount", "set", "value", "updateDefaultValueCount", "segment", "defaultValueCount", "", "Lkd/bos/olapServer2/common/int;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nMutableBitmap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableBitmap.kt\nkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/canUpdateBitmap/MutableBitmap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1855#2,2:158\n*S KotlinDebug\n*F\n+ 1 MutableBitmap.kt\nkd/bos/olapServer2/memoryMappedFiles/minBitmapV4/canUpdateBitmap/MutableBitmap\n*L\n61#1:158,2\n*E\n"})
public final class MutableBitmap
implements IMutableBitmap {
    @NotNull
    private final IMutableFixedSegmentContainer dataContainer;
    @NotNull
    private final IListMetadata countMetadata;
    private final long defaultValue;
    @NotNull
    private final ContainerByteBufferResource indexContainerByteBufferResource;
    @NotNull
    private final MutableSegmentEntryArray segmentEntryArray;
    private long count;
    private long lastGetSegmentEntryIndex;
    @NotNull
    private BitmapXSegment lastGetSegment;

    public MutableBitmap(@NotNull IMutableFixedSegmentSequenceContainer indexContainer, @NotNull IMutableFixedSegmentContainer dataContainer, @NotNull IOffsetMetadata offsetMetadata, @NotNull IListMetadata countMetadata, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)indexContainer, (String)"indexContainer");
        Intrinsics.checkNotNullParameter((Object)dataContainer, (String)"dataContainer");
        Intrinsics.checkNotNullParameter((Object)offsetMetadata, (String)"offsetMetadata");
        Intrinsics.checkNotNullParameter((Object)countMetadata, (String)"countMetadata");
        this.dataContainer = dataContainer;
        this.countMetadata = countMetadata;
        this.defaultValue = defaultValue ? -1L : 0L;
        this.indexContainerByteBufferResource = new ContainerByteBufferResource(indexContainer, offsetMetadata);
        this.segmentEntryArray = new MutableSegmentEntryArray(this.indexContainerByteBufferResource);
        this.count = this.countMetadata.getCount();
        this.lastGetSegmentEntryIndex = -1L;
        this.lastGetSegment = BitmapXSegment.Companion.getInvalidSegment();
    }

    public /* synthetic */ MutableBitmap(IMutableFixedSegmentSequenceContainer iMutableFixedSegmentSequenceContainer, IMutableFixedSegmentContainer iMutableFixedSegmentContainer, IOffsetMetadata iOffsetMetadata, IListMetadata iListMetadata, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(iMutableFixedSegmentSequenceContainer, iMutableFixedSegmentContainer, iOffsetMetadata, iListMetadata, bl);
    }

    private final BitmapXSegment getSegment(long segmentIndex) {
        BitmapXSegment segment = this.lastGetSegment;
        if (this.lastGetSegmentEntryIndex != segmentIndex) {
            BitmapXSegment bitmapXSegment;
            SegmentInfoEntry segmentEntry = this.segmentEntryArray.get(segmentIndex);
            if (segmentEntry.getOffset() == 0xFFFFFFFFFFFFL) {
                bitmapXSegment = BitmapXSegment.Companion.getInvalidSegment();
            } else {
                IByteBuffer buffer = ((IImmutableSegmentContainer)this.dataContainer.getImmutableObject()).getBuffer(segmentEntry.getOffset());
                bitmapXSegment = new BitmapXSegment(segmentEntry, buffer);
            }
            segment = bitmapXSegment;
            this.lastGetSegmentEntryIndex = segmentIndex;
            this.lastGetSegment = segment;
        }
        return segment;
    }

    private final void reCalcCount(long rowCount) {
        if (rowCount > this.count) {
            this.count = rowCount;
        }
    }

    public final void delete() {
        if (this.segmentEntryArray.getLength() == 0L) {
            return;
        }
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (long)this.segmentEntryArray.getLength());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            long element$iv;
            long it = element$iv = ((LongIterator)iterator2).nextLong();
            boolean bl = false;
            SegmentInfoEntry segmentEntry = this.segmentEntryArray.get(it);
            if (segmentEntry.getOffset() == 0xFFFFFFFFFFFFL) continue;
            this.dataContainer.release(segmentEntry.getOffset());
        }
        this.dataContainer.gc();
        this.indexContainerByteBufferResource.release();
        this.indexContainerByteBufferResource.gc();
        this.countMetadata.setCount(0L);
    }

    @Override
    public void flush() {
        this.countMetadata.setCount(this.count);
    }

    private final BitmapXSegment createAndFillSegment(long segmentIndex) {
        long offset = this.dataContainer.allot();
        IByteBuffer buffer = ((IImmutableSegmentContainer)this.dataContainer.getImmutableObject()).getBuffer(offset);
        SegmentInfoEntry segmentEntry = new SegmentInfoEntry(offset, 255);
        this.segmentEntryArray.set(segmentIndex, segmentEntry);
        BitmapXSegment segment = new BitmapXSegment(segmentEntry, buffer);
        byte value2 = this.defaultValue == 0L ? (byte)0 : -1;
        segment.fill(value2);
        this.lastGetSegmentEntryIndex = segmentIndex;
        this.lastGetSegment = segment;
        return segment;
    }

    @Override
    public long get(long index2) {
        if (index2 * (long)64 > this.count) {
            return this.defaultValue;
        }
        BitmapXSegment segment = this.getSegment(index2 / (long)256);
        return segment.get(index2 & 0xFFL, this.defaultValue);
    }

    @Override
    public void set(long index2, long value2) {
        long segmentIndex = index2 >> 8;
        BitmapXSegment segment = this.getSegment(segmentIndex);
        long innerSegmentIndex = index2 & 0xFFL;
        if (segment.getEntry().getOffset() == 0xFFFFFFFFFFFFL) {
            if (value2 != this.defaultValue) {
                segment = this.createAndFillSegment(segmentIndex);
                segment.set(innerSegmentIndex, value2);
            }
            this.reCalcCount((index2 + 1L) * (long)64);
            return;
        }
        long curLong = segment.get(innerSegmentIndex, this.defaultValue);
        if (value2 != curLong) {
            int oldDefaultValueCount;
            segment.set(innerSegmentIndex, value2);
            int newDefaultValueCount = oldDefaultValueCount = segment.getEntry().getDefaultValueCount();
            if (curLong == this.defaultValue) {
                newDefaultValueCount = oldDefaultValueCount - 1;
            } else if (value2 == this.defaultValue) {
                newDefaultValueCount = oldDefaultValueCount + 1;
            }
            if (oldDefaultValueCount != newDefaultValueCount) {
                if (newDefaultValueCount == 256) {
                    this.dataContainer.release(segment.getEntry().getOffset());
                    this.dataContainer.gc();
                    this.lastGetSegment = BitmapXSegment.Companion.getInvalidSegment();
                    this.segmentEntryArray.set(segmentIndex, new SegmentInfoEntry(0xFFFFFFFFFFFFL, 255));
                } else {
                    this.updateDefaultValueCount(segment, segmentIndex, newDefaultValueCount);
                }
            }
        }
        this.reCalcCount((index2 + 1L) * (long)64);
    }

    private final void updateDefaultValueCount(BitmapXSegment segment, long segmentIndex, int defaultValueCount) {
        SegmentInfoEntry tmpSegmentInfoEntry = new SegmentInfoEntry(segment.getEntry().getOffset(), defaultValueCount);
        this.segmentEntryArray.set(segmentIndex, tmpSegmentInfoEntry);
        segment.setEntry(tmpSegmentInfoEntry);
    }
}

