/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.primitiveCollections;

import java.io.Flushable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kd.bos.olapServer2.collections.HashHelpers;
import kd.bos.olapServer2.collections.HashMapEntry;
import kd.bos.olapServer2.collections.IGetOrAddStrategy;
import kd.bos.olapServer2.collections.IMutableArrayLong;
import kd.bos.olapServer2.collections.IMutableListHashMapEntry;
import kd.bos.olapServer2.collections.IMutableParallelArrayLong;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.EventArgs;
import kd.bos.olapServer2.common.EventHandlerList;
import kd.bos.olapServer2.memoryMappedFiles.LongEqualityComparer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer2.memoryMappedFiles.primitiveCollections.AbstractImmutableMapLong;
import kd.bos.olapServer2.memoryMappedFiles.primitiveCollections.IAddEntryFunctionLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ,\u0010\u0017\u001a\u00060\rj\u0002`\u00182\n\u0010\u0019\u001a\u00060\rj\u0002`\u000e2\n\u0010\u001a\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J \u0010\u0017\u001a\u00060\rj\u0002`\u00182\n\u0010\u0019\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\f\u0010\u001f\u001a\u00060\rj\u0002`\u000eH\u0002J6\u0010 \u001a\u00060\rj\u0002`\u00182\n\u0010\u0019\u001a\u00060\rj\u0002`\u000e2\n\u0010\u001a\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004J \u0010 \u001a\u00060\rj\u0002`\u00182\n\u0010\u0019\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J*\u0010 \u001a\u00060\rj\u0002`\u00182\n\u0010\u0019\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004J\u0014\u0010#\u001a\u00020\u001e2\n\u0010$\u001a\u00060\rj\u0002`\u0018H\u0002J\u0014\u0010%\u001a\u00020\u001e2\n\u0010&\u001a\u00060\rj\u0002`\u000eH\u0002J\u001c\u0010'\u001a\u00020\u001e2\n\u0010&\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0005\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u001eH\u0002J\u0014\u0010)\u001a\u00020\u001e2\n\u0010*\u001a\u00060\rj\u0002`\u0018H\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006+"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/primitiveCollections/AbstractMutableMapLong;", "TEntry", "Lkd/bos/olapServer2/collections/HashMapEntry;", "Lkd/bos/olapServer2/memoryMappedFiles/primitiveCollections/AbstractImmutableMapLong;", "Ljava/io/Flushable;", "buckets", "Lkd/bos/olapServer2/collections/IMutableArrayLong;", "entries", "Lkd/bos/olapServer2/collections/IMutableListHashMapEntry;", "comparer", "Lkd/bos/olapServer2/memoryMappedFiles/LongEqualityComparer;", "(Lkd/bos/olapServer2/collections/IMutableArrayLong;Lkd/bos/olapServer2/collections/IMutableListHashMapEntry;Lkd/bos/olapServer2/memoryMappedFiles/LongEqualityComparer;)V", "bucketsResizeCount", "", "Lkd/bos/olapServer2/common/long;", "rehashed", "Lkd/bos/olapServer2/common/EventHandlerList;", "", "Lkd/bos/olapServer2/common/EventArgs;", "getRehashed", "()Lkd/bos/olapServer2/common/EventHandlerList;", "rehashing", "getRehashing", "add", "Lkd/bos/olapServer2/common/rowIdx;", "key", "hashcode", "addEntry", "Lkd/bos/olapServer2/memoryMappedFiles/primitiveCollections/IAddEntryFunctionLong;", "flush", "", "getNeedResizeLength", "getOrAdd", "strategy", "Lkd/bos/olapServer2/collections/IGetOrAddStrategy;", "initialize", "size", "rehash", "newSize", "rehashParallel", "Lkd/bos/olapServer2/collections/IMutableParallelArrayLong;", "resize", "finalSize", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nLongCollections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongCollections.kt\nkd/bos/olapServer2/memoryMappedFiles/primitiveCollections/AbstractMutableMapLong\n+ 2 DebugContext.kt\nkd/bos/olapServer2/common/DebugContextKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,502:1\n16#2,4:503\n32#2,4:510\n1#3:507\n13309#4,2:508\n*S KotlinDebug\n*F\n+ 1 LongCollections.kt\nkd/bos/olapServer2/memoryMappedFiles/primitiveCollections/AbstractMutableMapLong\n*L\n273#1:503,4\n440#1:510,4\n424#1:508,2\n*E\n"})
public abstract class AbstractMutableMapLong<TEntry extends HashMapEntry>
extends AbstractImmutableMapLong
implements Flushable {
    @NotNull
    private final IMutableArrayLong buckets;
    @NotNull
    private final IMutableListHashMapEntry<TEntry> entries;
    private long bucketsResizeCount;
    @NotNull
    private final EventHandlerList<Object, EventArgs> rehashing;
    @NotNull
    private final EventHandlerList<Object, EventArgs> rehashed;

    public AbstractMutableMapLong(@NotNull IMutableArrayLong buckets, @NotNull IMutableListHashMapEntry<TEntry> entries2, @NotNull LongEqualityComparer comparer) {
        Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        Intrinsics.checkNotNullParameter((Object)comparer, (String)"comparer");
        super(buckets, entries2, comparer);
        this.buckets = buckets;
        this.entries = entries2;
        this.bucketsResizeCount = this.getNeedResizeLength();
        this.rehashing = new EventHandlerList();
        this.rehashed = new EventHandlerList();
    }

    private final long getNeedResizeLength() {
        long bucketsLength = this.buckets.getLength();
        return bucketsLength < 0x3FFFFFFFL ? bucketsLength * 3L / 4L : bucketsLength;
    }

    private final void initialize(long size) {
        long newSize = HashHelpers.INSTANCE.getPrime4Long(size);
        this.buckets.resize(newSize);
        this.buckets.fill(-1L);
        this.bucketsResizeCount = this.getNeedResizeLength();
    }

    protected final long getOrAdd(long key2, @NotNull IAddEntryFunctionLong addEntry) {
        Intrinsics.checkNotNullParameter((Object)addEntry, (String)"addEntry");
        return this.getOrAdd(key2, this.getComparer().getHashCode(key2) & Long.MAX_VALUE, addEntry, null);
    }

    protected final long getOrAdd(long key2, @NotNull IAddEntryFunctionLong addEntry, @Nullable IGetOrAddStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)addEntry, (String)"addEntry");
        return this.getOrAdd(key2, this.getComparer().getHashCode(key2) & Long.MAX_VALUE, addEntry, strategy);
    }

    protected final long getOrAdd(long key2, long hashcode, @NotNull IAddEntryFunctionLong addEntry, @Nullable IGetOrAddStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)addEntry, (String)"addEntry");
        boolean $i$f$onDebug = false;
        long bucketsLength = this.buckets.getLength();
        if (bucketsLength == 0L) {
            this.initialize(0L);
        }
        long targetBucket = hashcode % this.buckets.getLength();
        long i = this.buckets.get(targetBucket);
        while (i >= 0L) {
            if (this.entries.getEntryHashcode(i) == hashcode && this.equalsKey(i, key2)) {
                return i;
            }
            i = this.entries.getEntryNext(i);
        }
        long index2 = this.getCount();
        if (strategy != null && !strategy.allowAdd()) {
            return Long.MIN_VALUE;
        }
        if (index2 >= this.bucketsResizeCount) {
            this.resize();
            targetBucket = hashcode % this.buckets.getLength();
        }
        if (!(index2 == addEntry.invoke(key2, hashcode, this.buckets.get(targetBucket)))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.buckets.set(targetBucket, index2);
        return -(index2 + 1L);
    }

    protected final long add(long key2, @NotNull IAddEntryFunctionLong addEntry) {
        Intrinsics.checkNotNullParameter((Object)addEntry, (String)"addEntry");
        return this.add(key2, this.getComparer().getHashCode(key2) & Long.MAX_VALUE, addEntry);
    }

    protected final long add(long key2, long hashcode, @NotNull IAddEntryFunctionLong addEntry) {
        Intrinsics.checkNotNullParameter((Object)addEntry, (String)"addEntry");
        long bucketsLength = this.buckets.getLength();
        if (bucketsLength == 0L) {
            this.initialize(0L);
        }
        if (!(hashcode >= 0L)) {
            boolean bl = false;
            String string2 = "hashcode:" + hashcode + " \u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0";
            throw new IllegalArgumentException(string2.toString());
        }
        long targetBucket = hashcode % this.buckets.getLength();
        long index2 = this.getCount();
        if (index2 >= this.bucketsResizeCount) {
            this.resize();
            targetBucket = hashcode % this.buckets.getLength();
        }
        if (!(index2 == addEntry.invoke(key2, hashcode, this.buckets.get(targetBucket)))) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        this.buckets.set(targetBucket, index2);
        return index2;
    }

    @NotNull
    public final EventHandlerList<Object, EventArgs> getRehashing() {
        return this.rehashing;
    }

    @NotNull
    public final EventHandlerList<Object, EventArgs> getRehashed() {
        return this.rehashed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resize() {
        try {
            this.rehashing.invoke(this, EventArgs.Default.INSTANCE);
            long currentCount = this.buckets.getLength();
            long newSize = HashHelpers.INSTANCE.expandPrime4Long(currentCount);
            this.buckets.resize(newSize);
            this.buckets.fill(-1L);
            if (Bits.INSTANCE.getUnaligned() && currentCount > 10000000L && this.buckets instanceof IMutableParallelArrayLong) {
                this.rehashParallel(newSize, (IMutableParallelArrayLong)this.buckets);
            } else {
                this.rehash(newSize);
            }
            this.bucketsResizeCount = this.getNeedResizeLength();
        }
        finally {
            this.rehashed.invoke(this, EventArgs.Default.INSTANCE);
        }
    }

    private final void rehash(long newSize) {
        long bucket = 0L;
        long l = this.getCount();
        for (long i = 0L; i < l; ++i) {
            long hashcode = this.entries.getEntryHashcode(i);
            if (hashcode < 0L) continue;
            bucket = hashcode % newSize;
            this.entries.setEntryNext(i, this.buckets.get(bucket));
            this.buckets.set(bucket, i);
        }
    }

    private final void rehashParallel(long newSize, IMutableParallelArrayLong buckets) {
        Future[] tasks;
        int n;
        int threadCount = Math.max(2, CommonTypesKt.getAvailableProcessors() / 2);
        ExecutorService exe = Executors.newFixedThreadPool(threadCount);
        long size = this.getCount();
        long s = 0L;
        Future[] futureArray = new Future[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            long end;
            n = i;
            long start = s;
            s = end = n == threadCount - 1 ? size : s + size / (long)threadCount;
            futureArray[n] = exe.submit(() -> AbstractMutableMapLong.rehashParallel$lambda$3(start, end, this, newSize, buckets));
        }
        Future[] $this$forEach$iv = tasks = futureArray;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            Future element$iv;
            Future it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            it.get();
        }
        exe.shutdown();
    }

    protected final void resize(long finalSize) {
        this.initialize(finalSize);
    }

    @Override
    public void flush() {
        Object object2 = this.buckets;
        Flushable flushable = object2 instanceof Flushable ? (Flushable)object2 : null;
        if (flushable != null) {
            flushable.flush();
        }
        object2 = this.entries;
        Flushable flushable2 = object2 instanceof Flushable ? (Flushable)object2 : null;
        if (flushable2 != null) {
            flushable2.flush();
        }
        boolean $i$f$onTestTrace = false;
    }

    private static final void rehashParallel$lambda$3(long $start, long $end, AbstractMutableMapLong this$0, long $newSize, IMutableParallelArrayLong $buckets) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$buckets, (String)"$buckets");
        long bucket = 0L;
        long oldBucket = 0L;
        for (long i = $start; i < $end; ++i) {
            long hashcode = this$0.entries.getEntryHashcode(i);
            if (hashcode < 0L) continue;
            bucket = hashcode % $newSize;
            do {
                oldBucket = $buckets.getVolatile(bucket);
                this$0.entries.setEntryNext(i, oldBucket);
            } while (!$buckets.compareAndSet(bucket, oldBucket, i));
        }
    }
}

