/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.runLengthEncoding;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.dataEntities.DynamicSizeRange;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.runLengthEncoding.RunLengthSegment;
import kd.bos.olapServer2.memoryMappedFiles.runLengthEncoding.RunLengthSimpleSegment;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 62\u00020\u0001:\u000267B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u001d\u001a\u00020\u00012\n\u0010\u001e\u001a\u00060\nj\u0002`\u000bH\u0016J4\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u00060\nj\u0002`\u000b2\n\u0010\"\u001a\u00060\nj\u0002`\u000b2\u0006\u0010#\u001a\u00020$2\n\u0010%\u001a\u00060\nj\u0002`\u000bH\u0016J0\u0010&\u001a\u00060\nj\u0002`\u000b2\n\u0010'\u001a\u00060\nj\u0002`\u000b2\n\u0010(\u001a\u00060\nj\u0002`\u000b2\n\u0010)\u001a\u00060\nj\u0002`\u000bH\u0002J\u0010\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\bH\u0014J\b\u0010,\u001a\u00020 H\u0016J\u0019\u0010-\u001a\u00060\nj\u0002`\u000b2\n\u0010.\u001a\u00060\nj\u0002`\u000bH\u0096\u0002J\u0018\u0010/\u001a\u00060\nj\u0002`\u000b2\n\u0010.\u001a\u00060\nj\u0002`\u000bH\u0002J\t\u00100\u001a\u000201H\u0096\u0002J\u0018\u00102\u001a\u00060\nj\u0002`\u000b2\n\u00103\u001a\u00060\nj\u0002`\u000bH\u0002J\u0018\u00104\u001a\u00060\nj\u0002`\u000b2\n\u00103\u001a\u00060\nj\u0002`\u000bH\u0002J\b\u00105\u001a\u00020\u0001H\u0002R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\nj\u0002`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00060\nj\u0002`\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00060\u0005j\u0002`\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00068"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncoding/RunLengthArraySegment;", "Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncoding/RunLengthSegment;", "buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "offset", "", "Lkd/bos/olapServer2/common/long;", "currentAdapter", "Lkd/bos/olapServer2/dataEntities/DynamicSizeRange;", "count", "", "Lkd/bos/olapServer2/common/int;", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;JLkd/bos/olapServer2/dataEntities/DynamicSizeRange;I)V", "_L1Count", "_arrayCount", "_bytes", "", "_cachedRangeInnerIndex", "_cachedRangeMax", "_cachedRangeMin", "_intBytes", "_lastValue", "_maxArrayCount", "lastValue", "getLastValue", "()I", "nextSegmentOffset", "getNextSegmentOffset", "()J", "add", "value", "batchGet", "", "start", "end", "result", "", "destPos", "binarySearch", "lo", "hi", "target", "createInstance", "newSizeRange", "flush", "get", "index", "getArrayIndex", "iterator", "Lkotlin/collections/IntIterator;", "readIndex", "arrayIndex", "readValue", "switchToSimple", "Companion", "ValueIterator", "bos-olap-core2"})
public final class RunLengthArraySegment
extends RunLengthSegment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int _arrayCount;
    private final int _intBytes;
    private final int _maxArrayCount;
    private int _cachedRangeMin;
    private int _cachedRangeMax;
    private int _cachedRangeInnerIndex;
    private final int _L1Count;
    @NotNull
    private final byte[] _bytes;
    private int _lastValue;
    @NotNull
    private static final AtomicReference<int[]> _valuesArrayCache = new AtomicReference();

    public RunLengthArraySegment(@NotNull IByteBuffer buffer, long offset, @NotNull DynamicSizeRange currentAdapter, int count) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)currentAdapter, (String)"currentAdapter");
        super(buffer, offset, currentAdapter, count);
        this._arrayCount = CommonTypesKt.toIntNoNegative(this.get_buffer().getShort(this.get_offset()));
        this._intBytes = this.get_currentAdapter().getElementByteSize();
        this._maxArrayCount = 65536 * this._intBytes / (2 + this._intBytes) - 1;
        this._cachedRangeMin = -1;
        this._cachedRangeMax = -1;
        this._cachedRangeInnerIndex = -1;
        this._L1Count = 64 / (2 + this._intBytes);
        this._bytes = new byte[3];
        this._lastValue = -1;
    }

    @Override
    public int get(int index2) {
        return this.readValue(this.getArrayIndex(index2));
    }

    private final int getArrayIndex(int index2) {
        if (!(0 <= index2 ? index2 < this.get_count() : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int realIndex = this._cachedRangeMin < 0 ? this.binarySearch(0, this._arrayCount - 1, index2) : (index2 >= this._cachedRangeMin ? (index2 < this._cachedRangeMax ? -(this._cachedRangeInnerIndex + 1) : (index2 == this._cachedRangeMax ? this._cachedRangeInnerIndex : this.binarySearch(this._cachedRangeInnerIndex + 1, this._arrayCount - 1, index2))) : this.binarySearch(0, this._cachedRangeInnerIndex - 1, index2));
        return realIndex < 0 ? -realIndex - 2 : realIndex;
    }

    private final int binarySearch(int lo, int hi, int target) {
        int x;
        int low = lo;
        int high = hi;
        this._cachedRangeMin = target;
        while (low + this._L1Count <= high) {
            int mid = low + high >>> 1;
            int middleValue = this.readIndex(mid);
            if (middleValue < target) {
                low = mid + 1;
                continue;
            }
            if (middleValue > target) {
                high = mid - 1;
                continue;
            }
            this._cachedRangeMax = this._cachedRangeMin;
            this._cachedRangeInnerIndex = mid;
            return mid;
        }
        for (x = low; x <= high; ++x) {
            int value2 = this.readIndex(x);
            if (value2 < target) continue;
            this._cachedRangeMax = value2;
            if (value2 != target) break;
            this._cachedRangeInnerIndex = x;
            return x;
        }
        if (x > high) {
            this._cachedRangeMax = x < this._arrayCount ? this.readIndex(x) : Integer.MAX_VALUE;
        }
        this._cachedRangeInnerIndex = x;
        return -(x + 1);
    }

    private final int readIndex(int arrayIndex) {
        return arrayIndex == 0 ? 0 : CommonTypesKt.toIntNoNegative(this.get_buffer().getShort(this.get_offset() + (long)(arrayIndex * (2 + this._intBytes))));
    }

    private final int readValue(int arrayIndex) {
        int n;
        switch (this._intBytes) {
            case 1: {
                n = CommonTypesKt.toIntNoNegative(this.get_buffer().getByte(this.get_offset() + (long)(arrayIndex * 3) + (long)2));
                break;
            }
            case 2: {
                n = CommonTypesKt.toIntNoNegative(this.get_buffer().getShort(this.get_offset() + (long)(arrayIndex * 4) + (long)2));
                break;
            }
            case 3: {
                byte[] bytes2 = this._bytes;
                this.get_buffer().getByteArray(this.get_offset() + (long)(arrayIndex * 5) + (long)2, bytes2, 0, 3);
                n = bytes2[0] & 0xFF | (bytes2[1] & 0xFF) << 8 | (bytes2[2] & 0xFF) << 16;
                break;
            }
            case 4: {
                n = this.get_buffer().getInt(this.get_offset() + (long)(arrayIndex * 6) + (long)2);
                break;
            }
            default: {
                String string2 = Res.INSTANCE.getCommonException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CommonException_4>(...)");
                throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
            }
        }
        return n;
    }

    @Override
    @NotNull
    public RunLengthSegment add(int value2) {
        if (value2 != this.getLastValue()) {
            if (this._arrayCount > this._maxArrayCount) {
                RunLengthSegment newSegment = this.switchToSimple();
                return newSegment.add(value2);
            }
            long position = this.get_offset() + (long)(this._arrayCount * (2 + this._intBytes));
            if (this.get_count() > 0) {
                this.get_buffer().putShort(position, (short)this.get_count());
            }
            long valuePos = position + (long)2;
            switch (this._intBytes) {
                case 1: {
                    if (!(0 <= value2 ? value2 < 256 : false)) {
                        String string2 = "Failed requirement.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.get_buffer().putByte(valuePos, (byte)value2);
                    break;
                }
                case 2: {
                    if (!(0 <= value2 ? value2 < 65536 : false)) {
                        String string3 = "Failed requirement.";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.get_buffer().putShort(valuePos, (short)value2);
                    break;
                }
                case 3: {
                    if (!(0 <= value2 ? value2 < 0x1000000 : false)) {
                        String string4 = "Failed requirement.";
                        throw new IllegalArgumentException(string4.toString());
                    }
                    byte[] bytes2 = this._bytes;
                    bytes2[0] = (byte)value2;
                    bytes2[1] = (byte)(value2 >> 8);
                    bytes2[2] = (byte)(value2 >> 16);
                    this.get_buffer().putByteArray(valuePos, bytes2, 0, 3);
                    break;
                }
                case 4: {
                    if (!(value2 >= 0)) {
                        String string5 = "Failed requirement.";
                        throw new IllegalArgumentException(string5.toString());
                    }
                    this.get_buffer().putInt(valuePos, value2);
                    break;
                }
                default: {
                    String string6 = Res.INSTANCE.getCommonException_4();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"<get-CommonException_4>(...)");
                    throw Res.INSTANCE.getRuntimeException(string6, new Object[0]);
                }
            }
            int n = this._arrayCount;
            this._arrayCount = n + 1;
            this._lastValue = value2;
            this._cachedRangeMin = -1;
        }
        int n = this.get_count();
        this.set_count(n + 1);
        return this;
    }

    private final int getLastValue() {
        if (this._lastValue < 0 && this._arrayCount > 0) {
            this._lastValue = this.readValue(this._arrayCount - 1);
        }
        return this._lastValue;
    }

    @Override
    public void flush() {
        this.get_buffer().putShort(this.get_offset(), (short)this._arrayCount);
    }

    @Override
    public long getNextSegmentOffset() {
        return this.get_offset() + (long)(this._arrayCount * (2 + this._intBytes));
    }

    private final RunLengthSegment switchToSimple() {
        int[] values = RunLengthArraySegment.Companion.getValuesCache(this.get_count());
        Iterator iterator2 = this.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int value2;
            int index2 = n++;
            values[index2] = value2 = ((Number)iterator2.next()).intValue();
        }
        RunLengthSegment newSegment = new RunLengthSimpleSegment(this.get_buffer(), this.get_offset(), this.get_currentAdapter(), 0);
        int n2 = this.get_count();
        for (int i = 0; i < n2; ++i) {
            newSegment = newSegment.add(values[i]);
        }
        RunLengthArraySegment.Companion.releaseValuesCache(values);
        return newSegment;
    }

    @NotNull
    public IntIterator iterator() {
        return new ValueIterator();
    }

    @Override
    @NotNull
    protected RunLengthSegment createInstance(@NotNull DynamicSizeRange newSizeRange) {
        Intrinsics.checkNotNullParameter((Object)newSizeRange, (String)"newSizeRange");
        return new RunLengthArraySegment(this.get_buffer(), this.get_offset(), newSizeRange, 0);
    }

    @Override
    public void batchGet(int start, int end, @NotNull int[] result2, int destPos) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        int startArrayIndex = this.getArrayIndex(start);
        int rangMax = 0;
        int currentValue = 0;
        int index2 = start;
        while (index2 <= end) {
            int nextArrayIndex;
            currentValue = this.readValue(startArrayIndex);
            rangMax = ++startArrayIndex < this._arrayCount ? ((nextArrayIndex = this.readIndex(startArrayIndex)) <= end ? nextArrayIndex : end + 1) : end + 1;
            int n = destPos + (rangMax - start);
            for (int i = destPos + (index2 - start); i < n; ++i) {
                result2[i] = currentValue;
            }
            index2 = rangMax;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00052\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncoding/RunLengthArraySegment$Companion;", "", "()V", "_valuesArrayCache", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getValuesCache", "size", "", "Lkd/bos/olapServer2/common/int;", "releaseValuesCache", "", "valuesArray", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] getValuesCache(int size) {
            int[] valuesArray = _valuesArrayCache.getAndSet(null);
            if (valuesArray == null || valuesArray.length < size) {
                valuesArray = new int[size];
            }
            return valuesArray;
        }

        private final void releaseValuesCache(int[] valuesArray) {
            _valuesArrayCache.compareAndSet(null, valuesArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\b\u001a\u00020\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncoding/RunLengthArraySegment$ValueIterator;", "Lkotlin/collections/IntIterator;", "(Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncoding/RunLengthArraySegment;)V", "_arrayI", "", "_currentValue", "_i", "_rangeMax", "hasNext", "", "nextInt", "nextRange", "", "bos-olap-core2"})
    private final class ValueIterator
    extends IntIterator {
        private int _i;
        private int _arrayI;
        private int _rangeMax = -1;
        private int _currentValue = -1;

        public int nextInt() {
            int n = RunLengthArraySegment.this.get_count();
            int n2 = this._i;
            boolean bl = 0 <= n2 ? n2 < n : false;
            if (bl) {
                if (this._i >= this._rangeMax) {
                    this.nextRange();
                }
                n = this._i;
                this._i = n + 1;
                return this._currentValue;
            }
            throw new IndexOutOfBoundsException();
        }

        private final void nextRange() {
            this._currentValue = RunLengthArraySegment.this.readValue(this._arrayI);
            int n = this._arrayI;
            this._arrayI = n + 1;
            this._rangeMax = this._arrayI < RunLengthArraySegment.this._arrayCount ? RunLengthArraySegment.this.readIndex(this._arrayI) : RunLengthArraySegment.this.get_count();
        }

        public boolean hasNext() {
            int n = RunLengthArraySegment.this.get_count();
            int n2 = this._i;
            return 0 <= n2 ? n2 < n : false;
        }
    }
}

