/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.runLengthEncoding;

import java.util.Iterator;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.dataEntities.DynamicSizeRange;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.runLengthEncoding.RunLengthSegment;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0013\u001a\u00020\u00012\n\u0010\u0014\u001a\u00060\nj\u0002`\u000bH\u0016J4\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0018\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\nj\u0002`\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\bH\u0014J\u0019\u0010\u001e\u001a\u00060\nj\u0002`\u000b2\n\u0010\u001f\u001a\u00060\nj\u0002`\u000bH\u0096\u0002J\u0013\u0010 \u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0!H\u0096\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\u00060\u0005j\u0002`\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncoding/RunLengthSimpleSegment;", "Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncoding/RunLengthSegment;", "buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "offset", "", "Lkd/bos/olapServer2/common/long;", "currentAdapter", "Lkd/bos/olapServer2/dataEntities/DynamicSizeRange;", "count", "", "Lkd/bos/olapServer2/common/int;", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;JLkd/bos/olapServer2/dataEntities/DynamicSizeRange;I)V", "_bytes", "", "_intBytes", "nextSegmentOffset", "getNextSegmentOffset", "()J", "add", "value", "batchGet", "", "start", "end", "result", "", "destPos", "createInstance", "newSizeRange", "get", "index", "iterator", "", "ValueIterator", "bos-olap-core2"})
public final class RunLengthSimpleSegment
extends RunLengthSegment {
    private final int _intBytes;
    @NotNull
    private final byte[] _bytes;

    public RunLengthSimpleSegment(@NotNull IByteBuffer buffer, long offset, @NotNull DynamicSizeRange currentAdapter, int count) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)currentAdapter, (String)"currentAdapter");
        super(buffer, offset, currentAdapter, count);
        this._intBytes = this.get_currentAdapter().getElementByteSize();
        this._bytes = new byte[3];
    }

    @Override
    public int get(int index2) {
        int n;
        if (!(0 <= index2 ? index2 < this.get_count() : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        switch (this._intBytes) {
            case 1: {
                n = CommonTypesKt.toIntNoNegative(this.get_buffer().getByte(this.get_offset() + (long)index2));
                break;
            }
            case 2: {
                n = CommonTypesKt.toIntNoNegative(this.get_buffer().getShort(this.get_offset() + (long)(index2 * 2)));
                break;
            }
            case 3: {
                byte[] bytes2 = this._bytes;
                this.get_buffer().getByteArray(this.get_offset() + (long)(index2 * 3), bytes2, 0, 3);
                n = (bytes2[2] & 0xFF) << 16 | (bytes2[1] & 0xFF) << 8 | bytes2[0] & 0xFF;
                break;
            }
            case 4: {
                n = this.get_buffer().getInt(this.get_offset() + (long)(index2 * 4));
                break;
            }
            default: {
                String string3 = Res.INSTANCE.getCommonException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CommonException_4>(...)");
                throw Res.INSTANCE.getRuntimeException(string3, new Object[0]);
            }
        }
        return n;
    }

    @Override
    @NotNull
    public RunLengthSegment add(int value2) {
        long valuePos = this.get_offset() + (long)(this.get_count() * this._intBytes);
        switch (this._intBytes) {
            case 1: {
                if (!(0 <= value2 ? value2 < 256 : false)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                this.get_buffer().putByte(valuePos, (byte)value2);
                break;
            }
            case 2: {
                if (!(0 <= value2 ? value2 < 65536 : false)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                this.get_buffer().putShort(valuePos, (short)value2);
                break;
            }
            case 3: {
                if (!(0 <= value2 ? value2 < 0x1000000 : false)) {
                    String string4 = "Failed requirement.";
                    throw new IllegalArgumentException(string4.toString());
                }
                byte[] bytes2 = this._bytes;
                bytes2[0] = (byte)value2;
                bytes2[1] = (byte)(value2 >> 8);
                bytes2[2] = (byte)(value2 >> 16);
                this.get_buffer().putByteArray(valuePos, bytes2, 0, 3);
                break;
            }
            case 4: {
                if (!(value2 >= 0)) {
                    String string5 = "Failed requirement.";
                    throw new IllegalArgumentException(string5.toString());
                }
                this.get_buffer().putInt(valuePos, value2);
                break;
            }
            default: {
                String string6 = Res.INSTANCE.getCommonException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"<get-CommonException_4>(...)");
                throw Res.INSTANCE.getRuntimeException(string6, new Object[0]);
            }
        }
        int n = this.get_count();
        this.set_count(n + 1);
        return this;
    }

    @Override
    public long getNextSegmentOffset() {
        return this.get_offset() + (long)(this.get_count() * this._intBytes);
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return (Iterator)((Object)new ValueIterator());
    }

    @Override
    @NotNull
    protected RunLengthSegment createInstance(@NotNull DynamicSizeRange newSizeRange) {
        Intrinsics.checkNotNullParameter((Object)newSizeRange, (String)"newSizeRange");
        return new RunLengthSimpleSegment(this.get_buffer(), this.get_offset(), newSizeRange, 0);
    }

    @Override
    public void batchGet(int start, int end, @NotNull int[] result2, int destPos) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        int elementCount = end - start + 1;
        byte[] bytes2 = new byte[elementCount * 4];
        long position = this.get_offset() + (long)(start * this._intBytes);
        switch (this._intBytes) {
            case 1: {
                this.get_buffer().getByteArray(position, bytes2, 0, elementCount);
                for (int i = 0; i < elementCount; ++i) {
                    result2[i + destPos] = bytes2[i] & 0xFF;
                }
                break;
            }
            case 2: {
                this.get_buffer().getByteArray(position, bytes2, 0, elementCount * 2);
                int byteIndex = 0;
                for (int i = 0; i < elementCount; ++i) {
                    result2[i + destPos] = CommonTypesKt.toIntNoNegative((short)(bytes2[byteIndex] & 0xFF | (bytes2[byteIndex + 1] & 0xFF) << 8));
                    byteIndex += 2;
                }
                break;
            }
            case 3: {
                this.get_buffer().getByteArray(position, bytes2, 0, elementCount * 3);
                int byteIndex = 0;
                for (int i = 0; i < elementCount; ++i) {
                    result2[i + destPos] = bytes2[byteIndex] & 0xFF | (bytes2[byteIndex + 1] & 0xFF) << 8 | (bytes2[byteIndex + 2] & 0xFF) << 16;
                    byteIndex += 3;
                }
                break;
            }
            case 4: {
                this.get_buffer().getByteArray(position, bytes2, 0, elementCount * 4);
                int byteIndex = 0;
                for (int i = 0; i < elementCount; ++i) {
                    result2[i + destPos] = bytes2[byteIndex] & 0xFF | (bytes2[byteIndex + 1] & 0xFF) << 8 | (bytes2[byteIndex + 2] & 0xFF) << 16 | (bytes2[byteIndex + 3] & 0xFF) << 24;
                    byteIndex += 4;
                }
                break;
            }
            default: {
                String string2 = Res.INSTANCE.getCommonException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CommonException_4>(...)");
                throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncoding/RunLengthSimpleSegment$ValueIterator;", "Lkotlin/collections/IntIterator;", "(Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncoding/RunLengthSimpleSegment;)V", "_i", "", "hasNext", "", "nextInt", "bos-olap-core2"})
    private final class ValueIterator
    extends IntIterator {
        private int _i;

        public int nextInt() {
            int n = this._i;
            this._i = n + 1;
            return RunLengthSimpleSegment.this.get(n);
        }

        public boolean hasNext() {
            int n = RunLengthSimpleSegment.this.get_count();
            int n2 = this._i;
            return 0 <= n2 ? n2 < n : false;
        }
    }
}

