/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.memoryMappedFiles.runLengthEncodingV3;

import java.io.Flushable;
import kd.bos.olapServer2.collections.IMutableListLong;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IImmutableSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableUnFixedSegmentContainer;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncodingV3/MutableRunLengthListInt;", "Ljava/io/Flushable;", "segmentIndexes", "Lkd/bos/olapServer2/collections/IMutableListLong;", "containers", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableUnFixedSegmentContainer;", "(Lkd/bos/olapServer2/collections/IMutableListLong;Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableUnFixedSegmentContainer;)V", "add", "", "values", "", "flush", "Companion", "CompressType", "MinSegmentCompressor", "bos-olap-core2"})
public final class MutableRunLengthListInt
implements Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IMutableListLong segmentIndexes;
    @NotNull
    private final IMutableUnFixedSegmentContainer containers;
    public static final int SegmentValueSize = 65536;

    public MutableRunLengthListInt(@NotNull IMutableListLong segmentIndexes, @NotNull IMutableUnFixedSegmentContainer containers) {
        Intrinsics.checkNotNullParameter((Object)segmentIndexes, (String)"segmentIndexes");
        Intrinsics.checkNotNullParameter((Object)containers, (String)"containers");
        this.segmentIndexes = segmentIndexes;
        this.containers = containers;
    }

    public final void add(@NotNull int[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (!(65536 == values.length)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        MinSegmentCompressor compressor = new MinSegmentCompressor(values);
        compressor.statistics();
        long segmentIndex = 0L;
        if (compressor.getByteSize() == 0L) {
            segmentIndex = 0xFFFF00000000L | (long)compressor.getStartValue();
        } else {
            segmentIndex = this.containers.allot(compressor.getByteSize());
            IByteBuffer buffer = ((IImmutableSegmentContainer)this.containers.getImmutableObject()).getBuffer(segmentIndex);
            compressor.fill(buffer);
        }
        this.segmentIndexes.add(segmentIndex);
    }

    @Override
    public void flush() {
        block0: {
            IMutableListLong iMutableListLong = this.segmentIndexes;
            Flushable flushable = iMutableListLong instanceof Flushable ? (Flushable)((Object)iMutableListLong) : null;
            if (flushable == null) break block0;
            flushable.flush();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncodingV3/MutableRunLengthListInt$Companion;", "", "()V", "SegmentValueSize", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncodingV3/MutableRunLengthListInt$CompressType;", "", "(Ljava/lang/String;I)V", "RK", "DK", "bos-olap-core2"})
    public static final class CompressType
    extends Enum<CompressType> {
        public static final /* enum */ CompressType RK = new CompressType();
        public static final /* enum */ CompressType DK = new CompressType();
        private static final /* synthetic */ CompressType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CompressType[] values() {
            return (CompressType[])$VALUES.clone();
        }

        public static CompressType valueOf(String value2) {
            return Enum.valueOf(CompressType.class, value2);
        }

        @NotNull
        public static EnumEntries<CompressType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = compressTypeArray = new CompressType[]{CompressType.RK, CompressType.DK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0014\u001a\u00060\bj\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncodingV3/MutableRunLengthListInt$MinSegmentCompressor;", "", "values", "", "([I)V", "_byteSize", "", "_startValue", "", "Lkd/bos/olapServer2/common/int;", "byteArray", "", "getByteArray", "()[B", "byteSize", "getByteSize", "()J", "compressType", "Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncodingV3/MutableRunLengthListInt$CompressType;", "elementByteSize", "startValue", "getStartValue", "()I", "compressByDK", "", "buffer", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "compressByRK", "fill", "statistics", "Companion", "bos-olap-core2"})
    private static final class MinSegmentCompressor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final int[] values;
        private int elementByteSize;
        private int _startValue;
        private long _byteSize;
        @NotNull
        private CompressType compressType;
        @NotNull
        private final byte[] byteArray;

        public MinSegmentCompressor(@NotNull int[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            this.values = values;
            this.elementByteSize = -1;
            this._byteSize = -1L;
            this.compressType = CompressType.DK;
            this.byteArray = new byte[3];
        }

        public final long getByteSize() {
            return this._byteSize;
        }

        public final int getStartValue() {
            return this._startValue;
        }

        public final void statistics() {
            Pair pair = MinSegmentCompressor.Companion.maxAndMinValue(this.values);
            int minValue = ((Number)pair.component1()).intValue();
            int maxValue = ((Number)pair.component2()).intValue();
            if (maxValue == minValue) {
                this.compressType = CompressType.RK;
                this._byteSize = 0L;
                this._startValue = minValue;
                return;
            }
            int dkEleByteSize = MinSegmentCompressor.Companion.calcByteSize(maxValue - minValue);
            int eleByteSize = MinSegmentCompressor.Companion.calcByteSize(maxValue);
            int rkMaxArraySize = 65536 * dkEleByteSize / (2 + eleByteSize);
            int rkArraySize = 0;
            int lastValue = -1;
            for (int v : this.values) {
                if (v == lastValue) continue;
                if (++rkArraySize >= rkMaxArraySize) {
                    rkArraySize = -1;
                    break;
                }
                lastValue = v;
            }
            if (rkArraySize >= 0) {
                this._byteSize = (long)rkArraySize * ((long)eleByteSize + 2L) + 1L;
                this.compressType = CompressType.RK;
                this.elementByteSize = eleByteSize;
            } else {
                if (dkEleByteSize == eleByteSize) {
                    this._startValue = 0;
                    this._byteSize = (long)(65536 * dkEleByteSize) + 1L;
                } else {
                    this._startValue = minValue;
                    this._byteSize = (long)(65536 * dkEleByteSize) + 5L;
                }
                this.compressType = CompressType.DK;
                this.elementByteSize = dkEleByteSize;
            }
        }

        public final void fill(@NotNull IByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            switch (WhenMappings.$EnumSwitchMapping$0[this.compressType.ordinal()]) {
                case 1: {
                    this.compressByRK(buffer);
                    break;
                }
                case 2: {
                    this.compressByDK(buffer);
                }
            }
        }

        @NotNull
        public final byte[] getByteArray() {
            return this.byteArray;
        }

        private final void compressByDK(IByteBuffer buffer) {
            long l;
            if (this.getStartValue() == 0) {
                buffer.putByte(0L, (byte)(this.elementByteSize + 4));
                l = 1L;
            } else {
                buffer.putByte(0L, (byte)(this.elementByteSize + 12));
                buffer.putInt(1L, this.getStartValue());
                l = 5L;
            }
            long position = l;
            switch (this.elementByteSize) {
                case 1: {
                    for (int v : this.values) {
                        buffer.putByte(position, (byte)(v - this.getStartValue()));
                        long l2 = position;
                        position = l2 + 1L;
                    }
                    break;
                }
                case 2: {
                    for (int v : this.values) {
                        buffer.putShort(position, (short)(v - this.getStartValue()));
                        position += (long)2;
                    }
                    break;
                }
                case 3: {
                    for (int v : this.values) {
                        MinSegmentCompressor.Companion.intToByteArray3(this.byteArray, v - this.getStartValue());
                        buffer.putByteArray(position, this.byteArray);
                        position += (long)3;
                    }
                    break;
                }
                case 4: {
                    for (int v : this.values) {
                        buffer.putInt(position, v - this.getStartValue());
                        position += (long)4;
                    }
                    break;
                }
                default: {
                    String string2 = Res.INSTANCE.getCommonException_4();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CommonException_4>(...)");
                    throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
                }
            }
        }

        private final void compressByRK(IByteBuffer buffer) {
            buffer.putByte(0L, (byte)(this.elementByteSize + 8));
            int lastValue = -1;
            long position = 1L;
            int n = this.values.length;
            for (int i = 0; i < n; ++i) {
                if (lastValue == this.values[i]) continue;
                buffer.putShort(position, (short)i);
                lastValue = this.values[i];
                position += (long)2;
            }
            lastValue = -1;
            switch (this.elementByteSize) {
                case 1: {
                    for (int v : this.values) {
                        if (lastValue == v) continue;
                        buffer.putByte(position, (byte)v);
                        lastValue = v;
                        long l = position;
                        position = l + 1L;
                    }
                    break;
                }
                case 2: {
                    for (int v : this.values) {
                        if (lastValue == v) continue;
                        buffer.putShort(position, (short)v);
                        lastValue = v;
                        position += (long)2;
                    }
                    break;
                }
                case 3: {
                    for (int v : this.values) {
                        if (lastValue == v) continue;
                        MinSegmentCompressor.Companion.intToByteArray3(this.byteArray, v);
                        buffer.putByteArray(position, this.byteArray);
                        lastValue = v;
                        position += (long)3;
                    }
                    break;
                }
                case 4: {
                    for (int v : this.values) {
                        if (lastValue == v) continue;
                        buffer.putInt(position, v);
                        lastValue = v;
                        position += (long)4;
                    }
                    break;
                }
                default: {
                    String string2 = Res.INSTANCE.getCommonException_4();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CommonException_4>(...)");
                    throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005H\u0002J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005H\u0002J \u0010\u000b\u001a\u0016\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\b\u0012\u00060\u0004j\u0002`\u00050\f*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer2/memoryMappedFiles/runLengthEncodingV3/MutableRunLengthListInt$MinSegmentCompressor$Companion;", "", "()V", "calcByteSize", "", "Lkd/bos/olapServer2/common/int;", "value", "intToByteArray3", "", "bytes", "", "maxAndMinValue", "Lkotlin/Pair;", "", "bos-olap-core2"})
        public static final class Companion {
            private Companion() {
            }

            private final void intToByteArray3(byte[] bytes2, int value2) {
                bytes2[0] = (byte)value2;
                bytes2[1] = (byte)(value2 >> 8);
                bytes2[2] = (byte)(value2 >> 16);
            }

            private final Pair<Integer, Integer> maxAndMinValue(int[] $this$maxAndMinValue) {
                int min = Integer.MAX_VALUE;
                int max = Integer.MIN_VALUE;
                for (int i : $this$maxAndMinValue) {
                    if (i > max) {
                        max = i;
                    }
                    if (i >= min) continue;
                    min = i;
                }
                return new Pair((Object)min, (Object)max);
            }

            private final int calcByteSize(int value2) {
                int n;
                int n2 = value2;
                boolean bl = 0 <= n2 ? n2 < 256 : false;
                if (bl) {
                    n = 1;
                } else {
                    boolean bl2 = 256 <= n2 ? n2 < 65536 : false;
                    if (bl2) {
                        n = 2;
                    } else {
                        boolean bl3 = 65536 <= n2 ? n2 < 0x1000000 : false;
                        if (bl3) {
                            n = 3;
                        } else {
                            boolean bl4 = 0x1000000 <= n2 ? n2 <= Integer.MAX_VALUE : false;
                            if (bl4) {
                                n = 4;
                            } else {
                                String string2 = Res.INSTANCE.getCommonException_5();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CommonException_5>(...)");
                                throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
                            }
                        }
                    }
                }
                return n;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CompressType.values().length];
                try {
                    nArray[CompressType.RK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CompressType.DK.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

