/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.olapServer2.common.CellSet;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.common.PropertyBag;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.metadata.DeleteAllDataCubeWorkspaceRebuilder;
import kd.bos.olapServer2.metadata.DeleteDynamicDataCubeWorkspaceRebuilder;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer2.metadata.builds.OlapMetadataBuilder;
import kd.bos.olapServer2.metadata.builds.PropertyValueBuilder;
import kd.bos.olapServer2.metadata.builds.PropertyValueBuilderCollection;
import kd.bos.olapServer2.server.OlapServerContext;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.DSCacheCleaner;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.DSCacheDerivation;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.DSCacheRebuilder;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.tools.StringValidator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000  2\u00020\u0001:\u0002 !B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\u0014\u0010\u000e\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u00060\u0016j\u0002`\u00182\u000e\u0010\u0019\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rH\u0002J\u0014\u0010\u001a\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkd/bos/olapServer2/metadata/CubeMetadataCommand;", "", "metadataCmdInfo", "Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "(Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/storages/CubeWorkspace;)V", "alterCube", "", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "dropCube", "execute", "Lkd/bos/olapServer2/common/CellSet;", "getEnableDSAction", "Lkd/bos/olapServer2/metadata/CubeMetadataCommand$EnableDSAction;", "propertyBag", "Lkd/bos/olapServer2/common/PropertyBag;", "oldEnabledDS", "", "parseEnabledDS", "Lkd/bos/olapServer2/common/bool;", "value", "repairCube", "tryAllRebuild", "olapContext", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "cubeContext", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "Companion", "EnableDSAction", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nCubeMetadataCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubeMetadataCommand.kt\nkd/bos/olapServer2/metadata/CubeMetadataCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1#2:185\n1855#3,2:186\n*S KotlinDebug\n*F\n+ 1 CubeMetadataCommand.kt\nkd/bos/olapServer2/metadata/CubeMetadataCommand\n*L\n54#1:186,2\n*E\n"})
public final class CubeMetadataCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetadataCommandInfo metadataCmdInfo;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    public static final String ENABLED_DS_KEY = "enabledDS";
    @NotNull
    public static final String OPTIMIZE_CUBE_METADATA = "OptimizeCubeMetadata";

    public CubeMetadataCommand(@NotNull MetadataCommandInfo metadataCmdInfo, @NotNull OlapWorkspace olapWorkspace, @NotNull CubeWorkspace cubeWorkspace) {
        Intrinsics.checkNotNullParameter((Object)metadataCmdInfo, (String)"metadataCmdInfo");
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        this.metadataCmdInfo = metadataCmdInfo;
        this.olapWorkspace = olapWorkspace;
        this.cubeWorkspace = cubeWorkspace;
    }

    @Nullable
    public final CellSet execute() {
        if (!(this.metadataCmdInfo.getMetadataType() == MetadataTypes.Cube)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        StringValidator.INSTANCE.validate(this.metadataCmdInfo.getName());
        String cubeName = this.cubeWorkspace.getMetadata().getName();
        if (!Intrinsics.areEqual((Object)cubeName, (Object)this.metadataCmdInfo.getName())) {
            boolean bl = false;
            String string3 = "cubeName in initialcatalog is different from cubeName in commandInfo";
            throw new IllegalArgumentException(string3.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.metadataCmdInfo.getAction().ordinal()]) {
            case 1: {
                this.alterCube(cubeName);
                break;
            }
            case 2: {
                this.dropCube(cubeName);
                break;
            }
            case 3: {
                this.repairCube(cubeName);
                break;
            }
            default: {
                String string4 = Res.INSTANCE.getCommonException_7();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-CommonException_7>(...)");
                Object[] objectArray = new Object[]{this.metadataCmdInfo.getAction()};
                throw Res.INSTANCE.getRuntimeException(string4, objectArray);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void alterCube(String cubeName) {
        boolean oldEnabledDS = CommonTypesKt.getDynamicCalcAndStored() & this.parseEnabledDS(this.cubeWorkspace.getMetadata().getProperties().get(ENABLED_DS_KEY));
        EnableDSAction enableDSAction = this.getEnableDSAction(this.metadataCmdInfo.getProperties(), oldEnabledDS);
        if (enableDSAction == EnableDSAction.CleanAll) {
            new DSCacheCleaner(this.cubeWorkspace).cleanAll();
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Closeable closeable = this.cubeWorkspace.getMetadataStorage().createWriterContext();
        Throwable throwable = null;
        try {
            IMetadataWriterContext ctx = (IMetadataWriterContext)closeable;
            boolean bl = false;
            PropertyValueBuilderCollection properties2 = ctx.getCubeBuilder().getProperties();
            for (Map.Entry entry : ((Map)this.metadataCmdInfo.getProperties()).entrySet()) {
                String key2 = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                properties2.set(key2, value2);
            }
            ctx.save();
            Iterable $this$forEach$iv = properties2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PropertyValueBuilder it = (PropertyValueBuilder)element$iv;
                boolean bl2 = false;
                ((Map)propertyMap).put(it.getName(), it.getValue());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.olapWorkspace.getLockManager().enterWrite((Function0)new Function0<Unit>(this, cubeName, propertyMap){
            final /* synthetic */ CubeMetadataCommand this$0;
            final /* synthetic */ String $cubeName;
            final /* synthetic */ HashMap<String, String> $propertyMap;
            {
                this.this$0 = $receiver;
                this.$cubeName = $cubeName;
                this.$propertyMap = $propertyMap;
                super(0);
            }

            public final void invoke() {
                OlapMetadataBuilder builder = OlapMetadataBuilder.Companion.readFrom(CubeMetadataCommand.access$getOlapWorkspace$p(this.this$0).getRootPath());
                builder.updateProperties(this.$cubeName, this.$propertyMap);
                builder.save();
            }
        });
        CubeWorkspace.onMetadataUpdated$default(this.cubeWorkspace, false, 1, null);
        this.olapWorkspace.reloadOlapMetadata();
        if (enableDSAction == EnableDSAction.TryAllRebuild) {
            this.tryAllRebuild(this.olapWorkspace.getPluginContext$bos_olap_core2(), this.cubeWorkspace.getPluginContext());
        }
    }

    private final EnableDSAction getEnableDSAction(PropertyBag propertyBag, boolean oldEnabledDS) {
        boolean requireCacheRebuild;
        EnableDSAction enableDSAction = EnableDSAction.None;
        OlapServerContext olapServerContext = OlapContext.Companion.tryGetContext(OlapServerContext.class);
        boolean bl = requireCacheRebuild = olapServerContext != null ? olapServerContext.getRequireCacheRebuild() : false;
        if (requireCacheRebuild) {
            boolean newEnableDs = CommonTypesKt.getDynamicCalcAndStored() & this.parseEnabledDS((String)propertyBag.get((Object)ENABLED_DS_KEY));
            if (oldEnabledDS) {
                if (!newEnableDs) {
                    enableDSAction = EnableDSAction.CleanAll;
                }
            } else if (newEnableDs) {
                enableDSAction = EnableDSAction.TryAllRebuild;
            }
        }
        return enableDSAction;
    }

    private final void tryAllRebuild(OlapWorkspacePluginContext olapContext, CubeWorkspacePluginContext cubeContext) {
        DSCacheDerivation dsCacheDerivation;
        new DSCacheCleaner(this.cubeWorkspace).cleanAll();
        if (this.cubeWorkspace.getRowCount() > 0L && (dsCacheDerivation = cubeContext.getCubeWorkspace$bos_olap_core2().getMetadata().getDsCacheDerivation()).getHasDS()) {
            new DSCacheRebuilder(olapContext, cubeContext, cubeContext.getCubeWorkspace$bos_olap_core2().getMetadata().getBasePartitionItems(), dsCacheDerivation.getUnit()).rebuild();
        }
    }

    private final boolean parseEnabledDS(String value2) {
        CharSequence charSequence = value2;
        return charSequence == null || charSequence.length() == 0 ? false : Boolean.parseBoolean(value2);
    }

    private final void dropCube(String cubeName) {
        String realCubeName = this.cubeWorkspace.getMetadata().getName();
        if (!StringsKt.equals((String)cubeName, (String)realCubeName, (boolean)true)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.metadataCmdInfo.getPreventDropCubeWhenRowExists() && this.cubeWorkspace.getRowCount() > 0L) {
            String string3 = Res.INSTANCE.getCubeMetadataCommandException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CubeMetadataCommandException_1>(...)");
            Object[] objectArray = new Object[]{realCubeName};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        this.olapWorkspace.getLockManager().enterWrite((Function0)new Function0<Unit>(this, realCubeName){
            final /* synthetic */ CubeMetadataCommand this$0;
            final /* synthetic */ String $realCubeName;
            {
                this.this$0 = $receiver;
                this.$realCubeName = $realCubeName;
                super(0);
            }

            public final void invoke() {
                OlapMetadataBuilder builder = OlapMetadataBuilder.Companion.readFrom(CubeMetadataCommand.access$getOlapWorkspace$p(this.this$0).getRootPath());
                builder.remove(this.$realCubeName);
                builder.save();
                CubeMetadataCommand.access$getOlapWorkspace$p(this.this$0).updateMetadata(CommandTypes.drop, this.$realCubeName);
            }
        });
        String[] stringArray = new String[]{realCubeName};
        FileTools.INSTANCE.deleteDir(PathsKt.fileSafeConstructor(((Object)Paths.INSTANCE.get(this.olapWorkspace.getRootPath(), stringArray)).toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repairCube(String cubeName) {
        String optimizeCube = (String)this.metadataCmdInfo.getProperties().get((Object)OPTIMIZE_CUBE_METADATA);
        if (Intrinsics.areEqual((Object)optimizeCube, (Object)"true")) {
            this.cubeWorkspace.getMetadataStorage().optimize();
            CubeWorkspace.onMetadataUpdated$default(this.cubeWorkspace, false, 1, null);
            return;
        }
        if (this.cubeWorkspace.getRowCount() == 0L) {
            return;
        }
        String realCubeName = this.cubeWorkspace.getMetadata().getName();
        if (!StringsKt.equals((String)cubeName, (String)realCubeName, (boolean)true)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String clearAll = (String)this.metadataCmdInfo.getProperties().get((Object)"ClearAll");
        if (Intrinsics.areEqual((Object)clearAll, (Object)"true")) {
            Closeable closeable = new DeleteAllDataCubeWorkspaceRebuilder(this.olapWorkspace, this.cubeWorkspace);
            Throwable throwable = null;
            try {
                DeleteAllDataCubeWorkspaceRebuilder reBuilder = (DeleteAllDataCubeWorkspaceRebuilder)closeable;
                boolean bl = false;
                reBuilder.rebuild();
                reBuilder = Unit.INSTANCE;
            }
            catch (Throwable reBuilder) {
                throwable = reBuilder;
                throw reBuilder;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        Closeable closeable = new DeleteDynamicDataCubeWorkspaceRebuilder(this.olapWorkspace, this.cubeWorkspace, this.metadataCmdInfo.getProperties());
        Throwable throwable = null;
        try {
            DeleteDynamicDataCubeWorkspaceRebuilder reBuilder = (DeleteDynamicDataCubeWorkspaceRebuilder)closeable;
            boolean bl = false;
            reBuilder.rebuild();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ OlapWorkspace access$getOlapWorkspace$p(CubeMetadataCommand $this) {
        return $this.olapWorkspace;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer2/metadata/CubeMetadataCommand$Companion;", "", "()V", "ENABLED_DS_KEY", "", "OPTIMIZE_CUBE_METADATA", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer2/metadata/CubeMetadataCommand$EnableDSAction;", "", "(Ljava/lang/String;I)V", "None", "CleanAll", "TryAllRebuild", "bos-olap-core2"})
    private static final class EnableDSAction
    extends Enum<EnableDSAction> {
        public static final /* enum */ EnableDSAction None = new EnableDSAction();
        public static final /* enum */ EnableDSAction CleanAll = new EnableDSAction();
        public static final /* enum */ EnableDSAction TryAllRebuild = new EnableDSAction();
        private static final /* synthetic */ EnableDSAction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EnableDSAction[] values() {
            return (EnableDSAction[])$VALUES.clone();
        }

        public static EnableDSAction valueOf(String value2) {
            return Enum.valueOf(EnableDSAction.class, value2);
        }

        @NotNull
        public static EnumEntries<EnableDSAction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = enableDSActionArray = new EnableDSAction[]{EnableDSAction.None, EnableDSAction.CleanAll, EnableDSAction.TryAllRebuild};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandTypes.values().length];
            try {
                nArray[CommandTypes.alter.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandTypes.drop.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandTypes.repair.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

