/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.common.CellSet;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.dataSources.MetadataItem;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.CubeDataScope;
import kd.bos.olapServer2.metadata.CubeDataScopeCollection;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DropDimensionCubeWorkspaceRebuilder;
import kd.bos.olapServer2.metadata.IAliasedItem;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.metadata.PiecewisePair;
import kd.bos.olapServer2.metadata.builds.AggShieldRuleBlackListBuilder;
import kd.bos.olapServer2.metadata.builds.AggShieldRuleBuilder;
import kd.bos.olapServer2.metadata.builds.AggShieldRuleBuilderCollection;
import kd.bos.olapServer2.metadata.builds.AggShieldRuleDataPartitionBuilder;
import kd.bos.olapServer2.metadata.builds.CubeBuilder;
import kd.bos.olapServer2.metadata.builds.DimensionBuilder;
import kd.bos.olapServer2.metadata.builds.DimensionPartitionBuilder;
import kd.bos.olapServer2.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer2.metadata.builds.MemberBuilder;
import kd.bos.olapServer2.metadata.builds.PartitionBuilder;
import kd.bos.olapServer2.metadata.events.AlterDimensionEvent;
import kd.bos.olapServer2.metadata.events.CreateDimensionEvent;
import kd.bos.olapServer2.metadata.events.DropDimensionEvent;
import kd.bos.olapServer2.metadata.expressions.ExpressionUnit;
import kd.bos.olapServer2.metadata.expressions.PiecewiseExpressionUnit;
import kd.bos.olapServer2.metadata.partitions.SimpleLevelPartitionMetadata;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.tools.StringValidator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\n2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\n2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J \u0010\u0017\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer2/metadata/DimensionMetadataCommand;", "", "metadataCmdInfo", "Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "(Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/storages/CubeWorkspace;)V", "alterDimension", "", "checkPiecewiseExpression", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "dimension", "Lkd/bos/olapServer2/metadata/Dimension;", "createDimension", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "dropDimension", "execute", "Lkd/bos/olapServer2/common/CellSet;", "getContainDimensionScopeName", "cubeDataScopes", "Lkd/bos/olapServer2/metadata/CubeDataScopeCollection;", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nDimensionMetadataCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DimensionMetadataCommand.kt\nkd/bos/olapServer2/metadata/DimensionMetadataCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,357:1\n1855#2,2:358\n1855#2,2:365\n766#2:367\n857#2,2:368\n1855#2:370\n1855#2:371\n1747#2,3:372\n1856#2:375\n1856#2:376\n3792#3:360\n4307#3,2:361\n37#4,2:363\n*S KotlinDebug\n*F\n+ 1 DimensionMetadataCommand.kt\nkd/bos/olapServer2/metadata/DimensionMetadataCommand\n*L\n123#1:358,2\n267#1:365,2\n296#1:367\n296#1:368,2\n296#1:370\n299#1:371\n305#1:372,3\n299#1:375\n296#1:376\n242#1:360\n242#1:361,2\n242#1:363,2\n*E\n"})
public final class DimensionMetadataCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetadataCommandInfo metadataCmdInfo;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final CubeWorkspace cubeWorkspace;

    public DimensionMetadataCommand(@NotNull MetadataCommandInfo metadataCmdInfo, @NotNull OlapWorkspace olapWorkspace, @NotNull CubeWorkspace cubeWorkspace) {
        Intrinsics.checkNotNullParameter((Object)metadataCmdInfo, (String)"metadataCmdInfo");
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        this.metadataCmdInfo = metadataCmdInfo;
        this.olapWorkspace = olapWorkspace;
        this.cubeWorkspace = cubeWorkspace;
    }

    @Nullable
    public final CellSet execute() {
        if (!(this.metadataCmdInfo.getMetadataType() == MetadataTypes.Dimension)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String cubeName = StringValidator.INSTANCE.validateOwnerUniqueName(this.cubeWorkspace.getMetadata(), this.metadataCmdInfo.getOwnerUniqueName(), MetadataTypes.Dimension).get(0);
        switch (WhenMappings.$EnumSwitchMapping$0[this.metadataCmdInfo.getAction().ordinal()]) {
            case 1: {
                this.createDimension(cubeName);
                break;
            }
            case 2: {
                this.alterDimension();
                break;
            }
            case 3: {
                this.dropDimension(cubeName);
                break;
            }
            default: {
                String string3 = Res.INSTANCE.getCommonException_7();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CommonException_7>(...)");
                Object[] objectArray = new Object[]{this.metadataCmdInfo.getAction()};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createDimension(String cubeName) {
        block14: {
            String dimName = this.metadataCmdInfo.getName();
            StringValidator.INSTANCE.validate(dimName);
            List<File> deleteDirs = null;
            CubeWorkspace workspace = this.cubeWorkspace;
            Closeable closeable = workspace.getMetadataStorage().createWriterContext();
            Throwable throwable = null;
            try {
                IMetadataWriterContext writerContext = (IMetadataWriterContext)closeable;
                boolean bl = false;
                CubeBuilder cubeBuilder = writerContext.getCubeBuilder();
                Collection<String> aliases = Companion.buildAliasesName(cubeBuilder, dimName, this.metadataCmdInfo.getAlias());
                DimensionBuilder dimBuilder = (DimensionBuilder)cubeBuilder.getDimensions().add(dimName);
                cubeBuilder.getDimensions().resetPosition(cubeBuilder.getPartition());
                dimBuilder.setAliases(aliases);
                long currentRowCount = this.cubeWorkspace.getRowCount();
                String defaultMemberName = this.metadataCmdInfo.getDefaultMemberName();
                if (((CharSequence)defaultMemberName).length() > 0) {
                    StringValidator.INSTANCE.validateMember(defaultMemberName);
                    MemberBuilder defMember = (MemberBuilder)dimBuilder.getMembers().add(defaultMemberName);
                    if (currentRowCount > 0L) {
                        defMember.setFixedNumber(0);
                    }
                } else if (currentRowCount > 0L && !this.metadataCmdInfo.getAllowNull()) {
                    throw new RuntimeException("Create dimension(" + dimName + " at " + cubeName + ") error, should set AllowNull = true if not set DefaultMemberName.");
                }
                dimBuilder.setAllowNull(this.metadataCmdInfo.getAllowNull());
                dimBuilder.setDefaultMemberName(defaultMemberName);
                dimBuilder.setContinuousData(this.metadataCmdInfo.getDimensionContinuousData());
                String tags = this.metadataCmdInfo.getTagDefinitions();
                CharSequence charSequence = tags;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    dimBuilder.setTagDefinitions(tags);
                }
                dimBuilder.setAutoCreateSimpleMember(this.metadataCmdInfo.getAutoCreateSimpleMember());
                dimBuilder.setSimpleMemberCaseSensitive(this.metadataCmdInfo.getSimpleMemberCaseSensitive());
                dimBuilder.repair();
                String indexFormat = "";
                if (!((Collection)cubeBuilder.getDimensions()).isEmpty()) {
                    DimensionBuilder firstDimension = (DimensionBuilder)cubeBuilder.getDimensions().get(0);
                    indexFormat = firstDimension.getIndexFormat();
                }
                dimBuilder.setIndexFormat(indexFormat);
                dimBuilder.repairProperties$bos_olap_core2();
                CreateDimensionEvent event = new CreateDimensionEvent(cubeBuilder, dimBuilder, writerContext.getExtendCubeBuilder().getExtendDimension(dimBuilder), this.metadataCmdInfo.getProperties(), currentRowCount, null, 32, null);
                workspace.getMetadataStorage().invokeEvent(event);
                deleteDirs = event.getDeleteDirs();
                if (this.metadataCmdInfo.getSupportSimpleMember()) {
                    event.getExtendDimensionBuilder().enableExtendMembers();
                }
                writerContext.save();
                writerContext = Unit.INSTANCE;
            }
            catch (Throwable writerContext) {
                throwable = writerContext;
                throw writerContext;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            CubeWorkspace.onMetadataUpdated$default(workspace, false, 1, null);
            List<File> list2 = deleteDirs;
            if (list2 == null) break block14;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (FilesKt.deleteRecursively((File)it)) continue;
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void alterDimension() {
        Closeable closeable = this.cubeWorkspace.getMetadataStorage().createWriterContext();
        Throwable throwable = null;
        try {
            IMetadataWriterContext writerContext = (IMetadataWriterContext)closeable;
            boolean bl = false;
            CubeBuilder builder = writerContext.getCubeBuilder();
            List events = new ArrayList();
            if (this.metadataCmdInfo.getItems().isEmpty()) {
                DimensionBuilder dimBuilder = (DimensionBuilder)builder.getDimensions().get(this.metadataCmdInfo.getName());
                AlterDimensionEvent event = new AlterDimensionEvent(this.olapWorkspace, this.cubeWorkspace, builder, dimBuilder, this.metadataCmdInfo.getProperties(), writerContext.getExtendCubeBuilder().getExtendDimension(dimBuilder));
                events.add(event);
                this.cubeWorkspace.getMetadataStorage().invokeEvent(event);
            } else {
                for (MetadataItem item : this.metadataCmdInfo.getItems()) {
                    DimensionBuilder dimBuilder = (DimensionBuilder)builder.getDimensions().get(item.getName());
                    AlterDimensionEvent event = new AlterDimensionEvent(this.olapWorkspace, this.cubeWorkspace, builder, dimBuilder, item.getProperties(), writerContext.getExtendCubeBuilder().getExtendDimension(dimBuilder));
                    events.add(event);
                    this.cubeWorkspace.getMetadataStorage().invokeEvent(event);
                }
            }
            for (AlterDimensionEvent event : events) {
                if (!event.getNeedSupportSimpleMember()) continue;
                event.getAlterExtendDimensionBuilder().enableExtendMembers();
            }
            writerContext.save();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        CubeWorkspace.onMetadataUpdated$default(this.cubeWorkspace, false, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void dropDimension(String cubeName) {
        block25: {
            Throwable throwable;
            Closeable closeable;
            Object[] partitionDimensions;
            String dimensionName = this.metadataCmdInfo.getName();
            Cube cube = this.cubeWorkspace.getMetadata();
            if (!cube.getDimensions().contains(dimensionName)) {
                String string2 = Res.INSTANCE.getDimensionMetadataCommandException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-DimensionMetadataCommandException_2>(...)");
                Object[] objectArray = new Object[]{dimensionName, cubeName};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            Dimension dimension = (Dimension)cube.getDimensions().get(dimensionName);
            if (cube.getPartition() instanceof SimpleLevelPartitionMetadata && ArraysKt.contains((Object[])cube.getPartitionItems().getAssociatedDimension(), (Object)dimension)) {
                String string3 = Res.INSTANCE.getDimensionMetadataCommandException_7();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-DimensionMetadataCommandException_7>(...)");
                Object[] objectArray = new Object[]{dimension.getName()};
                throw Res.INSTANCE.getNotSupportedException(string3, objectArray);
            }
            boolean isPartitionDimension = false;
            int partitionDimensionCount = 0;
            if (cube.getEnabledPartition()) {
                partitionDimensions = cube.getPartitionItems().getAssociatedDimension();
                partitionDimensionCount = partitionDimensions.length;
                isPartitionDimension = ArraysKt.contains((Object[])partitionDimensions, (Object)dimension);
            } else {
                partitionDimensionCount = 0;
                isPartitionDimension = false;
            }
            if (!isPartitionDimension && cube.getDimensions().getCount() - partitionDimensionCount == 1) {
                String string4 = Res.INSTANCE.getDimensionMetadataCommandException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-DimensionMetadataCommandException_3>(...)");
                partitionDimensions = new Object[]{dimension.getName(), cubeName};
                throw Res.INSTANCE.getRuntimeException(string4, partitionDimensions);
            }
            if (cube.getValidFilterCollection().contains(dimension)) {
                String string5 = Res.INSTANCE.getDimensionMetadataCommandException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-DimensionMetadataCommandException_4>(...)");
                partitionDimensions = new Object[]{dimensionName, cubeName};
                throw Res.INSTANCE.getRuntimeException(string5, partitionDimensions);
            }
            if (cube.getCubeDataLockScopes().contains(dimension)) {
                String string6 = Res.INSTANCE.getDimensionMetadataCommandException_8();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"<get-DimensionMetadataCommandException_8>(...)");
                partitionDimensions = new Object[]{dimensionName, cubeName};
                throw Res.INSTANCE.getRuntimeException(string6, partitionDimensions);
            }
            this.checkPiecewiseExpression(cube, dimension);
            DropDimensionEvent event = new DropDimensionEvent(this.olapWorkspace, this.cubeWorkspace, dimension, this.cubeWorkspace.getRowCount() == 0L, isPartitionDimension, false, false, 96, null);
            this.cubeWorkspace.getMetadataStorage().invokeEvent(event);
            if (!event.isRebuild()) {
                closeable = this.cubeWorkspace.getMetadataStorage().createWriterContext();
                throwable = null;
                try {
                    IMetadataWriterContext writerContext = (IMetadataWriterContext)closeable;
                    boolean bl = false;
                    CubeBuilder cubeBuilder = writerContext.getCubeBuilder();
                    ((DimensionBuilder)cubeBuilder.getDimensions().get(dimensionName)).getMembers().size();
                    cubeBuilder.getDimensions().remove(dimensionName);
                    if (event.isPartitionDimension()) {
                        void $this$toTypedArray$iv;
                        void $this$filterTo$iv$iv;
                        PartitionBuilder partitionBuilder = cubeBuilder.getPartition();
                        DimensionPartitionBuilder dimensionPartitionBuilder = partitionBuilder instanceof DimensionPartitionBuilder ? (DimensionPartitionBuilder)partitionBuilder : null;
                        if (dimensionPartitionBuilder == null) {
                            throw new NotSupportedException();
                        }
                        DimensionPartitionBuilder partitionBuilder2 = dimensionPartitionBuilder;
                        Object $this$filter$iv = partitionBuilder2.getDimensions();
                        boolean $i$f$filter = false;
                        String[] stringArray = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        int n = ((void)$this$filterTo$iv$iv).length;
                        for (int i = 0; i < n; ++i) {
                            void element$iv$iv;
                            void it = element$iv$iv = $this$filterTo$iv$iv[i];
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual((Object)it, (Object)dimensionName))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        String[] newPartitionDimensions = thisCollection$iv.toArray(new String[0]);
                        if (newPartitionDimensions.length == 0) {
                            cubeBuilder.setPartition(null);
                        } else {
                            partitionBuilder2.setDimensions(newPartitionDimensions);
                        }
                    }
                    cubeBuilder.getDimensions().resetPosition(cubeBuilder.getPartition());
                    Companion.removeDimensionInAggShieldBuilder(cubeBuilder.getAggShieldRules(), dimensionName);
                    writerContext.save();
                    writerContext = Unit.INSTANCE;
                }
                catch (Throwable writerContext) {
                    throwable = writerContext;
                    throw writerContext;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            closeable = new DropDimensionCubeWorkspaceRebuilder(this.olapWorkspace, this.cubeWorkspace, dimension, isPartitionDimension);
            throwable = null;
            try {
                DropDimensionCubeWorkspaceRebuilder it = (DropDimensionCubeWorkspaceRebuilder)closeable;
                boolean bl = false;
                it.rebuild();
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            CubeWorkspace.onMetadataUpdated$default(this.cubeWorkspace, false, 1, null);
            List<File> list2 = event.getDeleteDirs();
            if (list2 == null) break block25;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (FilesKt.deleteRecursively((File)it)) continue;
                String string7 = "Failed requirement.";
                throw new IllegalArgumentException(string7.toString());
            }
        }
    }

    private final String getContainDimensionScopeName(CubeDataScopeCollection cubeDataScopes2, Dimension dimension) {
        for (CubeDataScope it : cubeDataScopes2) {
            if (!it.containsDimension(dimension)) continue;
            return it.getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPiecewiseExpression(Cube cube, Dimension dimension) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        if (!Cube.Companion.getAnyCubeDataScopesOrPiecewiseExpression(cube)) {
            return;
        }
        String dimensionName = dimension.getName();
        String cubeName = cube.getName();
        String scopeName = this.getContainDimensionScopeName(cube.getCubeDataScopes(), dimension);
        if (scopeName != null) {
            String string2 = Res.INSTANCE.getDimensionMetadataCommandException_5();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-DimensionMetadataCommandException_5>(...)");
            Object[] objectArray = new Object[]{cubeName, scopeName, dimensionName};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        Iterable $this$filter$iv = cube.getDimensions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Dimension it = (Dimension)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)dimension))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dimension dim = (Dimension)element$iv;
            boolean bl = false;
            String currentDimensionName = dim.getName();
            Iterable $this$forEach$iv2 = dim.getMembers();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                boolean bl2;
                Member member;
                block8: {
                    member = (Member)element$iv2;
                    boolean bl3 = false;
                    ExpressionUnit expressionUnit = member.tryGetOriginal();
                    if (expressionUnit == null || !(expressionUnit instanceof PiecewiseExpressionUnit)) continue;
                    Iterable $this$any$iv = ((PiecewiseExpressionUnit)expressionUnit).getExpressions();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv) {
                            PiecewisePair it = (PiecewisePair)element$iv3;
                            boolean bl4 = false;
                            if (!(it.getScope() != null && it.getScope().containsDimension(dimension))) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                String string3 = Res.INSTANCE.getDimensionMetadataCommandException_6();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-DimensionMetadataCommandException_6>(...)");
                Object[] objectArray = new Object[]{cubeName, currentDimensionName, member.getName(), dimensionName};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\u0005j\u0002`\u00062\u000e\u0010\n\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u001a\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0005j\u0002`\u0006\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/metadata/DimensionMetadataCommand$Companion;", "", "()V", "buildAliasesName", "", "", "Lkd/bos/olapServer2/common/string;", "cubeBuilder", "Lkd/bos/olapServer2/metadata/builds/CubeBuilder;", "name", "alias", "checkName", "", "removeDimensionInAggShieldBuilder", "aggShieldRules", "Lkd/bos/olapServer2/metadata/builds/AggShieldRuleBuilderCollection;", "dropDimensionName", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nDimensionMetadataCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DimensionMetadataCommand.kt\nkd/bos/olapServer2/metadata/DimensionMetadataCommand$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,357:1\n3792#2:358\n4307#2,2:359\n37#3,2:361\n1855#4,2:363\n1855#4,2:365\n*S KotlinDebug\n*F\n+ 1 DimensionMetadataCommand.kt\nkd/bos/olapServer2/metadata/DimensionMetadataCommand$Companion\n*L\n322#1:358\n322#1:359,2\n322#1:361,2\n332#1:363,2\n341#1:365,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void removeDimensionInAggShieldBuilder(@NotNull AggShieldRuleBuilderCollection aggShieldRules2, @NotNull String dropDimensionName) {
            Intrinsics.checkNotNullParameter((Object)aggShieldRules2, (String)"aggShieldRules");
            Intrinsics.checkNotNullParameter((Object)dropDimensionName, (String)"dropDimensionName");
            List removeRuleNames = new ArrayList();
            for (AggShieldRuleBuilder rule : aggShieldRules2) {
                AggShieldRuleBuilder aggShieldRuleBuilder = rule;
                if (aggShieldRuleBuilder instanceof AggShieldRuleBlackListBuilder) {
                    void $this$toTypedArray$iv;
                    void $this$filterTo$iv$iv;
                    Collection $this$filter$iv;
                    Object[] items2 = ((AggShieldRuleBlackListBuilder)rule).getItems();
                    if (!ArraysKt.contains((Object[])items2, (Object)dropDimensionName)) continue;
                    Object[] objectArray = items2;
                    AggShieldRuleBlackListBuilder aggShieldRuleBlackListBuilder = (AggShieldRuleBlackListBuilder)rule;
                    boolean $i$f$filter = false;
                    void var10_11 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    int n = ((void)$this$filterTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void it = element$iv$iv = $this$filterTo$iv$iv[i];
                        boolean bl = false;
                        if (!(!Intrinsics.areEqual((Object)it, (Object)dropDimensionName))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    aggShieldRuleBlackListBuilder.setItems(thisCollection$iv.toArray(new String[0]));
                    continue;
                }
                if (!(aggShieldRuleBuilder instanceof AggShieldRuleDataPartitionBuilder) || !Intrinsics.areEqual((Object)dropDimensionName, (Object)"Period") && !Intrinsics.areEqual((Object)dropDimensionName, (Object)"Year")) continue;
                removeRuleNames.add(rule.getName());
            }
            Iterable $this$forEach$iv = removeRuleNames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                aggShieldRules2.remove(it);
            }
        }

        @NotNull
        public final Collection<String> buildAliasesName(@NotNull CubeBuilder cubeBuilder, @NotNull String name2, @Nullable String alias) {
            Intrinsics.checkNotNullParameter((Object)cubeBuilder, (String)"cubeBuilder");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.checkName(cubeBuilder, name2);
            Collection<String> aliases = IAliasedItem.Utils.INSTANCE.splitAliasFromCommand(name2, alias);
            Iterable $this$forEach$iv = aliases;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Companion.checkName(cubeBuilder, it);
            }
            return aliases;
        }

        private final void checkName(CubeBuilder cubeBuilder, String name2) {
            StringValidator.INSTANCE.validate(name2);
            if (cubeBuilder.getDimensions().contains(name2)) {
                String string2 = Res.INSTANCE.getDimensionMetadataCommandException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-DimensionMetadataCommandException_1>(...)");
                Object[] objectArray = new Object[]{name2, cubeBuilder.getName()};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            if (cubeBuilder.getMeasures().contains(name2)) {
                String string3 = Res.INSTANCE.getMeasureMetadataCommandException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-MeasureMetadataCommandException_1>(...)");
                Object[] objectArray = new Object[]{name2, cubeBuilder.getName()};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandTypes.values().length];
            try {
                nArray[CommandTypes.create.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandTypes.alter.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandTypes.drop.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

