/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer.grammar.DragonEngine;
import kd.bos.olapServer2.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.metadata.CubeWorkspaceRebuilder;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionMetadataCommand;
import kd.bos.olapServer2.metadata.DropDimensionCubeWorkspaceRebuilder;
import kd.bos.olapServer2.metadata.builds.CubeBuilder;
import kd.bos.olapServer2.metadata.builds.DimensionBuilder;
import kd.bos.olapServer2.metadata.builds.DimensionPartitionBuilder;
import kd.bos.olapServer2.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer2.metadata.builds.PartitionBuilder;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.storages.StaticMeasureValueCollection;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.DSCacheRebuilder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\b\u0010\u0011\u001a\u00020\rH\u0014J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/metadata/DropDimensionCubeWorkspaceRebuilder;", "Lkd/bos/olapServer2/metadata/CubeWorkspaceRebuilder;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "source", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "dropDimension", "Lkd/bos/olapServer2/metadata/Dimension;", "isPartitionDimension", "", "Lkd/bos/olapServer2/common/bool;", "(Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/metadata/Dimension;Z)V", "beforeRebuild", "", "createAddOrUpdateStrategy", "Lkd/bos/olapServer2/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "endRebuild", "reBuildMetadata", "context", "Lkd/bos/olapServer2/metadata/builds/IMetadataWriterContext;", "DropDimensionAddOrUpdateStrategy", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nDropDimensionCubeWorkspaceRebuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropDimensionCubeWorkspaceRebuilder.kt\nkd/bos/olapServer2/metadata/DropDimensionCubeWorkspaceRebuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,97:1\n3792#2:98\n4307#2,2:99\n37#3,2:101\n*S KotlinDebug\n*F\n+ 1 DropDimensionCubeWorkspaceRebuilder.kt\nkd/bos/olapServer2/metadata/DropDimensionCubeWorkspaceRebuilder\n*L\n40#1:98\n40#1:99,2\n40#1:101,2\n*E\n"})
public final class DropDimensionCubeWorkspaceRebuilder
extends CubeWorkspaceRebuilder {
    @NotNull
    private final Dimension dropDimension;
    private final boolean isPartitionDimension;

    public DropDimensionCubeWorkspaceRebuilder(@NotNull OlapWorkspace olapWorkspace, @NotNull CubeWorkspace source2, @NotNull Dimension dropDimension, boolean isPartitionDimension) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dropDimension, (String)"dropDimension");
        super(olapWorkspace, source2);
        this.dropDimension = dropDimension;
        this.isPartitionDimension = isPartitionDimension;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void reBuildMetadata(@NotNull IMetadataWriterContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CubeBuilder builder = context.getCubeBuilder();
        DimensionBuilder dimensionBuilder = (DimensionBuilder)builder.getDimensions().get(this.dropDimension.getName());
        dimensionBuilder.getMembers().size();
        builder.getDimensions().remove(this.dropDimension.getName());
        if (this.isPartitionDimension) {
            void $this$toTypedArray$iv;
            void $this$filterTo$iv$iv;
            PartitionBuilder partitionBuilder = builder.getPartition();
            DimensionPartitionBuilder dimensionPartitionBuilder = partitionBuilder instanceof DimensionPartitionBuilder ? (DimensionPartitionBuilder)partitionBuilder : null;
            if (dimensionPartitionBuilder == null) {
                throw new NotSupportedException();
            }
            DimensionPartitionBuilder partitionBuilder2 = dimensionPartitionBuilder;
            Object $this$filter$iv = partitionBuilder2.getDimensions();
            boolean $i$f$filter = false;
            String[] stringArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)this.dropDimension.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] newPartitionDimensions = thisCollection$iv.toArray(new String[0]);
            if (newPartitionDimensions.length == 0) {
                builder.setPartition(null);
            } else {
                partitionBuilder2.setDimensions(newPartitionDimensions);
            }
        }
        DimensionMetadataCommand.Companion.removeDimensionInAggShieldBuilder(builder.getAggShieldRules(), this.dropDimension.getName());
        builder.getDimensions().resetPosition(builder.getPartition());
        context.getExtendCubeBuilder().getExtendDimension(dimensionBuilder).hardClearTags(null);
    }

    @Override
    protected void beforeRebuild() {
        DSCacheRebuilder.Companion.removeAllTasks(this.getSource());
    }

    @Override
    @NotNull
    protected IAddOrUpdateStrategy<IMeasureValues> createAddOrUpdateStrategy() {
        return new DropDimensionAddOrUpdateStrategy();
    }

    @Override
    protected void endRebuild() {
        CubeWorkspace rebuildCubeWorkspace = this.getOlapWorkspace().getCubeWorkspace(this.getSource().getMetadata().getName());
        DSCacheRebuilder.Companion.rebuildAll(this.getOlapWorkspace(), rebuildCubeWorkspace, (Function0<Boolean>)((Function0)endRebuild.1.INSTANCE));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00022\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer2/metadata/DropDimensionCubeWorkspaceRebuilder$DropDimensionAddOrUpdateStrategy;", "Lkd/bos/olapServer2/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "()V", "modifiedValue", "index", "", "Lkd/bos/olapServer2/common/rowIdx;", "originalValue", "newValue", "bos-olap-core2"})
    private static final class DropDimensionAddOrUpdateStrategy
    implements IAddOrUpdateStrategy<IMeasureValues> {
        @Override
        @NotNull
        public IMeasureValues modifiedValue(long index2, @NotNull IMeasureValues originalValue, @NotNull IMeasureValues newValue) {
            Intrinsics.checkNotNullParameter((Object)originalValue, (String)"originalValue");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            int count = originalValue.getCount();
            StaticMeasureValueCollection result2 = new StaticMeasureValueCollection(count);
            for (int i = 0; i < count; ++i) {
                Object currentValue = originalValue.getMeasureValue(i);
                Object newMeasureValue = newValue.getMeasureValue(i);
                if (newMeasureValue == CommonTypesKt.getIgnoreValue()) continue;
                if (currentValue == CommonTypesKt.getUndefined()) {
                    result2.set(i, newMeasureValue);
                    continue;
                }
                result2.set(i, DragonEngine.Companion.add(currentValue, newMeasureValue));
            }
            return result2;
        }

        @Override
        @NotNull
        public IMeasureValues addedValue(long index2, @NotNull IMeasureValues newValue) {
            return IAddOrUpdateStrategy.DefaultImpls.addedValue(this, index2, newValue);
        }

        @Override
        public boolean allowAdd() {
            return IAddOrUpdateStrategy.DefaultImpls.allowAdd(this);
        }
    }
}

