/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kd.bos.olapServer2.common.CellSet;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.metadata.ComponentMetadata;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.MeasureCollection;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.metadata.OlapDataFormats;
import kd.bos.olapServer2.metadata.OlapDataTypes;
import kd.bos.olapServer2.metadata.builds.CubeBuilder;
import kd.bos.olapServer2.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer2.metadata.builds.MeasureBuilder;
import kd.bos.olapServer2.metadata.events.AlterMeasureEvent;
import kd.bos.olapServer2.metadata.events.MetadataEvent;
import kd.bos.olapServer2.metadata.partitions.IPartitionItem;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.tools.StringValidator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\u0014\u0010\u000e\u001a\u00020\n2\n\u0010\u000f\u001a\u00060\fj\u0002`\rH\u0002J\u0014\u0010\u0010\u001a\u00020\n2\n\u0010\u000f\u001a\u00060\fj\u0002`\rH\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/metadata/MeasureMetadataCommand;", "", "metadataCmdInfo", "Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "(Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/storages/CubeWorkspace;)V", "alterMeasure", "", "uniqueName", "", "Lkd/bos/olapServer2/common/string;", "createMeasure", "cubeName", "dropMeasure", "execute", "Lkd/bos/olapServer2/common/CellSet;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nMeasureMetadataCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeasureMetadataCommand.kt\nkd/bos/olapServer2/metadata/MeasureMetadataCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1#2:197\n766#3:198\n857#3,2:199\n1549#3:201\n1620#3,3:202\n1855#3,2:205\n*S KotlinDebug\n*F\n+ 1 MeasureMetadataCommand.kt\nkd/bos/olapServer2/metadata/MeasureMetadataCommand\n*L\n173#1:198\n173#1:199,2\n175#1:201\n175#1:202,3\n189#1:205,2\n*E\n"})
public final class MeasureMetadataCommand {
    @NotNull
    private final MetadataCommandInfo metadataCmdInfo;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final CubeWorkspace cubeWorkspace;

    public MeasureMetadataCommand(@NotNull MetadataCommandInfo metadataCmdInfo, @NotNull OlapWorkspace olapWorkspace, @NotNull CubeWorkspace cubeWorkspace) {
        Intrinsics.checkNotNullParameter((Object)metadataCmdInfo, (String)"metadataCmdInfo");
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        this.metadataCmdInfo = metadataCmdInfo;
        this.olapWorkspace = olapWorkspace;
        this.cubeWorkspace = cubeWorkspace;
    }

    @Nullable
    public final CellSet execute() {
        if (!(this.metadataCmdInfo.getMetadataType() == MetadataTypes.Measure)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String cubeName = StringValidator.INSTANCE.validateOwnerUniqueName(this.cubeWorkspace.getMetadata(), this.metadataCmdInfo.getOwnerUniqueName(), MetadataTypes.Measure).get(0);
        switch (WhenMappings.$EnumSwitchMapping$0[this.metadataCmdInfo.getAction().ordinal()]) {
            case 1: {
                this.createMeasure(cubeName);
                break;
            }
            case 2: {
                this.alterMeasure(cubeName);
                break;
            }
            case 3: {
                this.dropMeasure(cubeName);
                break;
            }
            default: {
                String string3 = Res.INSTANCE.getCommonException_7();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CommonException_7>(...)");
                Object[] objectArray = new Object[]{this.metadataCmdInfo.getAction()};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void alterMeasure(String uniqueName) {
        Measure[] measureObj;
        Measure[] measureArray;
        Object object2;
        MeasureCollection measures2 = this.cubeWorkspace.getMetadata().getMeasures();
        String measureName = this.metadataCmdInfo.getName();
        if (this.metadataCmdInfo.getProperties().size() == 1 && Intrinsics.areEqual((Object)this.metadataCmdInfo.getProperties().get((Object)"dataType"), (Object)"object")) {
            int n = 0;
            int n2 = measures2.getCount();
            object2 = new Measure[n2];
            while (n < n2) {
                int n3 = n++;
                object2[n3] = measures2.get(n3);
            }
            measureArray = object2;
        } else {
            Measure[] measureArray2 = new Measure[]{measures2.get(measureName)};
            measureArray = measureObj = measureArray2;
        }
        if (!((Collection)this.metadataCmdInfo.getItems()).isEmpty()) {
            throw new NotSupportedException(uniqueName + " not support Items property.");
        }
        Ref.ObjectRef alterMeasureEvent = new Ref.ObjectRef();
        Closeable closeable = this.cubeWorkspace.getMetadataStorage().createWriterContext();
        object2 = null;
        try {
            IMetadataWriterContext writerContext = (IMetadataWriterContext)closeable;
            boolean bl = false;
            CubeBuilder cubeBuilder = writerContext.getCubeBuilder();
            int n = 0;
            int n4 = measureObj.length;
            Pair[] pairArray = new Pair[n4];
            while (n < n4) {
                int n5 = n++;
                pairArray[n5] = new Pair((Object)measureObj[n5], cubeBuilder.getMeasures().get(measureObj[n5].getName()));
            }
            Pair[] alterMeasures = pairArray;
            alterMeasureEvent.element = new AlterMeasureEvent(this.olapWorkspace, this.cubeWorkspace, alterMeasures, this.metadataCmdInfo.getProperties(), false);
            ((AlterMeasureEvent)alterMeasureEvent.element).after((Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef<AlterMeasureEvent>)alterMeasureEvent, writerContext, this){
                final /* synthetic */ Ref.ObjectRef<AlterMeasureEvent> $alterMeasureEvent;
                final /* synthetic */ IMetadataWriterContext $writerContext;
                final /* synthetic */ MeasureMetadataCommand this$0;
                {
                    this.$alterMeasureEvent = $alterMeasureEvent;
                    this.$writerContext = $writerContext;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (((AlterMeasureEvent)this.$alterMeasureEvent.element).getAutoSave()) {
                        this.$writerContext.save();
                        CubeWorkspace.onMetadataUpdated$default(MeasureMetadataCommand.access$getCubeWorkspace$p(this.this$0), false, 1, null);
                    }
                }
            }));
            this.cubeWorkspace.getMetadataStorage().invokeEvent((MetadataEvent)alterMeasureEvent.element);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createMeasure(String cubeName) {
        String measureName = this.metadataCmdInfo.getName();
        StringValidator.INSTANCE.validate(measureName);
        int measureSize = this.cubeWorkspace.getMetadata().getMeasures().getStoredMeasures().size();
        int realMeasureSize = CollectionsKt.count((Iterable)this.cubeWorkspace.getMetadata().getMeasures());
        Closeable closeable = this.cubeWorkspace.getMetadataStorage().createWriterContext();
        Throwable throwable = null;
        try {
            CharSequence charSequence;
            MeasureBuilder differenceMeasure;
            MeasureBuilder measureBuilder;
            Object leftMeasure;
            IMetadataWriterContext writerContext = (IMetadataWriterContext)closeable;
            boolean bl = false;
            CubeBuilder cubeBuilder = writerContext.getCubeBuilder();
            String dataFormat = this.metadataCmdInfo.getDataFormat();
            int maxMeasureNum = 1000;
            if (!Intrinsics.areEqual((Object)dataFormat, (Object)OlapDataFormats.MeasureFormat_Dif.getType()) && measureSize >= maxMeasureNum) {
                String string2 = Res.INSTANCE.getMeasureMetadataCommandException_14();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MeasureMetadataCommandException_14>(...)");
                Object[] objectArray = new Object[]{cubeName, maxMeasureNum};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            if (Intrinsics.areEqual((Object)dataFormat, (Object)OlapDataFormats.MeasureFormat_Dif.getType()) && realMeasureSize - measureSize >= maxMeasureNum) {
                String string3 = Res.INSTANCE.getMeasureMetadataCommandException_15();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-MeasureMetadataCommandException_15>(...)");
                Object[] objectArray = new Object[]{cubeName, maxMeasureNum};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
            if (((CharSequence)dataFormat).length() > 0 && OlapDataFormats.Companion.tryGet(dataFormat) == null) {
                String string4 = Res.INSTANCE.getMeasureMetadataCommandException_6();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-MeasureMetadataCommandException_6>(...)");
                Object[] objectArray = new Object[]{cubeName, measureName};
                throw Res.INSTANCE.getRuntimeException(string4, objectArray);
            }
            OlapDataTypes dataType = this.metadataCmdInfo.getDataType();
            if (((CharSequence)dataFormat).length() > 0 && OlapDataFormats.Companion.get(dataFormat).getDataType() != dataType) {
                String string5 = Res.INSTANCE.getMeasureMetadataCommandException_13();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-MeasureMetadataCommandException_13>(...)");
                Object[] objectArray = new Object[]{cubeName, measureName, dataType.name(), dataFormat};
                throw Res.INSTANCE.getRuntimeException(string5, objectArray);
            }
            if (Intrinsics.areEqual((Object)dataFormat, (Object)OlapDataFormats.MeasureFormat_Dif.getType())) {
                if (((CharSequence)this.metadataCmdInfo.getLeftMeasure()).length() == 0 || ((CharSequence)this.metadataCmdInfo.getRightMeasure()).length() == 0) {
                    String string6 = Res.INSTANCE.getMeasureMetadataCommandException_7();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"<get-MeasureMetadataCommandException_7>(...)");
                    Object[] objectArray = new Object[]{cubeName, measureName};
                    throw Res.INSTANCE.getRuntimeException(string6, objectArray);
                }
                if (Intrinsics.areEqual((Object)this.metadataCmdInfo.getLeftMeasure(), (Object)this.metadataCmdInfo.getRightMeasure())) {
                    String string7 = Res.INSTANCE.getMeasureMetadataCommandException_10();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"<get-MeasureMetadataCommandException_10>(...)");
                    Object[] objectArray = new Object[]{cubeName, measureName, this.metadataCmdInfo.getLeftMeasure()};
                    throw Res.INSTANCE.getRuntimeException(string7, objectArray);
                }
                leftMeasure = (MeasureBuilder)cubeBuilder.getMeasures().get(this.metadataCmdInfo.getLeftMeasure());
                MeasureBuilder rightMeasure = (MeasureBuilder)cubeBuilder.getMeasures().get(this.metadataCmdInfo.getRightMeasure());
                if (dataType != ((MeasureBuilder)leftMeasure).getDataType()) {
                    String string8 = Res.INSTANCE.getMeasureMetadataCommandException_8();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"<get-MeasureMetadataCommandException_8>(...)");
                    Object[] objectArray = new Object[]{cubeName, measureName, ((MeasureBuilder)leftMeasure).getName()};
                    throw Res.INSTANCE.getRuntimeException(string8, objectArray);
                }
                if (dataType != rightMeasure.getDataType()) {
                    String string9 = Res.INSTANCE.getMeasureMetadataCommandException_8();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"<get-MeasureMetadataCommandException_8>(...)");
                    Object[] objectArray = new Object[]{cubeName, measureName, rightMeasure.getName()};
                    throw Res.INSTANCE.getRuntimeException(string9, objectArray);
                }
                if (!OlapDataFormats.Companion.get(((MeasureBuilder)leftMeasure).getDataFormat()).isSupportUndefined()) {
                    String string10 = Res.INSTANCE.getMeasureMetadataCommandException_11();
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"<get-MeasureMetadataCommandException_11>(...)");
                    Object[] objectArray = new Object[]{cubeName, measureName, ((MeasureBuilder)leftMeasure).getName(), ((MeasureBuilder)leftMeasure).getDataFormat()};
                    throw Res.INSTANCE.getRuntimeException(string10, objectArray);
                }
                if (!OlapDataFormats.Companion.get(rightMeasure.getDataFormat()).isSupportUndefined()) {
                    String string11 = Res.INSTANCE.getMeasureMetadataCommandException_11();
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"<get-MeasureMetadataCommandException_11>(...)");
                    Object[] objectArray = new Object[]{cubeName, measureName, rightMeasure.getName(), rightMeasure.getDataFormat()};
                    throw Res.INSTANCE.getRuntimeException(string11, objectArray);
                }
                measureBuilder = new Pair(leftMeasure, (Object)rightMeasure);
            } else {
                measureBuilder = differenceMeasure = null;
            }
            if (cubeBuilder.getDimensions().contains(measureName)) {
                String string12 = Res.INSTANCE.getDimensionMetadataCommandException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"<get-DimensionMetadataCommandException_1>(...)");
                leftMeasure = new Object[]{measureName, cubeName};
                throw Res.INSTANCE.getRuntimeException(string12, (Object[])leftMeasure);
            }
            if (cubeBuilder.getMeasures().contains(measureName)) {
                String string13 = Res.INSTANCE.getMeasureMetadataCommandException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"<get-MeasureMetadataCommandException_1>(...)");
                leftMeasure = new Object[]{measureName, cubeName};
                throw Res.INSTANCE.getRuntimeException(string13, (Object[])leftMeasure);
            }
            MeasureBuilder measureBuilder2 = (MeasureBuilder)cubeBuilder.getMeasures().add(measureName);
            measureBuilder2.setDataType(dataType);
            measureBuilder2.setAllowNull(this.metadataCmdInfo.getAllowNull());
            if (!StringsKt.isBlank((CharSequence)this.metadataCmdInfo.getReadonlyExpression())) {
                measureBuilder2.setReadonlyExpression(this.metadataCmdInfo.getReadonlyExpression());
            }
            MeasureBuilder measureBuilder3 = measureBuilder2;
            CharSequence charSequence2 = dataFormat;
            if (charSequence2.length() == 0) {
                MeasureBuilder measureBuilder4 = measureBuilder3;
                boolean bl2 = false;
                charSequence = dataType.getDefaultOlapFormat();
                measureBuilder3 = measureBuilder4;
            } else {
                charSequence = charSequence2;
            }
            measureBuilder3.setDataFormat((String)charSequence);
            Object object2 = differenceMeasure;
            if (object2 == null || (object2 = (MeasureBuilder)object2.getFirst()) == null || (object2 = ((MeasureBuilder)object2).getGlobalID()) == null) {
                object2 = ComponentMetadata.Companion.getNull_ID();
            }
            measureBuilder2.setLeftMeasure((UUID)object2);
            Object object3 = differenceMeasure;
            if (object3 == null || (object3 = (MeasureBuilder)object3.getSecond()) == null || (object3 = ((MeasureBuilder)object3).getGlobalID()) == null) {
                object3 = ComponentMetadata.Companion.getNull_ID();
            }
            measureBuilder2.setRightMeasure((UUID)object3);
            writerContext.save();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        CubeWorkspace.onMetadataUpdated$default(this.cubeWorkspace, false, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void dropMeasure(String cubeName) {
        void $this$mapTo$iv$iv;
        Object[] $this$map$iv;
        Measure m;
        void $this$filterTo$iv$iv;
        Measure measure = (Measure)this.cubeWorkspace.getMetadata().getMeasures().get(this.metadataCmdInfo.getName());
        String measureName = measure.getName();
        Iterable $this$filter$iv = this.cubeWorkspace.getMetadata().getMeasures();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            m = (Measure)element$iv$iv;
            boolean bl = false;
            if (!(m.getLeftMeasure() == measure || m.getRightMeasure() == measure)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            m = (Measure)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List refMeasures = (List)destination$iv$iv;
        if (!((Collection)refMeasures).isEmpty()) {
            String string2 = Res.INSTANCE.getMeasureMetadataCommandException_9();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MeasureMetadataCommandException_9>(...)");
            $this$map$iv = new Object[]{cubeName, measureName, CollectionsKt.joinToString$default((Iterable)refMeasures, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)};
            throw Res.INSTANCE.getRuntimeException(string2, $this$map$iv);
        }
        $this$map$iv = (Object[])this.cubeWorkspace.getMetadataStorage().createWriterContext();
        Throwable $i$f$map22 = null;
        try {
            IMetadataWriterContext writerContext = (IMetadataWriterContext)$this$map$iv;
            boolean bl = false;
            writerContext.getCubeBuilder().getMeasures().remove(measureName);
            writerContext.save();
            writerContext = Unit.INSTANCE;
        }
        catch (Throwable writerContext) {
            $i$f$map22 = writerContext;
            throw writerContext;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$this$map$iv, (Throwable)$i$f$map22);
        }
        CubeWorkspace.onMetadataUpdated$default(this.cubeWorkspace, false, 1, null);
        Cube cube = this.cubeWorkspace.getMetadata();
        if (cube.getEnabledPartition()) {
            Iterable $this$forEach$iv = cube.getPartitionItems();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IPartitionItem it = (IPartitionItem)element$iv;
                boolean bl = false;
                String string3 = this.olapWorkspace.getRootPath();
                String[] stringArray = new String[3];
                stringArray[0] = cubeName;
                stringArray[1] = it.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)measure.getGlobalID().toString(), (String)"toString(...)");
                FileTools.INSTANCE.deleteDir(PathsKt.fileSafeConstructor(((Object)Paths.INSTANCE.get(string3, stringArray)).toString()));
            }
        } else {
            String string4 = this.olapWorkspace.getRootPath();
            String[] stringArray = new String[2];
            stringArray[0] = cubeName;
            Intrinsics.checkNotNullExpressionValue((Object)measure.getGlobalID().toString(), (String)"toString(...)");
            FileTools.INSTANCE.deleteDir(PathsKt.fileSafeConstructor(((Object)Paths.INSTANCE.get(string4, stringArray)).toString()));
        }
    }

    public static final /* synthetic */ CubeWorkspace access$getCubeWorkspace$p(MeasureMetadataCommand $this) {
        return $this.cubeWorkspace;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandTypes.values().length];
            try {
                nArray[CommandTypes.create.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandTypes.alter.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandTypes.drop.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

