/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata;

import java.nio.channels.ClosedChannelException;
import kd.bos.olapServer2.common.CellSet;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.metadata.AggFactorMetadataCommand;
import kd.bos.olapServer2.metadata.AggShieldRuleMetadataCommand;
import kd.bos.olapServer2.metadata.CubeCreateMetadataCommand;
import kd.bos.olapServer2.metadata.CubeDataLockRuleMetadataCommand;
import kd.bos.olapServer2.metadata.CubeDataScopeMetadataCommand;
import kd.bos.olapServer2.metadata.CubeMetadataCommand;
import kd.bos.olapServer2.metadata.DimensionMetadataCommand;
import kd.bos.olapServer2.metadata.MeasureMetadataCommand;
import kd.bos.olapServer2.metadata.MemberMetadataCommand;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.metadata.MetadataUpdatedEventArgs;
import kd.bos.olapServer2.metadata.PartitionMetadataCommand;
import kd.bos.olapServer2.metadata.PiecewiseExpressionMetadataCommand;
import kd.bos.olapServer2.metadata.SimpleMemberMetadataCommand;
import kd.bos.olapServer2.metadata.TagMetadataCommand;
import kd.bos.olapServer2.metadata.ValidDataRuleMetadataCommand;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.transactions.ITransaction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eB9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0002R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/metadata/MetadataCommandExecutor;", "", "metaCmdInfo", "Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "(Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/storages/CubeWorkspace;)V", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "transaction", "Lkd/bos/olapServer2/transactions/ITransaction;", "(Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;Lkd/bos/olapServer2/storages/OlapWorkspace;Ljava/lang/String;Lkd/bos/olapServer2/transactions/ITransaction;)V", "_cubeWorkspace", "(Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/storages/CubeWorkspace;Ljava/lang/String;Lkd/bos/olapServer2/transactions/ITransaction;)V", "version", "", "Lkd/bos/olapServer2/common/long;", "execute", "Lkd/bos/olapServer2/common/CellSet;", "run", "runCreateCube", "runWithoutLock", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nMetadataCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataCommandExecutor.kt\nkd/bos/olapServer2/metadata/MetadataCommandExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class MetadataCommandExecutor {
    @NotNull
    private final MetadataCommandInfo metaCmdInfo;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @Nullable
    private CubeWorkspace _cubeWorkspace;
    @NotNull
    private final String cubeName;
    private final long version;

    private MetadataCommandExecutor(MetadataCommandInfo metaCmdInfo, OlapWorkspace olapWorkspace, CubeWorkspace _cubeWorkspace, String cubeName, ITransaction transaction) {
        this.metaCmdInfo = metaCmdInfo;
        this.olapWorkspace = olapWorkspace;
        this._cubeWorkspace = _cubeWorkspace;
        this.cubeName = cubeName;
        ITransaction iTransaction = transaction;
        this.version = iTransaction != null ? iTransaction.getVersion() : -1L;
    }

    /* synthetic */ MetadataCommandExecutor(MetadataCommandInfo metadataCommandInfo, OlapWorkspace olapWorkspace, CubeWorkspace cubeWorkspace, String string2, ITransaction iTransaction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            iTransaction = null;
        }
        this(metadataCommandInfo, olapWorkspace, cubeWorkspace, string2, iTransaction);
    }

    public MetadataCommandExecutor(@NotNull MetadataCommandInfo metaCmdInfo, @NotNull OlapWorkspace olapWorkspace, @NotNull CubeWorkspace cubeWorkspace) {
        Intrinsics.checkNotNullParameter((Object)metaCmdInfo, (String)"metaCmdInfo");
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        this(metaCmdInfo, olapWorkspace, cubeWorkspace, cubeWorkspace.getMetadata().getName(), null, 16, null);
    }

    public MetadataCommandExecutor(@NotNull MetadataCommandInfo metaCmdInfo, @NotNull OlapWorkspace olapWorkspace, @NotNull String cubeName, @Nullable ITransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)metaCmdInfo, (String)"metaCmdInfo");
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this(metaCmdInfo, olapWorkspace, null, cubeName, transaction);
    }

    public /* synthetic */ MetadataCommandExecutor(MetadataCommandInfo metadataCommandInfo, OlapWorkspace olapWorkspace, String string2, ITransaction iTransaction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            iTransaction = null;
        }
        this(metadataCommandInfo, olapWorkspace, string2, iTransaction);
    }

    @Nullable
    public final CellSet run() {
        CellSet cellSet;
        CubeWorkspace cubeWorkspace;
        if (!(this.metaCmdInfo.getMetadataType() != MetadataTypes.Cube || this.metaCmdInfo.getAction() != CommandTypes.create)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        CubeWorkspace cubeWorkspace2 = this._cubeWorkspace;
        if (cubeWorkspace2 == null) {
            cubeWorkspace2 = this.olapWorkspace.getCubeWorkspace(this.cubeName);
        }
        if ((cubeWorkspace = cubeWorkspace2).isClosed()) {
            throw new ClosedChannelException();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.metaCmdInfo.getMetadataType().ordinal()]) {
            case 1: {
                cellSet = new CubeMetadataCommand(this.metaCmdInfo, this.olapWorkspace, cubeWorkspace).execute();
                break;
            }
            case 2: {
                cellSet = new DimensionMetadataCommand(this.metaCmdInfo, this.olapWorkspace, cubeWorkspace).execute();
                break;
            }
            case 3: {
                cellSet = new MemberMetadataCommand(this.metaCmdInfo, this.olapWorkspace, cubeWorkspace).execute();
                break;
            }
            case 4: {
                cellSet = new MeasureMetadataCommand(this.metaCmdInfo, this.olapWorkspace, cubeWorkspace).execute();
                break;
            }
            case 5: {
                cellSet = new PartitionMetadataCommand(this.metaCmdInfo, this.olapWorkspace, cubeWorkspace).execute();
                break;
            }
            case 6: {
                cellSet = new AggFactorMetadataCommand(this.metaCmdInfo, this.olapWorkspace, cubeWorkspace).execute();
                break;
            }
            case 7: {
                cellSet = new AggShieldRuleMetadataCommand(this.metaCmdInfo, this.olapWorkspace, cubeWorkspace).execute();
                break;
            }
            case 8: {
                cellSet = new ValidDataRuleMetadataCommand(this.metaCmdInfo, this.olapWorkspace, cubeWorkspace).execute();
                break;
            }
            case 9: {
                cellSet = new PiecewiseExpressionMetadataCommand(this.metaCmdInfo, cubeWorkspace).execute();
                break;
            }
            case 10: {
                cellSet = new CubeDataScopeMetadataCommand(this.metaCmdInfo, cubeWorkspace).execute();
                break;
            }
            case 11: {
                cellSet = new CubeDataLockRuleMetadataCommand(this.metaCmdInfo, cubeWorkspace).execute();
                break;
            }
            case 12: {
                cellSet = new TagMetadataCommand(this.metaCmdInfo, cubeWorkspace).execute();
                break;
            }
            case 13: {
                cellSet = new SimpleMemberMetadataCommand(this.metaCmdInfo, cubeWorkspace).execute();
                break;
            }
            default: {
                throw new NotSupportedException();
            }
        }
        return cellSet;
    }

    @Nullable
    public final CellSet execute() {
        return this.metaCmdInfo.getMetadataType() == MetadataTypes.Cube && this.metaCmdInfo.getAction() == CommandTypes.create ? this.runCreateCube() : this.runWithoutLock();
    }

    private final CellSet runWithoutLock() {
        CellSet cellSet;
        CubeWorkspace cubeWorkspace;
        this._cubeWorkspace = cubeWorkspace = this.olapWorkspace.getCubeWorkspace(this.cubeName);
        CellSet it = cellSet = this.run();
        boolean bl = false;
        cubeWorkspace.getMetadataUpdated().invoke(cubeWorkspace.getPlugins().getContext(), new MetadataUpdatedEventArgs(this.version, this.metaCmdInfo, null, 4, null));
        return cellSet;
    }

    private final CellSet runCreateCube() {
        if (!Intrinsics.areEqual((Object)this.cubeName, (Object)this.metaCmdInfo.getName())) {
            boolean $i$a$-require-MetadataCommandExecutor$runCreateCube$22 = false;
            String $i$a$-require-MetadataCommandExecutor$runCreateCube$22 = "cubeName in initialcatalog is different from cubeName in commandInfo";
            throw new IllegalArgumentException($i$a$-require-MetadataCommandExecutor$runCreateCube$22.toString());
        }
        CellSet result2 = new CubeCreateMetadataCommand(this.metaCmdInfo, this.olapWorkspace, this.olapWorkspace.assignNextId()).execute();
        CubeWorkspace cubeWorkspace = this.olapWorkspace.getCubeWorkspace(this.cubeName);
        cubeWorkspace.getMetadataUpdated().invoke(cubeWorkspace.getPlugins().getContext(), new MetadataUpdatedEventArgs(this.version, this.metaCmdInfo, null, 4, null));
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetadataTypes.values().length];
            try {
                nArray[MetadataTypes.Cube.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.Dimension.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.Member.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.Measure.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.Partition.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.AggFactor.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.AggShieldRule.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.ValidDataRule.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.PiecewiseExpression.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.CubeDataScope.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.CubeLockRule.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.Tag.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataTypes.SimpleMember.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

