/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.tools.FileTools;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\t2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\fJ\n\u0010\r\u001a\u00060\u0003j\u0002`\u0004J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0014\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0014\u0010\u0013\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0014\u0010\u0014\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u001a\u0010\u0015\u001a\u00020\t2\u0012\b\u0002\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0017R\u0012\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/metadata/ReBuilderFolder;", "Ljava/io/Closeable;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "sourceCubeName", "(Ljava/lang/String;Ljava/lang/String;)V", "_tempPath", "close", "", "copyToTemp", "fileNames", "", "createTempPath", "isOldCubeJson", "", "fileName", "isOldTransactionFile", "isRetainFile", "isRollbackFile", "isTransactionFile", "moveFiles", "doNotMoveFiles", "", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nReBuilderFolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReBuilderFolder.kt\nkd/bos/olapServer2/metadata/ReBuilderFolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,103:1\n1#2:104\n13309#3,2:105\n*S KotlinDebug\n*F\n+ 1 ReBuilderFolder.kt\nkd/bos/olapServer2/metadata/ReBuilderFolder\n*L\n50#1:105,2\n*E\n"})
public final class ReBuilderFolder
implements Closeable {
    @NotNull
    private final String rootPath;
    @NotNull
    private final String sourceCubeName;
    @NotNull
    private String _tempPath;

    public ReBuilderFolder(@NotNull String rootPath, @NotNull String sourceCubeName) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)sourceCubeName, (String)"sourceCubeName");
        this.rootPath = rootPath;
        this.sourceCubeName = sourceCubeName;
        this._tempPath = "";
    }

    @NotNull
    public final String createTempPath() {
        String string2;
        Object object2 = OlapContext.Companion.tryGetContext(ITempFolder.class);
        if ((object2 != null && (object2 = object2.getTempFolder()) != null ? ((File)object2).getAbsolutePath() : (string2 = null)) == null) {
            string2 = this.rootPath;
        }
        Object object3 = Files.createTempDirectory(Paths.INSTANCE.get(string2, new String[0]), "", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"createTempDirectory(...)");
        Object $this$createTempPath_u24lambda_u240 = object3 = ((Object)object3.toAbsolutePath()).toString();
        boolean bl = false;
        this._tempPath = $this$createTempPath_u24lambda_u240;
        return object3;
    }

    public final void copyToTemp(@NotNull List<String> fileNames) {
        Intrinsics.checkNotNullParameter(fileNames, (String)"fileNames");
        if (!(((CharSequence)this._tempPath).length() > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String[] stringArray = new String[]{this.sourceCubeName};
        String sourcePath = ((Object)Paths.INSTANCE.get(this.rootPath, stringArray).toAbsolutePath()).toString();
        for (String fileName : fileNames) {
            File file = Paths.INSTANCE.toFile(sourcePath, fileName);
            FilesKt.copyRecursively$default((File)file, (File)Paths.INSTANCE.toFile(this._tempPath, fileName), (boolean)false, null, (int)6, null);
        }
    }

    public final void moveFiles(@NotNull Set<String> doNotMoveFiles) {
        Set set;
        String string2;
        Intrinsics.checkNotNullParameter(doNotMoveFiles, (String)"doNotMoveFiles");
        File sourcePath = Paths.INSTANCE.toFile(this.rootPath, this.sourceCubeName);
        Object object2 = OlapContext.Companion.tryGetContext(ITempFolder.class);
        if ((object2 != null && (object2 = object2.getTempFolder()) != null ? ((File)object2).getAbsolutePath() : (string2 = null)) == null) {
            string2 = this.rootPath;
        }
        File sourcePath2 = Paths.INSTANCE.toFile(string2, "##" + this.sourceCubeName);
        Set $this$moveFiles_u24lambda_u241 = set = CollectionsKt.toMutableSet((Iterable)doNotMoveFiles);
        boolean bl = false;
        $this$moveFiles_u24lambda_u241.add("transaction.log");
        Set doNotMoveFile = set;
        File[] fileArray = sourcePath.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                String fileName = file.getName();
                if (!file.isFile()) continue;
                Intrinsics.checkNotNull((Object)fileName);
                if (!this.isRetainFile(fileName)) continue;
                doNotMoveFile.add(fileName);
            }
        }
        FileTools.moveDir$default(FileTools.INSTANCE, sourcePath, sourcePath2, doNotMoveFile, true, false, 16, null);
        File tempPath = PathsKt.fileSafeConstructor(this._tempPath);
        FileTools.moveDir$default(FileTools.INSTANCE, tempPath, sourcePath, SetsKt.emptySet(), true, false, 16, null);
        String string3 = sourcePath2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        this._tempPath = string3;
    }

    public static /* synthetic */ void moveFiles$default(ReBuilderFolder reBuilderFolder, Set set, int n, Object object2) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        reBuilderFolder.moveFiles(set);
    }

    private final boolean isRetainFile(String fileName) {
        return this.isTransactionFile(fileName) || this.isOldTransactionFile(fileName) || this.isOldCubeJson(fileName) || this.isRollbackFile(fileName);
    }

    private final boolean isOldCubeJson(String fileName) {
        return StringsKt.startsWith$default((String)fileName, (String)"cube.json.old", (boolean)false, (int)2, null);
    }

    private final boolean isOldTransactionFile(String fileName) {
        return StringsKt.startsWith$default((String)fileName, (String)"transaction_", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)fileName, (String)".log.zip", (boolean)false, (int)2, null);
    }

    private final boolean isTransactionFile(String fileName) {
        return StringsKt.startsWith$default((String)fileName, (String)"commands", (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)fileName, (String)".log", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".log2", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".logz", (boolean)false, (int)2, null));
    }

    private final boolean isRollbackFile(String fileName) {
        return StringsKt.startsWith$default((String)fileName, (String)"rollback.log", (boolean)false, (int)2, null);
    }

    @Override
    public void close() {
        boolean deleted;
        if (((CharSequence)this._tempPath).length() > 0 && !(deleted = FilesKt.deleteRecursively((File)PathsKt.fileSafeConstructor(this._tempPath)))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }
}

