/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.metadata.CubeDataScope;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.SliceScopeV2Encoding;
import kd.bos.olapServer2.query.models.DimensionFilter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002:\u0001)B3\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u001d\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001e\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u001fH\u0016J\u0014\u0010 \u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u001c\u0010!\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0004H\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0015\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030%H\u0096\u0002J\u0014\u0010&\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010'\u001a\u00020(H\u0016R\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0013\u001a\u00060\u0014j\u0002`\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lkd/bos/olapServer2/metadata/SliceScopeV2;", "Lkd/bos/olapServer2/metadata/CubeDataScope;", "", "", "Lkd/bos/olapServer2/metadata/Member;", "xId", "", "Lkd/bos/olapServer2/common/int;", "name", "", "Lkd/bos/olapServer2/common/string;", "dimensions", "Lkd/bos/olapServer2/metadata/Dimension;", "members", "", "(ILjava/lang/String;[Lkd/bos/olapServer2/metadata/Dimension;[B)V", "getDimensions", "()[Lkd/bos/olapServer2/metadata/Dimension;", "[Lkd/bos/olapServer2/metadata/Dimension;", "enabled", "", "Lkd/bos/olapServer2/common/bool;", "getEnabled", "()Z", "getMembers", "()[B", "parser", "Lkotlin/Lazy;", "Lkd/bos/olapServer2/metadata/SliceScopeV2$SliceScopeV2Parser;", "containsAnyMember", "dimension", "", "containsDimension", "containsMember", "member", "getDimensionIndex", "iterator", "", "test", "key", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "SliceScopeV2Parser", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nSliceScopeV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SliceScopeV2.kt\nkd/bos/olapServer2/metadata/SliceScopeV2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1747#2,3:107\n*S KotlinDebug\n*F\n+ 1 SliceScopeV2.kt\nkd/bos/olapServer2/metadata/SliceScopeV2\n*L\n51#1:107,3\n*E\n"})
public final class SliceScopeV2
extends CubeDataScope
implements Iterable<Member[]>,
KMappedMarker {
    @NotNull
    private final Dimension[] dimensions;
    @NotNull
    private final byte[] members;
    @NotNull
    private final Lazy<SliceScopeV2Parser> parser;

    public SliceScopeV2(int xId, @NotNull String name2, @NotNull Dimension[] dimensions2, @NotNull byte[] members2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dimensions2, (String)"dimensions");
        Intrinsics.checkNotNullParameter((Object)members2, (String)"members");
        super(xId, name2);
        this.dimensions = dimensions2;
        this.members = members2;
        this.parser = LazyKt.lazy((Function0)((Function0)new Function0<SliceScopeV2Parser>(this){
            final /* synthetic */ SliceScopeV2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SliceScopeV2Parser invoke() {
                return new SliceScopeV2Parser(this.this$0.getDimensions(), this.this$0.getMembers());
            }
        }));
    }

    @NotNull
    public final Dimension[] getDimensions() {
        return this.dimensions;
    }

    @NotNull
    public final byte[] getMembers() {
        return this.members;
    }

    @Override
    public boolean getEnabled() {
        return true;
    }

    @Override
    public boolean containsMember(@NotNull Dimension dimension, @NotNull Member member) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        int dimIndex = this.getDimensionIndex(dimension);
        if (dimIndex != -1) {
            Object[] members2 = ((SliceScopeV2Parser)this.parser.getValue()).get(dimIndex);
            return ArraysKt.contains((Object[])members2, (Object)member);
        }
        return false;
    }

    private final int getDimensionIndex(Dimension dimension) {
        Dimension[] dimensionArray = this.dimensions;
        int n = dimensionArray.length;
        for (int i = 0; i < n; ++i) {
            int index2 = i;
            Dimension dim = dimensionArray[i];
            if (dim != dimension) continue;
            return index2;
        }
        return -1;
    }

    @Override
    public boolean containsAnyMember(@NotNull Dimension dimension, @NotNull Collection<? extends Member> members2) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter(members2, (String)"members");
        int dimIndex = this.getDimensionIndex(dimension);
        if (dimIndex != -1) {
            boolean bl;
            block4: {
                Object[] dimMembers = ((SliceScopeV2Parser)this.parser.getValue()).get(dimIndex);
                Iterable $this$any$iv = members2;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Member it = (Member)element$iv;
                        boolean bl2 = false;
                        if (!ArraysKt.contains((Object[])dimMembers, (Object)it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean containsDimension(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        for (Dimension dim : this.dimensions) {
            if (dim != dimension) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean test(@NotNull IDimensionKeys key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        boolean flag = true;
        Iterator<Member[]> iterator2 = ((SliceScopeV2Parser)this.parser.getValue()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2;
            Object[] members2 = iterator2.next();
            if (new DimensionFilter(this.dimensions[index2 = n++], ArraysKt.toMutableSet((Object[])members2)).match(key2)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    @Override
    @NotNull
    public Iterator<Member[]> iterator() {
        return ((SliceScopeV2Parser)this.parser.getValue()).iterator();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0086\u0002\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0013H\u0096\u0002R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/metadata/SliceScopeV2$SliceScopeV2Parser;", "", "", "Lkd/bos/olapServer2/metadata/Member;", "dimensions", "Lkd/bos/olapServer2/metadata/Dimension;", "data", "", "([Lkd/bos/olapServer2/metadata/Dimension;[B)V", "dimensionMembers", "", "encoding", "Lkd/bos/olapServer2/metadata/SliceScopeV2Encoding;", "get", "index", "", "Lkd/bos/olapServer2/common/int;", "(I)[Lkd/bos/olapServer2/metadata/Member;", "iterator", "", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nSliceScopeV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SliceScopeV2.kt\nkd/bos/olapServer2/metadata/SliceScopeV2$SliceScopeV2Parser\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,106:1\n32#2,2:107\n*S KotlinDebug\n*F\n+ 1 SliceScopeV2.kt\nkd/bos/olapServer2/metadata/SliceScopeV2$SliceScopeV2Parser\n*L\n92#1:107,2\n*E\n"})
    private static final class SliceScopeV2Parser
    implements Iterable<Member[]>,
    KMappedMarker {
        @NotNull
        private final SliceScopeV2Encoding<Dimension, Member> encoding;
        @NotNull
        private final List<Member[]> dimensionMembers;

        public SliceScopeV2Parser(@NotNull Dimension[] dimensions2, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)dimensions2, (String)"dimensions");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.encoding = new SliceScopeV2Encoding(dimensions2);
            this.dimensionMembers = new ArrayList();
            Iterator<Member[]> $this$forEach$iv = this.encoding.decode(data);
            boolean $i$f$forEach = false;
            Iterator<Member[]> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Member[] element$iv;
                Member[] members2 = element$iv = iterator2.next();
                boolean bl = false;
                this.dimensionMembers.add(members2);
            }
        }

        @Override
        @NotNull
        public Iterator<Member[]> iterator() {
            return this.dimensionMembers.iterator();
        }

        @NotNull
        public final Member[] get(int index2) {
            return this.dimensionMembers.get(index2);
        }
    }
}

