/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata;

import java.util.Arrays;
import java.util.List;
import kd.bos.olapServer2.common.CellSet;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.dataSources.MetadataItem;
import kd.bos.olapServer2.dataSources.TagMetadataItem;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.MemberCollection;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.metadata.TagDefinitionCollection;
import kd.bos.olapServer2.metadata.extend.Tag;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.tools.StringValidator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J&\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/metadata/TagMetadataCommand;", "", "metadataCmdInfo", "Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "(Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;Lkd/bos/olapServer2/storages/CubeWorkspace;)V", "addTag", "", "dimension", "Lkd/bos/olapServer2/metadata/Dimension;", "convertTo", "Lkotlin/Pair;", "Lkd/bos/olapServer2/metadata/extend/Tag;", "", "item", "Lkd/bos/olapServer2/dataSources/TagMetadataItem;", "execute", "Lkd/bos/olapServer2/common/CellSet;", "getMemberIds", "memberNames", "", "", "Lkd/bos/olapServer2/common/string;", "removeTag", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nTagMetadataCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TagMetadataCommand.kt\nkd/bos/olapServer2/metadata/TagMetadataCommand\n+ 2 MetadataItem.kt\nkd/bos/olapServer2/dataSources/MetadataItem$Companion\n*L\n1#1,80:1\n58#2,8:81\n58#2,8:89\n*S KotlinDebug\n*F\n+ 1 TagMetadataCommand.kt\nkd/bos/olapServer2/metadata/TagMetadataCommand\n*L\n38#1:81,8\n47#1:89,8\n*E\n"})
public final class TagMetadataCommand {
    @NotNull
    private final MetadataCommandInfo metadataCmdInfo;
    @NotNull
    private final CubeWorkspace cubeWorkspace;

    public TagMetadataCommand(@NotNull MetadataCommandInfo metadataCmdInfo, @NotNull CubeWorkspace cubeWorkspace) {
        Intrinsics.checkNotNullParameter((Object)metadataCmdInfo, (String)"metadataCmdInfo");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        this.metadataCmdInfo = metadataCmdInfo;
        this.cubeWorkspace = cubeWorkspace;
    }

    @Nullable
    public final CellSet execute() {
        if (!(this.metadataCmdInfo.getMetadataType() == MetadataTypes.Tag)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String cubeName = StringValidator.INSTANCE.validateOwnerUniqueName(this.cubeWorkspace.getMetadata(), this.metadataCmdInfo.getOwnerUniqueName(), MetadataTypes.Tag).get(0);
        if (!StringsKt.equals((String)this.cubeWorkspace.getMetadata().getName(), (String)cubeName, (boolean)true)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        Dimension dim = (Dimension)this.cubeWorkspace.getMetadata().getDimensions().get(this.metadataCmdInfo.getName());
        switch (WhenMappings.$EnumSwitchMapping$0[this.metadataCmdInfo.getAction().ordinal()]) {
            case 1: {
                this.addTag(dim);
                break;
            }
            case 2: {
                this.removeTag(dim);
                break;
            }
            default: {
                String string4 = Res.INSTANCE.getCommonException_7();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-CommonException_7>(...)");
                Object[] objectArray = new Object[]{this.metadataCmdInfo.getAction()};
                throw Res.INSTANCE.getRuntimeException(string4, objectArray);
            }
        }
        return null;
    }

    private final void addTag(Dimension dimension) {
        MetadataItem.Companion companion = MetadataItem.Companion;
        List<MetadataItem> $this$forEachItems$iv = this.metadataCmdInfo.getItems();
        boolean $i$f$forEachItems$bos_olap_core2 = false;
        for (MetadataItem item$iv : $this$forEachItems$iv) {
            if (item$iv instanceof TagMetadataItem) {
                TagMetadataItem item = (TagMetadataItem)item$iv;
                boolean bl = false;
                Pair<Tag, int[]> pair = this.convertTo(item, dimension);
                Tag tag = (Tag)pair.component1();
                int[] members2 = (int[])pair.component2();
                if (members2 == null) continue;
                dimension.getTags().add(tag, Arrays.copyOf(members2, members2.length));
                continue;
            }
            String string2 = Res.INSTANCE.getMemberMetadataCommandException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MemberMetadataCommandException_1>(...)");
            Object[] objectArray = new Object[]{item$iv.getClass()};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
    }

    private final void removeTag(Dimension dimension) {
        MetadataItem.Companion companion = MetadataItem.Companion;
        List<MetadataItem> $this$forEachItems$iv = this.metadataCmdInfo.getItems();
        boolean $i$f$forEachItems$bos_olap_core2 = false;
        for (MetadataItem item$iv : $this$forEachItems$iv) {
            if (item$iv instanceof TagMetadataItem) {
                TagMetadataItem item = (TagMetadataItem)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)item.getName(), (Object)"*")) {
                    int[] members2 = this.getMemberIds(item.getMembers(), dimension);
                    dimension.getTags().clear(members2);
                    continue;
                }
                Pair<Tag, int[]> pair = this.convertTo(item, dimension);
                Tag tag = (Tag)pair.component1();
                int[] members3 = (int[])pair.component2();
                if (members3 == null) continue;
                dimension.getTags().remove(tag, members3);
                continue;
            }
            String string2 = Res.INSTANCE.getMemberMetadataCommandException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MemberMetadataCommandException_1>(...)");
            Object[] objectArray = new Object[]{item$iv.getClass()};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
    }

    private final Pair<Tag, int[]> convertTo(TagMetadataItem item, Dimension dimension) {
        String tagName = item.getName();
        TagDefinitionCollection.Companion.validate(tagName);
        Tag tag = dimension.getTagDefinitions().get(tagName);
        int[] memberIds = this.getMemberIds(item.getMembers(), dimension);
        return new Pair((Object)tag, (Object)memberIds);
    }

    private final int[] getMemberIds(List<String> memberNames2, Dimension dimension) {
        int[] nArray;
        List<String> list2 = memberNames2;
        if (list2 != null) {
            List<String> m = list2;
            boolean bl = false;
            MemberCollection members2 = dimension.getMembers();
            int n = 0;
            int n2 = m.size();
            int[] nArray2 = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray2[n3] = members2.nameToIndex(m.get(n3));
            }
            nArray = nArray2;
        } else {
            nArray = null;
        }
        return nArray;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandTypes.values().length];
            try {
                nArray[CommandTypes.create.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandTypes.drop.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

