/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata.partitions;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionCollection;
import kd.bos.olapServer2.metadata.partitions.BaseAndCachePartitionMetadata;
import kd.bos.olapServer2.metadata.partitions.CombinedCubePartitionMetadata;
import kd.bos.olapServer2.metadata.partitions.EmptyCubePartitionMetadata;
import kd.bos.olapServer2.metadata.partitions.EmptyPartitionItem;
import kd.bos.olapServer2.metadata.partitions.EmptyPartitionItemCollection;
import kd.bos.olapServer2.metadata.partitions.ICubePartitionMetadata;
import kd.bos.olapServer2.metadata.partitions.IPartitionItem;
import kd.bos.olapServer2.metadata.partitions.IPartitionItemCollection;
import kd.bos.olapServer2.metadata.partitions.PartitionItemCollection;
import kd.bos.olapServer2.metadata.partitions.SubCubePartitionMetadata;
import kd.bos.olapServer2.storages.dynamicCalcAndStored.DSCacheDerivation;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eJ\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u000eJ\u0012\u0010$\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010#\u001a\u00020\u000eJ\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00060\u0016j\u0002`\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0015\u0010\u001e\u001a\u00060\u0016j\u0002`\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lkd/bos/olapServer2/metadata/partitions/PartitionCubeCollection;", "", "rootCube", "Lkd/bos/olapServer2/metadata/Cube;", "partition", "Lkd/bos/olapServer2/metadata/partitions/ICubePartitionMetadata;", "(Lkd/bos/olapServer2/metadata/Cube;Lkd/bos/olapServer2/metadata/partitions/ICubePartitionMetadata;)V", "_baseToCache", "", "_subCube", "", "[Lkd/bos/olapServer2/metadata/Cube;", "basePartitionItems", "", "Lkd/bos/olapServer2/metadata/partitions/IPartitionItem;", "getBasePartitionItems", "()Ljava/util/List;", "dsCacheDerivation", "Lkd/bos/olapServer2/storages/dynamicCalcAndStored/DSCacheDerivation;", "getDsCacheDerivation", "()Lkd/bos/olapServer2/storages/dynamicCalcAndStored/DSCacheDerivation;", "enabledDS", "", "Lkd/bos/olapServer2/common/bool;", "getEnabledDS", "()Z", "partitionItems", "Lkd/bos/olapServer2/metadata/partitions/IPartitionItemCollection;", "getPartitionItems", "()Lkd/bos/olapServer2/metadata/partitions/IPartitionItemCollection;", "requireDS", "getRequireDS", "getDSCachePartition", "basePartitionItem", "getPartitionCubeMetadata", "partitionItem", "isBasePartition", "realDimension", "Lkd/bos/olapServer2/metadata/DimensionCollection;", "key", "Ljava/util/BitSet;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nPartitionCubeCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartitionCubeCollection.kt\nkd/bos/olapServer2/metadata/partitions/PartitionCubeCollection\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,151:1\n26#2:152\n1855#3:153\n1855#3,2:154\n1856#3:156\n766#3:159\n857#3,2:160\n37#4,2:157\n*S KotlinDebug\n*F\n+ 1 PartitionCubeCollection.kt\nkd/bos/olapServer2/metadata/partitions/PartitionCubeCollection\n*L\n64#1:152\n89#1:153\n91#1:154,2\n89#1:156\n112#1:159\n112#1:160,2\n109#1:157,2\n*E\n"})
public final class PartitionCubeCollection {
    @NotNull
    private final Cube rootCube;
    @NotNull
    private final int[] _baseToCache;
    @NotNull
    private final Cube[] _subCube;
    @NotNull
    private final DSCacheDerivation dsCacheDerivation;
    private final boolean requireDS;
    @NotNull
    private final IPartitionItemCollection partitionItems;
    @NotNull
    private final List<IPartitionItem> basePartitionItems;

    /*
     * WARNING - void declaration
     */
    public PartitionCubeCollection(@NotNull Cube rootCube, @NotNull ICubePartitionMetadata partition) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Collection $this$toTypedArray$iv;
        PartitionCubeCollection partitionCubeCollection;
        Intrinsics.checkNotNullParameter((Object)rootCube, (String)"rootCube");
        Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
        this.rootCube = rootCube;
        this.dsCacheDerivation = new DSCacheDerivation(this.rootCube);
        this.requireDS = this.getEnabledDS();
        if (!(partition != SubCubePartitionMetadata.INSTANCE)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (partition == EmptyCubePartitionMetadata.INSTANCE) {
            if (this.requireDS) {
                this.partitionItems = PartitionItemCollection.Companion.create((ICubePartitionMetadata)BaseAndCachePartitionMetadata.INSTANCE);
                if (!(this.partitionItems.size() == 2)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                Object[] objectArray = new Cube[]{this.rootCube, this.rootCube};
                this._subCube = objectArray;
                objectArray = new int[2];
                objectArray[0] = (Cube)true;
                objectArray[1] = (Cube)-1;
                this._baseToCache = (int[])objectArray;
            } else {
                this.partitionItems = EmptyPartitionItemCollection.INSTANCE;
                boolean $i$f$emptyArray = false;
                this._subCube = new Cube[0];
                this._baseToCache = CommonTypesKt.getEmptyIntArray();
            }
        } else {
            int n;
            Object object2;
            int partitionSize;
            if (this.requireDS) {
                CombinedCubePartitionMetadata combinedPartitionMetadata = CombinedCubePartitionMetadata.Companion.combine(BaseAndCachePartitionMetadata.INSTANCE, partition);
                this.partitionItems = PartitionItemCollection.Companion.create(combinedPartitionMetadata);
                partitionSize = this.partitionItems.size();
                if (!(partitionSize % 2 == 0)) {
                    String string4 = "Failed requirement.";
                    throw new IllegalArgumentException(string4.toString());
                }
                int basePartitionCount = partitionSize / 2;
                object2 = new int[partitionSize];
                partitionCubeCollection = this;
                for (n = 0; n < partitionSize; ++n) {
                    int n2 = n;
                    object2[n2] = n2 < basePartitionCount ? n2 + basePartitionCount : -1;
                }
                partitionCubeCollection._baseToCache = object2;
            } else {
                this.partitionItems = PartitionItemCollection.Companion.create(partition);
                int combinedPartitionMetadata = 0;
                partitionSize = this.partitionItems.size();
                int[] basePartitionCount = new int[partitionSize];
                partitionCubeCollection = this;
                while (combinedPartitionMetadata < partitionSize) {
                    n = combinedPartitionMetadata++;
                    basePartitionCount[n] = Integer.MAX_VALUE;
                }
                partitionCubeCollection._baseToCache = basePartitionCount;
            }
            ArrayList<Cube> subCube = new ArrayList<Cube>(this.partitionItems.size());
            HashMap cubeMap = new HashMap(this.partitionItems.size());
            Iterable $this$forEach$iv = this.partitionItems;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                IPartitionItem item = (IPartitionItem)element$iv;
                boolean bl = false;
                BitSet key2 = new BitSet();
                Iterable $this$forEach$iv2 = item.getMarkDimensionsAndMembers();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Pair it = (Pair)element$iv2;
                    boolean bl2 = false;
                    key2.set(((Dimension)it.getFirst()).getPosition());
                }
                Cube existCube = (Cube)cubeMap.get(key2);
                if (existCube != null) {
                    subCube.add(existCube);
                    continue;
                }
                Cube $this$lambda_u242_u24lambda_u241 = this.rootCube;
                boolean bl3 = false;
                Cube newCube = new Cube($this$lambda_u242_u24lambda_u241.getXId(), $this$lambda_u242_u24lambda_u241.getName(), -1L, this.realDimension(key2, this.rootCube), $this$lambda_u242_u24lambda_u241.getMeasures(), $this$lambda_u242_u24lambda_u241.getProperties(), SubCubePartitionMetadata.INSTANCE, $this$lambda_u242_u24lambda_u241.getAggRules(), $this$lambda_u242_u24lambda_u241.getValidDataRules(), $this$lambda_u242_u24lambda_u241.getCubeDataScopes(), $this$lambda_u242_u24lambda_u241.getCubeDataLockScopes());
                ((Map)cubeMap).put(key2, newCube);
                subCube.add(newCube);
            }
            $this$toTypedArray$iv = subCube;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this._subCube = thisCollection$iv.toArray(new Cube[0]);
        }
        Iterable subCube = this.partitionItems;
        partitionCubeCollection = this;
        boolean $i$f$filter = false;
        $this$toTypedArray$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPartitionItem it = (IPartitionItem)element$iv$iv;
            boolean bl = false;
            if (!(this._baseToCache[it.getId()] >= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        partitionCubeCollection.basePartitionItems = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final DSCacheDerivation getDsCacheDerivation() {
        return this.dsCacheDerivation;
    }

    private final boolean getEnabledDS() {
        String value2;
        return CommonTypesKt.getDynamicCalcEnabled() && CommonTypesKt.getDynamicCalcAndStored() ? (StringsKt.isBlank((CharSequence)(value2 = this.rootCube.getProperties().get("enabledDS"))) ? false : Boolean.parseBoolean(value2)) : false;
    }

    public final boolean getRequireDS() {
        return this.requireDS;
    }

    @NotNull
    public final IPartitionItemCollection getPartitionItems() {
        return this.partitionItems;
    }

    @NotNull
    public final List<IPartitionItem> getBasePartitionItems() {
        return this.basePartitionItems;
    }

    private final DimensionCollection realDimension(BitSet key2, Cube rootCube) {
        int n;
        Cube $this$realDimension_u24lambda_u244 = rootCube;
        boolean bl = false;
        int firstMark = key2.nextSetBit(0);
        if (firstMark >= 0) {
            if (!(key2.nextClearBit(firstMark) == $this$realDimension_u24lambda_u244.getDimensions().getCount())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            n = firstMark;
        } else {
            n = $this$realDimension_u24lambda_u244.getDimensions().getCount();
        }
        int realDimensionCount = n;
        int n2 = 0;
        Dimension[] dimensionArray = new Dimension[realDimensionCount];
        while (n2 < realDimensionCount) {
            int n3 = n2++;
            dimensionArray[n3] = $this$realDimension_u24lambda_u244.getDimensions().get(n3);
        }
        String string3 = $this$realDimension_u24lambda_u244.getName();
        Dimension[] dimensionArray2 = dimensionArray;
        return new DimensionCollection(dimensionArray2, string3);
    }

    @NotNull
    public final IPartitionItem getDSCachePartition(@NotNull IPartitionItem basePartitionItem) {
        Intrinsics.checkNotNullParameter((Object)basePartitionItem, (String)"basePartitionItem");
        int dsCachePartitionId = this._baseToCache[basePartitionItem.getId()];
        if (!(dsCachePartitionId >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return dsCachePartitionId == Integer.MAX_VALUE ? (IPartitionItem)EmptyPartitionItem.INSTANCE : this.partitionItems.get(dsCachePartitionId);
    }

    public final boolean isBasePartition(@NotNull IPartitionItem partitionItem) {
        Intrinsics.checkNotNullParameter((Object)partitionItem, (String)"partitionItem");
        return this._baseToCache[partitionItem.getId()] >= 0;
    }

    @NotNull
    public final Cube getPartitionCubeMetadata(@NotNull IPartitionItem partitionItem) {
        Intrinsics.checkNotNullParameter((Object)partitionItem, (String)"partitionItem");
        return this._subCube[partitionItem.getId()];
    }
}

