/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata.xObjectStorages;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kd.bos.olapServer.dataAdapter.IMetadataReader;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.metadata.xObjectStorages.XField;
import kd.bos.olapServer2.metadata.xObjectStorages.XFieldType;
import kd.bos.olapServer2.metadata.xObjectStorages.XSystemFieldContainer;
import kd.bos.olapServer2.tools.JsonHelper;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010 \u001a\u00060!j\u0002`\"H\u0016R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\u0006j\u0002`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00060\u0006j\u0002`\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00060\u0006j\u0002`\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u0018\u0010\u0013\u001a\u00060\u0014j\u0002`\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lkd/bos/olapServer2/metadata/xObjectStorages/MetadataJsonReader;", "Lkd/bos/olapServer/dataAdapter/IMetadataReader;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "_fieldId", "", "Lkd/bos/olapServer2/common/int;", "_objectId", "_value", "", "fieldId", "getFieldId", "()I", "jsonParser", "Lcom/fasterxml/jackson/core/JsonParser;", "kotlin.jvm.PlatformType", "objectId", "getObjectId", "type", "", "Lkd/bos/olapServer2/common/string;", "getType", "()Ljava/lang/String;", "value", "getValue", "()Ljava/lang/Object;", "close", "", "convertFrom", "fieldType", "Lkd/bos/olapServer2/metadata/xObjectStorages/XFieldType;", "next", "", "Lkd/bos/olapServer2/common/bool;", "Companion", "bos-olap-core2"})
public final class MetadataJsonReader
implements IMetadataReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream inputStream;
    private final JsonParser jsonParser;
    private int _objectId;
    private int _fieldId;
    @Nullable
    private Object _value;
    @NotNull
    public static final String objectIdKey = "__id__";

    public MetadataJsonReader(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.inputStream = inputStream;
        this.jsonParser = JsonHelper.INSTANCE.getDefaultFactory().createParser(this.inputStream);
        this._objectId = -1;
        this._fieldId = -1;
    }

    public int getObjectId() {
        return this._objectId;
    }

    public int getFieldId() {
        return this._fieldId;
    }

    @Nullable
    public Object getValue() {
        return this._value;
    }

    @NotNull
    public String getType() {
        return "MetadataJsonReader.v1";
    }

    public boolean next() {
        if (this.jsonParser.isClosed()) {
            return false;
        }
        while (this.jsonParser.nextToken() != null) {
            Object object2;
            if (JsonToken.FIELD_NAME != this.jsonParser.getCurrentToken()) continue;
            String fieldName = this.jsonParser.getCurrentName();
            this.jsonParser.nextToken();
            if (Intrinsics.areEqual((Object)objectIdKey, (Object)fieldName)) {
                this._objectId = this.jsonParser.getValueAsInt();
                continue;
            }
            Intrinsics.checkNotNull((Object)fieldName);
            String[] stringArray = new String[]{":"};
            List splits = StringsKt.split$default((CharSequence)fieldName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            this._fieldId = Integer.parseInt((String)splits.get(0));
            XField field = XSystemFieldContainer.INSTANCE.tryGet(this._fieldId);
            if (field == null) {
                if (!(this._fieldId >= 10001)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                JsonParser jsonParser = this.jsonParser;
                Intrinsics.checkNotNullExpressionValue((Object)jsonParser, (String)"jsonParser");
                object2 = this.convertFrom(XFieldType.String, jsonParser);
            } else {
                XFieldType xFieldType = field.getType();
                JsonParser jsonParser = this.jsonParser;
                Intrinsics.checkNotNullExpressionValue((Object)jsonParser, (String)"jsonParser");
                object2 = this.convertFrom(xFieldType, jsonParser);
            }
            this._value = object2;
            return true;
        }
        return false;
    }

    private final Object convertFrom(XFieldType fieldType, JsonParser jsonParser) {
        Serializable serializable;
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[fieldType.ordinal()]) {
            case 1: {
                serializable = (Serializable)((Object)jsonParser.getValueAsString());
                break;
            }
            case 2: {
                serializable = Integer.valueOf(jsonParser.getValueAsInt());
                break;
            }
            case 3: {
                serializable = Integer.valueOf(jsonParser.getValueAsInt());
                break;
            }
            case 4: {
                JsonToken jsonToken = jsonParser.getCurrentToken();
                switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                    case 1: {
                        List res = new ArrayList();
                        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                            if (!(JsonToken.VALUE_NUMBER_INT == jsonParser.getCurrentToken())) {
                                String string2 = "Failed requirement.";
                                throw new IllegalArgumentException(string2.toString());
                            }
                            res.add(jsonParser.getValueAsInt());
                        }
                        serializable = (Serializable)CollectionsKt.toIntArray((Collection)res);
                        break block0;
                    }
                    case 2: {
                        serializable = Integer.valueOf(jsonParser.getValueAsInt());
                        break block0;
                    }
                }
                throw new RuntimeException("can not read field value from JsonParser, currentToken: " + jsonParser.getCurrentToken().name());
            }
            case 5: {
                serializable = (Serializable)jsonParser.getBinaryValue();
                break;
            }
            case 6: {
                serializable = Boolean.valueOf(jsonParser.getBooleanValue());
                break;
            }
            case 7: {
                serializable = UUID.fromString(jsonParser.getValueAsString());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Serializable serializable2 = serializable;
        Intrinsics.checkNotNull((Object)serializable2);
        return serializable2;
    }

    public void close() {
        this.jsonParser.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\u0004j\u0002`\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/metadata/xObjectStorages/MetadataJsonReader$Companion;", "", "()V", "objectIdKey", "", "create", "Lkd/bos/olapServer2/metadata/xObjectStorages/MetadataJsonReader;", "jsonMetadataFilePath", "Lkd/bos/olapServer2/common/string;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MetadataJsonReader create(@NotNull String jsonMetadataFilePath) {
            Intrinsics.checkNotNullParameter((Object)jsonMetadataFilePath, (String)"jsonMetadataFilePath");
            return new MetadataJsonReader(Paths.INSTANCE.createInputStream(jsonMetadataFilePath));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.START_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.VALUE_NUMBER_INT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[XFieldType.values().length];
            try {
                nArray[XFieldType.String.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XFieldType.Int32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XFieldType.XObject.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XFieldType.List.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XFieldType.ByteArray.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XFieldType.Boolean.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XFieldType.UUID.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

