/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata.xObjectStorages;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IntArrayByteBuffer;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.IntArrayOutputStream;
import kd.bos.olapServer2.metadata.builds.DiscretePointScopeBuilder;
import kd.bos.olapServer2.metadata.xObjectStorages.IntKeyValue;
import kd.bos.olapServer2.metadata.xObjectStorages.MetadataJsonReader;
import kd.bos.olapServer2.metadata.xObjectStorages.MetadataJsonTools;
import kd.bos.olapServer2.metadata.xObjectStorages.MetadataJsonWriter;
import kd.bos.olapServer2.metadata.xObjectStorages.XField;
import kd.bos.olapServer2.metadata.xObjectStorages.XFieldContainer;
import kd.bos.olapServer2.metadata.xObjectStorages.XFieldType;
import kd.bos.olapServer2.metadata.xObjectStorages.XObjectSession;
import kd.bos.olapServer2.metadata.xObjectStorages.XObjectStorage;
import kd.bos.olapServer2.metadata.xObjectStorages.XSystemFieldContainer;
import kd.bos.olapServer2.metadata.xObjectStorages.xFiles.XFileStorage;
import kd.bos.olapServer2.storages.IMetadataDatabase;
import kd.bos.olapServer2.storages.writers.MetadataWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007J,\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\f\b\u0002\u0010\n\u001a\u00060\u000bj\u0002`\fJ\u0016\u0010\u0003\u001a\u00020\u0004*\u00020\r2\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007J\u0016\u0010\u000e\u001a\u00020\u0004*\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/metadata/xObjectStorages/MetadataJsonTools;", "", "()V", "exportToJsonFile", "", "metadataPath", "", "Lkd/bos/olapServer2/common/string;", "jsonMetadataFilePath", "importFromJsonFile", "isOptimize", "", "Lkd/bos/olapServer2/common/bool;", "Lkd/bos/olapServer2/metadata/xObjectStorages/xFiles/XFileStorage;", "optimize", "Lkd/bos/olapServer2/storages/IMetadataDatabase;", "path", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nMetadataJsonTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataJsonTools.kt\nkd/bos/olapServer2/metadata/xObjectStorages/MetadataJsonTools\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,244:1\n1855#2:245\n1855#2,2:246\n1856#2:248\n11095#3:249\n11430#3,3:250\n13309#3,2:258\n13309#3,2:260\n13309#3,2:262\n13309#3,2:264\n13309#3,2:266\n1099#4,3:253\n215#5,2:256\n*S KotlinDebug\n*F\n+ 1 MetadataJsonTools.kt\nkd/bos/olapServer2/metadata/xObjectStorages/MetadataJsonTools\n*L\n46#1:245\n47#1:246,2\n46#1:248\n129#1:249\n129#1:250,3\n202#1:258,2\n212#1:260,2\n222#1:262,2\n227#1:264,2\n186#1:266,2\n151#1:253,3\n163#1:256,2\n*E\n"})
public final class MetadataJsonTools {
    @NotNull
    public static final MetadataJsonTools INSTANCE = new MetadataJsonTools();

    private MetadataJsonTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exportToJsonFile(@NotNull String metadataPath, @NotNull String jsonMetadataFilePath) {
        Intrinsics.checkNotNullParameter((Object)metadataPath, (String)"metadataPath");
        Intrinsics.checkNotNullParameter((Object)jsonMetadataFilePath, (String)"jsonMetadataFilePath");
        if (!Paths.INSTANCE.toFile(metadataPath).exists()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Closeable closeable = new XFileStorage(metadataPath, false);
        Throwable throwable = null;
        try {
            XFileStorage storage = (XFileStorage)closeable;
            boolean bl = false;
            XObjectSession.Companion.loadAll(storage).save(true);
            INSTANCE.exportToJsonFile(storage, jsonMetadataFilePath);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exportToJsonFile(@NotNull XFileStorage $this$exportToJsonFile, @NotNull String jsonMetadataFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$exportToJsonFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jsonMetadataFilePath, (String)"jsonMetadataFilePath");
        Closeable closeable = Paths.INSTANCE.createOutputStream(jsonMetadataFilePath);
        Throwable throwable = null;
        try {
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)((Object)new MetadataJsonWriter(outputStream, new XFieldContainer($this$exportToJsonFile)));
            Throwable throwable2 = null;
            try {
                MetadataJsonWriter writer = (MetadataJsonWriter)((Object)closeable2);
                boolean bl2 = false;
                Iterable<IntKeyValue<Iterable<IntKeyValue<Object>>>> $this$forEach$iv = $this$exportToJsonFile.getAllFieldValues();
                boolean $i$f$forEach = false;
                Iterator<IntKeyValue<Iterable<IntKeyValue<Object>>>> iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Iterable<IntKeyValue<Object>> objEntry;
                    IntKeyValue<Iterable<IntKeyValue<Object>>> element$iv;
                    IntKeyValue<Iterable<IntKeyValue<Object>>> intKeyValue = element$iv = iterator2.next();
                    boolean bl3 = false;
                    int objectId = intKeyValue.component1();
                    Iterable<IntKeyValue<Object>> $this$forEach$iv2 = objEntry = intKeyValue.component2();
                    boolean $i$f$forEach2 = false;
                    Iterator<IntKeyValue<Object>> iterator3 = $this$forEach$iv2.iterator();
                    while (iterator3.hasNext()) {
                        IntKeyValue<Object> element$iv2;
                        IntKeyValue<Object> intKeyValue2 = element$iv2 = iterator3.next();
                        boolean bl4 = false;
                        int fieldId = intKeyValue2.component1();
                        Object value2 = intKeyValue2.component2();
                        writer.write(objectId, fieldId, value2);
                    }
                }
                writer.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void importFromJsonFile(@NotNull String metadataPath, @NotNull String jsonMetadataFilePath, boolean isOptimize) {
        Intrinsics.checkNotNullParameter((Object)metadataPath, (String)"metadataPath");
        Intrinsics.checkNotNullParameter((Object)jsonMetadataFilePath, (String)"jsonMetadataFilePath");
        if (!Paths.INSTANCE.toFile(metadataPath).exists()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!Paths.INSTANCE.toFile(jsonMetadataFilePath).exists()) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        Closeable closeable = XObjectStorage.Companion.open(metadataPath, false);
        Throwable throwable = null;
        try {
            XObjectStorage storage = (XObjectStorage)closeable;
            boolean bl = false;
            Map objectIdRelationMap = new LinkedHashMap();
            Closeable closeable2 = (Closeable)((Object)MetadataJsonReader.Companion.create(jsonMetadataFilePath));
            Throwable throwable2 = null;
            try {
                MetadataJsonReader reader = (MetadataJsonReader)((Object)closeable2);
                boolean bl2 = false;
                Map piecewiseDimensionCountMap = new LinkedHashMap();
                Map piecewisePointMap = new LinkedHashMap();
                Closeable closeable3 = (Closeable)((Object)new MetadataWriter(metadataPath, (Function0<Unit>)((Function0)importFromJsonFile.1.1.1.INSTANCE)));
                Throwable throwable3 = null;
                try {
                    MetadataWriter writer = (MetadataWriter)((Object)closeable3);
                    boolean bl3 = false;
                    block21: while (reader.next()) {
                        Object object2;
                        XFieldType xFieldType;
                        int objectId = MetadataJsonTools.importFromJsonFile$lambda$13$getObjectId(isOptimize, objectIdRelationMap, storage, reader.getObjectId());
                        int fieldId = reader.getFieldId();
                        Object fieldValue = reader.getValue();
                        XField field = XSystemFieldContainer.INSTANCE.tryGet(fieldId);
                        if (field == null) {
                            if (!(fieldId >= 10001)) {
                                String string4 = "Failed requirement.";
                                throw new IllegalArgumentException(string4.toString());
                            }
                            xFieldType = XFieldType.String;
                        } else {
                            xFieldType = field.getType();
                        }
                        XFieldType fieldType = xFieldType;
                        switch (WhenMappings.$EnumSwitchMapping$0[fieldType.ordinal()]) {
                            case 1: {
                                Intrinsics.checkNotNull((Object)fieldValue, (String)"null cannot be cast to non-null type kotlin.Int{ kd.bos.olapServer2.common.CommonTypesKt.int }");
                                object2 = MetadataJsonTools.importFromJsonFile$lambda$13$getObjectId(isOptimize, objectIdRelationMap, storage, (Integer)fieldValue);
                                break;
                            }
                            case 2: {
                                Object $this$map$iv;
                                if (fieldValue instanceof int[]) {
                                    void $this$mapTo$iv$iv;
                                    $this$map$iv = (int[])fieldValue;
                                    boolean $i$f$map = false;
                                    int[] nArray = $this$map$iv;
                                    Collection destination$iv$iv = new ArrayList(((int[])$this$map$iv).length);
                                    boolean $i$f$mapTo = false;
                                    int n = ((void)$this$mapTo$iv$iv).length;
                                    for (int i = 0; i < n; ++i) {
                                        void it;
                                        void item$iv$iv;
                                        void var33_44 = item$iv$iv = $this$mapTo$iv$iv[i];
                                        Collection collection = destination$iv$iv;
                                        boolean bl4 = false;
                                        collection.add(MetadataJsonTools.importFromJsonFile$lambda$13$getObjectId(isOptimize, objectIdRelationMap, storage, (int)it));
                                    }
                                    int[] nArray2 = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
                                    object2 = new IntArrayOutputStream(nArray2);
                                    break;
                                }
                                object2 = fieldValue;
                                break;
                            }
                            case 3: {
                                Object $this$map$iv;
                                if (isOptimize && fieldId == DiscretePointScopeBuilder.Companion.getPOINTS_FIELD().getId()) {
                                    if (piecewiseDimensionCountMap.containsKey(objectId)) {
                                        Object v = piecewiseDimensionCountMap.get(objectId);
                                        Intrinsics.checkNotNull(v);
                                        int n = ((Number)v).intValue();
                                        Intrinsics.checkNotNull((Object)fieldValue, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                                        object2 = MetadataJsonTools.importFromJsonFile$lambda$13$dealByteArray(isOptimize, objectIdRelationMap, storage, n, (byte[])fieldValue);
                                        break;
                                    }
                                    $this$map$iv = objectId;
                                    Intrinsics.checkNotNull((Object)fieldValue, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                                    piecewisePointMap.put($this$map$iv, (byte[])fieldValue);
                                    continue block21;
                                }
                                object2 = fieldValue;
                                break;
                            }
                            case 4: {
                                Object $this$map$iv;
                                if (isOptimize && fieldId == DiscretePointScopeBuilder.Companion.getDIMENSIONS_FIELD().getId()) {
                                    void $this$count$iv;
                                    $this$map$iv = String.valueOf(fieldValue);
                                    boolean $i$f$count = false;
                                    int count$iv = 0;
                                    for (int i = 0; i < $this$count$iv.length(); ++i) {
                                        char element$iv;
                                        char it = element$iv = $this$count$iv.charAt(i);
                                        boolean bl5 = false;
                                        if (!(it == ',')) continue;
                                        ++count$iv;
                                    }
                                    int dimensionCount = count$iv + 1;
                                    Integer previousValue = piecewiseDimensionCountMap.put(objectId, dimensionCount);
                                    if (!(previousValue == null)) {
                                        String string5 = "Failed requirement.";
                                        throw new IllegalArgumentException(string5.toString());
                                    }
                                }
                                object2 = fieldValue;
                                break;
                            }
                            default: {
                                object2 = fieldValue;
                            }
                        }
                        Object realValue = object2;
                        writer.write(objectId, fieldId, realValue);
                    }
                    if (isOptimize && !piecewisePointMap.isEmpty()) {
                        Map $this$forEach$iv = piecewisePointMap;
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry entry = element$iv = iterator2.next();
                            boolean bl6 = false;
                            int objectId = ((Number)entry.getKey()).intValue();
                            byte[] byteArray = (byte[])entry.getValue();
                            int n = DiscretePointScopeBuilder.Companion.getPOINTS_FIELD().getId();
                            Object v = piecewiseDimensionCountMap.get(objectId);
                            Intrinsics.checkNotNull(v);
                            writer.write(objectId, n, MetadataJsonTools.importFromJsonFile$lambda$13$dealByteArray(isOptimize, objectIdRelationMap, storage, ((Number)v).intValue(), byteArray));
                        }
                    }
                    writer.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            storage.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void importFromJsonFile$default(MetadataJsonTools metadataJsonTools, String string2, String string3, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = false;
        }
        metadataJsonTools.importFromJsonFile(string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void optimize(@NotNull IMetadataDatabase $this$optimize, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$optimize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String tempPath = ITempFolder.Companion.getTempFolder().getAbsolutePath();
        Intrinsics.checkNotNull((Object)tempPath);
        File targetMetadataFolder = Files.createTempDirectory(Paths.INSTANCE.get(tempPath, new String[0]), "temp_metadata_optimize_", new FileAttribute[0]).toFile();
        File metadataBackupFolder = Files.createTempDirectory(Paths.INSTANCE.get(tempPath, new String[0]), "temp_metadata_backupDir_", new FileAttribute[0]).toFile();
        File metadataJsonFile = Files.createTempFile(Paths.INSTANCE.get(tempPath, new String[0]), "temp_metadata", "json", new FileAttribute[0]).toFile();
        try {
            File originFile;
            File element$iv;
            boolean $i$f$forEach;
            String[] $this$forEach$iv = $this$optimize.getFileNames();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv2;
                String metadataFileName = element$iv2 = $this$forEach$iv[i];
                boolean bl = false;
                File file = Paths.INSTANCE.toFile(path, metadataFileName);
                Intrinsics.checkNotNull((Object)metadataBackupFolder);
                FileUtils.copyFile((File)file, (File)Paths.INSTANCE.toFile(metadataBackupFolder, metadataFileName));
            }
            String string2 = metadataJsonFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            this.exportToJsonFile(path, string2);
            String string3 = targetMetadataFolder.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
            String string4 = metadataJsonFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
            this.importFromJsonFile(string3, string4, true);
            try {
                File[] fileArray = metadataBackupFolder.listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv2 = fileArray;
                    $i$f$forEach = false;
                    int n2 = $this$forEach$iv2.length;
                    for (n = 0; n < n2; ++n) {
                        File backupFile = element$iv = $this$forEach$iv2[n];
                        boolean bl = false;
                        String string5 = backupFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                        originFile = Paths.INSTANCE.toFile(path, string5);
                        FileUtils.delete((File)originFile);
                    }
                }
            }
            catch (Exception e) {
                Intrinsics.checkNotNull((Object)metadataBackupFolder);
                MetadataJsonTools.optimize$recoveryFromBackupFolder(metadataBackupFolder, path);
                throw e;
            }
            try {
                File[] fileArray = targetMetadataFolder.listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv3 = fileArray;
                    $i$f$forEach = false;
                    int n3 = $this$forEach$iv3.length;
                    for (n = 0; n < n3; ++n) {
                        File newFile = element$iv = $this$forEach$iv3[n];
                        boolean bl = false;
                        String string6 = newFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                        originFile = Paths.INSTANCE.toFile(path, string6);
                        FileUtils.copyFile((File)newFile, (File)originFile);
                    }
                }
            }
            catch (Exception e) {
                File[] fileArray = targetMetadataFolder.listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv4 = fileArray;
                    boolean $i$f$forEach3 = false;
                    int n4 = $this$forEach$iv4.length;
                    for (int i = 0; i < n4; ++i) {
                        File element$iv3;
                        File newFile = element$iv3 = $this$forEach$iv4[i];
                        boolean bl = false;
                        String string7 = newFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getName(...)");
                        File originFile2 = Paths.INSTANCE.toFile(path, string7);
                        if (!originFile2.exists()) continue;
                        FileUtils.delete((File)originFile2);
                    }
                }
                Intrinsics.checkNotNull((Object)metadataBackupFolder);
                MetadataJsonTools.optimize$recoveryFromBackupFolder(metadataBackupFolder, path);
                throw e;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("optimize error", e);
        }
        finally {
            FileUtils.deleteDirectory((File)targetMetadataFolder);
            FileUtils.deleteDirectory((File)metadataBackupFolder);
            FileUtils.delete((File)metadataJsonFile);
        }
    }

    private static final int importFromJsonFile$lambda$13$nextObjectId(XObjectStorage $storage) {
        return $storage.createObjectIntRange(1).getFirst();
    }

    private static final int importFromJsonFile$lambda$13$getObjectId(boolean $isOptimize, Map<Integer, Integer> objectIdRelationMap, XObjectStorage $storage, int sourceObjectId) {
        int n;
        if ($isOptimize && sourceObjectId >= 0) {
            Integer n2 = objectIdRelationMap.get(sourceObjectId);
            if (n2 != null) {
                n = n2;
            } else {
                int n3;
                int it = n3 = MetadataJsonTools.importFromJsonFile$lambda$13$nextObjectId($storage);
                boolean bl = false;
                Integer n4 = sourceObjectId;
                Integer n5 = it;
                objectIdRelationMap.put(n4, n5);
                n = n3;
            }
        } else {
            n = sourceObjectId;
        }
        return n;
    }

    private static final byte[] importFromJsonFile$lambda$13$dealByteArray(boolean $isOptimize, Map<Integer, Integer> objectIdRelationMap, XObjectStorage $storage, int dimensionCount, byte[] byteArray) {
        IntArrayByteBuffer zipData = new IntArrayByteBuffer(byteArray);
        if (!zipData.isEmpty()) {
            int index2 = 0;
            int n = index2 = dimensionCount;
            index2 = n + 1;
            int rowCount = zipData.get(n);
            for (n = 0; n < rowCount; ++n) {
                int it = n;
                boolean bl = false;
                int n2 = index2;
                index2 = n2 + 1;
                int columnCount = zipData.get(n2);
                n2 = 0;
                while (n2 < columnCount) {
                    int it2 = n2++;
                    boolean bl2 = false;
                    int xObjectId = zipData.get(index2 + it2);
                    zipData.set(index2 + it2, MetadataJsonTools.importFromJsonFile$lambda$13$getObjectId($isOptimize, objectIdRelationMap, $storage, xObjectId));
                }
                index2 += columnCount;
            }
        }
        return byteArray;
    }

    private static final void optimize$recoveryFromBackupFolder(File metadataBackupFolder, String path) {
        block1: {
            File[] fileArray = metadataBackupFolder.listFiles();
            if (fileArray == null) break block1;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File backupFile = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                String string2 = backupFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                File originFile = Paths.INSTANCE.toFile(path, string2);
                if (originFile.exists()) continue;
                FileUtils.copyFile((File)backupFile, (File)originFile);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[XFieldType.values().length];
            try {
                nArray[XFieldType.XObject.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XFieldType.List.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XFieldType.ByteArray.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XFieldType.String.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

