/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.metadata.xObjectStorages;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import java.io.OutputStream;
import java.util.UUID;
import kd.bos.olapServer.dataAdapter.IMetadataWriter;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.metadata.xObjectStorages.XField;
import kd.bos.olapServer2.metadata.xObjectStorages.XFieldContainer;
import kd.bos.olapServer2.tools.JsonHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J*\u0010\u0014\u001a\u00020\u00122\n\u0010\u0015\u001a\u00060\bj\u0002`\t2\n\u0010\u0016\u001a\u00060\bj\u0002`\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer2/metadata/xObjectStorages/MetadataJsonWriter;", "Lkd/bos/olapServer/dataAdapter/IMetadataWriter;", "outputStream", "Ljava/io/OutputStream;", "fields", "Lkd/bos/olapServer2/metadata/xObjectStorages/XFieldContainer;", "(Ljava/io/OutputStream;Lkd/bos/olapServer2/metadata/xObjectStorages/XFieldContainer;)V", "_lastObjectId", "", "Lkd/bos/olapServer2/common/int;", "jsonGen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "kotlin.jvm.PlatformType", "type", "", "getType", "()Ljava/lang/String;", "close", "", "flush", "write", "objectId", "fieldId", "value", "", "Companion", "bos-olap-core2"})
public final class MetadataJsonWriter
implements IMetadataWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XFieldContainer fields;
    private int _lastObjectId;
    private final JsonGenerator jsonGen;

    public MetadataJsonWriter(@NotNull OutputStream outputStream, @NotNull XFieldContainer fields2) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)fields2, (String)"fields");
        this.fields = fields2;
        this._lastObjectId = -1;
        this.jsonGen = JsonHelper.INSTANCE.getDefaultFactory().createGenerator(outputStream).setRootValueSeparator((SerializableString)new SerializedString("")).enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        this.jsonGen.writeStartArray();
    }

    public void write(int objectId, int fieldId, @Nullable Object value2) {
        if (this._lastObjectId != objectId) {
            if (this._lastObjectId != -1) {
                this.jsonGen.writeEndObject();
            }
            this.jsonGen.writeStartObject();
            this.jsonGen.writeFieldName("__id__");
            this.jsonGen.writeNumber(objectId);
        }
        XField field = this.fields.getField(fieldId);
        this.jsonGen.writeFieldName("" + fieldId + ':' + field.getName());
        Object object2 = value2;
        if (object2 instanceof String) {
            this.jsonGen.writeString((String)value2);
        } else if (object2 instanceof Integer) {
            this.jsonGen.writeNumber(((Number)value2).intValue());
        } else if (object2 instanceof int[]) {
            this.jsonGen.writeArray((int[])value2, 0, ((int[])value2).length);
        } else if (object2 instanceof byte[]) {
            this.jsonGen.writeBinary((byte[])value2);
        } else if (object2 instanceof Boolean) {
            this.jsonGen.writeBoolean(((Boolean)value2).booleanValue());
        } else if (object2 instanceof UUID) {
            this.jsonGen.writeString(((UUID)value2).toString());
        } else if (object2 == null) {
            this.jsonGen.writeNull();
        } else {
            throw new NotSupportedException();
        }
        this._lastObjectId = objectId;
    }

    @NotNull
    public String getType() {
        return "MetadataJsonWriter.v1";
    }

    public void flush() {
        this.jsonGen.writeEndObject();
        this.jsonGen.writeEndArray();
        this.jsonGen.flush();
    }

    public void close() {
        this.jsonGen.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer2/metadata/xObjectStorages/MetadataJsonWriter$Companion;", "", "()V", "create", "Lkd/bos/olapServer2/metadata/xObjectStorages/MetadataJsonWriter;", "jsonMetadataFilePath", "", "Lkd/bos/olapServer2/common/string;", "fields", "Lkd/bos/olapServer2/metadata/xObjectStorages/XFieldContainer;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MetadataJsonWriter create(@NotNull String jsonMetadataFilePath, @NotNull XFieldContainer fields2) {
            Intrinsics.checkNotNullParameter((Object)jsonMetadataFilePath, (String)"jsonMetadataFilePath");
            Intrinsics.checkNotNullParameter((Object)fields2, (String)"fields");
            return new MetadataJsonWriter(Paths.INSTANCE.createOutputStream(jsonMetadataFilePath), fields2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

