/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.monitorReports;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.PlainHealthReport;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\f\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0010\u001a\u00020\u00062\n\u0010\u0011\u001a\u00060\rj\u0002`\u000e2\u000e\u0010\u0012\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000eJ\u0012\u0010\u0013\u001a\u00020\u00062\n\u0010\u0014\u001a\u00060\rj\u0002`\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/monitorReports/OlapHealthReportContainer;", "", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "(Lkd/bos/olapServer2/storages/OlapWorkspace;)V", "commit", "", "healthReport", "Lkd/bos/olapServer2/monitorReports/HealthReport;", "getReports", "", "Lkd/bos/olapServer2/monitorReports/PlainHealthReport;", "excludeTag", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)[Lkd/bos/olapServer2/monitorReports/PlainHealthReport;", "solveById", "id", "cubeName", "solveByTag", "tag", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nOlapHealthReportContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapHealthReportContainer.kt\nkd/bos/olapServer2/monitorReports/OlapHealthReportContainer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,57:1\n37#2,2:58\n*S KotlinDebug\n*F\n+ 1 OlapHealthReportContainer.kt\nkd/bos/olapServer2/monitorReports/OlapHealthReportContainer\n*L\n55#1:58,2\n*E\n"})
public final class OlapHealthReportContainer {
    @NotNull
    private final OlapWorkspace olapWorkspace;

    public OlapHealthReportContainer(@NotNull OlapWorkspace olapWorkspace) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        this.olapWorkspace = olapWorkspace;
    }

    public final void commit(@NotNull HealthReport healthReport) {
        Intrinsics.checkNotNullParameter((Object)healthReport, (String)"healthReport");
        String cubeName = healthReport.getCube();
        if (cubeName == null) {
            this.olapWorkspace.getHealthReports().commit(healthReport);
        } else {
            this.olapWorkspace.getCubeWorkspace(cubeName).getHealthReports().commit(healthReport);
        }
    }

    public final void solveById(@NotNull String id, @Nullable String cubeName) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (cubeName == null) {
            this.olapWorkspace.getHealthReports().solveById(id);
        } else {
            this.olapWorkspace.getCubeWorkspace(cubeName).getHealthReports().solveById(id);
        }
    }

    public final void solveByTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.olapWorkspace.getHealthReports().solveByTag(tag);
    }

    @NotNull
    public final PlainHealthReport[] getReports(@NotNull String excludeTag) {
        Intrinsics.checkNotNullParameter((Object)excludeTag, (String)"excludeTag");
        ArrayList reports = new ArrayList();
        CollectionsKt.addAll((Collection)reports, (Object[])this.olapWorkspace.getHealthReports().getReports(excludeTag));
        for (CubeWorkspace workspace : this.olapWorkspace.getLoadedWorkspaces$bos_olap_core2()) {
            CollectionsKt.addAll((Collection)reports, (Object[])workspace.getHealthReports().getReports(excludeTag));
        }
        Collection $this$toTypedArray$iv = reports;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PlainHealthReport[0]);
    }
}

