/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.performanceStatistics;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.dataSources.AggExpression;
import kd.bos.olapServer2.dataSources.ComputingCommandInfo;
import kd.bos.olapServer2.dataSources.DimensionFilterItem;
import kd.bos.olapServer2.dataSources.DragonLambdaExpression;
import kd.bos.olapServer2.dataSources.SelectCommandInfo;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.OlapMetadata;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.FileTools;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010F\u001a\u00020GH\u0016J\u0014\u0010H\u001a\u00020\f2\n\u0010I\u001a\u00060Jj\u0002`KH\u0002J\u0014\u0010L\u001a\u00020\f2\n\u0010I\u001a\u00060Jj\u0002`KH\u0002J\u001a\u0010M\u001a\b\u0012\u0004\u0012\u00020N0\u000b2\n\u0010I\u001a\u00060Jj\u0002`KH\u0002J\b\u0010O\u001a\u00020GH\u0002J#\u0010P\u001a\u00060\u0003j\u0002`\u00042\u0010\u0010Q\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0013H\u0002\u00a2\u0006\u0002\u0010RR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0018\u0010\u0015R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u001c\u0010\u0015R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0019\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b+\u0010\u0015R\u0019\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b-\u0010\u0015R\u0019\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b/\u0010\u0015R\u0019\u00100\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b1\u0010\u0015R\u0019\u00102\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b3\u0010\u0015R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0019\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b;\u0010\u0015R\u0019\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b=\u0010\u0015R\u0019\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b?\u0010\u0015R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u001fR\u0019\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\bC\u0010\u0015R\u0019\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\bE\u0010\u0015\u00a8\u0006S"}, d2={"Lkd/bos/olapServer2/performanceStatistics/BenchmarkDataProvider;", "Ljava/io/Closeable;", "benchmarkPath", "", "Lkd/bos/olapServer2/common/string;", "onlyUnitTest", "", "Lkd/bos/olapServer2/common/bool;", "(Ljava/lang/String;Z)V", "_closeProvider", "_computingCommandInfos", "", "Lkd/bos/olapServer2/dataSources/ComputingCommandInfo;", "_computingFelCommandInfos", "_cubeName", "_mainMeaName", "_selectCommandInfos", "Lkd/bos/olapServer2/dataSources/SelectCommandInfo;", "accounts", "", "getAccounts", "()[Ljava/lang/String;", "[Ljava/lang/String;", "auditTrails", "getAuditTrails", "getBenchmarkPath", "()Ljava/lang/String;", "changeTypes", "getChangeTypes", "computingCommandInfos", "getComputingCommandInfos", "()Ljava/util/List;", "computingFelCommandInfos", "getComputingFelCommandInfos", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "getCube", "()Lkd/bos/olapServer2/metadata/Cube;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "getCubeWorkspace", "()Lkd/bos/olapServer2/storages/CubeWorkspace;", "currencies", "getCurrencies", "dataSorts", "getDataSorts", "entities", "getEntities", "internalCompanys", "getInternalCompanys", "multiGAAPs", "getMultiGAAPs", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "getOlapWorkspace", "()Lkd/bos/olapServer2/storages/OlapWorkspace;", "getOnlyUnitTest", "()Z", "periods", "getPeriods", "process", "getProcess", "scenarios", "getScenarios", "selectCommandInfos", "getSelectCommandInfos", "versions", "getVersions", "years", "getYears", "close", "", "createAggComputingCommand", "entityIndex", "", "Lkd/bos/olapServer2/common/int;", "createFelComputingCommand", "createFilter", "Lkd/bos/olapServer2/dataSources/DimensionFilterItem;", "deleteCubeData", "joinMembers", "names", "([Ljava/lang/String;)Ljava/lang/String;", "bos-olap-core2"})
public final class BenchmarkDataProvider
implements Closeable {
    @NotNull
    private final String benchmarkPath;
    private final boolean onlyUnitTest;
    @NotNull
    private final String _cubeName;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final Cube cube;
    @NotNull
    private final String[] accounts;
    @NotNull
    private final String[] entities;
    @NotNull
    private final String[] years;
    @NotNull
    private final String[] periods;
    @NotNull
    private final String[] scenarios;
    @NotNull
    private final String[] process;
    @NotNull
    private final String[] currencies;
    @NotNull
    private final String[] auditTrails;
    @NotNull
    private final String[] changeTypes;
    @NotNull
    private final String[] internalCompanys;
    @NotNull
    private final String[] multiGAAPs;
    @NotNull
    private final String[] dataSorts;
    @NotNull
    private final String[] versions;
    @NotNull
    private final String _mainMeaName;
    @NotNull
    private final List<SelectCommandInfo> _selectCommandInfos;
    @NotNull
    private final List<ComputingCommandInfo> _computingCommandInfos;
    @NotNull
    private final List<ComputingCommandInfo> _computingFelCommandInfos;
    private boolean _closeProvider;

    public BenchmarkDataProvider(@NotNull String benchmarkPath, boolean onlyUnitTest) {
        int n;
        Intrinsics.checkNotNullParameter((Object)benchmarkPath, (String)"benchmarkPath");
        this.benchmarkPath = benchmarkPath;
        this.onlyUnitTest = onlyUnitTest;
        this._cubeName = "cubeBenchmarkTest";
        int n2 = 0;
        String[] stringArray = new String[10000];
        BenchmarkDataProvider benchmarkDataProvider = this;
        while (n2 < 10000) {
            n = n2++;
            stringArray[n] = "account" + n;
        }
        benchmarkDataProvider.accounts = stringArray;
        n2 = 0;
        stringArray = new String[1000];
        benchmarkDataProvider = this;
        while (n2 < 1000) {
            n = n2++;
            stringArray[n] = "entity" + n;
        }
        benchmarkDataProvider.entities = stringArray;
        String[] stringArray2 = new String[]{"FY2018", "FY2019", "FY2020", "FY2021", "FY2022"};
        this.years = stringArray2;
        int n3 = 0;
        stringArray = new String[12];
        benchmarkDataProvider = this;
        while (n3 < 12) {
            n = n3++;
            stringArray[n] = "M_M" + n;
        }
        benchmarkDataProvider.periods = stringArray;
        String[] stringArray3 = new String[]{"QRpt", "FRpt"};
        this.scenarios = stringArray3;
        stringArray3 = new String[]{"CC", "EJE", "EICA", "EIT"};
        this.process = stringArray3;
        stringArray3 = new String[]{"EC", "PC", "CNY", "HKD", "USD"};
        this.currencies = stringArray3;
        stringArray3 = new String[]{"ATTotal", "DataCollection", "EntityInput", "ADJE", "CWP"};
        this.auditTrails = stringArray3;
        stringArray3 = new String[]{"EndingBalance", "YTD", "CurrentPeriod", "BBOY", "BFLY"};
        this.changeTypes = stringArray3;
        int n4 = 0;
        stringArray = new String[5000];
        benchmarkDataProvider = this;
        while (n4 < 5000) {
            n = n4++;
            stringArray[n] = "internalCompany" + n;
        }
        benchmarkDataProvider.internalCompanys = stringArray;
        String[] stringArray4 = new String[]{"PRCGAAP", "HKGAAP"};
        this.multiGAAPs = stringArray4;
        stringArray4 = new String[]{"Budget", "CRate"};
        this.dataSorts = stringArray4;
        stringArray4 = new String[]{"V1", "V2"};
        this.versions = stringArray4;
        String indexJson = "\n            {\n                \"cubes\":[\"" + this._cubeName + "\"]\n            }\n            ";
        String accountsJson = "{\n            \"name\": \"Account\",\n            \"defaultMemberName\": \"\",\n            \"continuousData\": false,\n            \"dataFormat\": \"dk\",\n            \"indexFormat\": \"mv3\",\n            \"allowNull\": false,\n            \"members\":[" + this.joinMembers(this.accounts) + "]\n        }";
        String entityJson = "{\n\t\t\"name\": \"Entity\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.entities) + "]\n\t}";
        String yearJson = "{\n\t\t\"name\": \"Year\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": true,\n\t\t\"dataFormat\": \"rk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.years) + "]\n\t}";
        String periodJson = "{\n\t\t\"name\": \"Period\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": true,\n\t\t\"dataFormat\": \"rk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.periods) + "]\n\t}";
        String scenarioJson = "{\n\t\t\"name\": \"Scenario\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": true,\n\t\t\"dataFormat\": \"rk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.scenarios) + "]\n\t}";
        String processJson = "{\n\t\t\"name\": \"Process\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.process) + "]\n\t}";
        String currencyJson = "{\n\t\t\"name\": \"Currency\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": true,\n\t\t\"dataFormat\": \"rk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.currencies) + "]\n\t}";
        String auditTrailJson = "{\n\t\t\"name\": \"AuditTrail\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.auditTrails) + "]\n\t}";
        String changeTypeJson = "{\n\t\t\"name\": \"ChangeType\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.changeTypes) + "]\n\t}";
        String internalCompanyJson = "{\n\t\t\"name\": \"InternalCompany\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.internalCompanys) + "]\n\t}";
        String multiGAAPJson = "{\n\t\t\"name\": \"MultiGAAP\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.multiGAAPs) + "]\n\t}";
        String dataSortJson = "{\n\t\t\"name\": \"DataSort\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.dataSorts) + "]\n\t}";
        String versionJson = "{\n\t\t\"name\": \"Version\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.versions) + "]\n\t}";
        String measureJson = "\n       \"measures\": [{\n\t\t\"name\": \"FMONEY\",\n\t\t\"dataType\": \"object\",\n\t\t\"allowNull\": true,\n\t\t\"dataFormat\": \"object\",\n\t\t\"isList\": false\n\t}]";
        String partitionsJson = ",\n            \"partition\":{\n            \"type\" : \"dimensionPartition.v1\",\n            \"dimensions\" : [\"Year\", \"Entity\"]\n        }\n        ";
        String[] stringArray5 = new StringBuilder();
        stringArray5.append("\n\t\t   {\n\t\t\t\"name\": \"").append(this._cubeName).append("\",\n\t\t\t\"dimensions\":[").append(accountsJson).append(",\n\t\t\t").append(entityJson).append(",\n\t\t\t").append(yearJson).append(",\n\t\t\t").append(periodJson).append(",\n\t\t\t").append(scenarioJson).append(",\n\t\t\t").append(processJson).append(",\n\t\t\t").append(currencyJson).append(",\n\t\t\t").append(auditTrailJson).append(",\n\t\t\t").append(changeTypeJson).append(",\n\t\t\t").append(internalCompanyJson).append(",\n\t\t\t");
        stringArray5.append(multiGAAPJson).append(",\n\t\t\t").append(dataSortJson).append(",\n\t\t\t").append(versionJson).append("\n\t\t\t],\n\t\t\t").append(measureJson).append("\n            ").append(partitionsJson).append("\n\t\t   }\n\t\t");
        String totalJson = stringArray5.toString();
        stringArray5 = new String[]{"index.json"};
        Files.write(Paths.INSTANCE.get(this.benchmarkPath, stringArray5), (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)indexJson), new OpenOption[0]);
        File cubeFolderFile = Paths.INSTANCE.toFile(this.benchmarkPath, this._cubeName);
        cubeFolderFile.mkdirs();
        String string2 = cubeFolderFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        String[] stringArray6 = new String[]{"cube.json"};
        Files.write(Paths.INSTANCE.get(string2, stringArray6), (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)totalJson), new OpenOption[0]);
        OlapMetadata olapMetadata = OlapMetadata.Companion.ReadFrom(this.benchmarkPath);
        this.olapWorkspace = new OlapWorkspace(olapMetadata, this.benchmarkPath);
        this.cubeWorkspace = this.olapWorkspace.getCubeWorkspace(this._cubeName);
        this.cube = this.cubeWorkspace.getMetadata();
        this._mainMeaName = "FMONEY";
        this._selectCommandInfos = new ArrayList();
        this._computingCommandInfos = new ArrayList();
        this._computingFelCommandInfos = new ArrayList();
        this._closeProvider = true;
    }

    @NotNull
    public final String getBenchmarkPath() {
        return this.benchmarkPath;
    }

    public final boolean getOnlyUnitTest() {
        return this.onlyUnitTest;
    }

    @NotNull
    public final OlapWorkspace getOlapWorkspace() {
        return this.olapWorkspace;
    }

    @NotNull
    public final CubeWorkspace getCubeWorkspace() {
        return this.cubeWorkspace;
    }

    @NotNull
    public final Cube getCube() {
        return this.cube;
    }

    @NotNull
    public final String[] getAccounts() {
        return this.accounts;
    }

    @NotNull
    public final String[] getEntities() {
        return this.entities;
    }

    @NotNull
    public final String[] getYears() {
        return this.years;
    }

    @NotNull
    public final String[] getPeriods() {
        return this.periods;
    }

    @NotNull
    public final String[] getScenarios() {
        return this.scenarios;
    }

    @NotNull
    public final String[] getProcess() {
        return this.process;
    }

    @NotNull
    public final String[] getCurrencies() {
        return this.currencies;
    }

    @NotNull
    public final String[] getAuditTrails() {
        return this.auditTrails;
    }

    @NotNull
    public final String[] getChangeTypes() {
        return this.changeTypes;
    }

    @NotNull
    public final String[] getInternalCompanys() {
        return this.internalCompanys;
    }

    @NotNull
    public final String[] getMultiGAAPs() {
        return this.multiGAAPs;
    }

    @NotNull
    public final String[] getDataSorts() {
        return this.dataSorts;
    }

    @NotNull
    public final String[] getVersions() {
        return this.versions;
    }

    private final String joinMembers(String[] names) {
        StringBuilder sb = new StringBuilder();
        for (String name2 : names) {
            if (((CharSequence)sb).length() > 0) {
                sb.append(",");
            }
            sb.append("{\"name\": \"" + name2 + "\",\"id\": \"" + UUID.randomUUID() + "\"}");
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final List<SelectCommandInfo> getSelectCommandInfos() {
        if (this._selectCommandInfos.isEmpty()) {
            String measureName = ((Measure)this.cube.getMeasures().get(0)).getName();
            for (String entityMember : (String[])ArraysKt.sliceArray((Object[])this.entities, (IntRange)RangesKt.until((int)0, (int)50))) {
                SelectCommandInfo selectCommand = new SelectCommandInfo();
                Object object2 = new String[]{"Process", "Account", "InternalCompany"};
                selectCommand.addDims((String[])object2);
                for (Dimension dim : this.cube.getDimensions()) {
                    if (Intrinsics.areEqual((Object)dim.getName(), (Object)"Account") || Intrinsics.areEqual((Object)dim.getName(), (Object)"Process") || Intrinsics.areEqual((Object)dim.getName(), (Object)"Entity") || Intrinsics.areEqual((Object)dim.getName(), (Object)"InternalCompany")) continue;
                    String[] stringArray = new String[]{dim.getMembers().get(0).getName()};
                    selectCommand.addFilter(dim.getName(), stringArray);
                }
                object2 = (String[])ArraysKt.sliceArray((Object[])this.accounts, (IntRange)RangesKt.until((int)100, (int)200));
                selectCommand.addFilter("Account", (String[])Arrays.copyOf(object2, ((Object)object2).length));
                object2 = new String[]{entityMember};
                selectCommand.addFilter("Entity", (String[])object2);
                object2 = new String[]{measureName};
                selectCommand.addMeasures((String[])object2);
                this._selectCommandInfos.add(selectCommand);
            }
        }
        return this._selectCommandInfos;
    }

    @NotNull
    public final List<ComputingCommandInfo> getComputingCommandInfos() {
        if (this._computingCommandInfos.isEmpty()) {
            List<ComputingCommandInfo> $this$_get_computingCommandInfos__u24lambda_u240 = this._computingCommandInfos;
            boolean bl = false;
            int n = Math.min(CommonTypesKt.getAvailableProcessors(), this.entities.length);
            for (int i = 0; i < n; ++i) {
                $this$_get_computingCommandInfos__u24lambda_u240.add(this.createAggComputingCommand(i));
            }
        }
        return this._computingCommandInfos;
    }

    private final List<DimensionFilterItem> createFilter(int entityIndex) {
        List filter2 = new ArrayList();
        DimensionFilterItem.Companion $this$createFilter_u24lambda_u241 = DimensionFilterItem.Companion;
        boolean bl = false;
        String[] stringArray = new String[]{this.entities[entityIndex]};
        $this$createFilter_u24lambda_u241.addFilter$bos_olap_core2(filter2, "Entity", stringArray);
        stringArray = new String[]{this.years[0]};
        $this$createFilter_u24lambda_u241.addFilter$bos_olap_core2(filter2, "Year", stringArray);
        stringArray = new String[]{this.periods[0], this.periods[1]};
        $this$createFilter_u24lambda_u241.addFilter$bos_olap_core2(filter2, "Period", stringArray);
        stringArray = new String[]{this.scenarios[0]};
        $this$createFilter_u24lambda_u241.addFilter$bos_olap_core2(filter2, "Scenario", stringArray);
        stringArray = new String[]{this.currencies[0]};
        $this$createFilter_u24lambda_u241.addFilter$bos_olap_core2(filter2, "Currency", stringArray);
        stringArray = new String[]{this.auditTrails[0]};
        $this$createFilter_u24lambda_u241.addFilter$bos_olap_core2(filter2, "AuditTrail", stringArray);
        stringArray = new String[]{this.changeTypes[0]};
        $this$createFilter_u24lambda_u241.addFilter$bos_olap_core2(filter2, "ChangeType", stringArray);
        stringArray = new String[]{this.multiGAAPs[0]};
        $this$createFilter_u24lambda_u241.addFilter$bos_olap_core2(filter2, "MultiGAAP", stringArray);
        stringArray = new String[]{this.dataSorts[0]};
        $this$createFilter_u24lambda_u241.addFilter$bos_olap_core2(filter2, "DataSort", stringArray);
        stringArray = new String[]{this.versions[0]};
        $this$createFilter_u24lambda_u241.addFilter$bos_olap_core2(filter2, "Version", stringArray);
        return filter2;
    }

    @NotNull
    public final List<ComputingCommandInfo> getComputingFelCommandInfos() {
        if (this._computingFelCommandInfos.isEmpty()) {
            List<ComputingCommandInfo> $this$_get_computingFelCommandInfos__u24lambda_u242 = this._computingFelCommandInfos;
            boolean bl = false;
            int n = Math.min(CommonTypesKt.getAvailableProcessors(), this.entities.length);
            for (int i = 0; i < n; ++i) {
                $this$_get_computingFelCommandInfos__u24lambda_u242.add(this.createFelComputingCommand(i));
            }
        }
        return this._computingFelCommandInfos;
    }

    /*
     * WARNING - void declaration
     */
    private final ComputingCommandInfo createFelComputingCommand(int entityIndex) {
        void $this$createFelComputingCommand_u24lambda_u245;
        DragonLambdaExpression $this$createFelComputingCommand_u24lambda_u244;
        DragonLambdaExpression $this$createFelComputingCommand_u24lambda_u243;
        DragonLambdaExpression dragonLambdaExpression;
        ComputingCommandInfo cmd = new ComputingCommandInfo();
        cmd.setMainDimName("Account");
        cmd.setMainMeaName(this._mainMeaName);
        cmd.setFilter(this.createFilter(entityIndex));
        DragonLambdaExpression dragonLambdaExpression2 = dragonLambdaExpression = new DragonLambdaExpression();
        ComputingCommandInfo computingCommandInfo = cmd;
        boolean bl = false;
        $this$createFelComputingCommand_u24lambda_u243.setExpressLeft(this.accounts[10]);
        $this$createFelComputingCommand_u24lambda_u243.setExpression("v('Account." + this.accounts[11] + "')==0?0:v('Account." + this.accounts[12] + "')/v('Account." + this.accounts[11] + "')");
        computingCommandInfo.addExpression(dragonLambdaExpression);
        $this$createFelComputingCommand_u24lambda_u243 = dragonLambdaExpression = new DragonLambdaExpression();
        computingCommandInfo = cmd;
        boolean bl2 = false;
        $this$createFelComputingCommand_u24lambda_u244.setExpressLeft(this.accounts[20]);
        $this$createFelComputingCommand_u24lambda_u244.setExpression("v('Account." + this.accounts[21] + "')==0?0:v('Account." + this.accounts[22] + "')/v('Account." + this.accounts[21] + "')");
        computingCommandInfo.addExpression(dragonLambdaExpression);
        $this$createFelComputingCommand_u24lambda_u244 = dragonLambdaExpression = new DragonLambdaExpression();
        computingCommandInfo = cmd;
        boolean bl3 = false;
        $this$createFelComputingCommand_u24lambda_u245.setExpressLeft(this.accounts[30]);
        $this$createFelComputingCommand_u24lambda_u245.setExpression("v('Account." + this.accounts[31] + "')==0?0:v('Account." + this.accounts[32] + "')/v('Account." + this.accounts[31] + "')");
        computingCommandInfo.addExpression(dragonLambdaExpression);
        return cmd;
    }

    private final ComputingCommandInfo createAggComputingCommand(int entityIndex) {
        ComputingCommandInfo command = new ComputingCommandInfo();
        command.setMainDimName("Account");
        command.setMainMeaName(this._mainMeaName);
        command.setFilter(this.createFilter(entityIndex));
        String[][] stringArrayArray = new String[][]{ArraysKt.sliceArray((Object[])this.accounts, (IntRange)RangesKt.until((int)0, (int)21)), ArraysKt.sliceArray((Object[])this.accounts, (IntRange)RangesKt.until((int)1000, (int)1021)), ArraysKt.sliceArray((Object[])this.accounts, (IntRange)RangesKt.until((int)2000, (int)2021)), ArraysKt.sliceArray((Object[])this.accounts, (IntRange)RangesKt.until((int)3000, (int)3021)), ArraysKt.sliceArray((Object[])this.accounts, (IntRange)RangesKt.until((int)4000, (int)4021))};
        String[][] aggItems = stringArrayArray;
        int n = ((Object[])aggItems).length;
        for (int i = 0; i < n; ++i) {
            String[] memberArray = aggItems[i];
            AggExpression expressionItem = new AggExpression();
            expressionItem.setExpressLeft(memberArray[0]);
            int n2 = memberArray.length;
            for (int i2 = 1; i2 < n2; ++i2) {
                expressionItem.add(memberArray[i2]);
            }
            command.getExpressionItems().add(expressionItem);
        }
        return command;
    }

    private final void deleteCubeData() {
        String[] stringArray = new String[]{this._cubeName};
        FileTools.INSTANCE.deleteDir(PathsKt.fileSafeConstructor(((Object)Paths.INSTANCE.get(this.benchmarkPath, stringArray)).toString()));
        stringArray = new String[]{"index.json"};
        PathsKt.fileSafeConstructor(((Object)Paths.INSTANCE.get(this.benchmarkPath, stringArray)).toString()).delete();
    }

    @Override
    public void close() {
        if (this._closeProvider) {
            this.cubeWorkspace.close();
            this.olapWorkspace.close();
            this.deleteCubeData();
            this._closeProvider = false;
        }
    }
}

