/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.performanceStatistics;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.ICancellable;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.dataSources.ComputingCommandInfo;
import kd.bos.olapServer2.dataSources.SelectCommandInfo;
import kd.bos.olapServer2.performanceStatistics.BenchmarkContext;
import kd.bos.olapServer2.performanceStatistics.BenchmarkDataProvider;
import kd.bos.olapServer2.performanceStatistics.BenchmarkTask;
import kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder;
import kd.bos.olapServer2.performanceStatistics.BenchmarkThroughput;
import kd.bos.olapServer2.performanceStatistics.CommandStatisticsItem;
import kd.bos.olapServer2.performanceStatistics.ComputingBenchmarkTask;
import kd.bos.olapServer2.performanceStatistics.CubeBenchmarkTask;
import kd.bos.olapServer2.performanceStatistics.ICommandStatistics;
import kd.bos.olapServer2.performanceStatistics.IOBenchmarkTask;
import kd.bos.olapServer2.performanceStatistics.QueryBenchmarkTask;
import kd.bos.olapServer2.performanceStatistics.RunLengthBenchmarkTask;
import kd.bos.olapServer2.performanceStatistics.StandardCommandStatistics;
import kd.bos.olapServer2.performanceStatistics.UpdateBenchmarkTask;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 :2\u00020\u0001:\u0001:B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u001e\u0010\u001c\u001a\u00060\u0013j\u0002`\u001d2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u0013j\u0002`\u001d0\u001fH\u0002J>\u0010\u001c\u001a\u00060\u0013j\u0002`\u001d\"\u0004\b\u0000\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H 0\"2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u0002H \u0012\b\u0012\u00060\u0013j\u0002`\u001d0\"H\u0002J$\u0010#\u001a\u00060\u0013j\u0002`\u001d2\n\u0010$\u001a\u00060\u0013j\u0002`\u001d2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u001dH\u0002J\b\u0010%\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020\u001aH\u0002J\b\u0010'\u001a\u00020\u001aH\u0002J<\u0010(\u001a\u00060\u0013j\u0002`\u001d2\n\u0010)\u001a\u00060\rj\u0002`*2\n\u0010+\u001a\u00060\rj\u0002`*2\u0016\u0010!\u001a\u0012\u0012\b\u0012\u00060\rj\u0002`*\u0012\u0004\u0012\u00020,0\"H\u0002J \u0010(\u001a\u00060\u0013j\u0002`\u001d2\u0006\u0010-\u001a\u00020,2\n\u0010+\u001a\u00060\rj\u0002`*H\u0002J \u0010.\u001a\u00060\u0013j\u0002`\u001d2\u0006\u0010-\u001a\u00020,2\n\u0010+\u001a\u00060\rj\u0002`*H\u0002J\b\u0010/\u001a\u00020\u001aH\u0002J<\u00100\u001a\u00060\u0013j\u0002`\u001d2\u0006\u0010-\u001a\u0002012\n\u0010+\u001a\u00060\rj\u0002`*2\f\u00102\u001a\b\u0012\u0004\u0012\u000201032\f\b\u0002\u00104\u001a\u00060\u0006j\u0002`\u0007H\u0002J\b\u00105\u001a\u00020\u001aH\u0002J\u0006\u00106\u001a\u00020\u001aJ\b\u00107\u001a\u00020\u001aH\u0002J\b\u00108\u001a\u00020\u001aH\u0002J\b\u00109\u001a\u00020\u001aH\u0002R\u0012\u0010\t\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lkd/bos/olapServer2/performanceStatistics/BenchmarkTaskBuilder;", "Ljava/io/Closeable;", "databasePath", "", "Lkd/bos/olapServer2/common/string;", "onlyUnitTest", "", "Lkd/bos/olapServer2/common/bool;", "(Ljava/lang/String;Z)V", "benchmarkRootPath", "benchmarkThroughput", "Lkd/bos/olapServer2/performanceStatistics/BenchmarkThroughput;", "bigDataCount", "", "ctx", "Lkd/bos/olapServer2/performanceStatistics/BenchmarkContext;", "getCtx$bos_olap_core2", "()Lkd/bos/olapServer2/performanceStatistics/BenchmarkContext;", "dataCount", "", "dataProvider", "Lkd/bos/olapServer2/performanceStatistics/BenchmarkDataProvider;", "needSpaceSize", "smallDataCount", "updateCount", "aggComputingBenchmarkRunTask", "", "close", "commandMultiThread", "Lkd/bos/olapServer2/common/long;", "body", "Lkotlin/Function0;", "T", "createTask", "Lkotlin/Function1;", "computingThroughput", "time", "cpuRunBenchmarkTask", "felComputingBenchmarkRunTask", "ioRunBenchmarkTask", "measureAverageThroughout", "taskCount", "Lkd/bos/olapServer2/common/int;", "runCount", "Lkd/bos/olapServer2/performanceStatistics/BenchmarkTask;", "task", "measureTaskThroughout", "memoryRunBenchmarkTask", "multiThread", "Lkd/bos/olapServer2/performanceStatistics/RunLengthBenchmarkTask;", "taskList", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "isRandom", "queryBenchmarkTask", "run", "saveResult", "updateBenchmarkTask", "writeBenchmarkTask", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nBenchmarkTaskBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BenchmarkTaskBuilder.kt\nkd/bos/olapServer2/performanceStatistics/BenchmarkTaskBuilder\n+ 2 OlapContext.kt\nkd/bos/olapServer2/common/OlapContext$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,509:1\n120#2,6:510\n1855#3,2:516\n1855#3,2:518\n1855#3,2:520\n1855#3,2:522\n1855#3,2:524\n31#4,6:526\n*S KotlinDebug\n*F\n+ 1 BenchmarkTaskBuilder.kt\nkd/bos/olapServer2/performanceStatistics/BenchmarkTaskBuilder\n*L\n139#1:510,6\n234#1:516,2\n267#1:518,2\n268#1:520,2\n357#1:522,2\n423#1:524,2\n485#1:526,6\n*E\n"})
public final class BenchmarkTaskBuilder
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String databasePath;
    private final boolean onlyUnitTest;
    @NotNull
    private final String benchmarkRootPath;
    private final long dataCount;
    private final long updateCount;
    private final int smallDataCount;
    private final int bigDataCount;
    private final long needSpaceSize;
    @NotNull
    private final BenchmarkDataProvider dataProvider;
    @NotNull
    private final BenchmarkContext ctx;
    @NotNull
    private final BenchmarkThroughput benchmarkThroughput;
    @NotNull
    private static final CommandStatisticsItem writeCube = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "WriteCube");
    @NotNull
    private static final CommandStatisticsItem updateCube = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "UpdateCube");
    @NotNull
    private static final CommandStatisticsItem signThreadSelect = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "SingThreadSelect");
    @NotNull
    private static final CommandStatisticsItem multiThreadSelect = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "MultiThreadSelect");
    @NotNull
    private static final CommandStatisticsItem singleThreadAggComputing = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "SingleThreadAggComputing");
    @NotNull
    private static final CommandStatisticsItem multiThreadAggComputing = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "MultiThreadAggComputing");
    @NotNull
    private static final CommandStatisticsItem singleThreadFelComputing = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "SingleThreadFelComputing");
    @NotNull
    private static final CommandStatisticsItem multiThreadFelComputing = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "MultiThreadFelComputing");
    @NotNull
    private static final CommandStatisticsItem singleThreadCPU = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "SingleThreadCPU");
    @NotNull
    private static final CommandStatisticsItem multiThreadCPU = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "MultiThreadCPU");
    @NotNull
    private static final CommandStatisticsItem singleThreadRandomMemory = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "SingleThreadRandomMemory");
    @NotNull
    private static final CommandStatisticsItem multiThreadRandomMemory = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "MultiThreadRandomMemory");
    @NotNull
    private static final CommandStatisticsItem singleThreadOrderMemory = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "SingleThreadOrderMemory");
    @NotNull
    private static final CommandStatisticsItem multiThreadOrderMemory = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "MultiThreadOrderMemory");
    @NotNull
    private static final CommandStatisticsItem singleThreadIO = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "SingleThreadIO");
    @NotNull
    private static final CommandStatisticsItem multiThreadIO = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "MultiThreadIO");
    @NotNull
    private static final CommandStatisticsItem writeResult = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "WriteResult");
    @NotNull
    private static final CommandStatisticsItem endTask = kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder$Companion.access$newItem(Companion, "EndTask");

    public BenchmarkTaskBuilder(@NotNull String databasePath, boolean onlyUnitTest) {
        long freeSpace;
        Intrinsics.checkNotNullParameter((Object)databasePath, (String)"databasePath");
        this.databasePath = databasePath;
        this.onlyUnitTest = onlyUnitTest;
        this.dataCount = this.onlyUnitTest ? 50000L : 60000000L;
        this.updateCount = this.onlyUnitTest ? 10000L : 30000000L;
        this.smallDataCount = this.onlyUnitTest ? 36 : 360000;
        this.bigDataCount = this.onlyUnitTest ? 360 : 36000000;
        this.needSpaceSize = 0x800000000L;
        if (!this.onlyUnitTest && (freeSpace = ITempFolder.Companion.getTempFolder().getFreeSpace()) < this.needSpaceSize) {
            String string2 = Res.INSTANCE.getNotEnoughDiskSpace();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-NotEnoughDiskSpace>(...)");
            Object[] objectArray = new Object[]{freeSpace / (long)(1024 * 1024 * 1024) + "GB", this.needSpaceSize / (long)(1024 * 1024 * 1024) + "GB"};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        String string3 = ITempFolder.Companion.createTempDirectory$default(ITempFolder.Companion, null, 1, null).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        this.benchmarkRootPath = string3;
        this.dataProvider = new BenchmarkDataProvider(this.benchmarkRootPath, this.onlyUnitTest);
        this.benchmarkThroughput = new BenchmarkThroughput();
        this.ctx = new BenchmarkContext(this.dataProvider, this.benchmarkThroughput);
    }

    @NotNull
    public final BenchmarkContext getCtx$bos_olap_core2() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void run() {
        void this_$iv;
        OlapContext.Companion companion = OlapContext.Companion;
        ICommandStatistics context$iv = StandardCommandStatistics.INSTANCE.createCommandStatistics();
        boolean $i$f$withContext = false;
        try {
            this_$iv.push(context$iv);
            boolean bl = false;
            this.writeBenchmarkTask();
            this.updateBenchmarkTask();
            this.queryBenchmarkTask();
            this.aggComputingBenchmarkRunTask();
            this.felComputingBenchmarkRunTask();
            this.dataProvider.close();
            this.cpuRunBenchmarkTask();
            this.memoryRunBenchmarkTask();
            this.ioRunBenchmarkTask();
            this.saveResult();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.pop(context$iv);
        }
    }

    private final void saveResult() {
        this.ctx.reportTimeState(writeResult);
        String rootPath = ((Object)Paths.INSTANCE.get(this.databasePath, new String[0]).getParent()).toString();
        String[] stringArray = new String[]{"olaplogs", "profile"};
        String dirPath = ((Object)Paths.INSTANCE.get(rootPath, stringArray)).toString();
        FileTools.INSTANCE.autoMakeDir(dirPath);
        String string2 = JsonHelper.INSTANCE.getMapper().writeValueAsString((Object)this.benchmarkThroughput);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
        stringArray = new String[]{"benchmark.profile"};
        FileTools.INSTANCE.writeToFile(string2, ((Object)Paths.INSTANCE.get(dirPath, stringArray)).toString());
    }

    private final void writeBenchmarkTask() {
        this.ctx.reportTimeState(writeCube);
        String string2 = Res.INSTANCE.getCubeBenchmarkTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CubeBenchmarkTaskName>(...)");
        CubeBenchmarkTask cubeBenchmarkTask = new CubeBenchmarkTask(string2, this.ctx, this.dataCount);
        this.benchmarkThroughput.setWriteTime(this.measureTaskThroughout(cubeBenchmarkTask, 1));
    }

    private final void updateBenchmarkTask() {
        this.ctx.reportTimeState(updateCube);
        String string2 = Res.INSTANCE.getCubeBenchmarkTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CubeBenchmarkTaskName>(...)");
        UpdateBenchmarkTask updateBenchmarkTask = new UpdateBenchmarkTask(string2, this.ctx, this.updateCount);
        this.benchmarkThroughput.setUpdateTime(this.measureTaskThroughout(updateBenchmarkTask, 1));
    }

    private final void queryBenchmarkTask() {
        List<SelectCommandInfo> selectCommandInfos = this.dataProvider.getSelectCommandInfos();
        int taskCount = selectCommandInfos.size();
        int runCount = this.onlyUnitTest ? 5 : 200;
        this.ctx.reportTimeState(signThreadSelect);
        this.benchmarkThroughput.setQueryThroughput(this.measureAverageThroughout(taskCount, runCount, (Function1<? super Integer, ? extends BenchmarkTask>)((Function1)new Function1<Integer, BenchmarkTask>(selectCommandInfos, this){
            final /* synthetic */ List<SelectCommandInfo> $selectCommandInfos;
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            {
                this.$selectCommandInfos = $selectCommandInfos;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final BenchmarkTask invoke(int it) {
                String string2 = Res.INSTANCE.getQueryBenchmarkTaskName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-QueryBenchmarkTaskName>(...)");
                return new QueryBenchmarkTask(string2, this.$selectCommandInfos.get(it), this.this$0.getCtx$bos_olap_core2());
            }
        })));
        this.ctx.reportTimeState(multiThreadSelect);
        this.benchmarkThroughput.setMultiQueryThroughput(this.commandMultiThread((Function0<Long>)((Function0)new Function0<Long>(this, taskCount, runCount, selectCommandInfos){
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            final /* synthetic */ int $taskCount;
            final /* synthetic */ int $runCount;
            final /* synthetic */ List<SelectCommandInfo> $selectCommandInfos;
            {
                this.this$0 = $receiver;
                this.$taskCount = $taskCount;
                this.$runCount = $runCount;
                this.$selectCommandInfos = $selectCommandInfos;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return BenchmarkTaskBuilder.access$measureAverageThroughout(this.this$0, this.$taskCount, this.$runCount, (Function1)new Function1<Integer, BenchmarkTask>(this.$selectCommandInfos, this.this$0){
                    final /* synthetic */ List<SelectCommandInfo> $selectCommandInfos;
                    final /* synthetic */ BenchmarkTaskBuilder this$0;
                    {
                        this.$selectCommandInfos = $selectCommandInfos;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final BenchmarkTask invoke(int it) {
                        String string2 = Res.INSTANCE.getQueryBenchmarkTaskName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-QueryBenchmarkTaskName>(...)");
                        return new QueryBenchmarkTask(string2, this.$selectCommandInfos.get(it), this.this$0.getCtx$bos_olap_core2());
                    }
                });
            }
        })));
    }

    private final long measureAverageThroughout(int taskCount, int runCount, Function1<? super Integer, ? extends BenchmarkTask> createTask) {
        long throughput = 0L;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)taskCount);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            throughput += this.measureAverageThroughout((BenchmarkTask)createTask.invoke((Object)it), runCount);
        }
        return throughput / (long)taskCount;
    }

    private final <T> long commandMultiThread(Function1<? super Integer, ? extends T> createTask, Function1<? super T, Long> body) {
        Thread it;
        List threadArray = new ArrayList();
        AtomicLong multiThroughout = new AtomicLong();
        Ref.ObjectRef exception = new Ref.ObjectRef();
        int threadCount = this.onlyUnitTest ? Math.max(1, CommonTypesKt.getAvailableProcessors() / 2) : CommonTypesKt.getAvailableProcessors();
        for (int i = 0; i < threadCount; ++i) {
            OlapContext olapContext = OlapContext.Companion.getCurrentContext();
            Thread t2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(olapContext, createTask, i, body, multiThroughout, this, (Ref.ObjectRef<Throwable>)exception){
                final /* synthetic */ OlapContext $olapContext;
                final /* synthetic */ Function1<Integer, T> $createTask;
                final /* synthetic */ int $i;
                final /* synthetic */ Function1<T, Long> $body;
                final /* synthetic */ AtomicLong $multiThroughout;
                final /* synthetic */ BenchmarkTaskBuilder this$0;
                final /* synthetic */ Ref.ObjectRef<Throwable> $exception;
                {
                    this.$olapContext = $olapContext;
                    this.$createTask = $createTask;
                    this.$i = $i;
                    this.$body = $body;
                    this.$multiThroughout = $multiThroughout;
                    this.this$0 = $receiver;
                    this.$exception = $exception;
                    super(0);
                }

                public final void invoke() {
                    OlapContext.Companion.newContext(this.$olapContext, (Function0)new Function0<Unit>(this.$createTask, this.$i, this.$body, this.$multiThroughout){
                        final /* synthetic */ Function1<Integer, T> $createTask;
                        final /* synthetic */ int $i;
                        final /* synthetic */ Function1<T, Long> $body;
                        final /* synthetic */ AtomicLong $multiThroughout;
                        {
                            this.$createTask = $createTask;
                            this.$i = $i;
                            this.$body = $body;
                            this.$multiThroughout = $multiThroughout;
                            super(0);
                        }

                        public final void invoke() {
                            Object task = this.$createTask.invoke((Object)this.$i);
                            long throughout = ((Number)this.$body.invoke(task)).longValue();
                            this.$multiThroughout.addAndGet(throughout);
                        }
                    }, (Function1)new Function1<Throwable, Unit>(this.this$0, this.$exception){
                        final /* synthetic */ BenchmarkTaskBuilder this$0;
                        final /* synthetic */ Ref.ObjectRef<Throwable> $exception;
                        {
                            this.this$0 = $receiver;
                            this.$exception = $exception;
                            super(1);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke(@NotNull Throwable e) {
                            block4: {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                BenchmarkTaskBuilder benchmarkTaskBuilder = this.this$0;
                                Ref.ObjectRef<Throwable> objectRef = this.$exception;
                                BenchmarkTaskBuilder benchmarkTaskBuilder2 = benchmarkTaskBuilder;
                                synchronized (benchmarkTaskBuilder2) {
                                    boolean bl = false;
                                    if (objectRef.element == null) {
                                        objectRef.element = e;
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                ICancellable iCancellable = OlapContext.Companion.tryGetContext(ICancellable.class);
                                if (iCancellable == null) break block4;
                                iCancellable.cancel(e);
                            }
                        }
                    });
                }
            }), (int)30, null);
            threadArray.add(t2);
        }
        Iterable $this$forEach$iv = threadArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Thread)element$iv;
            boolean bl = false;
            it.start();
        }
        $this$forEach$iv = threadArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Thread)element$iv;
            boolean bl = false;
            it.join();
        }
        Throwable cex2 = (Throwable)exception.element;
        if (cex2 != null) {
            throw cex2;
        }
        return multiThroughout.get();
    }

    private final long commandMultiThread(Function0<Long> body) {
        return this.commandMultiThread(commandMultiThread.3.INSTANCE, (Function1)new Function1<Object, Long>(body){
            final /* synthetic */ Function0<Long> $body;
            {
                this.$body = $body;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Long)this.$body.invoke();
            }
        });
    }

    private final void aggComputingBenchmarkRunTask() {
        List<ComputingCommandInfo> computingCommandInfos = this.dataProvider.getComputingCommandInfos();
        int runCount = this.onlyUnitTest ? 5 : 200;
        this.ctx.reportTimeState(singleThreadAggComputing);
        String string2 = Res.INSTANCE.getComputingBenchmarkTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ComputingBenchmarkTaskName>(...)");
        this.benchmarkThroughput.setAggComputingThroughput(this.measureAverageThroughout(new ComputingBenchmarkTask(string2, computingCommandInfos.get(0), this.ctx), runCount));
        this.ctx.reportTimeState(multiThreadAggComputing);
        this.benchmarkThroughput.setMultiAggComputingThroughput(this.commandMultiThread((Function1)new Function1<Integer, ComputingBenchmarkTask>(computingCommandInfos, this){
            final /* synthetic */ List<ComputingCommandInfo> $computingCommandInfos;
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            {
                this.$computingCommandInfos = $computingCommandInfos;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ComputingBenchmarkTask invoke(int threadIndex) {
                String string2 = Res.INSTANCE.getComputingBenchmarkTaskName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ComputingBenchmarkTaskName>(...)");
                return new ComputingBenchmarkTask(string2, this.$computingCommandInfos.get(threadIndex), this.this$0.getCtx$bos_olap_core2());
            }
        }, (Function1)new Function1<ComputingBenchmarkTask, Long>(this, runCount){
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            final /* synthetic */ int $runCount;
            {
                this.this$0 = $receiver;
                this.$runCount = $runCount;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull ComputingBenchmarkTask task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                return BenchmarkTaskBuilder.access$measureAverageThroughout(this.this$0, task, this.$runCount);
            }
        }));
    }

    private final void felComputingBenchmarkRunTask() {
        List<ComputingCommandInfo> computingCommandInfos = this.dataProvider.getComputingFelCommandInfos();
        int runCount = this.onlyUnitTest ? 5 : 200;
        this.ctx.reportTimeState(singleThreadFelComputing);
        String string2 = Res.INSTANCE.getComputingBenchmarkTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ComputingBenchmarkTaskName>(...)");
        this.benchmarkThroughput.setFelComputingThroughput(this.measureAverageThroughout(new ComputingBenchmarkTask(string2, computingCommandInfos.get(0), this.ctx), runCount));
        this.ctx.reportTimeState(multiThreadFelComputing);
        this.benchmarkThroughput.setMultiFelComputingThroughput(this.commandMultiThread((Function1)new Function1<Integer, ComputingBenchmarkTask>(computingCommandInfos, this){
            final /* synthetic */ List<ComputingCommandInfo> $computingCommandInfos;
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            {
                this.$computingCommandInfos = $computingCommandInfos;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ComputingBenchmarkTask invoke(int threadIndex) {
                String string2 = Res.INSTANCE.getComputingBenchmarkTaskName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ComputingBenchmarkTaskName>(...)");
                return new ComputingBenchmarkTask(string2, this.$computingCommandInfos.get(threadIndex), this.this$0.getCtx$bos_olap_core2());
            }
        }, (Function1)new Function1<ComputingBenchmarkTask, Long>(this, runCount){
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            final /* synthetic */ int $runCount;
            {
                this.this$0 = $receiver;
                this.$runCount = $runCount;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull ComputingBenchmarkTask task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                return BenchmarkTaskBuilder.access$measureAverageThroughout(this.this$0, task, this.$runCount);
            }
        }));
    }

    private final void cpuRunBenchmarkTask() {
        String string2 = Res.INSTANCE.getMultiCPUBenchmarkTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MultiCPUBenchmarkTaskName>(...)");
        RunLengthBenchmarkTask task = new RunLengthBenchmarkTask(string2, this.ctx, this.smallDataCount, true, this.smallDataCount, false, 32, null);
        ConcurrentLinkedQueue<RunLengthBenchmarkTask> taskList = new ConcurrentLinkedQueue<RunLengthBenchmarkTask>();
        taskList.add(task);
        this.ctx.reportTimeState(singleThreadCPU);
        this.benchmarkThroughput.setCpuThroughput(this.measureAverageThroughout(task, 1));
        this.ctx.reportTimeState(multiThreadCPU);
        this.benchmarkThroughput.setMultiCPUThroughput(BenchmarkTaskBuilder.multiThread$default(this, task, 1, taskList, false, 8, null));
        Iterable $this$forEach$iv = taskList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RunLengthBenchmarkTask it = (RunLengthBenchmarkTask)element$iv;
            boolean bl = false;
            it.close();
        }
    }

    private final long computingThroughput(long time2, long dataCount) {
        return dataCount * 1000000000L / time2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ioRunBenchmarkTask() {
        String string2 = Res.INSTANCE.getMultiIOBenchmarkTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MultiIOBenchmarkTaskName>(...)");
        Closeable closeable = new IOBenchmarkTask(string2, new AtomicInteger(), this.ctx);
        Throwable throwable = null;
        try {
            IOBenchmarkTask it = (IOBenchmarkTask)closeable;
            boolean bl = false;
            this.ctx.reportTimeState(singleThreadIO);
            this.benchmarkThroughput.setIoOrderThroughput(this.measureAverageThroughout(it, 1));
            this.ctx.reportTimeState(multiThreadIO);
            this.benchmarkThroughput.setMultiIoOrderThroughput(this.commandMultiThread((Function1)new Function1<Integer, IOBenchmarkTask>(it){
                final /* synthetic */ IOBenchmarkTask $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final IOBenchmarkTask invoke(int n) {
                    return this.$it.clone();
                }
            }, (Function1)new Function1<IOBenchmarkTask, Long>(this){
                final /* synthetic */ BenchmarkTaskBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Long invoke(@NotNull IOBenchmarkTask newTask) {
                    Intrinsics.checkNotNullParameter((Object)newTask, (String)"newTask");
                    return BenchmarkTaskBuilder.access$measureAverageThroughout(this.this$0, newTask, 1);
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void memoryRunBenchmarkTask() {
        String string2 = Res.INSTANCE.getMultiMemoryBenchmarkTaskNmae();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-MultiMemoryBenchmarkTaskNmae>(...)");
        RunLengthBenchmarkTask task = new RunLengthBenchmarkTask(string2, this.ctx, this.bigDataCount, false, this.bigDataCount, true);
        ConcurrentLinkedQueue<RunLengthBenchmarkTask> taskList = new ConcurrentLinkedQueue<RunLengthBenchmarkTask>();
        taskList.add(task);
        try {
            this.ctx.reportTimeState(singleThreadRandomMemory);
            this.benchmarkThroughput.setMemoryRandomThroughput(this.measureAverageThroughout(task, 1));
            this.ctx.reportTimeState(multiThreadRandomMemory);
            this.benchmarkThroughput.setMultiMemoryRandomThroughput(BenchmarkTaskBuilder.multiThread$default(this, task, 1, taskList, false, 8, null));
            this.ctx.reportTimeState(singleThreadOrderMemory);
            RunLengthBenchmarkTask orderTask = task.clone(false);
            taskList.add(orderTask);
            this.benchmarkThroughput.setMemoryOrderThroughput(this.measureAverageThroughout(orderTask, 1));
            this.ctx.reportTimeState(multiThreadOrderMemory);
            this.benchmarkThroughput.setMultiMemoryOrderThroughput(this.multiThread(task, 1, taskList, false));
        }
        finally {
            Iterable $this$forEach$iv = taskList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RunLengthBenchmarkTask it = (RunLengthBenchmarkTask)element$iv;
                boolean bl = false;
                it.close();
            }
        }
    }

    private final long multiThread(RunLengthBenchmarkTask task, int runCount, ConcurrentLinkedQueue<RunLengthBenchmarkTask> taskList, boolean isRandom) {
        return this.commandMultiThread((Function1)new Function1<Integer, RunLengthBenchmarkTask>(task, isRandom, taskList){
            final /* synthetic */ RunLengthBenchmarkTask $task;
            final /* synthetic */ boolean $isRandom;
            final /* synthetic */ ConcurrentLinkedQueue<RunLengthBenchmarkTask> $taskList;
            {
                this.$task = $task;
                this.$isRandom = $isRandom;
                this.$taskList = $taskList;
                super(1);
            }

            @NotNull
            public final RunLengthBenchmarkTask invoke(int it) {
                RunLengthBenchmarkTask newTask = this.$task.clone(this.$isRandom);
                this.$taskList.add(newTask);
                return newTask;
            }
        }, (Function1)new Function1<RunLengthBenchmarkTask, Long>(this, runCount){
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            final /* synthetic */ int $runCount;
            {
                this.this$0 = $receiver;
                this.$runCount = $runCount;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull RunLengthBenchmarkTask newTask) {
                Intrinsics.checkNotNullParameter((Object)newTask, (String)"newTask");
                return BenchmarkTaskBuilder.access$measureAverageThroughout(this.this$0, newTask, this.$runCount);
            }
        });
    }

    static /* synthetic */ long multiThread$default(BenchmarkTaskBuilder benchmarkTaskBuilder, RunLengthBenchmarkTask runLengthBenchmarkTask, int n, ConcurrentLinkedQueue concurrentLinkedQueue, boolean bl, int n2, Object object2) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return benchmarkTaskBuilder.multiThread(runLengthBenchmarkTask, n, concurrentLinkedQueue, bl);
    }

    private final long measureAverageThroughout(BenchmarkTask task, int runCount) {
        int n = 0;
        long[] lArray = new long[6];
        while (n < 6) {
            int n2 = n++;
            lArray[n2] = this.measureTaskThroughout(task, runCount);
        }
        long[] dataArray = lArray;
        long maxValue = dataArray[0];
        long minValue = dataArray[0];
        long totalValue = dataArray[0];
        int n3 = dataArray.length;
        for (int index2 = 1; index2 < n3; ++index2) {
            long value2 = dataArray[index2];
            totalValue += value2;
            if (value2 > maxValue) {
                maxValue = value2;
                continue;
            }
            if (value2 >= minValue) continue;
            minValue = value2;
        }
        return (totalValue - maxValue - minValue) / (long)(dataArray.length - 2);
    }

    private final long measureTaskThroughout(BenchmarkTask task, int runCount) {
        long time2 = 0L;
        long statisticCount = 0L;
        IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
        if (continueToken.canContinue()) {
            task.init();
            boolean $i$f$measureNanoTime = false;
            long start$iv = System.nanoTime();
            boolean bl = false;
            for (int i = 0; i < runCount; ++i) {
                if (continueToken.canContinue()) {
                    task.execute();
                }
                statisticCount += task.getStatisticCount();
            }
            time2 = System.nanoTime() - start$iv;
        }
        return this.computingThroughput(time2, statisticCount);
    }

    @Override
    public void close() {
        this.dataProvider.close();
        if (!FileTools.INSTANCE.deleteDir(PathsKt.fileSafeConstructor(this.benchmarkRootPath))) {
            throw new RuntimeException(this.benchmarkRootPath + " not be deleted");
        }
        this.ctx.reportTimeState(endTask);
    }

    public static final /* synthetic */ long access$measureAverageThroughout(BenchmarkTaskBuilder $this, int taskCount, int runCount, Function1 createTask) {
        return $this.measureAverageThroughout(taskCount, runCount, (Function1<? super Integer, ? extends BenchmarkTask>)createTask);
    }

    public static final /* synthetic */ long access$measureAverageThroughout(BenchmarkTaskBuilder $this, BenchmarkTask task, int runCount) {
        return $this.measureAverageThroughout(task, runCount);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010)\u001a\u00020\u00042\n\u0010*\u001a\u00060+j\u0002`,H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006\u00a8\u0006-"}, d2={"Lkd/bos/olapServer2/performanceStatistics/BenchmarkTaskBuilder$Companion;", "", "()V", "endTask", "Lkd/bos/olapServer2/performanceStatistics/CommandStatisticsItem;", "getEndTask", "()Lkd/bos/olapServer2/performanceStatistics/CommandStatisticsItem;", "multiThreadAggComputing", "getMultiThreadAggComputing", "multiThreadCPU", "getMultiThreadCPU", "multiThreadFelComputing", "getMultiThreadFelComputing", "multiThreadIO", "getMultiThreadIO", "multiThreadOrderMemory", "getMultiThreadOrderMemory", "multiThreadRandomMemory", "getMultiThreadRandomMemory", "multiThreadSelect", "getMultiThreadSelect", "signThreadSelect", "getSignThreadSelect", "singleThreadAggComputing", "getSingleThreadAggComputing", "singleThreadCPU", "getSingleThreadCPU", "singleThreadFelComputing", "getSingleThreadFelComputing", "singleThreadIO", "getSingleThreadIO", "singleThreadOrderMemory", "getSingleThreadOrderMemory", "singleThreadRandomMemory", "getSingleThreadRandomMemory", "updateCube", "getUpdateCube", "writeCube", "getWriteCube", "writeResult", "getWriteResult", "newItem", "captionResKey", "", "Lkd/bos/olapServer2/common/string;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        private final CommandStatisticsItem newItem(String captionResKey) {
            return new CommandStatisticsItem(captionResKey, CommandStatisticsItem.CommandStatisticsTypes.Time, -1);
        }

        @NotNull
        public final CommandStatisticsItem getWriteCube() {
            return writeCube;
        }

        @NotNull
        public final CommandStatisticsItem getUpdateCube() {
            return updateCube;
        }

        @NotNull
        public final CommandStatisticsItem getSignThreadSelect() {
            return signThreadSelect;
        }

        @NotNull
        public final CommandStatisticsItem getMultiThreadSelect() {
            return multiThreadSelect;
        }

        @NotNull
        public final CommandStatisticsItem getSingleThreadAggComputing() {
            return singleThreadAggComputing;
        }

        @NotNull
        public final CommandStatisticsItem getMultiThreadAggComputing() {
            return multiThreadAggComputing;
        }

        @NotNull
        public final CommandStatisticsItem getSingleThreadFelComputing() {
            return singleThreadFelComputing;
        }

        @NotNull
        public final CommandStatisticsItem getMultiThreadFelComputing() {
            return multiThreadFelComputing;
        }

        @NotNull
        public final CommandStatisticsItem getSingleThreadCPU() {
            return singleThreadCPU;
        }

        @NotNull
        public final CommandStatisticsItem getMultiThreadCPU() {
            return multiThreadCPU;
        }

        @NotNull
        public final CommandStatisticsItem getSingleThreadRandomMemory() {
            return singleThreadRandomMemory;
        }

        @NotNull
        public final CommandStatisticsItem getMultiThreadRandomMemory() {
            return multiThreadRandomMemory;
        }

        @NotNull
        public final CommandStatisticsItem getSingleThreadOrderMemory() {
            return singleThreadOrderMemory;
        }

        @NotNull
        public final CommandStatisticsItem getMultiThreadOrderMemory() {
            return multiThreadOrderMemory;
        }

        @NotNull
        public final CommandStatisticsItem getSingleThreadIO() {
            return singleThreadIO;
        }

        @NotNull
        public final CommandStatisticsItem getMultiThreadIO() {
            return multiThreadIO;
        }

        @NotNull
        public final CommandStatisticsItem getWriteResult() {
            return writeResult;
        }

        @NotNull
        public final CommandStatisticsItem getEndTask() {
            return endTask;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ CommandStatisticsItem access$newItem(Companion $this, String captionResKey) {
            return $this.newItem(captionResKey);
        }
    }
}

