/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.performanceStatistics;

import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.performanceStatistics.BenchmarkContext;
import kd.bos.olapServer2.performanceStatistics.BenchmarkTask;
import kd.bos.olapServer2.tools.FileTools;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.internal.ProgressionUtilKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00060\u0012j\u0002`\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer2/performanceStatistics/IOBenchmarkTask;", "Lkd/bos/olapServer2/performanceStatistics/BenchmarkTask;", "name", "", "Lkd/bos/olapServer2/common/string;", "fileNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "ctx", "Lkd/bos/olapServer2/performanceStatistics/BenchmarkContext;", "(Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicInteger;Lkd/bos/olapServer2/performanceStatistics/BenchmarkContext;)V", "fileName", "fileSize", "", "ioBenchmarkFile", "Ljava/io/File;", "sourceFile", "Ljava/nio/file/Path;", "statisticCount", "", "Lkd/bos/olapServer2/common/long;", "getStatisticCount", "()J", "clone", "close", "", "execute", "init", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nIOBenchmarkTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IOBenchmarkTask.kt\nkd/bos/olapServer2/performanceStatistics/IOBenchmarkTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class IOBenchmarkTask
extends BenchmarkTask {
    @NotNull
    private final AtomicInteger fileNumber;
    @NotNull
    private final File ioBenchmarkFile;
    @NotNull
    private final String fileName;
    @Nullable
    private Path sourceFile;
    private final int fileSize;

    public IOBenchmarkTask(@NotNull String name2, @NotNull AtomicInteger fileNumber, @NotNull BenchmarkContext ctx) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fileNumber, (String)"fileNumber");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(name2, ctx);
        this.fileNumber = fileNumber;
        this.ioBenchmarkFile = Paths.INSTANCE.toFile(ctx.getDataProvider().getBenchmarkPath(), "hardware");
        this.fileName = "IOBenchmark.profile";
        this.fileSize = ctx.getDataProvider().getOnlyUnitTest() ? 0x100000 : 0x10000000;
    }

    @Override
    public long getStatisticCount() {
        return 256L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.sourceFile == null) {
            File file = this.ioBenchmarkFile;
            if (!file.exists()) {
                file.mkdirs();
            }
            String string2 = this.ioBenchmarkFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            Object object2 = new String[]{this.fileName};
            this.sourceFile = Paths.INSTANCE.get(string2, (String)object2);
            object2 = Files.newOutputStream(this.sourceFile, new OpenOption[0]);
            Throwable throwable = null;
            try {
                OutputStream out = (OutputStream)object2;
                boolean bl = false;
                int n = 0;
                byte[] byArray = new byte[1024];
                while (n < 1024) {
                    int n2 = n++;
                    byArray[n2] = (byte)(n2 % 2);
                }
                byte[] buffer = byArray;
                n = this.fileSize;
                int n3 = buffer.length;
                if (n3 <= 0) {
                    throw new IllegalArgumentException("Step must be positive, was: " + n3 + '.');
                }
                int i = 0;
                int n4 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)n3);
                int n5 = n3;
                if (i <= n4) {
                    while (true) {
                        out.write(buffer);
                        if (i == n4) break;
                        i += n5;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
    }

    @Override
    public void execute() {
        String string2 = this.ioBenchmarkFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        Object[] objectArray = new String[]{this.fileName + this.fileNumber.incrementAndGet() + ".copy.profile"};
        Path path = Paths.INSTANCE.get(string2, (String[])objectArray);
        objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Path targetFile = Files.copy(this.sourceFile, path, (CopyOption[])objectArray);
        Intrinsics.checkNotNull((Object)targetFile);
        Paths.INSTANCE.toFile(((Object)targetFile.toAbsolutePath()).toString()).delete();
    }

    @Override
    public void close() {
        FileTools.INSTANCE.deleteDir(this.ioBenchmarkFile);
    }

    @NotNull
    public final IOBenchmarkTask clone() {
        IOBenchmarkTask iOBenchmarkTask;
        IOBenchmarkTask it = iOBenchmarkTask = new IOBenchmarkTask(this.getName(), this.fileNumber, this.getCtx());
        boolean bl = false;
        it.sourceFile = this.sourceFile;
        return iOBenchmarkTask;
    }
}

