/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.query;

import kd.bos.olapServer2.collections.IImmutableBitmap;
import kd.bos.olapServer2.common.CommonTypesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\n\u001a\u00060\u0003j\u0002`\u000b2\n\u0010\f\u001a\u00060\u0003j\u0002`\u0004H\u0096\u0002R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer2/query/ImmutableRowValidBitmap;", "Lkd/bos/olapServer2/collections/IImmutableBitmap;", "rowCount", "", "Lkd/bos/olapServer2/common/rowIdx;", "rowValidBitmap", "(JLkd/bos/olapServer2/collections/IImmutableBitmap;)V", "lastLongIndex", "remBitCount", "", "get", "Lkd/bos/olapServer2/common/long;", "index", "bos-olap-core2"})
public final class ImmutableRowValidBitmap
implements IImmutableBitmap {
    private final long rowCount;
    @NotNull
    private final IImmutableBitmap rowValidBitmap;
    private final int remBitCount;
    private final long lastLongIndex;

    public ImmutableRowValidBitmap(long rowCount, @NotNull IImmutableBitmap rowValidBitmap) {
        Intrinsics.checkNotNullParameter((Object)rowValidBitmap, (String)"rowValidBitmap");
        this.rowCount = rowCount;
        this.rowValidBitmap = rowValidBitmap;
        if (!(this.rowCount >= 0L)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.remBitCount = CommonTypesKt.toIntNoNegative(this.rowCount % (long)64);
        this.lastLongIndex = CommonTypesKt.bitCountToLongCount(this.rowCount) - 1L;
    }

    @Override
    public long get(long index2) {
        long l;
        if (this.rowCount == 0L) {
            return 0L;
        }
        if (index2 < this.lastLongIndex) {
            l = this.rowValidBitmap.get(index2);
        } else if (index2 == this.lastLongIndex) {
            long maskLong = this.remBitCount == 0 ? -1L : (1L << this.remBitCount) - 1L;
            l = maskLong & this.rowValidBitmap.get(index2);
        } else {
            l = 0L;
        }
        return l;
    }
}

