/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.query;

import java.util.Arrays;
import java.util.List;
import kd.bos.olapServer2.collections.objectModel.KeyedCollection;
import kd.bos.olapServer2.computingEngine.DimensionFilterCollection;
import kd.bos.olapServer2.dataSources.SelectCommandInfo;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.query.models.AndFilter;
import kd.bos.olapServer2.query.models.DimensionFilter;
import kd.bos.olapServer2.query.models.DimensionFilterKt;
import kd.bos.olapServer2.query.models.Filter;
import kd.bos.olapServer2.selects.Query;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\u0011J!\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0012\u0010\u001d\u001a\u00020\f2\n\u0010\u001e\u001a\u00060\u000ej\u0002`\u000fJ\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u000e\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lkd/bos/olapServer2/query/QueryBuilder;", "", "cubeMetadata", "Lkd/bos/olapServer2/metadata/Cube;", "(Lkd/bos/olapServer2/metadata/Cube;)V", "_query", "Lkd/bos/olapServer2/selects/Query;", "(Lkd/bos/olapServer2/metadata/Cube;Lkd/bos/olapServer2/selects/Query;)V", "query", "getQuery", "()Lkd/bos/olapServer2/selects/Query;", "addFilter", "", "dimensionName", "", "Lkd/bos/olapServer2/common/string;", "memberNames", "", "dimension", "Lkd/bos/olapServer2/metadata/Dimension;", "members", "", "Lkd/bos/olapServer2/metadata/Member;", "(Lkd/bos/olapServer2/metadata/Dimension;[Lkd/bos/olapServer2/metadata/Member;)V", "filters", "", "Lkd/bos/olapServer2/query/models/DimensionFilter;", "addFilterCore", "filter", "addSelectField", "fieldName", "check", "parseCommand", "command", "Lkd/bos/olapServer2/dataSources/SelectCommandInfo;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nQueryBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryBuilder.kt\nkd/bos/olapServer2/query/QueryBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1855#2,2:154\n1855#2,2:156\n*S KotlinDebug\n*F\n+ 1 QueryBuilder.kt\nkd/bos/olapServer2/query/QueryBuilder\n*L\n61#1:154,2\n129#1:156,2\n*E\n"})
public final class QueryBuilder {
    @NotNull
    private final Cube cubeMetadata;
    @NotNull
    private final Query query;

    public QueryBuilder(@NotNull Cube cubeMetadata, @NotNull Query _query) {
        Intrinsics.checkNotNullParameter((Object)cubeMetadata, (String)"cubeMetadata");
        Intrinsics.checkNotNullParameter((Object)_query, (String)"_query");
        this.cubeMetadata = cubeMetadata;
        this.query = _query;
    }

    public QueryBuilder(@NotNull Cube cubeMetadata) {
        Intrinsics.checkNotNullParameter((Object)cubeMetadata, (String)"cubeMetadata");
        this(cubeMetadata, new Query());
    }

    @NotNull
    public final Query getQuery() {
        return this.query;
    }

    private final void addFilterCore(DimensionFilter filter2) {
        Filter currentFilter;
        this.check(filter2);
        Filter filter3 = currentFilter = this.query.getFilter();
        this.query.setFilter(filter3 == null ? (Filter)filter2 : filter3.and(filter2));
    }

    private final void check(DimensionFilter filter2) {
        if (filter2.getMembers().isEmpty()) {
            String string2 = Res.INSTANCE.getQueryTaskBuilderException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-QueryTaskBuilderException_1>(...)");
            Object[] objectArray = new Object[]{filter2.getDimension()};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
    }

    public final void addFilter(@NotNull Dimension dimension, @NotNull Member[] members2) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)members2, (String)"members");
        DimensionFilter newFilter = DimensionFilterKt.In(dimension, Arrays.copyOf(members2, members2.length));
        this.addFilterCore(newFilter);
    }

    public final void addFilter(@NotNull String dimensionName, @NotNull List<String> memberNames2) {
        Intrinsics.checkNotNullParameter((Object)dimensionName, (String)"dimensionName");
        Intrinsics.checkNotNullParameter(memberNames2, (String)"memberNames");
        Dimension dim = (Dimension)this.cubeMetadata.getDimensions().get(dimensionName);
        DimensionFilter newFilter = new DimensionFilter(dim);
        Iterable $this$forEach$iv = memberNames2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            newFilter.getMembers().add(dim.getMembers().get(it));
        }
        this.addFilterCore(newFilter);
    }

    public final void addFilter(@NotNull Iterable<DimensionFilter> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        AndFilter andFilter = new AndFilter();
        for (DimensionFilter filter2 : filters) {
            this.check(filter2);
            andFilter.add(filter2.clone());
        }
        if (andFilter.getHasChildren()) {
            Filter filter3;
            Filter currentFilter = this.query.getFilter();
            Filter filter4 = currentFilter;
            if (filter4 == null) {
                filter3 = andFilter;
            } else if (filter4 instanceof DimensionFilter) {
                andFilter.add(currentFilter);
                filter3 = andFilter;
            } else {
                filter3 = currentFilter.and(andFilter);
            }
            this.query.setFilter(filter3);
        }
    }

    public final void addSelectField(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Dimension dim = (Dimension)this.cubeMetadata.getDimensions().tryGet(fieldName);
        if (dim != null) {
            KeyedCollection<String, Dimension> $this$addSelectField_u24lambda_u241 = this.query.getDimensions();
            boolean bl = false;
            if (!$this$addSelectField_u24lambda_u241.containsKey(fieldName)) {
                $this$addSelectField_u24lambda_u241.add(dim);
            }
            return;
        }
        Measure measure = (Measure)this.cubeMetadata.getMeasures().tryGet(fieldName);
        if (measure != null) {
            KeyedCollection<String, Measure> $this$addSelectField_u24lambda_u242 = this.query.getMeasures();
            boolean bl = false;
            if (!$this$addSelectField_u24lambda_u242.containsKey(fieldName)) {
                $this$addSelectField_u24lambda_u242.add(measure);
            }
            return;
        }
        String string2 = Res.INSTANCE.getQueryTaskBuilderException_2();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-QueryTaskBuilderException_2>(...)");
        Object[] objectArray = new Object[]{fieldName, this.cubeMetadata.getName()};
        throw Res.INSTANCE.getIndexOutOfBoundsException(string2, objectArray);
    }

    public final void parseCommand(@NotNull SelectCommandInfo command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        List<String> dimensionNames = command.getDimensions();
        List<String> measureNames = command.getMeasures();
        Iterable $this$forEach$iv = DimensionFilterCollection.Companion.from(this.cubeMetadata.getDimensions(), command.getFilter());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DimensionFilter it = (DimensionFilter)element$iv;
            boolean bl = false;
            this.addFilterCore(it);
        }
        this.query.setTop(command.getTop());
        this.query.setExcludeDynamicCalcResult(command.getExcludeDynamicCalcResult());
        this.query.setIncludeDynamicMemberWhenNullFilter(command.getIncludeDynamicMemberWhenNullFilter());
        this.query.setDynamicCalcVersion(command.getDynamicCalcVersion());
        for (String dimName : dimensionNames) {
            this.addSelectField(dimName);
        }
        for (String measureName : measureNames) {
            this.addSelectField(measureName);
        }
    }
}

