/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kd.bos.olapServer2.collections.IImmutableBitmap;
import kd.bos.olapServer2.collections.IIndexScanner;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.query.AllRowIndexIterator;
import kd.bos.olapServer2.query.AllRowParallelIndexIterator;
import kd.bos.olapServer2.query.AllValidQueryBitmap;
import kd.bos.olapServer2.query.AndIndexScanner;
import kd.bos.olapServer2.query.EmptyQueryBitmap;
import kd.bos.olapServer2.query.IBitmapResourceContainer;
import kd.bos.olapServer2.query.IPossibleRowIndexIterator;
import kd.bos.olapServer2.query.IRowIndexIterator;
import kd.bos.olapServer2.query.ImmutableAndBitmap;
import kd.bos.olapServer2.query.ImmutableAndBitmap2;
import kd.bos.olapServer2.query.ImmutableOrBitmap;
import kd.bos.olapServer2.query.ImmutableOrBitmap2;
import kd.bos.olapServer2.query.IndexIterator;
import kd.bos.olapServer2.query.OrIndexScanner;
import kd.bos.olapServer2.query.ParallelRowIndexIterator;
import kd.bos.olapServer2.query.QueryOperationKt;
import kd.bos.olapServer2.query.RowIndexIterator;
import kd.bos.olapServer2.query.Spliterator;
import kd.bos.olapServer2.query.ValidValueIterator;
import kd.bos.olapServer2.query.models.AndFilter;
import kd.bos.olapServer2.query.models.DimensionFilter;
import kd.bos.olapServer2.query.models.Filter;
import kd.bos.olapServer2.query.models.OrFilter;
import kd.bos.olapServer2.storages.pools.TaskResourceContainer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0005\u001d\u001e\u001f !B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u0012\u0010\b\u001a\u00060\u0003j\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lkd/bos/olapServer2/query/QueryExecutionPlan;", "", "rowCount", "", "Lkd/bos/olapServer2/common/rowIdx;", "filter", "Lkd/bos/olapServer2/query/models/Filter;", "(JLkd/bos/olapServer2/query/models/Filter;)V", "_parallelSegmentLength", "Lkd/bos/olapServer2/common/long;", "_rootNode", "Lkd/bos/olapServer2/query/QueryExecutionPlan$ITaskNode;", "_spliterator", "Lkd/bos/olapServer2/query/Spliterator;", "get_spliterator", "()Lkd/bos/olapServer2/query/Spliterator;", "_spliterator$delegate", "Lkotlin/Lazy;", "getFilter", "()Lkd/bos/olapServer2/query/models/Filter;", "longCount", "getRowCount", "()J", "build", "Lkd/bos/olapServer2/query/IRowIndexIterator;", "res", "Lkd/bos/olapServer2/query/IBitmapResourceContainer;", "buildForParallel", "createTaskNode", "AndTaskNode", "DimensionTaskNode", "ITaskNode", "OrTaskNode", "TaskNode", "bos-olap-core2"})
public final class QueryExecutionPlan {
    private final long rowCount;
    @Nullable
    private final Filter filter;
    private final long longCount;
    @Nullable
    private final ITaskNode _rootNode;
    private long _parallelSegmentLength;
    @NotNull
    private final Lazy _spliterator$delegate;

    public QueryExecutionPlan(long rowCount, @Nullable Filter filter2) {
        this.rowCount = rowCount;
        this.filter = filter2;
        this.longCount = CommonTypesKt.bitCountToLongCount(this.rowCount);
        this._rootNode = this.filter == null ? null : this.createTaskNode(this.filter);
        this._parallelSegmentLength = Spliterator.Companion.getDefaultSegmentLength();
        this._spliterator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Spliterator>(this){
            final /* synthetic */ QueryExecutionPlan this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Spliterator invoke() {
                return this.this$0.getFilter() == null ? new Spliterator(this.this$0.getRowCount(), QueryExecutionPlan.access$get_parallelSegmentLength$p(this.this$0)) : new Spliterator(QueryExecutionPlan.access$getLongCount$p(this.this$0), QueryExecutionPlan.access$get_parallelSegmentLength$p(this.this$0));
            }
        }));
    }

    public final long getRowCount() {
        return this.rowCount;
    }

    @Nullable
    public final Filter getFilter() {
        return this.filter;
    }

    @NotNull
    public final IRowIndexIterator build(@NotNull IBitmapResourceContainer res) {
        IRowIndexIterator iRowIndexIterator;
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        if (this.rowCount == 0L) {
            return IRowIndexIterator.Empty.INSTANCE;
        }
        IImmutableBitmap rowValidQueryBitmap = res.getRowValidQueryBitmap();
        if (rowValidQueryBitmap instanceof AllValidQueryBitmap) {
            IPossibleRowIndexIterator iPossibleRowIndexIterator;
            if (this._rootNode == null) {
                iPossibleRowIndexIterator = new AllRowIndexIterator(this.rowCount);
            } else {
                ITaskNode rootTaskNode = this._rootNode;
                IndexIterator rangeIndexes = new IndexIterator(rootTaskNode.createIndexScanner(res), 0L, this.longCount);
                iPossibleRowIndexIterator = new RowIndexIterator(new ValidValueIterator(rootTaskNode.createBitmap(res), rangeIndexes));
            }
            iRowIndexIterator = iPossibleRowIndexIterator;
        } else {
            RowIndexIterator rowIndexIterator;
            if (this._rootNode == null) {
                rowIndexIterator = new RowIndexIterator(QueryOperationKt.getValidValues(rowValidQueryBitmap, RangesKt.until((int)0, (long)this.longCount)));
            } else {
                ITaskNode rootTaskNode = this._rootNode;
                IndexIterator rangeIndexes = new IndexIterator(rootTaskNode.createIndexScanner(res), 0L, this.longCount);
                ImmutableAndBitmap2 andBitmap = new ImmutableAndBitmap2(rootTaskNode.createBitmap(res), rowValidQueryBitmap);
                rowIndexIterator = new RowIndexIterator(new ValidValueIterator(andBitmap, rangeIndexes));
            }
            iRowIndexIterator = rowIndexIterator;
        }
        return iRowIndexIterator;
    }

    private final Spliterator get_spliterator() {
        Lazy lazy = this._spliterator$delegate;
        return (Spliterator)lazy.getValue();
    }

    @NotNull
    public final IRowIndexIterator buildForParallel(@NotNull IBitmapResourceContainer res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        if (this.rowCount == 0L) {
            return IRowIndexIterator.Empty.INSTANCE;
        }
        IImmutableBitmap rowValidQueryBitmap = res.getRowValidQueryBitmap();
        return rowValidQueryBitmap instanceof AllValidQueryBitmap ? (IRowIndexIterator)(this._rootNode == null ? (IPossibleRowIndexIterator)new AllRowParallelIndexIterator(this.get_spliterator()) : (IPossibleRowIndexIterator)new ParallelRowIndexIterator(res, this.get_spliterator(), this._rootNode, null, 8, null)) : (IRowIndexIterator)new ParallelRowIndexIterator(res, this.get_spliterator(), this._rootNode, rowValidQueryBitmap);
    }

    private final ITaskNode createTaskNode(Filter filter2) {
        ITaskNode iTaskNode;
        Filter filter3 = filter2;
        if (filter3 instanceof OrFilter) {
            iTaskNode = new OrTaskNode((OrFilter)filter2);
        } else if (filter3 instanceof AndFilter) {
            iTaskNode = new AndTaskNode((AndFilter)filter2);
        } else if (filter3 instanceof DimensionFilter) {
            iTaskNode = new DimensionTaskNode((DimensionFilter)filter2);
        } else {
            throw new NotSupportedException();
        }
        return iTaskNode;
    }

    public static final /* synthetic */ long access$get_parallelSegmentLength$p(QueryExecutionPlan $this) {
        return $this._parallelSegmentLength;
    }

    public static final /* synthetic */ long access$getLongCount$p(QueryExecutionPlan $this) {
        return $this.longCount;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/query/QueryExecutionPlan$AndTaskNode;", "Lkd/bos/olapServer2/query/QueryExecutionPlan$TaskNode;", "Lkd/bos/olapServer2/query/models/AndFilter;", "Lkd/bos/olapServer2/query/QueryExecutionPlan;", "filter", "(Lkd/bos/olapServer2/query/QueryExecutionPlan;Lkd/bos/olapServer2/query/models/AndFilter;)V", "cost", "", "getCost", "()D", "createBitmap", "Lkd/bos/olapServer2/collections/IImmutableBitmap;", "res", "Lkd/bos/olapServer2/query/IBitmapResourceContainer;", "createIndexScanner", "Lkd/bos/olapServer2/collections/IIndexScanner;", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nQueryExecutionPlan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryExecutionPlan.kt\nkd/bos/olapServer2/query/QueryExecutionPlan$AndTaskNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n1002#2,2:260\n*S KotlinDebug\n*F\n+ 1 QueryExecutionPlan.kt\nkd/bos/olapServer2/query/QueryExecutionPlan$AndTaskNode\n*L\n198#1:260,2\n*E\n"})
    private final class AndTaskNode
    extends TaskNode<AndFilter> {
        public AndTaskNode(AndFilter filter2) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            super(QueryExecutionPlan.this, (Filter)filter2);
            for (Filter child : filter2.getChildren()) {
                this.add(child);
            }
            List<ITaskNode> $this$sortBy$iv = this.getChildren();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ITaskNode it = (ITaskNode)a;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.getCost());
                        it = (ITaskNode)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getCost()));
                    }
                });
            }
        }

        @Override
        @NotNull
        public IIndexScanner createIndexScanner(@NotNull IBitmapResourceContainer res) {
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            int n = 0;
            int n2 = this.getChildren().size();
            IIndexScanner[] iIndexScannerArray = new IIndexScanner[n2];
            while (n < n2) {
                int n3 = n++;
                iIndexScannerArray[n3] = this.getChildren().get(n3).createIndexScanner(res);
            }
            IIndexScanner[] iIndexScannerArray2 = iIndexScannerArray;
            return new AndIndexScanner(iIndexScannerArray2);
        }

        @Override
        @NotNull
        public IImmutableBitmap createBitmap(@NotNull IBitmapResourceContainer res) {
            IImmutableBitmap iImmutableBitmap;
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            if (this.getChildren().size() == 2) {
                iImmutableBitmap = new ImmutableAndBitmap2(this.getChildren().get(0).createBitmap(res), this.getChildren().get(1).createBitmap(res));
            } else {
                int n = 0;
                int n2 = this.getChildren().size();
                IImmutableBitmap[] iImmutableBitmapArray = new IImmutableBitmap[n2];
                while (n < n2) {
                    int n3 = n++;
                    iImmutableBitmapArray[n3] = this.getChildren().get(n3).createBitmap(res);
                }
                IImmutableBitmap[] iImmutableBitmapArray2 = iImmutableBitmapArray;
                iImmutableBitmap = new ImmutableAndBitmap(iImmutableBitmapArray2);
            }
            return iImmutableBitmap;
        }

        @Override
        public double getCost() {
            double r = 1.0;
            for (ITaskNode c : this.getChildren()) {
                r *= c.getCost();
            }
            return r;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/query/QueryExecutionPlan$DimensionTaskNode;", "Lkd/bos/olapServer2/query/QueryExecutionPlan$TaskNode;", "Lkd/bos/olapServer2/query/models/DimensionFilter;", "Lkd/bos/olapServer2/query/QueryExecutionPlan;", "filter", "(Lkd/bos/olapServer2/query/QueryExecutionPlan;Lkd/bos/olapServer2/query/models/DimensionFilter;)V", "cost", "", "getCost", "()D", "createBitmap", "Lkd/bos/olapServer2/collections/IImmutableBitmap;", "res", "Lkd/bos/olapServer2/query/IBitmapResourceContainer;", "createIndexScanner", "Lkd/bos/olapServer2/collections/IIndexScanner;", "bos-olap-core2"})
    private final class DimensionTaskNode
    extends TaskNode<DimensionFilter> {
        public DimensionTaskNode(DimensionFilter filter2) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            super(QueryExecutionPlan.this, (Filter)filter2);
        }

        @Override
        @NotNull
        public IIndexScanner createIndexScanner(@NotNull IBitmapResourceContainer res) {
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            Set<Member> members2 = ((DimensionFilter)this.getFilter()).getMembers();
            return members2.size() == 0 ? EmptyQueryBitmap.INSTANCE.getIndexScanner() : res.getIndexScanner(((DimensionFilter)this.getFilter()).getDimension(), (Collection<? extends Member>)members2);
        }

        @Override
        @NotNull
        public IImmutableBitmap createBitmap(@NotNull IBitmapResourceContainer res) {
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            Set<Member> members2 = ((DimensionFilter)this.getFilter()).getMembers();
            return members2.size() == 0 ? (IImmutableBitmap)EmptyQueryBitmap.INSTANCE : res.getImmutableBitmap(((DimensionFilter)this.getFilter()).getDimension(), (Collection<? extends Member>)members2);
        }

        @Override
        public double getCost() {
            double x = (double)((DimensionFilter)this.getFilter()).getMembers().size() * 1.0 / (double)((DimensionFilter)this.getFilter()).getDimension().getMembers().getRealCount();
            int s = ((DimensionFilter)this.getFilter()).getMembers().size();
            double c = s > TaskResourceContainer.Companion.getUsingBitmapIndexMaxMemberCount() ? 1.2 : 0.5;
            return c * x;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer2/query/QueryExecutionPlan$ITaskNode;", "", "cost", "", "getCost", "()D", "createBitmap", "Lkd/bos/olapServer2/collections/IImmutableBitmap;", "res", "Lkd/bos/olapServer2/query/IBitmapResourceContainer;", "createIndexScanner", "Lkd/bos/olapServer2/collections/IIndexScanner;", "bos-olap-core2"})
    public static interface ITaskNode {
        @NotNull
        public IIndexScanner createIndexScanner(@NotNull IBitmapResourceContainer var1);

        @NotNull
        public IImmutableBitmap createBitmap(@NotNull IBitmapResourceContainer var1);

        public double getCost();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/query/QueryExecutionPlan$OrTaskNode;", "Lkd/bos/olapServer2/query/QueryExecutionPlan$TaskNode;", "Lkd/bos/olapServer2/query/models/OrFilter;", "Lkd/bos/olapServer2/query/QueryExecutionPlan;", "filter", "(Lkd/bos/olapServer2/query/QueryExecutionPlan;Lkd/bos/olapServer2/query/models/OrFilter;)V", "cost", "", "getCost", "()D", "createBitmap", "Lkd/bos/olapServer2/collections/IImmutableBitmap;", "res", "Lkd/bos/olapServer2/query/IBitmapResourceContainer;", "createIndexScanner", "Lkd/bos/olapServer2/collections/IIndexScanner;", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nQueryExecutionPlan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryExecutionPlan.kt\nkd/bos/olapServer2/query/QueryExecutionPlan$OrTaskNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n1002#2,2:260\n*S KotlinDebug\n*F\n+ 1 QueryExecutionPlan.kt\nkd/bos/olapServer2/query/QueryExecutionPlan$OrTaskNode\n*L\n163#1:260,2\n*E\n"})
    private final class OrTaskNode
    extends TaskNode<OrFilter> {
        public OrTaskNode(OrFilter filter2) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            super(QueryExecutionPlan.this, (Filter)filter2);
            for (Filter child : filter2.getChildren()) {
                this.add(child);
            }
            List<ITaskNode> $this$sortBy$iv = this.getChildren();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ITaskNode it = (ITaskNode)a;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.getCost());
                        it = (ITaskNode)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getCost()));
                    }
                });
            }
        }

        @Override
        @NotNull
        public IIndexScanner createIndexScanner(@NotNull IBitmapResourceContainer res) {
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            int n = 0;
            int n2 = this.getChildren().size();
            IIndexScanner[] iIndexScannerArray = new IIndexScanner[n2];
            while (n < n2) {
                int n3 = n++;
                iIndexScannerArray[n3] = this.getChildren().get(n3).createIndexScanner(res);
            }
            IIndexScanner[] iIndexScannerArray2 = iIndexScannerArray;
            return new OrIndexScanner(iIndexScannerArray2);
        }

        @Override
        @NotNull
        public IImmutableBitmap createBitmap(@NotNull IBitmapResourceContainer res) {
            IImmutableBitmap iImmutableBitmap;
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            if (this.getChildren().size() == 2) {
                iImmutableBitmap = new ImmutableOrBitmap2(this.getChildren().get(0).createBitmap(res), this.getChildren().get(1).createBitmap(res));
            } else {
                int n = 0;
                int n2 = this.getChildren().size();
                IImmutableBitmap[] iImmutableBitmapArray = new IImmutableBitmap[n2];
                while (n < n2) {
                    int n3 = n++;
                    iImmutableBitmapArray[n3] = this.getChildren().get(n3).createBitmap(res);
                }
                IImmutableBitmap[] iImmutableBitmapArray2 = iImmutableBitmapArray;
                iImmutableBitmap = new ImmutableOrBitmap(iImmutableBitmapArray2);
            }
            return iImmutableBitmap;
        }

        @Override
        public double getCost() {
            if (this.getChildren().isEmpty()) {
                return 0.0;
            }
            double r = this.getChildren().get(0).getCost();
            int n = this.getChildren().size();
            for (int c = 1; c < n; ++c) {
                r += (1.0 - r) * this.getChildren().get(c).getCost();
            }
            return r;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u00a2\u0004\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0002H\u0004R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer2/query/QueryExecutionPlan$TaskNode;", "T", "Lkd/bos/olapServer2/query/models/Filter;", "Lkd/bos/olapServer2/query/QueryExecutionPlan$ITaskNode;", "filter", "(Lkd/bos/olapServer2/query/QueryExecutionPlan;Lkd/bos/olapServer2/query/models/Filter;)V", "children", "", "getChildren", "()Ljava/util/List;", "getFilter", "()Lkd/bos/olapServer2/query/models/Filter;", "Lkd/bos/olapServer2/query/models/Filter;", "add", "", "bos-olap-core2"})
    private static abstract class TaskNode<T extends Filter>
    implements ITaskNode {
        @NotNull
        private final T filter;
        @NotNull
        private final List<ITaskNode> children;
        final /* synthetic */ QueryExecutionPlan this$0;

        public TaskNode(T filter2) {
            Intrinsics.checkNotNullParameter(filter2, (String)"filter");
            this.this$0 = this$0;
            this.filter = filter2;
            this.children = new ArrayList();
        }

        @NotNull
        public final T getFilter() {
            return this.filter;
        }

        @NotNull
        public final List<ITaskNode> getChildren() {
            return this.children;
        }

        protected final void add(@NotNull Filter filter2) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            this.children.add(this.this$0.createTaskNode(filter2));
        }
    }
}

