/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.olapServer2.collections.ILongIterator;
import kd.bos.olapServer2.computingEngine.batchTasks.LongBatchLockedResourceIterator;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.query.IBitmapResourceContainer;
import kd.bos.olapServer2.query.IRowIndexIterator;
import kd.bos.olapServer2.query.ITaskResourceContainerProvider;
import kd.bos.olapServer2.query.QueryExecutionPlan;
import kd.bos.olapServer2.query.Spliterator;
import kd.bos.olapServer2.query.models.AndFilter;
import kd.bos.olapServer2.query.models.DimensionFilter;
import kd.bos.olapServer2.query.models.Filter;
import kd.bos.olapServer2.selects.QueryReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010$\u001a\u00020\u0011R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010\u000f\u001a.\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00120\u0010j\u0016\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lkd/bos/olapServer2/query/QuerySession;", "", "isParallel", "", "Lkd/bos/olapServer2/common/bool;", "rowCount", "", "Lkd/bos/olapServer2/common/rowIdx;", "filter", "Lkd/bos/olapServer2/query/models/Filter;", "(ZJLkd/bos/olapServer2/query/models/Filter;)V", "_sharedQueryExecutionPlan", "Lkd/bos/olapServer2/query/QueryExecutionPlan;", "_sharedRowIndexItr", "Lkd/bos/olapServer2/query/IRowIndexIterator;", "dimensionFilterMembersCache", "Ljava/util/HashMap;", "Lkd/bos/olapServer2/metadata/Dimension;", "", "Lkd/bos/olapServer2/metadata/Member;", "Lkotlin/collections/HashMap;", "getFilter", "()Lkd/bos/olapServer2/query/models/Filter;", "getRowCount", "()J", "analyzeSelectFields", "", "build", "res", "Lkd/bos/olapServer2/query/IBitmapResourceContainer;", "buildForParallel", "resProvider", "Lkd/bos/olapServer2/query/ITaskResourceContainerProvider;", "createReader", "Lkd/bos/olapServer2/selects/QueryReader;", "getDimensionFilterMembers", "dimension", "bos-olap-core2"})
public final class QuerySession {
    private final boolean isParallel;
    @NotNull
    private final QueryExecutionPlan _sharedQueryExecutionPlan;
    @NotNull
    private final HashMap<Dimension, Collection<Member>> dimensionFilterMembersCache;
    @Nullable
    private volatile IRowIndexIterator _sharedRowIndexItr;

    public QuerySession(boolean isParallel, long rowCount, @Nullable Filter filter2) {
        this.isParallel = isParallel;
        this.dimensionFilterMembersCache = new HashMap();
        Filter filter3 = filter2;
        if (filter3 != null) {
            filter3.freeze();
        }
        this._sharedQueryExecutionPlan = new QueryExecutionPlan(rowCount, filter2);
        this.analyzeSelectFields();
    }

    private final Filter getFilter() {
        return this._sharedQueryExecutionPlan.getFilter();
    }

    private final long getRowCount() {
        return this._sharedQueryExecutionPlan.getRowCount();
    }

    private final void analyzeSelectFields() {
        Filter currentFilter = this.getFilter();
        if (currentFilter instanceof DimensionFilter) {
            ((Map)this.dimensionFilterMembersCache).put(((DimensionFilter)currentFilter).getDimension(), ((DimensionFilter)currentFilter).getMembers());
        } else if (currentFilter instanceof AndFilter) {
            for (Filter child : ((AndFilter)currentFilter).getChildren()) {
                if (!(child instanceof DimensionFilter)) continue;
                ((Map)this.dimensionFilterMembersCache).put(((DimensionFilter)child).getDimension(), ((DimensionFilter)child).getMembers());
            }
        }
    }

    @Nullable
    public final Collection<Member> getDimensionFilterMembers(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        return this.dimensionFilterMembersCache.get(dimension);
    }

    private final IRowIndexIterator build(IBitmapResourceContainer res) {
        return this._sharedQueryExecutionPlan.build(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IRowIndexIterator buildForParallel(ITaskResourceContainerProvider resProvider) {
        IRowIndexIterator sharedRowIndexItr = this._sharedRowIndexItr;
        if (sharedRowIndexItr == null && this.getRowCount() < Spliterator.Companion.getMaxBatchLockLoadRowCount()) {
            IRowIndexIterator iRowIndexIterator;
            QuerySession querySession = this;
            synchronized (querySession) {
                boolean bl = false;
                IRowIndexIterator iRowIndexIterator2 = this._sharedRowIndexItr;
                if (iRowIndexIterator2 == null) {
                    IRowIndexIterator iRowIndexIterator3;
                    IRowIndexIterator it = iRowIndexIterator3 = this._sharedQueryExecutionPlan.build(resProvider.getSharedResourceContainer());
                    boolean bl2 = false;
                    this._sharedRowIndexItr = it;
                    iRowIndexIterator2 = iRowIndexIterator3;
                }
                iRowIndexIterator = iRowIndexIterator2;
            }
            sharedRowIndexItr = iRowIndexIterator;
        }
        return sharedRowIndexItr == null ? this._sharedQueryExecutionPlan.buildForParallel(resProvider.getCurrentThreadResourceContainer()) : (IRowIndexIterator)new LongBatchLockedResourceIterator<ILongIterator>(sharedRowIndexItr);
    }

    @NotNull
    public final QueryReader createReader(@NotNull ITaskResourceContainerProvider resProvider) {
        Intrinsics.checkNotNullParameter((Object)resProvider, (String)"resProvider");
        IRowIndexIterator itr = this.isParallel ? this.buildForParallel(resProvider) : this.build(resProvider.getCurrentThreadResourceContainer());
        return new QueryReader(resProvider.getCurrentThreadResourceContainer(), this.getRowCount(), itr);
    }
}

