/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.query;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer.grammar.DragonEngine;
import kd.bos.olapServer.grammar.expr.IExpr;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.computingEngine.dynamicCalc.DynamicCalcQuerySessionBuilder;
import kd.bos.olapServer2.computingEngine.dynamicCalc.DynamicCalcSession;
import kd.bos.olapServer2.computingEngine.scriptBindings.DragonScriptBuiltin;
import kd.bos.olapServer2.dataSources.DistinctSelectCommandInfo;
import kd.bos.olapServer2.dataSources.SelectCommandInfo;
import kd.bos.olapServer2.dataSources.SelectCommandInfoV1;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.MeasureCollection;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.MemberCollection;
import kd.bos.olapServer2.metadata.OlapDataTypes;
import kd.bos.olapServer2.query.IQueryJsonWriter;
import kd.bos.olapServer2.query.MeasureOrderByQueryReader;
import kd.bos.olapServer2.query.QueryBuilder;
import kd.bos.olapServer2.query.QueryJsonWriter;
import kd.bos.olapServer2.query.QueryJsonWriterV1;
import kd.bos.olapServer2.query.SpecialMeasureQueryReaderKt;
import kd.bos.olapServer2.query.TopRowQueryReaderKt;
import kd.bos.olapServer2.selects.CountDistinctQueryReaderKt;
import kd.bos.olapServer2.selects.DistinctQueryReader;
import kd.bos.olapServer2.selects.DistinctQueryReaderKt;
import kd.bos.olapServer2.selects.IDimensionSelectField;
import kd.bos.olapServer2.selects.IDimensionSelectFieldV1;
import kd.bos.olapServer2.selects.IMeasureSelectField;
import kd.bos.olapServer2.selects.IQueryReader;
import kd.bos.olapServer2.selects.IQuerySession;
import kd.bos.olapServer2.selects.ISelectField;
import kd.bos.olapServer2.selects.ISelectFieldCollection;
import kd.bos.olapServer2.selects.ParallelQueryReader;
import kd.bos.olapServer2.selects.Query;
import kd.bos.olapServer2.shrek.dataSources.DimensionItem;
import kd.bos.olapServer2.shrek.dataSources.DimensionItemV1;
import kd.bos.olapServer2.shrek.dataSources.MeasureItem;
import kd.bos.olapServer2.shrek.dataSources.SelectMetaData;
import kd.bos.olapServer2.shrek.dataSources.SelectMetaDataV1;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001c\u001a\u00020\u00122\u001a\u0010\u001d\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f\u0012\u0004\u0012\u00020\u00120\u001eJ.\u0010\u001c\u001a\u00020\u00122\u001a\u0010\u001d\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f\u0012\u0004\u0012\u00020\u00120\u001e2\n\u0010 \u001a\u00060!j\u0002`\"J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010'\u001a\u00020(2\f\b\u0002\u0010)\u001a\u00060!j\u0002`\"H\u0002J\b\u0010*\u001a\u00020+H\u0002J\f\u0010,\u001a\u00020\u0019*\u00020+H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lkd/bos/olapServer2/query/SelectCommandExecutor;", "", "command", "Lkd/bos/olapServer2/dataSources/SelectCommandInfo;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "(Lkd/bos/olapServer2/dataSources/SelectCommandInfo;Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/storages/CubeWorkspace;)V", "cancelToken", "Lkd/bos/olapServer2/common/IContinueToken;", "measureFilter", "Lkd/bos/olapServer/grammar/expr/IExpr;", "query", "Lkd/bos/olapServer2/selects/Query;", "getQuery", "()Lkd/bos/olapServer2/selects/Query;", "buildCountDistinctResult", "", "outputStream", "Ljava/io/OutputStream;", "buildDimensionJsonWriter", "jsonWriter", "Lkd/bos/olapServer2/query/IQueryJsonWriter;", "queryReader", "Lkd/bos/olapServer2/selects/IQueryReader;", "buildDistinctResult", "buildJsonWriter", "buildResult", "consumer", "Lkotlin/Function1;", "", "outputMemberName", "", "Lkd/bos/olapServer2/common/bool;", "buildResultV1", "buildResultV3", "buildSelectMetadataV1", "Lkd/bos/olapServer2/shrek/dataSources/SelectMetaDataV1;", "buildSelectMetadataV3", "Lkd/bos/olapServer2/shrek/dataSources/SelectMetaData;", "addMeasureFlag", "createQuerySession", "Lkd/bos/olapServer2/selects/IQuerySession;", "createReader2", "bos-olap-core2"})
public final class SelectCommandExecutor {
    @NotNull
    private final SelectCommandInfo command;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final Query query;
    @NotNull
    private final IContinueToken cancelToken;
    @Nullable
    private final IExpr measureFilter;

    /*
     * WARNING - void declaration
     */
    public SelectCommandExecutor(@NotNull SelectCommandInfo command, @NotNull OlapWorkspace olapWorkspace, @NotNull CubeWorkspace cubeWorkspace) {
        IExpr iExpr;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        this.command = command;
        this.olapWorkspace = olapWorkspace;
        this.cubeWorkspace = cubeWorkspace;
        this.cancelToken = CancellableToken.INSTANCE.getContinueToken();
        QueryBuilder queryBuilder = new QueryBuilder(this.cubeWorkspace.getMetadata());
        queryBuilder.parseCommand(this.command);
        this.query = queryBuilder.getQuery();
        SelectCommandExecutor selectCommandExecutor = this;
        String string2 = this.command.getMeasureFilter();
        if (string2 != null) {
            void expression;
            IExpr iExpr2;
            String string3 = string2;
            SelectCommandExecutor selectCommandExecutor2 = selectCommandExecutor;
            boolean bl = false;
            IExpr $this$lambda_u241_u24lambda_u240 = iExpr2 = DragonScriptBuiltin.INSTANCE.parse((String)expression);
            boolean bl2 = false;
            if (!DragonEngine.Companion.isBooleanReturnData($this$lambda_u241_u24lambda_u240)) {
                String string4 = Res.INSTANCE.getUnsupportedFilterMeasureException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-UnsupportedFilterMeasureException_2>(...)");
                Object[] objectArray = new Object[]{expression};
                throw Res.INSTANCE.getNotSupportedException(string4, objectArray);
            }
            iExpr = iExpr2;
            selectCommandExecutor = selectCommandExecutor2;
        } else {
            iExpr = selectCommandExecutor.measureFilter = null;
        }
        if (!((Collection)this.command.getOrderBy()).isEmpty()) {
            int n = MeasureOrderByQueryReader.Companion.getLimitCount();
            long l = this.command.getTop();
            if (!(1L <= l ? l <= (long)n : false)) {
                String string5 = Res.INSTANCE.getSelectCommandExecutorMeasureOrderException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-SelectCommandExecut\u2026ureOrderException_1>(...)");
                Object[] objectArray = new Object[]{1, MeasureOrderByQueryReader.Companion.getLimitCount()};
                throw Res.INSTANCE.getRuntimeException(string5, objectArray);
            }
        }
    }

    @NotNull
    public final Query getQuery() {
        return this.query;
    }

    public final void buildResult(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        SelectCommandInfo selectCommandInfo = this.command;
        if (selectCommandInfo instanceof SelectCommandInfoV1) {
            this.buildResultV1(outputStream);
        } else if (selectCommandInfo instanceof DistinctSelectCommandInfo) {
            if (((DistinctSelectCommandInfo)this.command).getIncludeDistinctCount()) {
                this.buildCountDistinctResult(outputStream);
            } else {
                this.buildDistinctResult(outputStream);
            }
        } else if (selectCommandInfo instanceof SelectCommandInfo) {
            this.buildResultV3(outputStream);
        } else {
            String string2 = Res.INSTANCE.getUnsupportedCommandInfoException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-UnsupportedCommandInfoException_1>(...)");
            Object[] objectArray = new Object[]{this.command.toString()};
            throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
        }
    }

    public final void buildResult(@NotNull Function1<? super Object[], Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.buildResult(consumer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void buildResult(@NotNull Function1<? super Object[], Unit> consumer, boolean outputMemberName) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Closeable closeable = this.createQuerySession();
        Throwable throwable = null;
        try {
            IQuerySession dynamicCalcSession = (IQuerySession)closeable;
            boolean bl = false;
            Closeable closeable2 = SpecialMeasureQueryReaderKt.whereFilter(SpecialMeasureQueryReaderKt.excludeSpecialMeasure(this.createReader2(dynamicCalcSession), this.command.getExcludeNull(), this.command.getExcludeNullOrDefault()), this.measureFilter);
            Throwable throwable2 = null;
            try {
                int n;
                IQueryReader dynamicCalcReader = (IQueryReader)closeable2;
                boolean bl2 = false;
                Cube cube = this.cubeWorkspace.getMetadata();
                int dimSize = this.query.getDimensions().getCount();
                int measureSize = this.query.getMeasures().getCount();
                ISelectFieldCollection fields2 = dynamicCalcReader.getSelectFields();
                int n2 = 0;
                MemberCollection[] memberCollectionArray = new MemberCollection[dimSize];
                while (n2 < dimSize) {
                    n = n2++;
                    memberCollectionArray[n] = ((Dimension)cube.getDimensions().get(((ISelectField)fields2.get(n)).getName())).getMembers();
                }
                MemberCollection[] dims = memberCollectionArray;
                Object[] values = new Object[fields2.getCount()];
                while (dynamicCalcReader.next() && this.cancelToken.canContinue()) {
                    n = values.length;
                    for (int i = 0; i < n; ++i) {
                        ISelectField field = (ISelectField)fields2.get(i);
                        if (field instanceof IDimensionSelectField) {
                            Member member = dims[i].get(((IDimensionSelectField)field).getCurrent());
                            values[i + measureSize] = outputMemberName ? member.getName() : member;
                            continue;
                        }
                        if (field instanceof IMeasureSelectField) {
                            values[i - dimSize] = ((IMeasureSelectField)field).getCurrent();
                            continue;
                        }
                        throw new NotSupportedException();
                    }
                    consumer.invoke((Object)values);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildResultV1(OutputStream outputStream) {
        Closeable closeable = this.createQuerySession();
        Throwable throwable = null;
        try {
            IQuerySession dynamicCalcSession = (IQuerySession)closeable;
            boolean bl = false;
            Closeable closeable2 = SpecialMeasureQueryReaderKt.excludeSpecialMeasure(dynamicCalcSession.createReader(), this.command.getExcludeNull(), this.command.getExcludeNullOrDefault());
            Throwable throwable2 = null;
            try {
                IQueryReader dynamicCalcReader = (IQueryReader)closeable2;
                boolean bl2 = false;
                if (dynamicCalcReader.next()) {
                    QueryJsonWriterV1 jsonWriter = new QueryJsonWriterV1(this.buildSelectMetadataV1(dynamicCalcReader), outputStream);
                    this.buildJsonWriter(jsonWriter, dynamicCalcReader);
                    jsonWriter.writeHead();
                    do {
                        jsonWriter.writeRow();
                    } while (dynamicCalcReader.next() && this.cancelToken.canContinue());
                    jsonWriter.writeEnd();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildResultV3(OutputStream outputStream) {
        Closeable closeable = this.createQuerySession();
        Throwable throwable = null;
        try {
            IQuerySession dynamicCalcSession = (IQuerySession)closeable;
            boolean bl = false;
            Closeable closeable2 = TopRowQueryReaderKt.top(SpecialMeasureQueryReaderKt.whereFilter(SpecialMeasureQueryReaderKt.excludeSpecialMeasure(this.createReader2(dynamicCalcSession), this.command.getExcludeNull(), this.command.getExcludeNullOrDefault()), this.measureFilter), this.query.getTop(), false, this.command.getOrderBy());
            Throwable throwable2 = null;
            try {
                IQueryReader dynamicCalcReader = (IQueryReader)closeable2;
                boolean bl2 = false;
                QueryJsonWriter jsonWriter = new QueryJsonWriter(SelectCommandExecutor.buildSelectMetadataV3$default(this, false, 1, null), outputStream);
                this.buildJsonWriter(jsonWriter, dynamicCalcReader);
                jsonWriter.writeHead();
                while (dynamicCalcReader.next() && this.cancelToken.canContinue()) {
                    jsonWriter.writeRow();
                }
                jsonWriter.writeEnd();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final IQuerySession createQuerySession() {
        boolean isParallel = this.command.getTop() == 0L && CommonTypesKt.getDefaultWorkerCount() > 1;
        return DynamicCalcQuerySessionBuilder.INSTANCE.createQuerySession(this.cubeWorkspace, this.olapWorkspace.getTempPool(), this.query, isParallel, true);
    }

    private final IQueryReader createReader2(IQuerySession $this$createReader2) {
        return $this$createReader2 instanceof DynamicCalcSession && this.command.getTop() == 0L && CommonTypesKt.getDefaultWorkerCount() > 1 ? (IQueryReader)new ParallelQueryReader($this$createReader2, 0, 2, null) : $this$createReader2.createReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildDistinctResult(OutputStream outputStream) {
        long top = this.query.getTop() <= 0L ? DistinctQueryReader.Companion.getLimitCount() : RangesKt.coerceAtMost((long)this.query.getTop(), (long)DistinctQueryReader.Companion.getLimitCount());
        this.query.setTop(0L);
        this.query.setExcludeDynamicCalcResult(true);
        Closeable closeable = this.cubeWorkspace.createQuerySession(this.query, false);
        Throwable throwable = null;
        try {
            IQuerySession querySession = (IQuerySession)closeable;
            boolean bl = false;
            Closeable closeable2 = TopRowQueryReaderKt.top(DistinctQueryReaderKt.distinct(SpecialMeasureQueryReaderKt.excludeSpecialMeasure(querySession.createReader(), this.command.getExcludeNull(), this.command.getExcludeNullOrDefault()), this.olapWorkspace.getTempPool(), this.cubeWorkspace.getMetadata(), this.query), top, false, CollectionsKt.emptyList());
            Throwable throwable2 = null;
            try {
                IQueryReader queryReader = (IQueryReader)closeable2;
                boolean bl2 = false;
                QueryJsonWriter jsonWriter = new QueryJsonWriter(this.buildSelectMetadataV3(false), outputStream);
                this.buildDimensionJsonWriter(jsonWriter, queryReader);
                jsonWriter.writeHead();
                while (queryReader.next() && this.cancelToken.canContinue()) {
                    jsonWriter.writeRow();
                }
                jsonWriter.writeEnd();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildCountDistinctResult(OutputStream outputStream) {
        long top = this.query.getTop() <= 0L ? DistinctQueryReader.Companion.getLimitCount() : RangesKt.coerceAtMost((long)this.query.getTop(), (long)DistinctQueryReader.Companion.getLimitCount());
        this.query.setExcludeDynamicCalcResult(true);
        Closeable closeable = this.cubeWorkspace.createQuerySession(this.query, false);
        Throwable throwable = null;
        try {
            IQuerySession querySession = (IQuerySession)closeable;
            boolean bl = false;
            Closeable closeable2 = TopRowQueryReaderKt.top(CountDistinctQueryReaderKt.countDistinct(SpecialMeasureQueryReaderKt.excludeSpecialMeasure(querySession.createReader(), this.command.getExcludeNull(), this.command.getExcludeNullOrDefault()), this.olapWorkspace.getTempPool(), this.cubeWorkspace.getMetadata(), this.query), top, false, CollectionsKt.emptyList());
            Throwable throwable2 = null;
            try {
                IQueryReader queryReader = (IQueryReader)closeable2;
                boolean bl2 = false;
                SelectMetaData selectMetadata = this.buildSelectMetadataV3(false);
                selectMetadata.addMeasure(new MeasureItem("count", OlapDataTypes.object));
                QueryJsonWriter jsonWriter = new QueryJsonWriter(selectMetadata, outputStream);
                this.buildDimensionJsonWriter(jsonWriter, queryReader);
                Object TValue = queryReader.getSelectFields().get("count");
                Intrinsics.checkNotNull(TValue, (String)"null cannot be cast to non-null type kd.bos.olapServer2.selects.IMeasureSelectField");
                jsonWriter.addMeasureField("count", (IMeasureSelectField)TValue);
                jsonWriter.writeHead();
                while (queryReader.next() && this.cancelToken.canContinue()) {
                    jsonWriter.writeRow();
                }
                jsonWriter.writeEnd();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void buildJsonWriter(IQueryJsonWriter jsonWriter, IQueryReader queryReader) {
        this.buildDimensionJsonWriter(jsonWriter, queryReader);
        for (String measure : this.command.getMeasures()) {
            Measure realMeasure = (Measure)this.cubeWorkspace.getMetadata().getMeasures().get(measure);
            Object TValue = queryReader.getSelectFields().get(realMeasure.getName());
            Intrinsics.checkNotNull(TValue, (String)"null cannot be cast to non-null type kd.bos.olapServer2.selects.IMeasureSelectField");
            jsonWriter.addMeasureField(measure, (IMeasureSelectField)TValue);
        }
    }

    private final void buildDimensionJsonWriter(IQueryJsonWriter jsonWriter, IQueryReader queryReader) {
        for (String dimension : this.command.getDimensions()) {
            Dimension realDimension = (Dimension)this.cubeWorkspace.getMetadata().getDimensions().get(dimension);
            Object TValue = queryReader.getSelectFields().get(realDimension.getName());
            Intrinsics.checkNotNull(TValue, (String)"null cannot be cast to non-null type kd.bos.olapServer2.selects.IDimensionSelectField");
            jsonWriter.addDimensionField(dimension, (IDimensionSelectField)TValue);
        }
    }

    private final SelectMetaDataV1 buildSelectMetadataV1(IQueryReader queryReader) {
        SelectMetaDataV1 selectMetadata = new SelectMetaDataV1();
        List<String> dimensions2 = this.command.getDimensions();
        for (String dimension : dimensions2) {
            Object TValue = queryReader.getSelectFields().get(dimension);
            Intrinsics.checkNotNull(TValue, (String)"null cannot be cast to non-null type kd.bos.olapServer2.selects.IDimensionSelectFieldV1");
            IDimensionSelectFieldV1 dimField = (IDimensionSelectFieldV1)TValue;
            Member[] members2 = dimField.getOutMembers();
            int n = 0;
            int n2 = members2.length;
            Object[] objectArray = new String[n2];
            String string2 = dimension;
            SelectMetaDataV1 selectMetaDataV1 = selectMetadata;
            while (n < n2) {
                int n3 = n++;
                objectArray[n3] = members2[n3].getName();
            }
            ArrayList arrayList = (ArrayList)ArraysKt.toCollection((Object[])objectArray, (Collection)new ArrayList());
            String string3 = string2;
            selectMetaDataV1.addDimensionItem(new DimensionItemV1(string3, arrayList));
        }
        for (String measure : this.command.getMeasures()) {
            selectMetadata.addMeasure(measure);
        }
        return selectMetadata;
    }

    private final SelectMetaData buildSelectMetadataV3(boolean addMeasureFlag) {
        Cube cube = this.cubeWorkspace.getMetadata();
        SelectMetaData selectMetadata = new SelectMetaData();
        List<String> dimensions2 = this.command.getDimensions();
        for (String dimension : dimensions2) {
            selectMetadata.addDimensionItem(new DimensionItem(dimension, OlapDataTypes.string));
        }
        if (addMeasureFlag) {
            MeasureCollection mes = cube.getMeasures();
            for (String measure : this.command.getMeasures()) {
                selectMetadata.addMeasure(new MeasureItem(measure, ((Measure)mes.get(measure)).getDataType()));
            }
        }
        return selectMetadata;
    }

    static /* synthetic */ SelectMetaData buildSelectMetadataV3$default(SelectCommandExecutor selectCommandExecutor, boolean bl, int n, Object object2) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return selectCommandExecutor.buildSelectMetadataV3(bl);
    }
}

