/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.query.match;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer2.collections.BitSetEx;
import kd.bos.olapServer2.collections.IIterator;
import kd.bos.olapServer2.collections.objectModel.IImmutableCollection;
import kd.bos.olapServer2.collections.objectModel.ImmutableArray;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.computingEngine.IntArraySequenceBuilder;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.MemberCollection;
import kd.bos.olapServer2.query.match.AbstractMatchBitmap;
import kd.bos.olapServer2.query.match.AndFilterBitmapNode;
import kd.bos.olapServer2.query.match.DimensionFilterBitmapNode;
import kd.bos.olapServer2.query.match.FilterBitmapNode;
import kd.bos.olapServer2.query.match.OrFilterBitmapNode;
import kd.bos.olapServer2.query.match.PartitionFilterBitmapNode;
import kd.bos.olapServer2.query.match.StandardMatchBitmap;
import kd.bos.olapServer2.query.models.AndFilter;
import kd.bos.olapServer2.query.models.DimensionFilter;
import kd.bos.olapServer2.query.models.Filter;
import kd.bos.olapServer2.query.models.OrFilter;
import kd.bos.olapServer2.query.models.PartitionFilter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0014\u0010\u0017\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\f\u0010\u0019\u001a\u00060\u000fj\u0002`\u0010H\u0002J\f\u0010\u001a\u001a\u00060\u000fj\u0002`\u0010H\u0002J$\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0015\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u00020\u001c2\n\u0010\"\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010#\u001a\u00020\tR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lkd/bos/olapServer2/query/match/MatchBitmapFactory;", "", "dimensions", "", "Lkd/bos/olapServer2/metadata/Dimension;", "([Lkd/bos/olapServer2/metadata/Dimension;)V", "Lkd/bos/olapServer2/collections/objectModel/IImmutableCollection;", "(Lkd/bos/olapServer2/collections/objectModel/IImmutableCollection;)V", "assistArray", "", "dimensionMap", "positionArray", "positionBuilder", "Lkd/bos/olapServer2/computingEngine/IntArraySequenceBuilder;", "size", "", "Lkd/bos/olapServer2/common/int;", "getSize", "()I", "createMatchBitmap", "Lkd/bos/olapServer2/query/match/FilterBitmapNode;", "filter", "Lkd/bos/olapServer2/query/models/Filter;", "getDimensionIndex", "dimension", "init", "maxPosition", "setBitmap", "", "index", "Lkd/bos/olapServer2/query/models/DimensionFilter;", "bitMap", "Lkd/bos/olapServer2/collections/BitSetEx;", "setKey", "position", "key", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nMatchBitmapFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatchBitmapFactory.kt\nkd/bos/olapServer2/query/match/MatchBitmapFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1#2:185\n*E\n"})
public final class MatchBitmapFactory {
    @NotNull
    private final IImmutableCollection<Dimension> dimensions;
    @NotNull
    private final int[] dimensionMap;
    @NotNull
    private final int[] assistArray;
    private final int size;
    @NotNull
    private final int[] positionArray;
    @NotNull
    private final IntArraySequenceBuilder positionBuilder;

    public MatchBitmapFactory(@NotNull IImmutableCollection<? extends Dimension> dimensions2) {
        Intrinsics.checkNotNullParameter(dimensions2, (String)"dimensions");
        this.dimensions = dimensions2;
        int n = 0;
        int n2 = this.maxPosition();
        int[] nArray = new int[n2];
        MatchBitmapFactory matchBitmapFactory = this;
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = -1;
        }
        matchBitmapFactory.dimensionMap = nArray;
        this.assistArray = new int[this.dimensions.getCount()];
        this.size = this.init();
        this.positionArray = new int[this.dimensions.getCount()];
        this.positionBuilder = new IntArraySequenceBuilder(this.positionArray);
    }

    public MatchBitmapFactory(@NotNull Dimension[] dimensions2) {
        Intrinsics.checkNotNullParameter((Object)dimensions2, (String)"dimensions");
        this((IImmutableCollection<? extends Dimension>)new ImmutableArray<Dimension>(dimensions2));
    }

    private final int maxPosition() {
        int result2 = -1;
        for (Dimension elem : this.dimensions) {
            result2 = Math.max(result2, elem.getPosition());
        }
        return result2 + 1;
    }

    public final int getSize() {
        return this.size;
    }

    private final int init() {
        long result2 = 1L;
        for (int i = this.dimensions.getCount() - 1; -1 < i; --i) {
            this.dimensionMap[this.dimensions.get((int)i).getPosition()] = i;
            this.assistArray[i] = (int)result2;
            Dimension dimension = this.dimensions.get(i);
            if (!(!dimension.isSupportSimpleMember())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            result2 = Math.multiplyExact(result2, (long)dimension.getMembers().getNextUnusedPosition());
        }
        if (!(result2 >= 0L && result2 <= Integer.MAX_VALUE)) {
            boolean bl = false;
            String string3 = "\u8d85\u51fa\u8303\u56f4";
            throw new IllegalArgumentException(string3.toString());
        }
        return (int)result2;
    }

    @NotNull
    public final FilterBitmapNode createMatchBitmap(@Nullable Filter filter2) {
        FilterBitmapNode filterBitmapNode;
        Filter filter3;
        Filter filter4 = filter3 = filter2;
        if (filter4 == null ? true : filter4 instanceof PartitionFilter) {
            filterBitmapNode = new PartitionFilterBitmapNode((AbstractMatchBitmap)AbstractMatchBitmap.FullBitmap.INSTANCE, filter2);
        } else if (filter3 instanceof DimensionFilter) {
            int index2 = this.getDimensionIndex(((DimensionFilter)filter2).getDimension());
            if (index2 == -1) {
                filterBitmapNode = new DimensionFilterBitmapNode((AbstractMatchBitmap)AbstractMatchBitmap.FullBitmap.INSTANCE, (DimensionFilter)filter2);
            } else {
                AbstractMatchBitmap abstractMatchBitmap;
                if (((DimensionFilter)filter2).getMembers().isEmpty()) {
                    abstractMatchBitmap = AbstractMatchBitmap.EmptyBitmap.INSTANCE;
                } else {
                    BitSetEx bitMap = new BitSetEx(this.size);
                    this.setBitmap(index2, (DimensionFilter)filter2, bitMap);
                    abstractMatchBitmap = StandardMatchBitmap.INSTANCE.create(bitMap);
                }
                filterBitmapNode = new PartitionFilterBitmapNode(abstractMatchBitmap, filter2);
            }
        } else if (filter3 instanceof AndFilter) {
            AbstractMatchBitmap result2 = AbstractMatchBitmap.FullBitmap.INSTANCE;
            ArrayList<FilterBitmapNode> nodes = new ArrayList<FilterBitmapNode>(((AndFilter)filter2).getSize());
            for (Filter child : ((AndFilter)filter2).getChildren()) {
                FilterBitmapNode node = this.createMatchBitmap(child);
                nodes.add(node);
                result2 = result2.and(node.getBitmap());
            }
            filterBitmapNode = new AndFilterBitmapNode(result2, (List<? extends FilterBitmapNode>)nodes);
        } else if (filter3 instanceof OrFilter) {
            AbstractMatchBitmap result3 = ((OrFilter)filter2).getHasChildren() ? (AbstractMatchBitmap)AbstractMatchBitmap.EmptyBitmap.INSTANCE : (AbstractMatchBitmap)AbstractMatchBitmap.FullBitmap.INSTANCE;
            ArrayList<FilterBitmapNode> nodes = new ArrayList<FilterBitmapNode>(((OrFilter)filter2).getSize());
            for (Filter child : ((OrFilter)filter2).getChildren()) {
                FilterBitmapNode node = this.createMatchBitmap(child);
                nodes.add(node);
                result3 = result3.or(node.getBitmap());
            }
            filterBitmapNode = new OrFilterBitmapNode(result3, (List<? extends FilterBitmapNode>)nodes);
        } else {
            throw new NotSupportedException("\u9519\u8bef\u7684\u6761\u4ef6:" + filter2);
        }
        return filterBitmapNode;
    }

    private final int getDimensionIndex(Dimension dimension) {
        if (dimension.getPosition() >= this.dimensionMap.length) {
            return -1;
        }
        return this.dimensionMap[dimension.getPosition()];
    }

    private final void setBitmap(int index2, DimensionFilter filter2, BitSetEx bitMap) {
        int n = this.dimensions.getCount();
        for (int i = 0; i < n; ++i) {
            if (i == index2) continue;
            Dimension dimension = this.dimensions.get(i);
            MemberCollection members2 = dimension.getMembers();
            if (!(!dimension.isSupportSimpleMember() && members2.getRealCount() == members2.getNextUnusedPosition())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            this.positionBuilder.setRangeValue(i, 0, members2.getNextUnusedPosition() - 1);
        }
        if (!filter2.getMembers().isEmpty()) {
            if (filter2.getMembers().size() == 1) {
                this.positionBuilder.setFixedValue(index2, ((Member)CollectionsKt.first((Iterable)filter2.getMembers())).getPosition());
            } else {
                int[] value2 = new int[filter2.getMembers().size()];
                Iterator<Member> iterator2 = filter2.getMembers().iterator();
                int dimension = 0;
                while (iterator2.hasNext()) {
                    int i = dimension++;
                    Member item = iterator2.next();
                    value2[i] = item.getPosition();
                }
                this.positionBuilder.setArrayValue(index2, value2);
            }
        }
        IIterator positionItr = this.positionBuilder.build();
        int position = 0;
        while (positionItr.next()) {
            position = 0;
            int n2 = this.dimensions.getCount();
            for (int i = 0; i < n2; ++i) {
                position += this.positionArray[i] * this.assistArray[i];
            }
            bitMap.set(position);
        }
    }

    public final void setKey(int position, @NotNull int[] key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        int temp = position;
        int n = this.dimensions.getCount();
        for (int i = 0; i < n; ++i) {
            key2[this.dimensions.get((int)i).getPosition()] = temp / this.assistArray[i];
            temp -= key2[this.dimensions.get(i).getPosition()] * this.assistArray[i];
        }
    }
}

